/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheDistributedGetFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedSingleGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridPartitionedGetFuture<K, V>
extends CacheDistributedGetFutureAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static final GridCacheVersion DUMMY_VER = new GridCacheVersion(0, 0, 0L, 0L);
    private static IgniteLogger log;
    private AffinityTopologyVersion topVer;

    public GridPartitionedGetFuture(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer, boolean readThrough, boolean forcePrimary, @Nullable UUID subjId, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean canRemap, boolean needVer, boolean keepCacheObjects) {
        super(cctx, keys, readThrough, forcePrimary, subjId, taskName, deserializeBinary, expiryPlc, skipVals, canRemap, needVer, keepCacheObjects);
        this.topVer = topVer;
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridPartitionedGetFuture.class);
        }
    }

    public void init() {
        AffinityTopologyVersion lockedTopVer = this.cctx.shared().lockedTopologyVersion(null);
        if (lockedTopVer != null) {
            this.canRemap = false;
            this.map(this.keys, Collections.emptyMap(), lockedTopVer);
        } else {
            AffinityTopologyVersion topVer = this.topVer.topologyVersion() > 0L ? this.topVer : (this.canRemap ? this.cctx.affinity().affinityTopologyVersion() : this.cctx.shared().exchange().readyAffinityVersion());
            this.map(this.keys, Collections.emptyMap(), topVer);
        }
        this.markInitialized();
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            found = true;
            f.onNodeLeft(new ClusterTopologyCheckedException("Remote node left grid (will retry): " + nodeId));
        }
        return found;
    }

    @Override
    public void onResult(UUID nodeId, GridNearGetResponse res) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).futureId().equals(res.miniId())) continue;
            assert (f.node().id().equals(nodeId));
            f.onResult(res);
        }
    }

    @Override
    public boolean onDone(Map<K, V> res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            this.cache().sendTtlUpdateRequest(this.expiryPlc);
            return true;
        }
        return false;
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private void map(Collection<KeyCacheObject> keys, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped, AffinityTopologyVersion topVer) {
        Collection<ClusterNode> cacheNodes = CU.affinityNodes(this.cctx, topVer);
        if (cacheNodes.isEmpty()) {
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", cache=" + this.cctx.name() + ']'));
            return;
        }
        HashMap<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings = U.newHashMap(cacheNodes.size());
        int keysSize = keys.size();
        HashMap locVals = U.newHashMap(keysSize);
        boolean hasRmtNodes = false;
        for (KeyCacheObject keyCacheObject : keys) {
            hasRmtNodes |= this.map(keyCacheObject, mappings, locVals, topVer, mapped);
        }
        if (this.isDone()) {
            return;
        }
        if (!locVals.isEmpty()) {
            this.add(new GridFinishedFuture(locVals));
        }
        if (hasRmtNodes && !this.trackable) {
            this.trackable = true;
            this.cctx.mvcc().addFuture(this, this.futId);
        }
        for (Map.Entry entry : mappings.entrySet()) {
            IgniteInternalFuture fut;
            ClusterNode n = (ClusterNode)entry.getKey();
            LinkedHashMap mappedKeys = (LinkedHashMap)entry.getValue();
            assert (!mappedKeys.isEmpty());
            if (n.isLocal()) {
                fut = this.cache().getDhtAsync(n.id(), -1L, mappedKeys, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals);
                Collection<Integer> invalidParts = fut.invalidPartitions();
                if (!F.isEmpty(invalidParts)) {
                    ArrayList<KeyCacheObject> remapKeys = new ArrayList<KeyCacheObject>(keysSize);
                    for (KeyCacheObject key : keys) {
                        if (key == null || !invalidParts.contains(this.cctx.affinity().partition(key))) continue;
                        remapKeys.add(key);
                    }
                    AffinityTopologyVersion updTopVer = this.cctx.discovery().topologyVersionEx();
                    assert (updTopVer.compareTo(topVer) > 0) : "Got invalid partitions for local node but topology version did not change [topVer=" + topVer + ", updTopVer=" + updTopVer + ", invalidParts=" + invalidParts + ']';
                    this.map(remapKeys, mappings, updTopVer);
                }
                this.add(fut.chain(new C1<IgniteInternalFuture<Collection<GridCacheEntryInfo>>, Map<K, V>>(){

                    @Override
                    public Map<K, V> apply(IgniteInternalFuture<Collection<GridCacheEntryInfo>> fut) {
                        try {
                            return GridPartitionedGetFuture.this.createResultMap(fut.get());
                        }
                        catch (Exception e) {
                            U.error(log, "Failed to get values from dht cache [fut=" + fut + "]", e);
                            GridPartitionedGetFuture.this.onDone(e);
                            return Collections.emptyMap();
                        }
                    }
                }));
                continue;
            }
            fut = new MiniFuture(n, mappedKeys, topVer);
            GridNearGetRequest req = new GridNearGetRequest(this.cctx.cacheId(), this.futId, ((MiniFuture)fut).futureId(), n.version().compareTo(GridPartitionedSingleGetFuture.SINGLE_GET_MSG_SINCE) >= 0 ? null : DUMMY_VER, mappedKeys, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc != null ? this.expiryPlc.forCreate() : -1L, this.expiryPlc != null ? this.expiryPlc.forAccess() : -1L, this.skipVals, this.cctx.deploymentEnabled());
            this.add(fut);
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.cctx.ioPolicy());
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    ((MiniFuture)fut).onNodeLeft((ClusterTopologyCheckedException)e);
                    continue;
                }
                ((MiniFuture)fut).onResult(e);
            }
        }
    }

    private boolean map(KeyCacheObject key, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings, Map<K, V> locVals, AffinityTopologyVersion topVer, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped) {
        boolean fastLocGet;
        int part = this.cctx.affinity().partition(key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(topVer));
            return false;
        }
        boolean bl = fastLocGet = (!this.forcePrimary || affNodes.get(0).isLocal()) && this.cctx.allowFastLocalRead(part, affNodes, topVer);
        if (fastLocGet && this.localGet(key, part, locVals)) {
            return false;
        }
        ClusterNode node = this.affinityNode(affNodes);
        if (node == null) {
            this.onDone(this.serverNotFoundError(topVer));
            return false;
        }
        boolean remote = !node.isLocal();
        LinkedHashMap<KeyCacheObject, Boolean> keys = mapped.get(node);
        if (keys != null && keys.containsKey(key) && REMAP_CNT_UPD.incrementAndGet(this) > MAX_REMAP_CNT) {
            this.onDone(new ClusterTopologyCheckedException("Failed to remap key to a new node after " + MAX_REMAP_CNT + " attempts (key got remapped to the same node) [key=" + key + ", node=" + U.toShortString(node) + ", mappings=" + mapped + ']'));
            return false;
        }
        LinkedHashMap<KeyCacheObject, Boolean> old = mappings.get(node);
        if (old == null) {
            old = new LinkedHashMap(3, 1.0f);
            mappings.put(node, old);
        }
        old.put(key, false);
        return remote;
    }

    private boolean localGet(KeyCacheObject key, int part, Map<K, V> locVals) {
        assert (this.cctx.affinityNode()) : this;
        GridDhtCacheAdapter<K, V> cache = this.cache();
        while (true) {
            try {
                boolean topStable;
                GridCacheEntryEx entry;
                GridCacheEntryEx gridCacheEntryEx = entry = cache.context().isSwapOrOffheapEnabled() ? cache.entryEx(key) : cache.peekEx(key);
                if (entry != null) {
                    boolean isNew = entry.isNewLocked();
                    EntryGetResult getRes = null;
                    CacheObject v = null;
                    GridCacheVersion ver = null;
                    if (this.needVer) {
                        getRes = entry.innerGetVersioned(null, null, true, true, false, !this.skipVals, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null);
                        if (getRes != null) {
                            v = (CacheObject)getRes.value();
                            ver = getRes.version();
                        }
                    } else {
                        v = entry.innerGet(null, null, true, false, false, !this.skipVals, false, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary);
                    }
                    cache.context().evicts().touch(entry, this.topVer);
                    if (v == null) {
                        if (isNew && entry.markObsoleteIfEmpty(ver)) {
                            cache.removeEntry(entry);
                        }
                    } else {
                        this.cctx.addResult(locVals, key, v, this.skipVals, this.keepCacheObjects, this.deserializeBinary, true, getRes, ver, 0L, 0L, this.needVer);
                        return true;
                    }
                }
                boolean bl = topStable = this.cctx.isReplicated() || this.topVer.equals(this.cctx.topology().topologyVersion());
                if (!this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part))) {
                    if (!this.skipVals && this.cctx.config().isStatisticsEnabled()) {
                        cache.metrics0().onRead(false);
                    }
                    return true;
                }
                return false;
            }
            catch (GridCacheEntryRemovedException topStable) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                return false;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                return true;
            }
            break;
        }
    }

    private GridDhtCacheAdapter<K, V> cache() {
        return this.cctx.dht();
    }

    private Map<K, V> createResultMap(Collection<GridCacheEntryInfo> infos) {
        int keysSize = infos.size();
        if (keysSize != 0) {
            GridLeanMap map = new GridLeanMap(keysSize);
            for (GridCacheEntryInfo info : infos) {
                assert (this.skipVals == (info.value() == null));
                this.cctx.addResult(map, info.key(), info.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, this.needVer ? info.version() : null, 0L, 0L);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (GridPartitionedGetFuture.this.isMini(f)) {
                    return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
                }
                return "[loc=true, done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridPartitionedGetFuture.class, this, "innerFuts", futs, "super", super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<Map<K, V>> {
        private static final long serialVersionUID = 0L;
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        private final ClusterNode node;
        @GridToStringInclude
        private final LinkedHashMap<KeyCacheObject, Boolean> keys;
        private final AffinityTopologyVersion topVer;
        private boolean remapped;

        MiniFuture(ClusterNode node, LinkedHashMap<KeyCacheObject, Boolean> keys, AffinityTopologyVersion topVer) {
            this.node = node;
            this.keys = keys;
            this.topVer = topVer;
        }

        IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node;
        }

        public Collection<KeyCacheObject> keys() {
            return this.keys.keySet();
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        synchronized void onNodeLeft(ClusterTopologyCheckedException e) {
            if (this.remapped) {
                return;
            }
            this.remapped = true;
            if (log.isDebugEnabled()) {
                log.debug("Remote node left grid while sending or waiting for reply (will retry): " + this);
            }
            if (!GridPartitionedGetFuture.this.canRemap) {
                GridPartitionedGetFuture.this.map(this.keys.keySet(), F.t(this.node, this.keys), this.topVer);
                this.onDone(Collections.emptyMap());
            } else {
                final AffinityTopologyVersion updTopVer = new AffinityTopologyVersion(Math.max(this.topVer.topologyVersion() + 1L, GridPartitionedGetFuture.this.cctx.discovery().topologyVersion()));
                GridPartitionedGetFuture.this.cctx.affinity().affinityReadyFuture(updTopVer).listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        try {
                            fut.get();
                            GridPartitionedGetFuture.this.map(MiniFuture.this.keys.keySet(), F.t(MiniFuture.this.node, MiniFuture.this.keys), updTopVer);
                            MiniFuture.this.onDone(Collections.emptyMap());
                        }
                        catch (IgniteCheckedException e) {
                            GridPartitionedGetFuture.this.onDone(e);
                        }
                    }
                });
            }
        }

        void onResult(final GridNearGetResponse res) {
            final Collection<Integer> invalidParts = res.invalidPartitions();
            if (res.error() != null) {
                this.onDone(res.error());
                return;
            }
            if (!F.isEmpty(invalidParts)) {
                AffinityTopologyVersion rmtTopVer = res.topologyVersion();
                assert (!rmtTopVer.equals(AffinityTopologyVersion.ZERO));
                if (rmtTopVer.compareTo(this.topVer) <= 0) {
                    this.onDone(new IgniteCheckedException("Failed to process invalid partitions response (remote node reported invalid partitions but remote topology version does not differ from local) [topVer=" + this.topVer + ", rmtTopVer=" + rmtTopVer + ", invalidParts=" + invalidParts + ", nodeId=" + this.node.id() + ']'));
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Remapping mini get future [invalidParts=" + invalidParts + ", fut=" + this + ']');
                }
                if (!GridPartitionedGetFuture.this.canRemap) {
                    GridPartitionedGetFuture.this.map(F.view(this.keys.keySet(), new P1<KeyCacheObject>(){

                        @Override
                        public boolean apply(KeyCacheObject key) {
                            return invalidParts.contains(GridPartitionedGetFuture.this.cctx.affinity().partition(key));
                        }
                    }), F.t(this.node, this.keys), this.topVer);
                    this.onDone(GridPartitionedGetFuture.this.createResultMap(res.entries()));
                    return;
                }
                IgniteInternalFuture<AffinityTopologyVersion> topFut = GridPartitionedGetFuture.this.cctx.affinity().affinityReadyFuture(rmtTopVer);
                topFut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CIX1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<AffinityTopologyVersion> fut) throws IgniteCheckedException {
                        AffinityTopologyVersion topVer = fut.get();
                        GridPartitionedGetFuture.this.map(F.view(MiniFuture.this.keys.keySet(), new P1<KeyCacheObject>(){

                            @Override
                            public boolean apply(KeyCacheObject key) {
                                return invalidParts.contains(GridPartitionedGetFuture.this.cctx.affinity().partition(key));
                            }
                        }), F.t(MiniFuture.this.node, MiniFuture.this.keys), topVer);
                        MiniFuture.this.onDone(GridPartitionedGetFuture.this.createResultMap(res.entries()));
                    }
                });
            } else {
                try {
                    this.onDone(GridPartitionedGetFuture.this.createResultMap(res.entries()));
                }
                catch (Exception e) {
                    this.onDone(e);
                }
            }
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this);
        }
    }
}

