/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.near.CacheVersionedValue;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

public class GridPartitionedSingleGetFuture
extends GridFutureAdapter<Object>
implements GridCacheFuture<Object>,
CacheGetFuture {
    private static final long serialVersionUID = 0L;
    public static final IgniteProductVersion SINGLE_GET_MSG_SINCE = IgniteProductVersion.fromString("1.5.0");
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private AffinityTopologyVersion topVer;
    private final GridCacheContext cctx;
    private final KeyCacheObject key;
    private final boolean readThrough;
    private final boolean forcePrimary;
    private final IgniteUuid futId;
    private boolean trackable;
    private final UUID subjId;
    private final String taskName;
    private boolean deserializeBinary;
    private boolean skipVals;
    private IgniteCacheExpiryPolicy expiryPlc;
    private final boolean canRemap;
    private final boolean needVer;
    private final boolean keepCacheObjects;
    @GridToStringInclude
    private ClusterNode node;

    public GridPartitionedSingleGetFuture(GridCacheContext cctx, KeyCacheObject key, AffinityTopologyVersion topVer, boolean readThrough, boolean forcePrimary, @Nullable UUID subjId, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean canRemap, boolean needVer, boolean keepCacheObjects) {
        assert (key != null);
        AffinityTopologyVersion lockedTopVer = cctx.shared().lockedTopologyVersion(null);
        if (lockedTopVer != null) {
            topVer = lockedTopVer;
            canRemap = false;
        }
        this.cctx = cctx;
        this.key = key;
        this.readThrough = readThrough;
        this.forcePrimary = forcePrimary;
        this.subjId = subjId;
        this.taskName = taskName;
        this.deserializeBinary = deserializeBinary;
        this.expiryPlc = expiryPlc;
        this.skipVals = skipVals;
        this.canRemap = canRemap;
        this.needVer = needVer;
        this.keepCacheObjects = keepCacheObjects;
        this.topVer = topVer;
        this.futId = IgniteUuid.randomUuid();
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridPartitionedSingleGetFuture.class);
        }
    }

    public void init() {
        AffinityTopologyVersion topVer = this.topVer.topologyVersion() > 0L ? this.topVer : (this.canRemap ? this.cctx.affinity().affinityTopologyVersion() : this.cctx.shared().exchange().readyAffinityVersion());
        this.map(topVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void map(AffinityTopologyVersion topVer) {
        ClusterNode node = this.mapKeyToNode(topVer);
        if (node == null) {
            assert (this.isDone()) : this;
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (node.isLocal()) {
            Map<KeyCacheObject, Boolean> map = Collections.singletonMap(this.key, false);
            GridDhtFuture<Collection<GridCacheEntryInfo>> fut = this.cctx.dht().getDhtAsync(node.id(), -1L, map, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals);
            Collection<Integer> invalidParts = fut.invalidPartitions();
            if (!F.isEmpty(invalidParts)) {
                AffinityTopologyVersion updTopVer = this.cctx.discovery().topologyVersionEx();
                assert (updTopVer.compareTo(topVer) > 0) : "Got invalid partitions for local node but topology version did not change [topVer=" + topVer + ", updTopVer=" + updTopVer + ", invalidParts=" + invalidParts + ']';
                this.map(updTopVer);
            } else {
                fut.listen(new CI1<IgniteInternalFuture<Collection<GridCacheEntryInfo>>>(){

                    @Override
                    public void apply(IgniteInternalFuture<Collection<GridCacheEntryInfo>> fut) {
                        try {
                            Collection<GridCacheEntryInfo> infos = fut.get();
                            assert (F.isEmpty(infos) || infos.size() == 1) : infos;
                            GridPartitionedSingleGetFuture.this.setResult(F.first(infos));
                        }
                        catch (Exception e) {
                            U.error(log, "Failed to get values from dht cache [fut=" + fut + "]", e);
                            GridPartitionedSingleGetFuture.this.onDone(e);
                        }
                    }
                });
            }
        } else {
            GridCacheMessage req;
            GridPartitionedSingleGetFuture map = this;
            synchronized (map) {
                assert (this.node == null);
                this.topVer = topVer;
                this.node = node;
            }
            if (!this.trackable) {
                this.trackable = true;
                this.cctx.mvcc().addFuture(this, this.futId);
            }
            if (node.version().compareTo(SINGLE_GET_MSG_SINCE) >= 0) {
                req = new GridNearSingleGetRequest(this.cctx.cacheId(), this.futId.localId(), this.key, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc != null ? this.expiryPlc.forCreate() : -1L, this.expiryPlc != null ? this.expiryPlc.forAccess() : -1L, this.skipVals, false, this.needVer, this.cctx.deploymentEnabled());
            } else {
                Map<KeyCacheObject, Boolean> map2 = Collections.singletonMap(this.key, false);
                req = new GridNearGetRequest(this.cctx.cacheId(), this.futId, this.futId, this.cctx.versions().next(), map2, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc != null ? this.expiryPlc.forCreate() : -1L, this.expiryPlc != null ? this.expiryPlc.forAccess() : -1L, this.skipVals, this.cctx.deploymentEnabled());
            }
            try {
                this.cctx.io().send(node, req, this.cctx.ioPolicy());
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    this.onNodeLeft(node.id());
                }
                this.onDone(e);
            }
        }
    }

    @Nullable
    private ClusterNode mapKeyToNode(AffinityTopologyVersion topVer) {
        boolean fastLocGet;
        int part = this.cctx.affinity().partition(this.key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(topVer));
            return null;
        }
        boolean bl = fastLocGet = (!this.forcePrimary || affNodes.get(0).isLocal()) && this.cctx.allowFastLocalRead(part, affNodes, topVer);
        if (fastLocGet && this.localGet(topVer, part)) {
            return null;
        }
        ClusterNode affNode = this.affinityNode(affNodes);
        if (affNode == null) {
            this.onDone(this.serverNotFoundError(topVer));
            return null;
        }
        return affNode;
    }

    private boolean localGet(AffinityTopologyVersion topVer, int part) {
        assert (this.cctx.affinityNode()) : this;
        GridDhtCacheAdapter colocated = this.cctx.dht();
        while (true) {
            try {
                boolean topStable;
                GridCacheEntryEx entry;
                GridCacheEntryEx gridCacheEntryEx = entry = colocated.context().isSwapOrOffheapEnabled() ? colocated.entryEx(this.key) : colocated.peekEx(this.key);
                if (entry != null) {
                    boolean isNew = entry.isNewLocked();
                    CacheObject v = null;
                    GridCacheVersion ver = null;
                    if (this.needVer) {
                        EntryGetResult res = entry.innerGetVersioned(null, null, true, true, false, !this.skipVals, this.subjId, null, this.taskName, this.expiryPlc, true, null);
                        if (res != null) {
                            v = (CacheObject)res.value();
                            ver = res.version();
                        }
                    } else {
                        v = entry.innerGet(null, null, true, false, false, !this.skipVals, false, this.subjId, null, this.taskName, this.expiryPlc, true);
                    }
                    colocated.context().evicts().touch(entry, topVer);
                    if (v == null) {
                        if (isNew && entry.markObsoleteIfEmpty(ver)) {
                            colocated.removeEntry(entry);
                        }
                    } else {
                        if (!this.skipVals && this.cctx.config().isStatisticsEnabled()) {
                            this.cctx.cache().metrics0().onRead(true);
                        }
                        if (!this.skipVals) {
                            this.setResult(v, ver);
                        } else {
                            this.setSkipValueResult(true, ver);
                        }
                        return true;
                    }
                }
                boolean bl = topStable = this.cctx.isReplicated() || topVer.equals(this.cctx.topology().topologyVersion());
                if (!this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part))) {
                    if (!this.skipVals && this.cctx.config().isStatisticsEnabled()) {
                        colocated.metrics0().onRead(false);
                    }
                    if (this.skipVals) {
                        this.setSkipValueResult(false, null);
                    } else {
                        this.setResult(null, null);
                    }
                    return true;
                }
                return false;
            }
            catch (GridCacheEntryRemovedException topStable) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                return false;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                return true;
            }
            break;
        }
    }

    public void onResult(UUID nodeId, GridNearSingleGetResponse res) {
        if (!this.processResponse(nodeId) || !this.checkError(res.error(), res.invalidPartitions(), res.topologyVersion(), nodeId)) {
            return;
        }
        Message res0 = res.result();
        if (this.needVer) {
            CacheVersionedValue verVal = (CacheVersionedValue)res0;
            if (verVal != null) {
                if (this.skipVals) {
                    this.setSkipValueResult(true, verVal.version());
                } else {
                    this.setResult(verVal.value(), verVal.version());
                }
            } else if (this.skipVals) {
                this.setSkipValueResult(false, null);
            } else {
                this.setResult(null, null);
            }
        } else if (this.skipVals) {
            this.setSkipValueResult(res.containsValue(), null);
        } else {
            this.setResult((CacheObject)res0, null);
        }
    }

    @Override
    public void onResult(UUID nodeId, GridNearGetResponse res) {
        if (!this.processResponse(nodeId) || !this.checkError(res.error(), !F.isEmpty(res.invalidPartitions()), res.topologyVersion(), nodeId)) {
            return;
        }
        Collection<GridCacheEntryInfo> infos = res.entries();
        assert (F.isEmpty(infos) || infos.size() == 1) : infos;
        this.setResult(F.first(infos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processResponse(UUID nodeId) {
        GridPartitionedSingleGetFuture gridPartitionedSingleGetFuture = this;
        synchronized (gridPartitionedSingleGetFuture) {
            if (this.node != null && this.node.id().equals(nodeId)) {
                this.node = null;
                return true;
            }
        }
        return false;
    }

    private boolean checkError(@Nullable IgniteCheckedException err, boolean invalidParts, AffinityTopologyVersion rmtTopVer, UUID nodeId) {
        if (err != null) {
            this.onDone(err);
            return false;
        }
        if (invalidParts) {
            assert (!rmtTopVer.equals(AffinityTopologyVersion.ZERO));
            if (rmtTopVer.compareTo(this.topVer) <= 0) {
                this.onDone(new IgniteCheckedException("Failed to process invalid partitions response (remote node reported invalid partitions but remote topology version does not differ from local) [topVer=" + this.topVer + ", rmtTopVer=" + rmtTopVer + ", part=" + this.cctx.affinity().partition(this.key) + ", nodeId=" + nodeId + ']'));
                return false;
            }
            if (this.canRemap) {
                IgniteInternalFuture<AffinityTopologyVersion> topFut = this.cctx.affinity().affinityReadyFuture(rmtTopVer);
                topFut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CIX1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        try {
                            AffinityTopologyVersion topVer = fut.get();
                            GridPartitionedSingleGetFuture.this.remap(topVer);
                        }
                        catch (IgniteCheckedException e) {
                            GridPartitionedSingleGetFuture.this.onDone(e);
                        }
                    }
                });
            } else {
                this.map(this.topVer);
            }
            return false;
        }
        return true;
    }

    private void setResult(@Nullable GridCacheEntryInfo info) {
        assert (info == null || this.skipVals == (info.value() == null));
        if (this.skipVals) {
            if (info != null) {
                this.setSkipValueResult(true, info.version());
            } else {
                this.setSkipValueResult(false, null);
            }
        } else if (info != null) {
            this.setResult(info.value(), info.version());
        } else {
            this.setResult(null, null);
        }
    }

    private void setSkipValueResult(boolean res, @Nullable GridCacheVersion ver) {
        assert (this.skipVals);
        if (this.needVer) {
            assert (ver != null || !res);
            this.onDone(new EntryGetResult(res, ver));
        } else {
            this.onDone(res);
        }
    }

    private void setResult(@Nullable CacheObject val, @Nullable GridCacheVersion ver) {
        try {
            assert (!this.skipVals);
            if (val != null) {
                if (!this.keepCacheObjects) {
                    Object res = this.cctx.unwrapBinaryIfNeeded(val, !this.deserializeBinary);
                    this.onDone(this.needVer ? new EntryGetResult(res, ver) : res);
                } else {
                    this.onDone(this.needVer ? new EntryGetResult(val, ver) : val);
                }
            } else {
                this.onDone(null);
            }
        }
        catch (Exception e) {
            this.onDone(e);
        }
    }

    private boolean partitionOwned(int part) {
        return this.cctx.topology().partitionState(this.cctx.localNodeId(), part) == GridDhtPartitionState.OWNING;
    }

    private ClusterTopologyServerNotFoundException serverNotFoundError(AffinityTopologyVersion topVer) {
        return new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", cache=" + this.cctx.name() + ']');
    }

    @Nullable
    private ClusterNode affinityNode(List<ClusterNode> affNodes) {
        if (!this.canRemap) {
            for (ClusterNode node : affNodes) {
                if (!this.cctx.discovery().alive(node)) continue;
                return node;
            }
            return null;
        }
        return affNodes.get(0);
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        if (!this.processResponse(nodeId)) {
            return false;
        }
        if (this.canRemap) {
            final AffinityTopologyVersion updTopVer = new AffinityTopologyVersion(Math.max(this.topVer.topologyVersion() + 1L, this.cctx.discovery().topologyVersion()));
            this.cctx.affinity().affinityReadyFuture(updTopVer).listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                    try {
                        fut.get();
                        GridPartitionedSingleGetFuture.this.remap(updTopVer);
                    }
                    catch (IgniteCheckedException e) {
                        GridPartitionedSingleGetFuture.this.onDone(e);
                    }
                }
            });
        } else {
            this.remap(this.topVer);
        }
        return true;
    }

    private void remap(final AffinityTopologyVersion topVer) {
        this.cctx.closures().runLocalSafe(new Runnable(){

            @Override
            public void run() {
                GridPartitionedSingleGetFuture.this.map(topVer);
            }
        });
    }

    @Override
    public boolean onDone(Object res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            this.cctx.dht().sendTtlUpdateRequest(this.expiryPlc);
            return true;
        }
        return false;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
    }

    @Override
    public String toString() {
        return S.toString(GridPartitionedSingleGetFuture.class, this);
    }
}

