/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAtomicFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtAtomicAbstractUpdateFuture
extends GridFutureAdapter<Void>
implements GridCacheAtomicFuture<Void> {
    private static final long serialVersionUID = 0L;
    protected static IgniteLogger log;
    private static final AtomicReference<IgniteLogger> logRef;
    protected static IgniteLogger msgLog;
    protected final GridCacheVersion writeVer;
    protected final GridCacheContext cctx;
    protected final GridCacheVersion futVer;
    @GridToStringExclude
    private final CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb;
    protected final GridNearAtomicAbstractUpdateRequest updateReq;
    final GridNearAtomicUpdateResponse updateRes;
    @GridToStringInclude
    protected Map<UUID, GridDhtAtomicAbstractUpdateRequest> mappings;
    private Collection<CI1<Boolean>> cntQryClsrs;
    private final boolean waitForExchange;
    private volatile int resCnt;

    protected GridDhtAtomicAbstractUpdateFuture(GridCacheContext cctx, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb, GridCacheVersion writeVer, GridNearAtomicAbstractUpdateRequest updateReq, GridNearAtomicUpdateResponse updateRes) {
        this.cctx = cctx;
        this.futVer = cctx.versions().next(updateReq.topologyVersion());
        this.updateReq = updateReq;
        this.completionCb = completionCb;
        this.updateRes = updateRes;
        this.writeVer = writeVer;
        boolean bl = this.waitForExchange = !updateReq.topologyLocked() && (!updateReq.fastMap() || updateReq.clientRequest());
        if (log == null) {
            msgLog = cctx.shared().atomicMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridDhtAtomicUpdateFuture.class);
        }
    }

    @Override
    public final IgniteInternalFuture<Void> completeFuture(AffinityTopologyVersion topVer) {
        if (this.waitForExchange && this.updateReq.topologyVersion().compareTo(topVer) < 0) {
            return this;
        }
        return null;
    }

    public final void addContinuousQueryClosure(CI1<Boolean> clsr) {
        assert (!this.isDone()) : this;
        if (this.cntQryClsrs == null) {
            this.cntQryClsrs = new ArrayList<CI1<Boolean>>(10);
        }
        this.cntQryClsrs.add(clsr);
    }

    final void addWriteEntry(GridDhtCacheEntry entry, @Nullable CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer, boolean addPrevVal, @Nullable CacheObject prevVal, long updateCntr) {
        AffinityTopologyVersion topVer = this.updateReq.topologyVersion();
        List<ClusterNode> dhtNodes = this.cctx.dht().topology().nodes(entry.partition(), topVer);
        if (log.isDebugEnabled()) {
            log.debug("Mapping entry to DHT nodes [nodes=" + U.nodeIds(dhtNodes) + ", entry=" + entry + ']');
        }
        CacheWriteSynchronizationMode syncMode = this.updateReq.writeSynchronizationMode();
        this.addDhtKey(entry.key(), dhtNodes);
        for (int i = 0; i < dhtNodes.size(); ++i) {
            ClusterNode node = dhtNodes.get(i);
            UUID nodeId = node.id();
            if (nodeId.equals(this.cctx.localNodeId())) continue;
            GridDhtAtomicAbstractUpdateRequest updateReq = this.mappings.get(nodeId);
            if (updateReq == null) {
                updateReq = this.createRequest(node, this.futVer, this.writeVer, syncMode, topVer, ttl, conflictExpireTime, conflictVer);
                this.mappings.put(nodeId, updateReq);
            }
            updateReq.addWriteValue(entry.key(), val, entryProcessor, ttl, conflictExpireTime, conflictVer, addPrevVal, entry.partition(), prevVal, updateCntr);
        }
    }

    protected abstract void addDhtKey(KeyCacheObject var1, List<ClusterNode> var2);

    protected abstract void addNearKey(KeyCacheObject var1, Collection<UUID> var2);

    final void addNearWriteEntries(Collection<UUID> readers, GridDhtCacheEntry entry, @Nullable CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, long ttl, long expireTime) {
        CacheWriteSynchronizationMode syncMode = this.updateReq.writeSynchronizationMode();
        this.addNearKey(entry.key(), readers);
        AffinityTopologyVersion topVer = this.updateReq.topologyVersion();
        for (UUID nodeId : readers) {
            GridDhtAtomicAbstractUpdateRequest updateReq = this.mappings.get(nodeId);
            if (updateReq == null) {
                ClusterNode node = this.cctx.discovery().node(nodeId);
                if (node == null) continue;
                updateReq = this.createRequest(node, this.futVer, this.writeVer, syncMode, topVer, ttl, expireTime, null);
                this.mappings.put(nodeId, updateReq);
            }
            this.addNearReaderEntry(entry);
            updateReq.addNearWriteValue(entry.key(), val, entryProcessor, ttl, expireTime);
        }
    }

    protected abstract void addNearReaderEntry(GridDhtCacheEntry var1);

    final GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    @Override
    public final IgniteUuid futureId() {
        return this.futVer.asGridUuid();
    }

    @Override
    public final GridCacheVersion version() {
        return this.futVer;
    }

    @Override
    public final boolean onNodeLeft(UUID nodeId) {
        boolean res = this.registerResponse(nodeId);
        if (res && msgLog.isDebugEnabled()) {
            msgLog.debug("DTH update fut, node left [futId=" + this.futVer + ", writeVer=" + this.writeVer + ", node=" + nodeId + ']');
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean registerResponse(UUID nodeId) {
        GridDhtAtomicAbstractUpdateRequest req;
        GridDhtAtomicAbstractUpdateRequest gridDhtAtomicAbstractUpdateRequest = req = this.mappings != null ? this.mappings.get(nodeId) : null;
        if (req != null) {
            int resCnt0;
            GridDhtAtomicAbstractUpdateFuture gridDhtAtomicAbstractUpdateFuture = this;
            synchronized (gridDhtAtomicAbstractUpdateFuture) {
                if (!req.onResponse()) {
                    return false;
                }
                resCnt0 = this.resCnt;
                this.resCnt = ++resCnt0;
            }
            if (resCnt0 == this.mappings.size()) {
                this.onDone();
            }
            return true;
        }
        return false;
    }

    final void map() {
        if (!F.isEmpty(this.mappings)) {
            for (GridDhtAtomicAbstractUpdateRequest req : this.mappings.values()) {
                try {
                    this.cctx.io().send(req.nodeId(), (GridCacheMessage)req, this.cctx.ioPolicy());
                    if (!msgLog.isDebugEnabled()) continue;
                    msgLog.debug("DTH update fut, sent request [futId=" + this.futVer + ", writeVer=" + this.writeVer + ", node=" + req.nodeId() + ']');
                }
                catch (ClusterTopologyCheckedException ignored) {
                    if (msgLog.isDebugEnabled()) {
                        msgLog.debug("DTH update fut, failed to send request, node left [futId=" + this.futVer + ", writeVer=" + this.writeVer + ", node=" + req.nodeId() + ']');
                    }
                    this.registerResponse(req.nodeId());
                }
                catch (IgniteCheckedException ignored) {
                    U.error(msgLog, "Failed to send request [futId=" + this.futVer + ", writeVer=" + this.writeVer + ", node=" + req.nodeId() + ']');
                    this.registerResponse(req.nodeId());
                }
            }
        } else {
            this.onDone();
        }
        if (this.updateReq.writeSynchronizationMode() != CacheWriteSynchronizationMode.FULL_SYNC) {
            this.completionCb.apply(this.updateReq, this.updateRes);
        }
    }

    public final void onResult(UUID nodeId) {
        if (log.isDebugEnabled()) {
            log.debug("Received deferred DHT atomic update future result [nodeId=" + nodeId + ']');
        }
        this.registerResponse(nodeId);
    }

    protected abstract GridDhtAtomicAbstractUpdateRequest createRequest(ClusterNode var1, GridCacheVersion var2, GridCacheVersion var3, CacheWriteSynchronizationMode var4, @NotNull AffinityTopologyVersion var5, long var6, long var8, @Nullable GridCacheVersion var10);

    public abstract void onResult(UUID var1, GridDhtAtomicUpdateResponse var2);

    protected abstract void addFailedKeys(GridNearAtomicUpdateResponse var1, Throwable var2);

    @Override
    public final boolean onDone(@Nullable Void res, @Nullable Throwable err) {
        if (super.onDone(res, err)) {
            boolean suc;
            this.cctx.mvcc().removeAtomicFuture(this.version());
            boolean bl = suc = err == null;
            if (!suc) {
                this.addFailedKeys(this.updateRes, err);
            }
            if (this.cntQryClsrs != null) {
                for (CI1<Boolean> clsr : this.cntQryClsrs) {
                    clsr.apply(suc);
                }
            }
            if (this.updateReq.writeSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC) {
                this.completionCb.apply(this.updateReq, this.updateRes);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
    }

    static {
        logRef = new AtomicReference();
    }
}

