/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CacheStorePartialUpdateException;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateAtomicResult;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridDeferredAckMessageSender;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedSingleGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicDeferredUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicOffHeapCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicSingleUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetResponse;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrExpirationInfo;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.CO;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedDeque8;

@GridToStringExclude
public class GridDhtAtomicCache<K, V>
extends GridDhtCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private static final int DEFERRED_UPDATE_RESPONSE_BUFFER_SIZE = Integer.getInteger("IGNITE_ATOMIC_DEFERRED_ACK_BUFFER_SIZE", 256);
    private static final int DEFERRED_UPDATE_RESPONSE_TIMEOUT = Integer.getInteger("IGNITE_ATOMIC_DEFERRED_ACK_TIMEOUT", 500);
    @GridToStringExclude
    private CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> updateReplyClos;
    private GridDeferredAckMessageSender deferredUpdateMsgSnd;
    private GridNearAtomicCache<K, V> near;
    private IgniteLogger msgLog;

    public GridDhtAtomicCache() {
    }

    public GridDhtAtomicCache(GridCacheContext<K, V> ctx) {
        super(ctx);
        this.msgLog = ctx.shared().atomicMessageLogger();
    }

    public GridDhtAtomicCache(GridCacheContext<K, V> ctx, GridCacheConcurrentMap map) {
        super(ctx, map);
        this.msgLog = ctx.shared().atomicMessageLogger();
    }

    @Override
    protected void checkJta() throws IgniteCheckedException {
    }

    @Override
    public boolean isDhtAtomic() {
        return true;
    }

    @Override
    protected GridCacheMapEntryFactory entryFactory() {
        return new GridCacheMapEntryFactory(){

            @Override
            public GridCacheMapEntry create(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key, int hash, CacheObject val) {
                if (ctx.useOffheapEntry()) {
                    return new GridDhtAtomicOffHeapCacheEntry(ctx, topVer, key, hash, val);
                }
                return new GridDhtAtomicCacheEntry(ctx, topVer, key, hash, val);
            }
        };
    }

    @Override
    protected void init() {
        super.init();
        this.updateReplyClos = new CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse>(){

            @Override
            public void apply(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
                if (GridDhtAtomicCache.this.ctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK) {
                    assert (req.writeSynchronizationMode() != CacheWriteSynchronizationMode.FULL_ASYNC) : req;
                    GridDhtAtomicCache.this.sendNearUpdateReply(res.nodeId(), res);
                    return;
                }
                assert (req.hasPrimary()) : req;
                if (req.writeSynchronizationMode() != CacheWriteSynchronizationMode.FULL_ASYNC) {
                    GridDhtAtomicCache.this.sendNearUpdateReply(res.nodeId(), res);
                } else if (!F.isEmpty(res.remapKeys())) {
                    GridDhtAtomicCache.this.remapToNewPrimary(req);
                } else if (res.error() != null) {
                    U.error(GridDhtAtomicCache.this.log, "Failed to process write update request in FULL_ASYNC mode for keys: " + res.failedKeys(), res.error());
                }
            }
        };
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.deferredUpdateMsgSnd = new GridDeferredAckMessageSender(this.ctx.time(), this.ctx.closures()){

            @Override
            public int getTimeout() {
                return DEFERRED_UPDATE_RESPONSE_TIMEOUT;
            }

            @Override
            public int getBufferSize() {
                return DEFERRED_UPDATE_RESPONSE_BUFFER_SIZE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finish(UUID nodeId, ConcurrentLinkedDeque8<GridCacheVersion> vers) {
                GridDhtAtomicDeferredUpdateResponse msg = new GridDhtAtomicDeferredUpdateResponse(GridDhtAtomicCache.this.ctx.cacheId(), vers, GridDhtAtomicCache.this.ctx.deploymentEnabled());
                try {
                    GridDhtAtomicCache.this.ctx.kernalContext().gateway().readLock();
                    try {
                        GridDhtAtomicCache.this.ctx.io().send(nodeId, (GridCacheMessage)msg, GridDhtAtomicCache.this.ctx.ioPolicy());
                        if (GridDhtAtomicCache.this.msgLog.isDebugEnabled()) {
                            GridDhtAtomicCache.this.msgLog.debug("Sent deferred DHT update response [futIds=" + msg.futureVersions() + ", node=" + nodeId + ']');
                        }
                    }
                    finally {
                        GridDhtAtomicCache.this.ctx.kernalContext().gateway().readUnlock();
                    }
                }
                catch (IllegalStateException ignored) {
                    if (GridDhtAtomicCache.this.msgLog.isDebugEnabled()) {
                        GridDhtAtomicCache.this.msgLog.debug("Failed to send deferred DHT update response, node is stopping [futIds=" + msg.futureVersions() + ", node=" + nodeId + ']');
                    }
                }
                catch (ClusterTopologyCheckedException ignored) {
                    if (GridDhtAtomicCache.this.msgLog.isDebugEnabled()) {
                        GridDhtAtomicCache.this.msgLog.debug("Failed to send deferred DHT update response, node left [futIds=" + msg.futureVersions() + ", node=" + nodeId + ']');
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(GridDhtAtomicCache.this.log, "Failed to send deferred DHT update response to remote node [futIds=" + msg.futureVersions() + ", node=" + nodeId + ']', e);
                }
            }
        };
        CacheMetricsImpl m = new CacheMetricsImpl(this.ctx);
        if (this.ctx.dht().near() != null) {
            m.delegate(this.ctx.dht().near().metrics0());
        }
        this.metrics = m;
        this.preldr = new GridDhtPreloader(this.ctx);
        this.preldr.start();
        this.ctx.io().addHandler(this.ctx.cacheId(), GridNearGetRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearGetRequest>(){

            @Override
            public void apply(UUID nodeId, GridNearGetRequest req) {
                GridDhtAtomicCache.this.processNearGetRequest(nodeId, req);
            }
        });
        this.ctx.io().addHandler(this.ctx.cacheId(), GridNearSingleGetRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearSingleGetRequest>(){

            @Override
            public void apply(UUID nodeId, GridNearSingleGetRequest req) {
                GridDhtAtomicCache.this.processNearSingleGetRequest(nodeId, req);
            }
        });
        this.ctx.io().addHandler(this.ctx.cacheId(), GridNearAtomicAbstractUpdateRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearAtomicAbstractUpdateRequest>(){

            @Override
            public void apply(UUID nodeId, GridNearAtomicAbstractUpdateRequest req) {
                GridDhtAtomicCache.this.processNearAtomicUpdateRequest(nodeId, req);
            }

            public String toString() {
                return "GridNearAtomicAbstractUpdateRequest handler [msgIdx=" + GridNearAtomicAbstractUpdateRequest.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addHandler(this.ctx.cacheId(), GridNearAtomicUpdateResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearAtomicUpdateResponse>(){

            @Override
            public void apply(UUID nodeId, GridNearAtomicUpdateResponse res) {
                GridDhtAtomicCache.this.processNearAtomicUpdateResponse(nodeId, res);
            }

            public String toString() {
                return "GridNearAtomicUpdateResponse handler [msgIdx=" + GridNearAtomicUpdateResponse.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addHandler(this.ctx.cacheId(), GridDhtAtomicAbstractUpdateRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridDhtAtomicAbstractUpdateRequest>(){

            @Override
            public void apply(UUID nodeId, GridDhtAtomicAbstractUpdateRequest req) {
                GridDhtAtomicCache.this.processDhtAtomicUpdateRequest(nodeId, req);
            }

            public String toString() {
                return "GridDhtAtomicUpdateRequest handler [msgIdx=" + GridDhtAtomicUpdateRequest.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addHandler(this.ctx.cacheId(), GridDhtAtomicUpdateResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridDhtAtomicUpdateResponse>(){

            @Override
            public void apply(UUID nodeId, GridDhtAtomicUpdateResponse res) {
                GridDhtAtomicCache.this.processDhtAtomicUpdateResponse(nodeId, res);
            }

            public String toString() {
                return "GridDhtAtomicUpdateResponse handler [msgIdx=" + GridDhtAtomicUpdateResponse.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addHandler(this.ctx.cacheId(), GridDhtAtomicDeferredUpdateResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridDhtAtomicDeferredUpdateResponse>(){

            @Override
            public void apply(UUID nodeId, GridDhtAtomicDeferredUpdateResponse res) {
                GridDhtAtomicCache.this.processDhtAtomicDeferredUpdateResponse(nodeId, res);
            }

            public String toString() {
                return "GridDhtAtomicDeferredUpdateResponse handler [msgIdx=" + GridDhtAtomicDeferredUpdateResponse.CACHE_MSG_IDX + ']';
            }
        });
        if (this.near == null) {
            this.ctx.io().addHandler(this.ctx.cacheId(), GridNearGetResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearGetResponse>(){

                @Override
                public void apply(UUID nodeId, GridNearGetResponse res) {
                    GridDhtAtomicCache.this.processNearGetResponse(nodeId, res);
                }
            });
            this.ctx.io().addHandler(this.ctx.cacheId(), GridNearSingleGetResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearSingleGetResponse>(){

                @Override
                public void apply(UUID nodeId, GridNearSingleGetResponse res) {
                    GridDhtAtomicCache.this.processNearSingleGetResponse(nodeId, res);
                }
            });
        }
    }

    @Override
    public void stop() {
        this.deferredUpdateMsgSnd.stop();
    }

    public void near(GridNearAtomicCache<K, V> near) {
        this.near = near;
    }

    @Override
    public GridNearCacheAdapter<K, V> near() {
        return this.near;
    }

    @Override
    protected V get0(K key, String taskName, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (this.keyCheck) {
            this.validateCacheKey(key);
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        UUID subjId = this.ctx.subjectIdPerCall(null, opCtx);
        ExpiryPolicy expiryPlc = opCtx != null ? opCtx.expiry() : null;
        boolean skipStore = opCtx != null && opCtx.skipStore();
        try {
            return this.getAsync0(this.ctx.toCacheKeyObject(key), !this.ctx.config().isReadFromBackup(), subjId, taskName, deserializeBinary, expiryPlc, false, skipStore, true, needVer).get();
        }
        catch (IgniteException e) {
            if (e.getCause(IgniteCheckedException.class) != null) {
                throw e.getCause(IgniteCheckedException.class);
            }
            throw e;
        }
    }

    @Override
    protected IgniteInternalFuture<V> getAsync(final K key, final boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, final String taskName, final boolean deserializeBinary, final boolean skipVals, final boolean canRemap, final boolean needVer) {
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (this.keyCheck) {
            this.validateCacheKey(key);
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final UUID subjId0 = subjId = this.ctx.subjectIdPerCall(null, opCtx);
        final ExpiryPolicy expiryPlc = skipVals ? null : (opCtx != null ? opCtx.expiry() : null);
        final boolean skipStore = opCtx != null && opCtx.skipStore();
        return this.asyncOp(new CO<IgniteInternalFuture<V>>(){

            @Override
            public IgniteInternalFuture<V> apply() {
                return GridDhtAtomicCache.this.getAsync0(GridDhtAtomicCache.this.ctx.toCacheKeyObject(key), forcePrimary, subjId0, taskName, deserializeBinary, expiryPlc, skipVals, skipStore, canRemap, needVer);
            }
        });
    }

    @Override
    protected Map<K, V> getAll0(Collection<? extends K> keys, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        return this.getAllAsyncInternal(keys, !this.ctx.config().isReadFromBackup(), null, this.ctx.kernalContext().job().currentTaskName(), deserializeBinary, false, true, needVer, false).get();
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(@Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, String taskName, boolean deserializeBinary, boolean skipVals, boolean canRemap, boolean needVer) {
        return this.getAllAsyncInternal(keys, forcePrimary, subjId, taskName, deserializeBinary, skipVals, canRemap, needVer, true);
    }

    private IgniteInternalFuture<Map<K, V>> getAllAsyncInternal(final @Nullable Collection<? extends K> keys, final boolean forcePrimary, @Nullable UUID subjId, final String taskName, final boolean deserializeBinary, final boolean skipVals, final boolean canRemap, final boolean needVer, boolean asyncOp) {
        boolean skipStore;
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture(Collections.emptyMap());
        }
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final UUID subjId0 = subjId = this.ctx.subjectIdPerCall(subjId, opCtx);
        final ExpiryPolicy expiryPlc = skipVals ? null : (opCtx != null ? opCtx.expiry() : null);
        boolean bl = skipStore = opCtx != null && opCtx.skipStore();
        if (asyncOp) {
            return this.asyncOp(new CO<IgniteInternalFuture<Map<K, V>>>(){

                @Override
                public IgniteInternalFuture<Map<K, V>> apply() {
                    return GridDhtAtomicCache.this.getAllAsync0(GridDhtAtomicCache.this.ctx.cacheKeysView(keys), forcePrimary, subjId0, taskName, deserializeBinary, expiryPlc, skipVals, skipStore, canRemap, needVer);
                }
            });
        }
        return this.getAllAsync0(this.ctx.cacheKeysView(keys), forcePrimary, subjId0, taskName, deserializeBinary, expiryPlc, skipVals, skipStore, canRemap, needVer);
    }

    @Override
    protected V getAndPut0(K key, V val, @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        return (V)this.update0(key, val, null, null, true, filter, true, false).get();
    }

    @Override
    protected boolean put0(K key, V val, CacheEntryPredicate filter) throws IgniteCheckedException {
        Boolean res = (Boolean)this.update0(key, val, null, null, false, filter, true, false).get();
        assert (res != null);
        return res;
    }

    @Override
    public IgniteInternalFuture<V> getAndPutAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.update0(key, val, null, null, true, filter, true, true);
    }

    @Override
    public IgniteInternalFuture<Boolean> putAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.update0(key, val, null, null, false, filter, true, true);
    }

    @Override
    public V tryGetAndPut(K key, V val) throws IgniteCheckedException {
        A.notNull(key, "key", val, "val");
        return (V)this.update0(key, val, null, null, true, null, false, false).get();
    }

    @Override
    protected void putAll0(Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        this.updateAll0(m, null, null, null, null, false, false, true, GridCacheOperation.UPDATE, false).get();
    }

    @Override
    public IgniteInternalFuture<?> putAllAsync0(Map<? extends K, ? extends V> m) {
        return this.updateAll0(m, null, null, null, null, false, false, true, GridCacheOperation.UPDATE, true).chain(RET2NULL);
    }

    @Override
    public void putAllConflict(Map<KeyCacheObject, GridCacheDrInfo> conflictMap) throws IgniteCheckedException {
        this.putAllConflictAsync(conflictMap).get();
    }

    @Override
    public IgniteInternalFuture<?> putAllConflictAsync(Map<KeyCacheObject, GridCacheDrInfo> conflictMap) {
        this.ctx.dr().onReceiveCacheEntriesReceived(conflictMap.size());
        return this.updateAll0(null, null, null, conflictMap, null, false, false, true, GridCacheOperation.UPDATE, true);
    }

    @Override
    public V getAndRemove0(K key) throws IgniteCheckedException {
        return (V)this.remove0(key, true, null, false).get();
    }

    @Override
    public IgniteInternalFuture<V> getAndRemoveAsync0(K key) {
        return this.remove0(key, true, null, true);
    }

    @Override
    protected void removeAll0(Collection<? extends K> keys) throws IgniteCheckedException {
        this.removeAllAsync0(keys, null, false, false, false).get();
    }

    @Override
    public IgniteInternalFuture<Object> removeAllAsync0(Collection<? extends K> keys) {
        return this.removeAllAsync0(keys, null, false, false, true).chain(RET2NULL);
    }

    @Override
    protected boolean remove0(K key, CacheEntryPredicate filter) throws IgniteCheckedException {
        return (Boolean)this.remove0(key, false, filter, false).get();
    }

    @Override
    public IgniteInternalFuture<Boolean> removeAsync0(K key, @Nullable CacheEntryPredicate filter) {
        return this.remove0(key, false, filter, true);
    }

    @Override
    public void removeAllConflict(Map<KeyCacheObject, GridCacheVersion> conflictMap) throws IgniteCheckedException {
        this.removeAllConflictAsync(conflictMap).get();
    }

    @Override
    public IgniteInternalFuture<?> removeAllConflictAsync(Map<KeyCacheObject, GridCacheVersion> conflictMap) {
        this.ctx.dr().onReceiveCacheEntriesReceived(conflictMap.size());
        return this.removeAllAsync0(null, conflictMap, false, false, true);
    }

    private boolean writeThrough() {
        return this.ctx.writeThrough() && this.ctx.store().configured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> IgniteInternalFuture<T> asyncOp(final CO<IgniteInternalFuture<T>> op) {
        IgniteInternalFuture fail = this.asyncOpAcquire();
        if (fail != null) {
            return fail;
        }
        GridCacheAdapter.FutureHolder holder = (GridCacheAdapter.FutureHolder)this.lastFut.get();
        holder.lock();
        try {
            IgniteInternalFuture fut = holder.future();
            if (fut != null && !fut.isDone()) {
                GridEmbeddedFuture f = new GridEmbeddedFuture(fut, new IgniteOutClosure<IgniteInternalFuture>(){

                    @Override
                    public IgniteInternalFuture<T> apply() {
                        if (GridDhtAtomicCache.this.ctx.kernalContext().isStopping()) {
                            return new GridFinishedFuture(new IgniteCheckedException("Operation has been cancelled (node is stopping)."));
                        }
                        return (IgniteInternalFuture)op.apply();
                    }
                });
                this.saveFuture(holder, f);
                GridEmbeddedFuture gridEmbeddedFuture = f;
                return gridEmbeddedFuture;
            }
            IgniteInternalFuture f = (IgniteInternalFuture)op.apply();
            this.saveFuture(holder, f);
            IgniteInternalFuture igniteInternalFuture = f;
            return igniteInternalFuture;
        }
        finally {
            holder.unlock();
        }
    }

    @Override
    protected IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> keys, long timeout, @Nullable IgniteTxLocalEx tx, boolean isInvalidate, boolean isRead, boolean retval, @Nullable TransactionIsolation isolation, long createTtl, long accessTtl) {
        return new FinishedLockFuture(new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)"));
    }

    @Override
    public <T> EntryProcessorResult<T> invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        IgniteInternalFuture<EntryProcessorResult<T>> invokeFut = this.invoke0(false, key, entryProcessor, args);
        CacheInvokeResult res = invokeFut.get();
        return res != null ? res : new CacheInvokeResult();
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.invokeAll0(false, keys, entryProcessor, args).get();
    }

    @Override
    public <T> IgniteInternalFuture<EntryProcessorResult<T>> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.invoke0(true, key, entryProcessor, args);
    }

    private <T> IgniteInternalFuture<EntryProcessorResult<T>> invoke0(boolean async, K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        CacheOperationContext opCtx;
        A.notNull(key, "key", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKey(key);
        }
        final boolean keepBinary = (opCtx = this.ctx.operationContextPerCall()) != null && opCtx.isKeepBinary();
        IgniteInternalFuture fut = this.update0(key, null, entryProcessor, args, false, null, true, async);
        return fut.chain(new CX1<IgniteInternalFuture<Map<K, EntryProcessorResult<T>>>, EntryProcessorResult<T>>(){

            @Override
            public EntryProcessorResult<T> applyx(IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> fut) throws IgniteCheckedException {
                Map resMap = fut.get();
                if (resMap != null) {
                    CacheInvokeResult invokeRes;
                    EntryProcessorResult res;
                    assert (resMap.isEmpty() || resMap.size() == 1) : resMap.size();
                    EntryProcessorResult entryProcessorResult = res = resMap.isEmpty() ? null : resMap.values().iterator().next();
                    if (res instanceof CacheInvokeResult && (invokeRes = (CacheInvokeResult)res).result() != null) {
                        res = CacheInvokeResult.fromResult(GridDhtAtomicCache.this.ctx.unwrapBinaryIfNeeded(invokeRes.result(), keepBinary, false));
                    }
                    return res;
                }
                return null;
            }
        });
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.invokeAll0(true, keys, entryProcessor, args);
    }

    private <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAll0(boolean async, Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor>(){

            @Override
            public EntryProcessor apply(K k) {
                return entryProcessor;
            }
        }, new IgnitePredicate[0]);
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        IgniteInternalFuture resFut = this.updateAll0(null, invokeMap, args, null, null, false, false, true, GridCacheOperation.TRANSFORM, async);
        return resFut.chain(new CX1<IgniteInternalFuture<Map<K, EntryProcessorResult<T>>>, Map<K, EntryProcessorResult<T>>>(){

            @Override
            public Map<K, EntryProcessorResult<T>> applyx(IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> fut) throws IgniteCheckedException {
                Map<Object, EntryProcessorResult> resMap = fut.get();
                return GridDhtAtomicCache.this.ctx.unwrapInvokeResult(resMap, keepBinary);
            }
        });
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws IgniteCheckedException {
        A.notNull(map, "map");
        if (this.keyCheck) {
            this.validateCacheKeys(map.keySet());
        }
        return (Map)this.updateAll0(null, map, args, null, null, false, false, true, GridCacheOperation.TRANSFORM, false).get();
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        A.notNull(map, "map");
        if (this.keyCheck) {
            this.validateCacheKeys(map.keySet());
        }
        return this.updateAll0(null, map, args, null, null, false, false, true, GridCacheOperation.TRANSFORM, true);
    }

    private IgniteInternalFuture updateAll0(@Nullable Map<? extends K, ? extends V> map, @Nullable Map<? extends K, ? extends EntryProcessor> invokeMap, @Nullable Object[] invokeArgs, @Nullable Map<KeyCacheObject, GridCacheDrInfo> conflictPutMap, @Nullable Map<KeyCacheObject, GridCacheVersion> conflictRmvMap, boolean retval, boolean rawRetval, boolean waitTopFut, GridCacheOperation op, boolean async) {
        assert (this.ctx.updatesAllowed());
        if (map != null && this.keyCheck) {
            this.validateCacheKeys(map.keySet());
        }
        this.ctx.checkSecurity(SecurityPermission.CACHE_PUT);
        final CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        if (opCtx != null && opCtx.hasDataCenterId()) {
            assert (conflictPutMap == null) : conflictPutMap;
            assert (conflictRmvMap == null) : conflictRmvMap;
            if (op == GridCacheOperation.TRANSFORM) {
                assert (invokeMap != null) : invokeMap;
                conflictPutMap = F.viewReadOnly(invokeMap, new IgniteClosure<EntryProcessor, GridCacheDrInfo>(){

                    @Override
                    public GridCacheDrInfo apply(EntryProcessor o) {
                        return new GridCacheDrInfo(o, GridDhtAtomicCache.this.ctx.versions().next(opCtx.dataCenterId()));
                    }
                }, new IgnitePredicate[0]);
                invokeMap = null;
            } else if (op == GridCacheOperation.DELETE) {
                assert (map != null) : map;
                conflictRmvMap = F.viewReadOnly(map, new IgniteClosure<V, GridCacheVersion>(){

                    @Override
                    public GridCacheVersion apply(V o) {
                        return GridDhtAtomicCache.this.ctx.versions().next(opCtx.dataCenterId());
                    }
                }, new IgnitePredicate[0]);
                map = null;
            } else {
                assert (map != null) : map;
                conflictPutMap = F.viewReadOnly(map, new IgniteClosure<V, GridCacheDrInfo>(){

                    @Override
                    public GridCacheDrInfo apply(V o) {
                        return new GridCacheDrInfo(GridDhtAtomicCache.this.ctx.toCacheObject(o), GridDhtAtomicCache.this.ctx.versions().next(opCtx.dataCenterId()));
                    }
                }, new IgnitePredicate[0]);
                map = null;
            }
        }
        UUID subjId = this.ctx.subjectIdPerCall(null, opCtx);
        int taskNameHash = this.ctx.kernalContext().job().currentTaskNameHash();
        final GridNearAtomicUpdateFuture updateFut = new GridNearAtomicUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), op, map != null ? map.keySet() : (invokeMap != null ? invokeMap.keySet() : (conflictPutMap != null ? conflictPutMap.keySet() : conflictRmvMap.keySet())), map != null ? map.values() : (invokeMap != null ? invokeMap.values() : null), invokeArgs, conflictPutMap != null ? conflictPutMap.values() : null, conflictRmvMap != null ? conflictRmvMap.values() : null, retval, rawRetval, opCtx != null ? opCtx.expiry() : null, CU.filterArray(null), subjId, taskNameHash, opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES, waitTopFut);
        if (async) {
            return this.asyncOp(new CO<IgniteInternalFuture<Object>>(){

                @Override
                public IgniteInternalFuture<Object> apply() {
                    updateFut.map();
                    return updateFut;
                }
            });
        }
        updateFut.map();
        return updateFut;
    }

    private IgniteInternalFuture update0(K key, @Nullable V val, @Nullable EntryProcessor proc, @Nullable Object[] invokeArgs, boolean retval, @Nullable CacheEntryPredicate filter, boolean waitTopFut, boolean async) {
        assert (val == null || proc == null);
        assert (this.ctx.updatesAllowed());
        this.validateCacheKey(key);
        this.ctx.checkSecurity(SecurityPermission.CACHE_PUT);
        final GridNearAtomicAbstractUpdateFuture updateFut = this.createSingleUpdateFuture(key, val, proc, invokeArgs, retval, filter, waitTopFut);
        if (async) {
            return this.asyncOp(new CO<IgniteInternalFuture<Object>>(){

                @Override
                public IgniteInternalFuture<Object> apply() {
                    updateFut.map();
                    return updateFut;
                }
            });
        }
        updateFut.map();
        return updateFut;
    }

    private IgniteInternalFuture remove0(K key, boolean retval, @Nullable CacheEntryPredicate filter, boolean async) {
        assert (this.ctx.updatesAllowed());
        this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        final GridNearAtomicAbstractUpdateFuture updateFut = this.createSingleUpdateFuture(key, null, null, null, retval, filter, true);
        if (async) {
            return this.asyncOp(new CO<IgniteInternalFuture<Object>>(){

                @Override
                public IgniteInternalFuture<Object> apply() {
                    updateFut.map();
                    return updateFut;
                }
            });
        }
        updateFut.map();
        return updateFut;
    }

    private GridNearAtomicAbstractUpdateFuture createSingleUpdateFuture(K key, @Nullable V val, @Nullable EntryProcessor proc, @Nullable Object[] invokeArgs, boolean retval, @Nullable CacheEntryPredicate filter, boolean waitTopFut) {
        Object val0;
        GridCacheOperation op;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        if (val != null) {
            op = GridCacheOperation.UPDATE;
            val0 = val;
        } else if (proc != null) {
            op = GridCacheOperation.TRANSFORM;
            val0 = proc;
        } else {
            op = GridCacheOperation.DELETE;
            val0 = null;
        }
        GridCacheDrInfo conflictPutVal = null;
        GridCacheVersion conflictRmvVer = null;
        if (opCtx != null && opCtx.hasDataCenterId()) {
            Byte dcId = opCtx.dataCenterId();
            assert (dcId != null);
            if (op == GridCacheOperation.UPDATE) {
                conflictPutVal = new GridCacheDrInfo(this.ctx.toCacheObject(val), this.ctx.versions().next(dcId));
                val0 = null;
            } else if (op == GridCacheOperation.TRANSFORM) {
                conflictPutVal = new GridCacheDrInfo(proc, this.ctx.versions().next(dcId));
                val0 = null;
            } else {
                conflictRmvVer = this.ctx.versions().next(dcId);
            }
        }
        CacheEntryPredicate[] filters = CU.filterArray(filter);
        if (conflictPutVal == null && conflictRmvVer == null && !this.isFastMap(filters, op)) {
            return new GridNearAtomicSingleUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), op, key, val0, invokeArgs, retval, false, opCtx != null ? opCtx.expiry() : null, filters, this.ctx.subjectIdPerCall(null, opCtx), this.ctx.kernalContext().job().currentTaskNameHash(), opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES, waitTopFut);
        }
        return new GridNearAtomicUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), op, Collections.singletonList(key), val0 != null ? Collections.singletonList(val0) : null, invokeArgs, conflictPutVal != null ? Collections.singleton(conflictPutVal) : null, conflictRmvVer != null ? Collections.singleton(conflictRmvVer) : null, retval, false, opCtx != null ? opCtx.expiry() : null, filters, this.ctx.subjectIdPerCall(null, opCtx), this.ctx.kernalContext().job().currentTaskNameHash(), opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES, waitTopFut);
    }

    public boolean isFastMap(CacheEntryPredicate[] filters, GridCacheOperation op) {
        return F.isEmpty(filters) && op != GridCacheOperation.TRANSFORM && this.ctx.config().getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC && this.ctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK && (!this.ctx.writeThrough() || this.ctx.config().getInterceptor() == null);
    }

    private IgniteInternalFuture removeAllAsync0(@Nullable Collection<? extends K> keys, @Nullable Map<KeyCacheObject, GridCacheVersion> conflictMap, boolean retval, boolean rawRetval, boolean async) {
        assert (this.ctx.updatesAllowed());
        assert (keys != null || conflictMap != null);
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        final CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        UUID subjId = this.ctx.subjectIdPerCall(null, opCtx);
        int taskNameHash = this.ctx.kernalContext().job().currentTaskNameHash();
        Collection drVers = null;
        if (opCtx != null && keys != null && opCtx.hasDataCenterId()) {
            assert (conflictMap == null) : conflictMap;
            drVers = F.transform(keys, new C1<K, GridCacheVersion>(){

                @Override
                public GridCacheVersion apply(K k) {
                    return GridDhtAtomicCache.this.ctx.versions().next(opCtx.dataCenterId());
                }
            });
        }
        final GridNearAtomicUpdateFuture updateFut = new GridNearAtomicUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), GridCacheOperation.DELETE, keys != null ? keys : conflictMap.keySet(), null, null, null, (Collection<GridCacheVersion>)(drVers != null ? drVers : (keys != null ? null : conflictMap.values())), retval, rawRetval, opCtx != null ? opCtx.expiry() : null, CU.filterArray(null), subjId, taskNameHash, opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES, true);
        if (async) {
            return this.asyncOp(new CO<IgniteInternalFuture<Object>>(){

                @Override
                public IgniteInternalFuture<Object> apply() {
                    updateFut.map();
                    return updateFut;
                }
            });
        }
        updateFut.map();
        return updateFut;
    }

    private IgniteInternalFuture<V> getAsync0(KeyCacheObject key, boolean forcePrimary, UUID subjId, String taskName, boolean deserializeBinary, @Nullable ExpiryPolicy expiryPlc, boolean skipVals, boolean skipStore, boolean canRemap, boolean needVer) {
        AffinityTopologyVersion topVer = canRemap ? this.ctx.affinity().affinityTopologyVersion() : this.ctx.shared().exchange().readyAffinityVersion();
        IgniteCacheExpiryPolicy expiry = skipVals ? null : this.expiryPolicy(expiryPlc);
        GridPartitionedSingleGetFuture fut = new GridPartitionedSingleGetFuture(this.ctx, key, topVer, !skipStore, forcePrimary, subjId, taskName, deserializeBinary, expiry, skipVals, canRemap, needVer, false);
        fut.init();
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IgniteInternalFuture<Map<K, V>> getAllAsync0(@Nullable Collection<KeyCacheObject> keys, boolean forcePrimary, UUID subjId, String taskName, boolean deserializeBinary, @Nullable ExpiryPolicy expiryPlc, boolean skipVals, boolean skipStore, boolean canRemap, boolean needVer) {
        IgniteCacheExpiryPolicy expiry;
        AffinityTopologyVersion topVer = canRemap ? this.ctx.affinity().affinityTopologyVersion() : this.ctx.shared().exchange().readyAffinityVersion();
        IgniteCacheExpiryPolicy igniteCacheExpiryPolicy = expiry = skipVals ? null : this.expiryPolicy(expiryPlc);
        if (!forcePrimary && this.ctx.affinityNode()) {
            HashMap locVals = U.newHashMap(keys.size());
            boolean success = true;
            for (KeyCacheObject key : keys) {
                GridCacheEntryEx entry = null;
                while (true) {
                    try {
                        GridCacheEntryEx gridCacheEntryEx = entry = this.ctx.isSwapOrOffheapEnabled() ? this.entryEx(key) : this.peekEx(key);
                        if (entry != null) {
                            boolean isNew = entry.isNewLocked();
                            EntryGetResult getRes = null;
                            CacheObject v = null;
                            GridCacheVersion ver = null;
                            if (needVer) {
                                getRes = entry.innerGetVersioned(null, null, true, true, false, !skipVals, subjId, null, taskName, expiry, true, null);
                                if (getRes != null) {
                                    v = (CacheObject)getRes.value();
                                    ver = getRes.version();
                                }
                            } else {
                                v = entry.innerGet(null, null, true, false, false, !skipVals, false, subjId, null, taskName, expiry, !deserializeBinary);
                            }
                            if (v == null) {
                                GridCacheVersion obsoleteVer = this.context().versions().next();
                                if (isNew && entry.markObsoleteIfEmpty(obsoleteVer)) {
                                    this.removeEntry(entry);
                                }
                                success = false;
                                break;
                            }
                            this.ctx.addResult(locVals, key, v, skipVals, false, deserializeBinary, true, getRes, ver, 0L, 0L, needVer);
                            break;
                        }
                        success = false;
                    }
                    catch (GridCacheEntryRemovedException isNew) {
                        continue;
                    }
                    catch (GridDhtInvalidPartitionException ignored) {
                        success = false;
                    }
                    catch (IgniteCheckedException e) {
                        GridFinishedFuture<Map<K, V>> gridFinishedFuture = new GridFinishedFuture<Map<K, V>>(e);
                        return gridFinishedFuture;
                    }
                    finally {
                        if (entry == null) continue;
                        this.ctx.evicts().touch(entry, topVer);
                        continue;
                    }
                    break;
                }
                if (!success) break;
                if (skipVals || !this.ctx.config().isStatisticsEnabled()) continue;
                this.metrics0().onRead(true);
            }
            if (success) {
                this.sendTtlUpdateRequest(expiry);
                return new GridFinishedFuture<Map<K, V>>(locVals);
            }
        }
        if (expiry != null) {
            expiry.reset();
        }
        GridPartitionedGetFuture fut = new GridPartitionedGetFuture(this.ctx, keys, topVer, !skipStore, forcePrimary, subjId, taskName, deserializeBinary, expiry, skipVals, canRemap, needVer, false);
        fut.init();
        return fut;
    }

    public void updateAllAsyncInternal(final UUID nodeId, final GridNearAtomicAbstractUpdateRequest req, final CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb) {
        IgniteInternalFuture<Object> forceFut = this.preldr.request(req, req.topologyVersion());
        if (forceFut == null || forceFut.isDone()) {
            try {
                if (forceFut != null) {
                    forceFut.get();
                }
            }
            catch (NodeStoppingException ignored) {
                return;
            }
            catch (IgniteCheckedException e) {
                this.onForceKeysError(nodeId, req, completionCb, e);
                return;
            }
            this.updateAllAsyncInternal0(nodeId, req, completionCb);
        } else {
            forceFut.listen((IgniteInClosure<IgniteInternalFuture<Object>>)new CI1<IgniteInternalFuture<Object>>(){

                @Override
                public void apply(IgniteInternalFuture<Object> fut) {
                    try {
                        fut.get();
                    }
                    catch (NodeStoppingException ignored) {
                        return;
                    }
                    catch (IgniteCheckedException e) {
                        GridDhtAtomicCache.this.onForceKeysError(nodeId, req, completionCb, e);
                        return;
                    }
                    GridDhtAtomicCache.this.updateAllAsyncInternal0(nodeId, req, completionCb);
                }
            });
        }
    }

    private void onForceKeysError(UUID nodeId, GridNearAtomicAbstractUpdateRequest req, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb, IgniteCheckedException e) {
        GridNearAtomicUpdateResponse res = new GridNearAtomicUpdateResponse(this.ctx.cacheId(), nodeId, req.futureVersion(), this.ctx.deploymentEnabled());
        res.addFailedKeys(req.keys(), e);
        completionCb.apply(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateAllAsyncInternal0(UUID nodeId, GridNearAtomicAbstractUpdateRequest req, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb) {
        GridNearAtomicUpdateResponse res = new GridNearAtomicUpdateResponse(this.ctx.cacheId(), nodeId, req.futureVersion(), this.ctx.deploymentEnabled());
        assert (!req.returnValue() || req.operation() == GridCacheOperation.TRANSFORM || req.size() == 1);
        GridDhtAtomicAbstractUpdateFuture dhtFut = null;
        boolean remap = false;
        String taskName = this.ctx.kernalContext().task().resolveTaskName(req.taskNameHash());
        IgniteCacheExpiryPolicy expiry = null;
        try {
            List<GridDhtCacheEntry> locked = this.lockEntries(req, req.topologyVersion());
            Collection deleted = null;
            try {
                GridDhtPartitionTopology top = this.topology();
                top.readLock();
                try {
                    if (top.stopping()) {
                        res.addFailedKeys(req.keys(), new IgniteCheckedException("Failed to perform cache operation (cache is stopped): " + this.name()));
                        completionCb.apply(req, res);
                        top.readUnlock();
                        return;
                    }
                    if (req.fastMap() && !req.clientRequest() || req.topologyLocked() || !this.needRemap(req.topologyVersion(), top.topologyVersion())) {
                        Object updRes;
                        ClusterNode node = this.ctx.discovery().node(nodeId);
                        if (node == null) {
                            U.warn(this.msgLog, "Skip near update request, node originated update request left [futId=" + req.futureVersion() + ", node=" + nodeId + ']');
                            top.readUnlock();
                            return;
                        }
                        boolean hasNear = this.ctx.discovery().cacheNearNode(node, this.name());
                        GridCacheVersion ver = req.updateVersion();
                        if (ver == null) {
                            ver = this.ctx.versions().next(top.topologyVersion());
                            if (hasNear) {
                                res.nearVersion(ver);
                            }
                            if (this.msgLog.isDebugEnabled()) {
                                this.msgLog.debug("Assigned update version [futId=" + req.futureVersion() + ", writeVer=" + ver + ']');
                            }
                        }
                        assert (ver != null) : "Got null version for update request: " + req;
                        boolean sndPrevVal = !top.rebalanceFinished(req.topologyVersion());
                        dhtFut = this.createDhtFuture(ver, req, res, completionCb, false);
                        expiry = this.expiryPolicy(req.expiry());
                        GridCacheReturn retVal = null;
                        if (req.size() > 1 && this.writeThrough() && !req.skipStore() && !this.ctx.store().isLocal() && !this.ctx.dr().receiveEnabled()) {
                            updRes = this.updateWithBatch(node, hasNear, req, res, locked, ver, dhtFut, completionCb, this.ctx.isDrEnabled(), taskName, expiry, sndPrevVal);
                            deleted = ((UpdateBatchResult)updRes).deleted();
                            dhtFut = ((UpdateBatchResult)updRes).dhtFuture();
                            if (req.operation() == GridCacheOperation.TRANSFORM) {
                                retVal = ((UpdateBatchResult)updRes).invokeResults();
                            }
                        } else {
                            updRes = this.updateSingle(node, hasNear, req, res, locked, ver, dhtFut, completionCb, this.ctx.isDrEnabled(), taskName, expiry, sndPrevVal);
                            retVal = ((UpdateSingleResult)updRes).returnValue();
                            deleted = ((UpdateSingleResult)updRes).deleted();
                            dhtFut = ((UpdateSingleResult)updRes).dhtFuture();
                        }
                        if (retVal == null) {
                            retVal = new GridCacheReturn(this.ctx, node.isLocal(), true, null, true);
                        }
                        res.returnValue(retVal);
                        if (req.writeSynchronizationMode() != CacheWriteSynchronizationMode.FULL_ASYNC) {
                            req.cleanup(!node.isLocal());
                        }
                        if (dhtFut != null) {
                            this.ctx.mvcc().addAtomicFuture(dhtFut.version(), dhtFut);
                        }
                    } else {
                        remap = true;
                    }
                    top.readUnlock();
                }
                catch (Throwable throwable) {
                    top.readUnlock();
                    throw throwable;
                }
            }
            catch (GridCacheEntryRemovedException e) {
                assert (false) : "Entry should not become obsolete while holding lock.";
                e.printStackTrace();
            }
            finally {
                if (locked != null) {
                    this.unlockEntries(locked, req.topologyVersion());
                }
                if (deleted != null) {
                    assert (!deleted.isEmpty());
                    assert (this.ctx.deferredDelete()) : this;
                    for (IgniteBiTuple e : deleted) {
                        this.ctx.onDeferredDelete((GridCacheEntryEx)e.get1(), (GridCacheVersion)e.get2());
                    }
                }
            }
        }
        catch (GridDhtInvalidPartitionException ignore) {
            assert (!req.fastMap() || req.clientRequest()) : req;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caught invalid partition exception for cache entry (will remap update request): " + req);
            }
            remap = true;
        }
        catch (Throwable e) {
            U.error(this.log, "Unexpected exception during cache update", e);
            res.addFailedKeys(req.keys(), e);
            completionCb.apply(req, res);
            if (!(e instanceof Error)) return;
            throw e;
        }
        if (remap) {
            assert (dhtFut == null);
            res.remapKeys(req.keys());
            completionCb.apply(req, res);
        } else if (dhtFut != null) {
            dhtFut.map();
        } else {
            completionCb.apply(req, res);
        }
        this.sendTtlUpdateRequest(expiry);
    }

    private UpdateBatchResult updateWithBatch(ClusterNode node, boolean hasNear, GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res, List<GridDhtCacheEntry> locked, GridCacheVersion ver, @Nullable GridDhtAtomicAbstractUpdateFuture dhtFut, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb, boolean replicate, String taskName, @Nullable IgniteCacheExpiryPolicy expiry, boolean sndPrevVal) throws GridCacheEntryRemovedException {
        assert (!this.ctx.dr().receiveEnabled());
        assert (!req.returnValue() || req.operation() == GridCacheOperation.TRANSFORM);
        if (!F.isEmpty(req.filter()) && this.ctx.loadPreviousValue()) {
            try {
                this.reloadIfNeeded(locked);
            }
            catch (IgniteCheckedException e) {
                res.addFailedKeys(req.keys(), e);
                return new UpdateBatchResult();
            }
        }
        int size = req.size();
        LinkedHashMap<KeyCacheObject, CacheObject> putMap = null;
        HashMap<KeyCacheObject, EntryProcessor<Object, Object, Object>> entryProcessorMap = null;
        ArrayList<KeyCacheObject> rmvKeys = null;
        ArrayList<CacheObject> writeVals = null;
        UpdateBatchResult updRes = new UpdateBatchResult();
        ArrayList<GridDhtCacheEntry> filtered = new ArrayList<GridDhtCacheEntry>(size);
        GridCacheOperation op = req.operation();
        GridCacheReturn invokeRes = null;
        int firstEntryIdx = 0;
        boolean intercept = this.ctx.config().getInterceptor() != null;
        for (int i = 0; i < locked.size(); ++i) {
            GridDhtCacheEntry entry = locked.get(i);
            if (entry == null) continue;
            try {
                CacheObject old;
                if (!this.checkFilter(entry, req, res)) {
                    long ttl;
                    if (expiry != null && entry.hasValue() && (ttl = expiry.forAccess()) != -1L) {
                        entry.updateTtl(null, ttl);
                        expiry.ttlUpdated(entry.key(), entry.version(), entry.readers());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Entry did not pass the filter (will skip write) [entry=" + entry + ", filter=" + Arrays.toString(req.filter()) + ", res=" + res + ']');
                    }
                    if (hasNear) {
                        res.addSkippedIndex(i);
                    }
                    ++firstEntryIdx;
                    continue;
                }
                if (op == GridCacheOperation.TRANSFORM) {
                    CacheLazyEntry e;
                    CacheObject updated;
                    EntryProcessor<Object, Object, Object> entryProcessor = req.entryProcessor(i);
                    old = entry.innerGet(ver, null, true, true, true, true, true, req.subjectId(), entryProcessor, taskName, null, req.keepBinary());
                    Object oldVal = null;
                    Object updatedVal = null;
                    CacheInvokeEntry invokeEntry = new CacheInvokeEntry(entry.key(), old, entry.version(), req.keepBinary(), entry);
                    try {
                        Object computed = entryProcessor.process(invokeEntry, req.invokeArguments());
                        if (computed != null) {
                            if (invokeRes == null) {
                                invokeRes = new GridCacheReturn(node.isLocal());
                            }
                            computed = this.ctx.unwrapTemporary(computed);
                            invokeRes.addEntryProcessResult(this.ctx, entry.key(), invokeEntry.key(), computed, null, req.keepBinary());
                        }
                        if (!invokeEntry.modified()) continue;
                        updatedVal = this.ctx.unwrapTemporary(invokeEntry.getValue());
                        updated = this.ctx.toCacheObject(updatedVal);
                    }
                    catch (Exception e2) {
                        if (invokeRes == null) {
                            invokeRes = new GridCacheReturn(node.isLocal());
                        }
                        invokeRes.addEntryProcessResult(this.ctx, entry.key(), invokeEntry.key(), null, e2, req.keepBinary());
                        updated = old;
                    }
                    if (updated == null) {
                        if (intercept) {
                            e = new CacheLazyEntry(this.ctx, entry.key(), invokeEntry.key(), old, oldVal, req.keepBinary());
                            IgniteBiTuple<Boolean, Object> interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(e);
                            if (this.ctx.cancelRemove(interceptorRes)) continue;
                        }
                        if (putMap != null) {
                            dhtFut = this.updatePartialBatch(hasNear, firstEntryIdx, filtered, ver, node, writeVals, putMap, null, entryProcessorMap, dhtFut, completionCb, req, res, replicate, updRes, taskName, expiry, sndPrevVal);
                            firstEntryIdx = i;
                            putMap = null;
                            writeVals = null;
                            entryProcessorMap = null;
                            filtered = new ArrayList();
                        }
                        if (rmvKeys == null) {
                            rmvKeys = new ArrayList(size);
                        }
                        rmvKeys.add(entry.key());
                    } else {
                        if (intercept) {
                            e = new CacheLazyEntry(this.ctx, entry.key(), invokeEntry.key(), old, oldVal, req.keepBinary());
                            Object val = this.ctx.config().getInterceptor().onBeforePut(e, updatedVal);
                            if (val == null) continue;
                            updated = this.ctx.toCacheObject(this.ctx.unwrapTemporary(val));
                        }
                        if (rmvKeys != null) {
                            dhtFut = this.updatePartialBatch(hasNear, firstEntryIdx, filtered, ver, node, null, null, rmvKeys, entryProcessorMap, dhtFut, completionCb, req, res, replicate, updRes, taskName, expiry, sndPrevVal);
                            firstEntryIdx = i;
                            rmvKeys = null;
                            entryProcessorMap = null;
                            filtered = new ArrayList();
                        }
                        if (putMap == null) {
                            putMap = new LinkedHashMap(size, 1.0f);
                            writeVals = new ArrayList(size);
                        }
                        putMap.put(entry.key(), updated);
                        writeVals.add(updated);
                    }
                    if (entryProcessorMap == null) {
                        entryProcessorMap = new HashMap<KeyCacheObject, EntryProcessor<Object, Object, Object>>();
                    }
                    entryProcessorMap.put(entry.key(), entryProcessor);
                } else if (op == GridCacheOperation.UPDATE) {
                    CacheObject updated = req.value(i);
                    if (intercept) {
                        old = entry.innerGet(null, null, true, this.ctx.loadPreviousValue(), true, true, true, req.subjectId(), null, taskName, null, req.keepBinary());
                        Object val = this.ctx.config().getInterceptor().onBeforePut(new CacheLazyEntry(this.ctx, entry.key(), old, req.keepBinary()), this.ctx.unwrapBinaryIfNeeded(updated, req.keepBinary(), false));
                        if (val == null) continue;
                        updated = this.ctx.toCacheObject(this.ctx.unwrapTemporary(val));
                    }
                    assert (updated != null);
                    if (putMap == null) {
                        putMap = new LinkedHashMap<KeyCacheObject, CacheObject>(size, 1.0f);
                        writeVals = new ArrayList<CacheObject>(size);
                    }
                    putMap.put(entry.key(), updated);
                    writeVals.add(updated);
                } else {
                    assert (op == GridCacheOperation.DELETE);
                    if (intercept) {
                        CacheObject old2 = entry.innerGet(null, null, true, this.ctx.loadPreviousValue(), true, true, true, req.subjectId(), null, taskName, null, req.keepBinary());
                        IgniteBiTuple<Boolean, CacheObject> interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry(this.ctx, entry.key(), old2, req.keepBinary()));
                        if (this.ctx.cancelRemove(interceptorRes)) continue;
                    }
                    if (rmvKeys == null) {
                        rmvKeys = new ArrayList<KeyCacheObject>(size);
                    }
                    rmvKeys.add(entry.key());
                }
                filtered.add(entry);
                continue;
            }
            catch (IgniteCheckedException e) {
                res.addFailedKey(entry.key(), e);
            }
        }
        if (putMap != null || rmvKeys != null) {
            dhtFut = this.updatePartialBatch(hasNear, firstEntryIdx, filtered, ver, node, writeVals, putMap, rmvKeys, entryProcessorMap, dhtFut, completionCb, req, res, replicate, updRes, taskName, expiry, sndPrevVal);
        } else assert (filtered.isEmpty());
        updRes.dhtFuture(dhtFut);
        updRes.invokeResult(invokeRes);
        return updRes;
    }

    private void reloadIfNeeded(final List<GridDhtCacheEntry> entries) throws IgniteCheckedException {
        HashMap<KeyCacheObject, Integer> needReload = null;
        for (int i = 0; i < entries.size(); ++i) {
            CacheObject val;
            GridDhtCacheEntry entry = entries.get(i);
            if (entry == null || (val = entry.rawGetOrUnmarshal(false)) != null) continue;
            if (needReload == null) {
                needReload = new HashMap<KeyCacheObject, Integer>(entries.size(), 1.0f);
            }
            needReload.put(entry.key(), i);
        }
        if (needReload != null) {
            final HashMap<KeyCacheObject, Integer> idxMap = needReload;
            this.ctx.store().loadAll(null, needReload.keySet(), (IgniteBiInClosure<KeyCacheObject, Object>)new CI2<KeyCacheObject, Object>(){

                @Override
                public void apply(KeyCacheObject k, Object v) {
                    Integer idx = (Integer)idxMap.get(k);
                    if (idx != null) {
                        GridDhtCacheEntry entry = (GridDhtCacheEntry)entries.get(idx);
                        try {
                            GridCacheVersion ver = entry.version();
                            entry.versionedValue(GridDhtAtomicCache.this.ctx.toCacheObject(v), null, ver, null, null);
                        }
                        catch (GridCacheEntryRemovedException e) {
                            assert (false) : "Entry should not get obsolete while holding lock [entry=" + entry + ", e=" + e + ']';
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    }
                }
            });
        }
    }

    private UpdateSingleResult updateSingle(ClusterNode node, boolean hasNear, GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res, List<GridDhtCacheEntry> locked, GridCacheVersion ver, @Nullable GridDhtAtomicAbstractUpdateFuture dhtFut, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb, boolean replicate, String taskName, @Nullable IgniteCacheExpiryPolicy expiry, boolean sndPrevVal) throws GridCacheEntryRemovedException {
        GridCacheReturn retVal = null;
        ArrayList<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>> deleted = null;
        AffinityTopologyVersion topVer = req.topologyVersion();
        boolean checkReaders = hasNear || this.ctx.discovery().hasNearCache(this.name(), topVer);
        boolean readersOnly = false;
        boolean intercept = this.ctx.config().getInterceptor() != null;
        for (int i = 0; i < req.size(); ++i) {
            KeyCacheObject k = req.key(i);
            GridCacheOperation op = req.operation();
            try {
                GridDhtCacheEntry entry = locked.get(i);
                if (entry == null) continue;
                GridCacheVersion newConflictVer = req.conflictVersion(i);
                long newConflictTtl = req.conflictTtl(i);
                long newConflictExpireTime = req.conflictExpireTime(i);
                assert (!(newConflictVer instanceof GridCacheVersionEx)) : newConflictVer;
                boolean primary = !req.fastMap() || this.ctx.affinity().primaryByPartition(this.ctx.localNode(), entry.partition(), req.topologyVersion());
                Object writeVal = op == GridCacheOperation.TRANSFORM ? req.entryProcessor(i) : req.writeValue(i);
                Collection<UUID> readers = null;
                Collection<UUID> filteredReaders = null;
                if (checkReaders) {
                    readers = entry.readers();
                    filteredReaders = F.view(entry.readers(), F.notEqualTo(node.id()));
                }
                GridCacheUpdateAtomicResult updRes = entry.innerUpdate(ver, node.id(), this.locNodeId, op, writeVal, req.invokeArguments(), (primary || this.ctx.store().isLocal() && !this.ctx.shared().localStorePrimaryOnly()) && this.writeThrough() && !req.skipStore(), !req.skipStore(), sndPrevVal || req.returnValue(), req.keepBinary(), expiry, true, true, primary, this.ctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK, topVer, req.filter(), replicate ? (primary ? GridDrType.DR_PRIMARY : GridDrType.DR_BACKUP) : GridDrType.DR_NONE, newConflictTtl, newConflictExpireTime, newConflictVer, true, intercept, req.subjectId(), taskName, null, null, dhtFut);
                if (dhtFut == null && !F.isEmpty(filteredReaders)) {
                    dhtFut = this.createDhtFuture(ver, req, res, completionCb, true);
                    readersOnly = true;
                }
                if (dhtFut != null) {
                    if (updRes.sendToDht()) {
                        GridCacheVersionConflictContext<?, ?> conflictCtx = updRes.conflictResolveResult();
                        if (conflictCtx == null) {
                            newConflictVer = null;
                        } else if (conflictCtx.isMerge()) {
                            newConflictVer = null;
                        }
                        EntryProcessor<Object, Object, Object> entryProcessor = null;
                        if (!readersOnly) {
                            dhtFut.addWriteEntry(entry, updRes.newValue(), entryProcessor, updRes.newTtl(), updRes.conflictExpireTime(), newConflictVer, sndPrevVal, updRes.oldValue(), updRes.updateCounter());
                        }
                        if (!F.isEmpty(filteredReaders)) {
                            dhtFut.addNearWriteEntries(filteredReaders, entry, updRes.newValue(), entryProcessor, updRes.newTtl(), updRes.conflictExpireTime());
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Entry did not pass the filter or conflict resolution (will skip write) [entry=" + entry + ", filter=" + Arrays.toString(req.filter()) + ']');
                    }
                }
                if (hasNear) {
                    if (primary && updRes.sendToDht()) {
                        if (!this.ctx.affinity().partitionBelongs(node, entry.partition(), topVer)) {
                            if (op == GridCacheOperation.TRANSFORM || writeVal != updRes.newValue()) {
                                res.addNearValue(i, updRes.newValue(), updRes.newTtl(), updRes.conflictExpireTime());
                            } else {
                                res.addNearTtl(i, updRes.newTtl(), updRes.conflictExpireTime());
                            }
                            if (updRes.newValue() != null) {
                                IgniteInternalFuture<Boolean> f = entry.addReader(node.id(), req.messageId(), topVer);
                                assert (f == null) : f;
                            }
                        } else if (F.contains(readers, node.id())) {
                            entry.removeReader(node.id(), req.messageId());
                        } else {
                            res.addSkippedIndex(i);
                        }
                    } else {
                        res.addSkippedIndex(i);
                    }
                }
                if (updRes.removeVersion() != null) {
                    if (deleted == null) {
                        deleted = new ArrayList<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>>(req.size());
                    }
                    deleted.add(F.t(entry, updRes.removeVersion()));
                }
                if (op == GridCacheOperation.TRANSFORM) {
                    assert (!req.returnValue());
                    IgniteBiTuple<Object, Exception> compRes = updRes.computedResult();
                    if (compRes == null || compRes.get1() == null && compRes.get2() == null) continue;
                    if (retVal == null) {
                        retVal = new GridCacheReturn(node.isLocal());
                    }
                    retVal.addEntryProcessResult(this.ctx, k, null, compRes.get1(), compRes.get2(), req.keepBinary());
                    continue;
                }
                if (retVal != null) continue;
                CacheObject ret = updRes.oldValue();
                retVal = new GridCacheReturn(this.ctx, node.isLocal(), req.keepBinary(), req.returnValue() ? ret : null, updRes.success());
                continue;
            }
            catch (IgniteCheckedException e) {
                res.addFailedKey(k, e);
            }
        }
        return new UpdateSingleResult(retVal, deleted, dhtFut);
    }

    @Nullable
    private GridDhtAtomicAbstractUpdateFuture updatePartialBatch(boolean hasNear, int firstEntryIdx, List<GridDhtCacheEntry> entries, final GridCacheVersion ver, ClusterNode node, @Nullable List<CacheObject> writeVals, @Nullable Map<KeyCacheObject, CacheObject> putMap, @Nullable Collection<KeyCacheObject> rmvKeys, @Nullable Map<KeyCacheObject, EntryProcessor<Object, Object, Object>> entryProcessorMap, @Nullable GridDhtAtomicAbstractUpdateFuture dhtFut, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb, final GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res, boolean replicate, UpdateBatchResult batchRes, String taskName, @Nullable IgniteCacheExpiryPolicy expiry, boolean sndPrevVal) {
        assert (putMap == null ^ rmvKeys == null);
        assert (req.conflictVersions() == null) : "Cannot be called when there are conflict entries in the batch.";
        AffinityTopologyVersion topVer = req.topologyVersion();
        boolean checkReaders = hasNear || this.ctx.discovery().hasNearCache(this.name(), topVer);
        CacheStorePartialUpdateException storeErr = null;
        try {
            GridCacheOperation op;
            if (putMap != null) {
                Map<KeyCacheObject, CacheObject> storeMap = req.fastMap() ? F.view(putMap, new P1<CacheObject>(){

                    @Override
                    public boolean apply(CacheObject key) {
                        return GridDhtAtomicCache.this.ctx.affinity().primaryByKey(GridDhtAtomicCache.this.ctx.localNode(), key, req.topologyVersion());
                    }
                }) : putMap;
                try {
                    this.ctx.store().putAll(null, F.viewReadOnly(storeMap, new C1<CacheObject, IgniteBiTuple<CacheObject, GridCacheVersion>>(){

                        @Override
                        public IgniteBiTuple<CacheObject, GridCacheVersion> apply(CacheObject v) {
                            return F.t(v, ver);
                        }
                    }, new IgnitePredicate[0]));
                }
                catch (CacheStorePartialUpdateException e) {
                    storeErr = e;
                }
                op = GridCacheOperation.UPDATE;
            } else {
                Collection<Object> storeKeys = req.fastMap() ? F.view(rmvKeys, new P1<Object>(){

                    @Override
                    public boolean apply(Object key) {
                        return GridDhtAtomicCache.this.ctx.affinity().primaryByKey(GridDhtAtomicCache.this.ctx.localNode(), key, req.topologyVersion());
                    }
                }) : rmvKeys;
                try {
                    this.ctx.store().removeAll(null, storeKeys);
                }
                catch (CacheStorePartialUpdateException e) {
                    storeErr = e;
                }
                op = GridCacheOperation.DELETE;
            }
            boolean intercept = this.ctx.config().getInterceptor() != null;
            for (int i = 0; i < entries.size(); ++i) {
                GridDhtCacheEntry entry = entries.get(i);
                assert (Thread.holdsLock(entry));
                if (entry.obsolete()) {
                    assert (req.operation() == GridCacheOperation.DELETE) : "Entry can become obsolete only after remove: " + entry;
                    continue;
                }
                if (storeErr != null && storeErr.failedKeys().contains(entry.key().value(this.ctx.cacheObjectContext(), false))) continue;
                try {
                    CacheObject writeVal;
                    CacheObject cacheObject = writeVal = op == GridCacheOperation.UPDATE ? writeVals.get(i) : null;
                    assert (writeVal != null || op == GridCacheOperation.DELETE) : "null write value found.";
                    boolean primary = !req.fastMap() || this.ctx.affinity().primaryByPartition(this.ctx.localNode(), entry.partition(), req.topologyVersion());
                    Collection<UUID> readers = null;
                    Collection<UUID> filteredReaders = null;
                    if (checkReaders) {
                        readers = entry.readers();
                        filteredReaders = F.view(entry.readers(), F.notEqualTo(node.id()));
                    }
                    GridCacheUpdateAtomicResult updRes = entry.innerUpdate(ver, node.id(), this.locNodeId, op, writeVal, null, false, false, sndPrevVal, req.keepBinary(), expiry, true, true, primary, this.ctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK, topVer, null, replicate ? (primary ? GridDrType.DR_PRIMARY : GridDrType.DR_BACKUP) : GridDrType.DR_NONE, -1L, -1L, null, false, false, req.subjectId(), taskName, null, null, dhtFut);
                    assert (!updRes.success() || updRes.newTtl() == -1L || expiry != null) : "success=" + updRes.success() + ", newTtl=" + updRes.newTtl() + ", expiry=" + expiry;
                    if (intercept) {
                        if (op == GridCacheOperation.UPDATE) {
                            this.ctx.config().getInterceptor().onAfterPut(new CacheLazyEntry(this.ctx, entry.key(), updRes.newValue(), req.keepBinary()));
                        } else {
                            assert (op == GridCacheOperation.DELETE) : op;
                            this.ctx.config().getInterceptor().onAfterRemove(new CacheLazyEntry(this.ctx, entry.key(), updRes.oldValue(), req.keepBinary()));
                        }
                    }
                    batchRes.addDeleted(entry, updRes, entries);
                    if (dhtFut == null && !F.isEmpty(filteredReaders)) {
                        dhtFut = this.createDhtFuture(ver, req, res, completionCb, true);
                        batchRes.readersOnly(true);
                    }
                    if (dhtFut != null) {
                        EntryProcessor<Object, Object, Object> entryProcessor;
                        EntryProcessor<Object, Object, Object> entryProcessor2 = entryProcessor = entryProcessorMap == null ? null : entryProcessorMap.get(entry.key());
                        if (!batchRes.readersOnly()) {
                            dhtFut.addWriteEntry(entry, writeVal, entryProcessor, updRes.newTtl(), -1L, null, sndPrevVal, updRes.oldValue(), updRes.updateCounter());
                        }
                        if (!F.isEmpty(filteredReaders)) {
                            dhtFut.addNearWriteEntries(filteredReaders, entry, writeVal, entryProcessor, updRes.newTtl(), -1L);
                        }
                    }
                    if (!hasNear) continue;
                    if (primary) {
                        if (!this.ctx.affinity().partitionBelongs(node, entry.partition(), topVer)) {
                            int idx = firstEntryIdx + i;
                            if (req.operation() == GridCacheOperation.TRANSFORM) {
                                res.addNearValue(idx, writeVal, updRes.newTtl(), -1L);
                            } else {
                                res.addNearTtl(idx, updRes.newTtl(), -1L);
                            }
                            if (writeVal == null && !entry.hasValue()) continue;
                            IgniteInternalFuture<Boolean> f = entry.addReader(node.id(), req.messageId(), topVer);
                            assert (f == null) : f;
                            continue;
                        }
                        if (readers.contains(node.id())) {
                            entry.removeReader(node.id(), req.messageId());
                            continue;
                        }
                        res.addSkippedIndex(firstEntryIdx + i);
                        continue;
                    }
                    res.addSkippedIndex(firstEntryIdx + i);
                    continue;
                }
                catch (GridCacheEntryRemovedException e) {
                    assert (false) : "Entry cannot become obsolete while holding lock.";
                    e.printStackTrace();
                }
            }
        }
        catch (IgniteCheckedException e) {
            res.addFailedKeys(putMap != null ? putMap.keySet() : rmvKeys, e, this.ctx);
        }
        if (storeErr != null) {
            ArrayList<KeyCacheObject> failed = new ArrayList<KeyCacheObject>(storeErr.failedKeys().size());
            for (Object failedKey : storeErr.failedKeys()) {
                failed.add(this.ctx.toCacheKeyObject(failedKey));
            }
            res.addFailedKeys(failed, storeErr.getCause(), this.ctx);
        }
        return dhtFut;
    }

    private List<GridDhtCacheEntry> lockEntries(GridNearAtomicAbstractUpdateRequest req, AffinityTopologyVersion topVer) throws GridDhtInvalidPartitionException {
        boolean retry;
        if (req.size() == 1) {
            KeyCacheObject key = req.key(0);
            try {
                GridDhtCacheEntry entry;
                while (true) {
                    entry = this.entryExx(key, topVer);
                    GridUnsafe.monitorEnter(entry);
                    if (!entry.obsolete()) break;
                    GridUnsafe.monitorExit(entry);
                }
                return Collections.singletonList(entry);
            }
            catch (GridDhtInvalidPartitionException e) {
                if (this.ctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK) {
                    return Collections.singletonList(null);
                }
                throw e;
            }
        }
        ArrayList<GridDhtCacheEntry> locked = new ArrayList<GridDhtCacheEntry>(req.size());
        block5: do {
            for (int i = 0; i < req.size(); ++i) {
                try {
                    GridDhtCacheEntry entry = this.entryExx(req.key(i), topVer);
                    locked.add(entry);
                    continue;
                }
                catch (GridDhtInvalidPartitionException e) {
                    if (this.ctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK) {
                        locked.add(null);
                        continue;
                    }
                    throw e;
                }
            }
            retry = false;
            for (int i = 0; i < locked.size(); ++i) {
                GridCacheMapEntry entry = (GridCacheMapEntry)locked.get(i);
                if (entry == null) continue;
                GridUnsafe.monitorEnter(entry);
                if (!entry.obsolete()) continue;
                for (int j = 0; j <= i; ++j) {
                    if (locked.get(j) == null) continue;
                    GridUnsafe.monitorExit(locked.get(j));
                }
                locked.clear();
                retry = true;
                continue block5;
            }
        } while (retry);
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockEntries(Collection<GridDhtCacheEntry> locked, AffinityTopologyVersion topVer) {
        assert (this.ctx.deferredDelete()) : this;
        HashSet<KeyCacheObject> skip = null;
        try {
            for (GridCacheMapEntry gridCacheMapEntry : locked) {
                if (gridCacheMapEntry == null || !gridCacheMapEntry.deleted()) continue;
                if (skip == null) {
                    skip = new HashSet<KeyCacheObject>(locked.size(), 1.0f);
                }
                skip.add(gridCacheMapEntry.key());
            }
        }
        finally {
            for (GridCacheMapEntry gridCacheMapEntry : locked) {
                if (gridCacheMapEntry == null) continue;
                GridUnsafe.monitorExit(gridCacheMapEntry);
            }
        }
        for (GridDhtCacheEntry gridDhtCacheEntry : locked) {
            if (gridDhtCacheEntry == null) continue;
            gridDhtCacheEntry.onUnlock();
        }
        if (skip != null && skip.size() == locked.size()) {
            return;
        }
        for (GridCacheMapEntry gridCacheMapEntry : locked) {
            if (gridCacheMapEntry == null || skip != null && skip.contains(gridCacheMapEntry.key())) continue;
            this.ctx.evicts().touch(gridCacheMapEntry, topVer);
        }
    }

    private boolean checkFilter(GridCacheEntryEx entry, GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
        try {
            return this.ctx.isAllLocked(entry, req.filter());
        }
        catch (IgniteCheckedException e) {
            res.addFailedKey(entry.key(), e);
            return false;
        }
    }

    private void remapToNewPrimary(GridNearAtomicAbstractUpdateRequest req) {
        List<GridCacheVersion> drRmvVals;
        ArrayList<GridCacheDrInfo> drPutVals;
        List<?> vals;
        assert (req.writeSynchronizationMode() == CacheWriteSynchronizationMode.FULL_ASYNC) : req;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remapping near update request locally: " + req);
        }
        if (req.conflictVersions() == null) {
            vals = req.values();
            drPutVals = null;
            drRmvVals = null;
        } else if (req.operation() == GridCacheOperation.UPDATE) {
            int size = req.keys().size();
            drPutVals = new ArrayList<GridCacheDrInfo>(size);
            for (int i = 0; i < size; ++i) {
                long ttl = req.conflictTtl(i);
                if (ttl == -1L) {
                    drPutVals.add(new GridCacheDrInfo(req.value(i), req.conflictVersion(i)));
                    continue;
                }
                drPutVals.add(new GridCacheDrExpirationInfo(req.value(i), req.conflictVersion(i), ttl, req.conflictExpireTime(i)));
            }
            vals = null;
            drRmvVals = null;
        } else {
            assert (req.operation() == GridCacheOperation.DELETE) : req;
            drRmvVals = req.conflictVersions();
            vals = null;
            drPutVals = null;
        }
        GridNearAtomicUpdateFuture updateFut = new GridNearAtomicUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), req.operation(), req.keys(), vals, req.invokeArguments(), drPutVals, drRmvVals, req.returnValue(), false, req.expiry(), req.filter(), req.subjectId(), req.taskNameHash(), req.skipStore(), req.keepBinary(), MAX_RETRIES, true);
        updateFut.map();
    }

    @Nullable
    private GridDhtAtomicAbstractUpdateFuture createDhtFuture(GridCacheVersion writeVer, GridNearAtomicAbstractUpdateRequest updateReq, GridNearAtomicUpdateResponse updateRes, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb, boolean force) {
        if (!force) {
            if (updateReq.fastMap()) {
                return null;
            }
            AffinityTopologyVersion topVer = updateReq.topologyVersion();
            Collection<ClusterNode> nodes = this.ctx.kernalContext().discovery().cacheAffinityNodes(this.name(), topVer);
            assert (!nodes.isEmpty()) : "Failed to find affinity nodes [name=" + this.name() + ", topVer=" + topVer + this.ctx.kernalContext().discovery().discoCache(topVer) + ']';
            if (nodes.size() == 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partitioned cache topology has only one node, will not create DHT atomic update future [topVer=" + topVer + ", updateReq=" + updateReq + ']');
                }
                return null;
            }
        }
        if (updateReq.size() == 1) {
            return new GridDhtAtomicSingleUpdateFuture(this.ctx, completionCb, writeVer, updateReq, updateRes);
        }
        return new GridDhtAtomicUpdateFuture(this.ctx, completionCb, writeVer, updateReq, updateRes);
    }

    private void processNearAtomicUpdateRequest(UUID nodeId, GridNearAtomicAbstractUpdateRequest req) {
        if (this.msgLog.isDebugEnabled()) {
            this.msgLog.debug("Received near atomic update request [futId=" + req.futureVersion() + ", writeVer=" + req.updateVersion() + ", node=" + nodeId + ']');
        }
        req.nodeId(this.ctx.localNodeId());
        this.updateAllAsyncInternal(nodeId, req, this.updateReplyClos);
    }

    private void processNearAtomicUpdateResponse(UUID nodeId, GridNearAtomicUpdateResponse res) {
        if (this.msgLog.isDebugEnabled()) {
            this.msgLog.debug("Received near atomic update response [futId" + res.futureVersion() + ", node=" + nodeId + ']');
        }
        res.nodeId(this.ctx.localNodeId());
        GridNearAtomicAbstractUpdateFuture fut = (GridNearAtomicAbstractUpdateFuture)this.ctx.mvcc().atomicFuture(res.futureVersion());
        if (fut != null) {
            fut.onResult(nodeId, res, false);
        } else {
            U.warn(this.msgLog, "Failed to find near update future for update response (will ignore) [futId" + res.futureVersion() + ", node=" + nodeId + ", res=" + res + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDhtAtomicUpdateRequest(UUID nodeId, GridDhtAtomicAbstractUpdateRequest req) {
        if (this.msgLog.isDebugEnabled()) {
            this.msgLog.debug("Received DHT atomic update request [futId=" + req.futureVersion() + ", writeVer=" + req.writeVersion() + ", node=" + nodeId + ']');
        }
        GridCacheVersion ver = req.writeVersion();
        GridDhtAtomicUpdateResponse res = new GridDhtAtomicUpdateResponse(this.ctx.cacheId(), req.futureVersion(), this.ctx.deploymentEnabled());
        Boolean replicate = this.ctx.isDrEnabled();
        boolean intercept = req.forceTransformBackups() && this.ctx.config().getInterceptor() != null;
        String taskName = this.ctx.kernalContext().task().resolveTaskName(req.taskNameHash());
        block11: for (int i = 0; i < req.size(); ++i) {
            KeyCacheObject key = req.key(i);
            try {
                while (true) {
                    GridDhtCacheEntry entry = null;
                    try {
                        entry = this.entryExx(key);
                        CacheObject val = req.value(i);
                        CacheObject prevVal = req.previousValue(i);
                        EntryProcessor<Object, Object, Object> entryProcessor = req.entryProcessor(i);
                        Long updateIdx = req.updateCounter(i);
                        GridCacheOperation op = entryProcessor != null ? GridCacheOperation.TRANSFORM : (val != null ? GridCacheOperation.UPDATE : GridCacheOperation.DELETE);
                        long ttl = req.ttl(i);
                        long expireTime = req.conflictExpireTime(i);
                        GridCacheUpdateAtomicResult updRes = entry.innerUpdate(ver, nodeId, nodeId, op, op == GridCacheOperation.TRANSFORM ? entryProcessor : val, op == GridCacheOperation.TRANSFORM ? req.invokeArguments() : null, this.ctx.store().isLocal() && !this.ctx.shared().localStorePrimaryOnly() && this.writeThrough() && !req.skipStore(), false, false, req.keepBinary(), null, true, true, false, !req.forceTransformBackups(), req.topologyVersion(), CU.empty0(), replicate != false ? GridDrType.DR_BACKUP : GridDrType.DR_NONE, ttl, expireTime, req.conflictVersion(i), false, intercept, req.subjectId(), taskName, prevVal, updateIdx, null);
                        if (updRes.removeVersion() != null) {
                            this.ctx.onDeferredDelete(entry, updRes.removeVersion());
                        }
                        entry.onUnlock();
                        continue block11;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Got removed entry while updating backup value (will retry): " + key);
                        }
                        entry = null;
                        continue;
                    }
                    finally {
                        if (entry == null) continue;
                        this.ctx.evicts().touch(entry, req.topologyVersion());
                        continue;
                    }
                    break;
                }
            }
            catch (GridDhtInvalidPartitionException entry) {
                continue;
            }
            catch (IgniteCheckedException e) {
                res.addFailedKey(key, new IgniteCheckedException("Failed to update key on backup node: " + key, e));
            }
        }
        if (GridCacheUtils.isNearEnabled(this.cacheCfg)) {
            ((GridNearAtomicCache)this.near()).processDhtAtomicUpdateRequest(nodeId, req, res);
        }
        try {
            if (res.failedKeys() != null || res.nearEvicted() != null || req.writeSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC) {
                this.ctx.io().send(nodeId, (GridCacheMessage)res, this.ctx.ioPolicy());
                if (this.msgLog.isDebugEnabled()) {
                    this.msgLog.debug("Sent DHT atomic update response [futId=" + req.futureVersion() + ", writeVer=" + req.writeVersion() + ", node=" + nodeId + ']');
                }
            } else {
                if (this.msgLog.isDebugEnabled()) {
                    this.msgLog.debug("Will send deferred DHT atomic update response [futId=" + req.futureVersion() + ", writeVer=" + req.writeVersion() + ", node=" + nodeId + ']');
                }
                this.sendDeferredUpdateResponse(nodeId, req.futureVersion());
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            U.warn(this.msgLog, "Failed to send DHT atomic update response, node left [futId=" + req.futureVersion() + ", node=" + req.nodeId() + ']');
        }
        catch (IgniteCheckedException e) {
            U.error(this.msgLog, "Failed to send DHT atomic update response [futId=" + req.futureVersion() + ", node=" + nodeId + ", res=" + res + ']', e);
        }
    }

    private void sendDeferredUpdateResponse(UUID nodeId, GridCacheVersion ver) {
        this.deferredUpdateMsgSnd.sendDeferredAckMessage(nodeId, ver);
    }

    private void processDhtAtomicUpdateResponse(UUID nodeId, GridDhtAtomicUpdateResponse res) {
        GridDhtAtomicAbstractUpdateFuture updateFut = (GridDhtAtomicAbstractUpdateFuture)this.ctx.mvcc().atomicFuture(res.futureVersion());
        if (updateFut != null) {
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Received DHT atomic update response [futId=" + res.futureVersion() + ", writeVer=" + updateFut.writeVersion() + ", node=" + nodeId + ']');
            }
            updateFut.onResult(nodeId, res);
        } else {
            U.warn(this.msgLog, "Failed to find DHT update future for update response [futId=" + res.futureVersion() + ", node=" + nodeId + ", res=" + res + ']');
        }
    }

    private void processDhtAtomicDeferredUpdateResponse(UUID nodeId, GridDhtAtomicDeferredUpdateResponse res) {
        for (GridCacheVersion ver : res.futureVersions()) {
            GridDhtAtomicAbstractUpdateFuture updateFut = (GridDhtAtomicAbstractUpdateFuture)this.ctx.mvcc().atomicFuture(ver);
            if (updateFut != null) {
                if (this.msgLog.isDebugEnabled()) {
                    this.msgLog.debug("Received DHT atomic deferred update response [futId=" + ver + ", writeVer=" + res + ", node=" + nodeId + ']');
                }
                updateFut.onResult(nodeId);
                continue;
            }
            U.warn(this.msgLog, "Failed to find DHT update future for deferred update response [futId=" + ver + ", nodeId=" + nodeId + ", res=" + res + ']');
        }
    }

    private void sendNearUpdateReply(UUID nodeId, GridNearAtomicUpdateResponse res) {
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)res, this.ctx.ioPolicy());
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Sent near update response [futId=" + res.futureVersion() + ", node=" + nodeId + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Failed to send near update response [futId=" + res.futureVersion() + ", node=" + nodeId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.msgLog, "Failed to send near update response [futId=" + res.futureVersion() + ", node=" + nodeId + ", res=" + res + ']', e);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicCache.class, this, super.toString());
    }

    private static class FinishedLockFuture
    extends GridFinishedFuture<Boolean>
    implements GridDhtFuture<Boolean> {
        private FinishedLockFuture(Throwable err) {
            super(err);
        }

        @Override
        public Collection<Integer> invalidPartitions() {
            return Collections.emptyList();
        }
    }

    private static class UpdateBatchResult {
        private Collection<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>> deleted;
        private GridDhtAtomicAbstractUpdateFuture dhtFut;
        private boolean readersOnly;
        private GridCacheReturn invokeRes;

        private UpdateBatchResult() {
        }

        private void addDeleted(GridDhtCacheEntry entry, GridCacheUpdateAtomicResult updRes, Collection<GridDhtCacheEntry> entries) {
            if (updRes.removeVersion() != null) {
                if (this.deleted == null) {
                    this.deleted = new ArrayList<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>>(entries.size());
                }
                this.deleted.add(F.t(entry, updRes.removeVersion()));
            }
        }

        private Collection<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>> deleted() {
            return this.deleted;
        }

        public GridDhtAtomicAbstractUpdateFuture dhtFuture() {
            return this.dhtFut;
        }

        private void invokeResult(GridCacheReturn invokeRes) {
            this.invokeRes = invokeRes;
        }

        GridCacheReturn invokeResults() {
            return this.invokeRes;
        }

        private void dhtFuture(@Nullable GridDhtAtomicAbstractUpdateFuture dhtFut) {
            this.dhtFut = dhtFut;
        }

        private boolean readersOnly() {
            return this.readersOnly;
        }

        private void readersOnly(boolean readersOnly) {
            this.readersOnly = readersOnly;
        }
    }

    private static class UpdateSingleResult {
        private final GridCacheReturn retVal;
        private final Collection<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>> deleted;
        private final GridDhtAtomicAbstractUpdateFuture dhtFut;

        private UpdateSingleResult(GridCacheReturn retVal, Collection<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>> deleted, GridDhtAtomicAbstractUpdateFuture dhtFut) {
            this.retVal = retVal;
            this.deleted = deleted;
            this.dhtFut = dhtFut;
        }

        private GridCacheReturn returnValue() {
            return this.retVal;
        }

        private Collection<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>> deleted() {
            return this.deleted;
        }

        public GridDhtAtomicAbstractUpdateFuture dhtFuture() {
            return this.dhtFut;
        }
    }
}

