/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtAtomicDeferredUpdateResponse
extends GridCacheMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    public static final int CACHE_MSG_IDX = GridDhtAtomicDeferredUpdateResponse.nextIndexId();
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> futVers;

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    public GridDhtAtomicDeferredUpdateResponse() {
    }

    public GridDhtAtomicDeferredUpdateResponse(int cacheId, Collection<GridCacheVersion> futVers, boolean addDepInfo) {
        assert (!F.isEmpty(futVers));
        this.cacheId = cacheId;
        this.futVers = futVers;
        this.addDepInfo = addDepInfo;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    public Collection<GridCacheVersion> futureVersions() {
        return this.futVers;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeCollection("futVers", this.futVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.futVers = reader.readCollection("futVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAtomicDeferredUpdateResponse.class);
    }

    @Override
    public byte directType() {
        return 37;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }
}

