/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicSingleUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GridDhtAtomicSingleUpdateFuture
extends GridDhtAtomicAbstractUpdateFuture {
    private static final long serialVersionUID = 0L;
    private static final IgniteProductVersion SINGLE_UPDATE_REQUEST = IgniteProductVersion.fromString("1.7.4");
    private KeyCacheObject key;
    private GridDhtCacheEntry nearReaderEntry;

    GridDhtAtomicSingleUpdateFuture(GridCacheContext cctx, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb, GridCacheVersion writeVer, GridNearAtomicAbstractUpdateRequest updateReq, GridNearAtomicUpdateResponse updateRes) {
        super(cctx, completionCb, writeVer, updateReq, updateRes);
    }

    @Override
    protected void addDhtKey(KeyCacheObject key, List<ClusterNode> dhtNodes) {
        assert (this.key == null || this.key.equals(key)) : this.key;
        if (this.mappings == null) {
            this.mappings = U.newHashMap(dhtNodes.size());
        }
        this.key = key;
    }

    @Override
    protected void addNearKey(KeyCacheObject key, Collection<UUID> readers) {
        assert (this.key == null || this.key.equals(key)) : this.key;
        if (this.mappings == null) {
            this.mappings = U.newHashMap(readers.size());
        }
        this.key = key;
    }

    @Override
    protected void addNearReaderEntry(GridDhtCacheEntry entry) {
        this.nearReaderEntry = entry;
    }

    @Override
    protected GridDhtAtomicAbstractUpdateRequest createRequest(ClusterNode node, GridCacheVersion futVer, GridCacheVersion writeVer, CacheWriteSynchronizationMode syncMode, @NotNull AffinityTopologyVersion topVer, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer) {
        if (this.canUseSingleRequest(node, ttl, conflictExpireTime, conflictVer)) {
            return new GridDhtAtomicSingleUpdateRequest(this.cctx.cacheId(), node.id(), futVer, writeVer, syncMode, topVer, this.updateReq.subjectId(), this.updateReq.taskNameHash(), this.cctx.deploymentEnabled(), this.updateReq.keepBinary(), this.updateReq.skipStore());
        }
        return new GridDhtAtomicUpdateRequest(this.cctx.cacheId(), node.id(), futVer, writeVer, syncMode, topVer, false, this.updateReq.subjectId(), this.updateReq.taskNameHash(), null, this.cctx.deploymentEnabled(), this.updateReq.keepBinary(), this.updateReq.skipStore());
    }

    @Override
    public void onResult(UUID nodeId, GridDhtAtomicUpdateResponse updateRes) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug("Received DHT atomic update future result [nodeId=" + nodeId + ", updateRes=" + updateRes + ']');
            }
            if (updateRes.error() != null) {
                this.updateRes.addFailedKeys(updateRes.failedKeys(), updateRes.error());
            }
            if (!F.isEmpty(updateRes.nearEvicted())) {
                try {
                    assert (this.nearReaderEntry != null);
                    this.nearReaderEntry.removeReader(nodeId, updateRes.messageId());
                }
                catch (GridCacheEntryRemovedException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("Entry with evicted reader was removed [entry=" + this.nearReaderEntry + ", err=" + e + ']');
                }
            }
        }
        this.registerResponse(nodeId);
    }

    @Override
    protected void addFailedKeys(GridNearAtomicUpdateResponse updateRes, Throwable err) {
        updateRes.addFailedKey(this.key, err);
    }

    private boolean canUseSingleRequest(ClusterNode node, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer) {
        return node.version().compareToIgnoreTimestamp(SINGLE_UPDATE_REQUEST) >= 0 && ttl == -1L && conflictExpireTime == -1L && conflictVer == null;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicSingleUpdateFuture.class, this);
    }
}

