/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtAtomicSingleUpdateRequest
extends GridDhtAtomicAbstractUpdateRequest {
    private static final long serialVersionUID = 0L;
    private static final int NEAR_FLAG_MASK = 128;
    protected GridCacheVersion futVer;
    protected GridCacheVersion writeVer;
    protected CacheWriteSynchronizationMode syncMode;
    protected AffinityTopologyVersion topVer;
    protected UUID subjId;
    protected int taskNameHash;
    protected byte flags;
    @GridToStringInclude
    protected KeyCacheObject key;
    @GridToStringInclude
    protected CacheObject val;
    @GridToStringInclude
    protected CacheObject prevVal;
    protected long updateCntr;
    protected int partId;

    public GridDhtAtomicSingleUpdateRequest() {
    }

    GridDhtAtomicSingleUpdateRequest(int cacheId, UUID nodeId, GridCacheVersion futVer, GridCacheVersion writeVer, CacheWriteSynchronizationMode syncMode, @NotNull AffinityTopologyVersion topVer, UUID subjId, int taskNameHash, boolean addDepInfo, boolean keepBinary, boolean skipStore) {
        super(cacheId, nodeId);
        this.futVer = futVer;
        this.writeVer = writeVer;
        this.syncMode = syncMode;
        this.topVer = topVer;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.addDepInfo = addDepInfo;
        if (skipStore) {
            this.setFlag(true, 1);
        }
        if (keepBinary) {
            this.setFlag(true, 2);
        }
    }

    @Override
    public void addWriteValue(KeyCacheObject key, @Nullable CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer, boolean addPrevVal, int partId, @Nullable CacheObject prevVal, @Nullable Long updateCntr) {
        assert (entryProcessor == null);
        assert (ttl <= 0L) : ttl;
        assert (conflictExpireTime <= 0L) : conflictExpireTime;
        assert (conflictVer == null) : conflictVer;
        this.near(false);
        this.key = key;
        this.partId = partId;
        this.val = val;
        if (addPrevVal) {
            this.prevVal = prevVal;
        }
        if (updateCntr != null) {
            this.updateCntr = updateCntr;
        }
    }

    @Override
    public void addNearWriteValue(KeyCacheObject key, @Nullable CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, long ttl, long expireTime) {
        assert (entryProcessor == null);
        assert (ttl <= 0L) : ttl;
        this.near(true);
        this.key = key;
        this.val = val;
    }

    @Override
    public boolean forceTransformBackups() {
        return false;
    }

    @Override
    public int size() {
        return this.key != null ? (this.near() ? 0 : 1) : 0;
    }

    @Override
    public int nearSize() {
        return this.key != null ? (this.near() ? 1 : 0) : 0;
    }

    @Override
    public boolean hasKey(KeyCacheObject key) {
        return !this.near() && F.eq(this.key, key);
    }

    @Override
    public boolean skipStore() {
        return this.isFlag(1);
    }

    @Override
    public KeyCacheObject key(int idx) {
        assert (idx == 0) : idx;
        return this.near() ? null : this.key;
    }

    @Override
    public int partition() {
        return this.partId;
    }

    @Override
    public int partitionId(int idx) {
        assert (idx == 0) : idx;
        return this.partId;
    }

    @Override
    public Long updateCounter(int updCntr) {
        assert (updCntr == 0) : updCntr;
        return this.updateCntr;
    }

    @Override
    public KeyCacheObject nearKey(int idx) {
        assert (idx == 0) : idx;
        return this.near() ? this.key : null;
    }

    @Override
    @Nullable
    public CacheObject value(int idx) {
        assert (idx == 0) : idx;
        return this.near() ? null : this.val;
    }

    @Override
    public GridCacheVersion futureVersion() {
        return this.futVer;
    }

    @Override
    public GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    @Override
    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public UUID subjectId() {
        return this.subjId;
    }

    @Override
    public CacheWriteSynchronizationMode writeSynchronizationMode() {
        return this.syncMode;
    }

    @Override
    @Nullable
    public CacheObject previousValue(int idx) {
        assert (idx == 0) : idx;
        return this.prevVal;
    }

    @Override
    @Nullable
    public CacheObject nearValue(int idx) {
        assert (idx == 0) : idx;
        return this.near() ? this.val : null;
    }

    @Override
    @Nullable
    public EntryProcessor<Object, Object, Object> entryProcessor(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    @Nullable
    public EntryProcessor<Object, Object, Object> nearEntryProcessor(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    @Nullable
    public GridCacheVersion conflictVersion(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    public long ttl(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    public long nearTtl(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    public long conflictExpireTime(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    public long nearExpireTime(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    @Nullable
    public Object[] invokeArguments() {
        return null;
    }

    @Override
    public boolean keepBinary() {
        return this.isFlag(2);
    }

    private boolean near() {
        return this.isFlag(128);
    }

    private void near(boolean near) {
        this.setFlag(near, 128);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalObject(this.key, cctx);
        this.prepareMarshalObject(this.val, cctx);
        this.prepareMarshalObject(this.prevVal, cctx);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalObject(this.key, cctx, ldr);
        this.finishUnmarshalObject(this.val, cctx, ldr);
        this.finishUnmarshalObject(this.prevVal, cctx, ldr);
        this.key.partition(this.partId);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMessage("futVer", this.futVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeInt("partId", this.partId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMessage("prevVal", this.prevVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeByte("syncMode", this.syncMode != null ? (byte)this.syncMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeLong("updateCntr", this.updateCntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeMessage("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeMessage("writeVer", this.writeVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.futVer = (GridCacheVersion)reader.readMessage("futVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.partId = reader.readInt("partId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.prevVal = (CacheObject)reader.readMessage("prevVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                byte syncModeOrd = reader.readByte("syncMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.syncMode = CacheWriteSynchronizationMode.fromOrdinal(syncModeOrd);
                reader.incrementState();
            }
            case 10: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.updateCntr = reader.readLong("updateCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.writeVer = (GridCacheVersion)reader.readMessage("writeVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAtomicSingleUpdateRequest.class);
    }

    private void prepareMarshalObject(CacheObject obj, GridCacheContext ctx) throws IgniteCheckedException {
        if (obj != null) {
            obj.prepareMarshal(ctx.cacheObjectContext());
        }
    }

    private void finishUnmarshalObject(@Nullable CacheObject obj, GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (obj != null) {
            obj.finishUnmarshal(ctx.cacheObjectContext(), ldr);
        }
    }

    @Override
    protected void cleanup() {
        this.val = null;
        this.prevVal = null;
    }

    @Override
    public byte directType() {
        return -36;
    }

    @Override
    public byte fieldsCount() {
        return 15;
    }

    private void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicSingleUpdateRequest.class, this, "super", super.toString());
    }
}

