/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GridDhtAtomicUpdateFuture
extends GridDhtAtomicAbstractUpdateFuture {
    private static final long serialVersionUID = 0L;
    private final Collection<KeyCacheObject> keys;
    private Map<KeyCacheObject, GridDhtCacheEntry> nearReadersEntries;

    GridDhtAtomicUpdateFuture(GridCacheContext cctx, CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> completionCb, GridCacheVersion writeVer, GridNearAtomicAbstractUpdateRequest updateReq, GridNearAtomicUpdateResponse updateRes) {
        super(cctx, completionCb, writeVer, updateReq, updateRes);
        this.keys = new ArrayList<KeyCacheObject>(updateReq.size());
        this.mappings = U.newHashMap(updateReq.size());
    }

    @Override
    protected void addDhtKey(KeyCacheObject key, List<ClusterNode> dhtNodes) {
        this.keys.add(key);
    }

    @Override
    protected void addNearKey(KeyCacheObject key, Collection<UUID> readers) {
        this.keys.add(key);
    }

    @Override
    protected void addNearReaderEntry(GridDhtCacheEntry entry) {
        if (this.nearReadersEntries == null) {
            this.nearReadersEntries = new HashMap<KeyCacheObject, GridDhtCacheEntry>();
        }
        this.nearReadersEntries.put(entry.key(), entry);
    }

    @Override
    public void onResult(UUID nodeId, GridDhtAtomicUpdateResponse updateRes) {
        if (log.isDebugEnabled()) {
            log.debug("Received DHT atomic update future result [nodeId=" + nodeId + ", updateRes=" + updateRes + ']');
        }
        if (updateRes.error() != null) {
            this.updateRes.addFailedKeys(updateRes.failedKeys(), updateRes.error());
        }
        if (!F.isEmpty(updateRes.nearEvicted())) {
            for (KeyCacheObject key : updateRes.nearEvicted()) {
                GridDhtCacheEntry entry = this.nearReadersEntries.get(key);
                try {
                    entry.removeReader(nodeId, updateRes.messageId());
                }
                catch (GridCacheEntryRemovedException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Entry with evicted reader was removed [entry=" + entry + ", err=" + e + ']');
                }
            }
        }
        this.registerResponse(nodeId);
    }

    @Override
    protected void addFailedKeys(GridNearAtomicUpdateResponse updateRes, Throwable err) {
        for (KeyCacheObject key : this.keys) {
            updateRes.addFailedKey(key, err);
        }
    }

    @Override
    protected GridDhtAtomicAbstractUpdateRequest createRequest(ClusterNode node, GridCacheVersion futVer, GridCacheVersion writeVer, CacheWriteSynchronizationMode syncMode, @NotNull AffinityTopologyVersion topVer, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer) {
        return new GridDhtAtomicUpdateRequest(this.cctx.cacheId(), node.id(), futVer, writeVer, syncMode, topVer, false, this.updateReq.subjectId(), this.updateReq.taskNameHash(), null, this.cctx.deploymentEnabled(), this.updateReq.keepBinary(), this.updateReq.skipStore());
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicUpdateFuture.class, this);
    }
}

