/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtAtomicUpdateResponse
extends GridCacheMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    public static final int CACHE_MSG_IDX = GridDhtAtomicUpdateResponse.nextIndexId();
    private GridCacheVersion futVer;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> failedKeys;
    @GridDirectTransient
    private IgniteCheckedException err;
    private byte[] errBytes;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> nearEvicted;

    public GridDhtAtomicUpdateResponse() {
    }

    public GridDhtAtomicUpdateResponse(int cacheId, GridCacheVersion futVer, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.futVer = futVer;
        this.addDepInfo = addDepInfo;
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    public GridCacheVersion futureVersion() {
        return this.futVer;
    }

    public void onError(IgniteCheckedException err) {
        this.err = err;
    }

    @Override
    public IgniteCheckedException error() {
        return this.err;
    }

    public Collection<KeyCacheObject> failedKeys() {
        return this.failedKeys;
    }

    public void addFailedKey(KeyCacheObject key, Throwable e) {
        if (this.failedKeys == null) {
            this.failedKeys = new ArrayList<KeyCacheObject>();
        }
        this.failedKeys.add(key);
        if (this.err == null) {
            this.err = new IgniteCheckedException("Failed to update keys on primary node.");
        }
        this.err.addSuppressed(e);
    }

    public Collection<KeyCacheObject> nearEvicted() {
        return this.nearEvicted;
    }

    public void addNearEvicted(KeyCacheObject key) {
        if (this.nearEvicted == null) {
            this.nearEvicted = new ArrayList<KeyCacheObject>();
        }
        this.nearEvicted.add(key);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObjects(this.failedKeys, cctx);
        this.prepareMarshalCacheObjects(this.nearEvicted, cctx);
        if (this.errBytes == null) {
            this.errBytes = U.marshal(ctx, (Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalCacheObjects(this.failedKeys, cctx, ldr);
        this.finishUnmarshalCacheObjects(this.nearEvicted, cctx, ldr);
        if (this.errBytes != null && this.err == null) {
            this.err = (IgniteCheckedException)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeCollection("failedKeys", this.failedKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("futVer", this.futVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeCollection("nearEvicted", this.nearEvicted, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.failedKeys = (List)reader.readCollection("failedKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.futVer = (GridCacheVersion)reader.readMessage("futVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.nearEvicted = (List)reader.readCollection("nearEvicted", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAtomicUpdateResponse.class);
    }

    @Override
    public byte directType() {
        return 39;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicUpdateResponse.class, this);
    }
}

