/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearAtomicAbstractSingleUpdateRequest
extends GridNearAtomicAbstractUpdateRequest {
    private static final long serialVersionUID = 0L;
    private static final CacheEntryPredicate[] NO_FILTER = new CacheEntryPredicate[0];
    private static final int FAST_MAP_FLAG_MASK = 1;
    private static final int HAS_PRIMARY_FLAG_MASK = 2;
    private static final int TOP_LOCKED_FLAG_MASK = 4;
    private static final int SKIP_STORE_FLAG_MASK = 8;
    private static final int CLIENT_REQ_FLAG_MASK = 16;
    private static final int KEEP_BINARY_FLAG_MASK = 32;
    private static final int RET_VAL_FLAG_MASK = 64;
    @GridDirectTransient
    protected UUID nodeId;
    protected GridCacheVersion futVer;
    private GridCacheVersion updateVer;
    protected AffinityTopologyVersion topVer;
    protected CacheWriteSynchronizationMode syncMode;
    protected GridCacheOperation op;
    protected UUID subjId;
    protected int taskNameHash;
    @GridDirectTransient
    private GridNearAtomicUpdateResponse res;
    protected byte flags;

    protected GridNearAtomicAbstractSingleUpdateRequest() {
    }

    protected GridNearAtomicAbstractSingleUpdateRequest(int cacheId, UUID nodeId, GridCacheVersion futVer, boolean fastMap, @Nullable GridCacheVersion updateVer, @NotNull AffinityTopologyVersion topVer, boolean topLocked, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, boolean retval, @Nullable UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, boolean clientReq, boolean addDepInfo) {
        assert (futVer != null);
        this.cacheId = cacheId;
        this.nodeId = nodeId;
        this.futVer = futVer;
        this.updateVer = updateVer;
        this.topVer = topVer;
        this.syncMode = syncMode;
        this.op = op;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.addDepInfo = addDepInfo;
        this.fastMap(fastMap);
        this.topologyLocked(topLocked);
        this.returnValue(retval);
        this.skipStore(skipStore);
        this.keepBinary(keepBinary);
        this.clientRequest(clientReq);
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    @Override
    public UUID nodeId() {
        return this.nodeId;
    }

    @Override
    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public UUID subjectId() {
        return this.subjId;
    }

    @Override
    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public GridCacheVersion futureVersion() {
        return this.futVer;
    }

    @Override
    public GridCacheVersion updateVersion() {
        return this.updateVer;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public CacheWriteSynchronizationMode writeSynchronizationMode() {
        return this.syncMode;
    }

    @Override
    public ExpiryPolicy expiry() {
        return null;
    }

    @Override
    public GridCacheOperation operation() {
        return this.op;
    }

    @Override
    @Nullable
    public Object[] invokeArguments() {
        return null;
    }

    @Override
    public boolean onResponse(GridNearAtomicUpdateResponse res) {
        if (this.res == null) {
            this.res = res;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public GridNearAtomicUpdateResponse response() {
        return this.res;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    @Override
    public boolean fastMap() {
        return this.isFlag(1);
    }

    public void fastMap(boolean val) {
        this.setFlag(val, 1);
    }

    @Override
    public boolean topologyLocked() {
        return this.isFlag(4);
    }

    public void topologyLocked(boolean val) {
        this.setFlag(val, 4);
    }

    @Override
    public boolean clientRequest() {
        return this.isFlag(16);
    }

    public void clientRequest(boolean val) {
        this.setFlag(val, 16);
    }

    @Override
    public boolean returnValue() {
        return this.isFlag(64);
    }

    public void returnValue(boolean val) {
        this.setFlag(val, 64);
    }

    @Override
    public boolean skipStore() {
        return this.isFlag(8);
    }

    public void skipStore(boolean val) {
        this.setFlag(val, 8);
    }

    @Override
    public boolean keepBinary() {
        return this.isFlag(32);
    }

    public void keepBinary(boolean val) {
        this.setFlag(val, 32);
    }

    @Override
    public boolean hasPrimary() {
        return this.isFlag(2);
    }

    public void hasPrimary(boolean val) {
        this.setFlag(val, 2);
    }

    @Override
    @Nullable
    public CacheEntryPredicate[] filter() {
        return NO_FILTER;
    }

    private void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMessage("futVer", this.futVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByte("op", this.op != null ? (byte)this.op.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeByte("syncMode", this.syncMode != null ? (byte)this.syncMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("updateVer", this.updateVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.futVer = (GridCacheVersion)reader.readMessage("futVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                byte opOrd = reader.readByte("op");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.op = GridCacheOperation.fromOrdinal(opOrd);
                reader.incrementState();
            }
            case 6: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                byte syncModeOrd = reader.readByte("syncMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.syncMode = CacheWriteSynchronizationMode.fromOrdinal(syncModeOrd);
                reader.incrementState();
            }
            case 8: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.updateVer = (GridCacheVersion)reader.readMessage("updateVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicAbstractSingleUpdateRequest.class);
    }

    @Override
    public byte fieldsCount() {
        return 11;
    }
}

