/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheAtomicFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearAtomicAbstractUpdateFuture
extends GridFutureAdapter<Object>
implements GridCacheAtomicFuture<Object> {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    protected static IgniteLogger log;
    protected static IgniteLogger msgLog;
    protected final GridCacheContext cctx;
    protected final GridDhtAtomicCache cache;
    protected final CacheWriteSynchronizationMode syncMode;
    protected final GridCacheOperation op;
    protected final Object[] invokeArgs;
    protected final boolean retval;
    protected final boolean rawRetval;
    protected final ExpiryPolicy expiryPlc;
    protected final CacheEntryPredicate[] filter;
    protected final UUID subjId;
    protected final int taskNameHash;
    protected final boolean skipStore;
    protected final boolean keepBinary;
    protected final boolean waitTopFut;
    protected final boolean nearEnabled;
    protected final Object mux = new Object();
    protected boolean topLocked;
    protected int remapCnt;
    protected AffinityTopologyVersion topVer = AffinityTopologyVersion.ZERO;
    protected GridCacheVersion updVer;
    protected AffinityTopologyVersion mapErrTopVer;
    protected int resCnt;
    protected CachePartialUpdateCheckedException err;
    protected GridCacheVersion futVer;
    protected GridFutureAdapter<Void> topCompleteFut;
    protected GridCacheReturn opRes;

    protected GridNearAtomicAbstractUpdateFuture(GridCacheContext cctx, GridDhtAtomicCache cache, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, @Nullable Object[] invokeArgs, boolean retval, boolean rawRetval, @Nullable ExpiryPolicy expiryPlc, CacheEntryPredicate[] filter, UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, int remapCnt, boolean waitTopFut) {
        if (log == null) {
            msgLog = cctx.shared().atomicMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridFutureAdapter.class);
        }
        this.cctx = cctx;
        this.cache = cache;
        this.syncMode = syncMode;
        this.op = op;
        this.invokeArgs = invokeArgs;
        this.retval = retval;
        this.rawRetval = rawRetval;
        this.expiryPlc = expiryPlc;
        this.filter = filter;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.skipStore = skipStore;
        this.keepBinary = keepBinary;
        this.waitTopFut = waitTopFut;
        this.nearEnabled = CU.isNearEnabled(cctx);
        if (!waitTopFut) {
            remapCnt = 1;
        }
        this.remapCnt = remapCnt;
    }

    public void map() {
        AffinityTopologyVersion topVer = this.cctx.shared().lockedTopologyVersion(null);
        if (topVer == null) {
            this.mapOnTopology();
        } else {
            this.topLocked = true;
            this.remapCnt = 1;
            GridCacheVersion futVer = this.addAtomicFuture(topVer);
            if (futVer != null) {
                this.map(topVer, futVer);
            }
        }
    }

    protected abstract void map(AffinityTopologyVersion var1, GridCacheVersion var2);

    protected abstract void mapOnTopology();

    @Override
    public IgniteUuid futureId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
    }

    protected boolean storeFuture() {
        return this.cctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK || this.syncMode != CacheWriteSynchronizationMode.FULL_ASYNC;
    }

    protected void mapSingle(UUID nodeId, GridNearAtomicAbstractUpdateRequest req) {
        if (this.cctx.localNodeId().equals(nodeId)) {
            this.cache.updateAllAsyncInternal(nodeId, req, new CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse>(){

                @Override
                public void apply(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
                    GridNearAtomicAbstractUpdateFuture.this.onResult(res.nodeId(), res, false);
                }
            });
        } else {
            try {
                this.cctx.io().send(req.nodeId(), (GridCacheMessage)req, this.cctx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near update fut, sent request [futId=" + req.futureVersion() + ", writeVer=" + req.updateVersion() + ", node=" + req.nodeId() + ']');
                }
                if (this.syncMode == CacheWriteSynchronizationMode.FULL_ASYNC) {
                    this.onDone(new GridCacheReturn(this.cctx, true, true, null, true));
                }
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near update fut, failed to send request [futId=" + req.futureVersion() + ", writeVer=" + req.updateVersion() + ", node=" + req.nodeId() + ", err=" + e + ']');
                }
                this.onSendError(req, e);
            }
        }
    }

    public abstract void onResult(UUID var1, GridNearAtomicUpdateResponse var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onSendError(GridNearAtomicAbstractUpdateRequest req, IgniteCheckedException e) {
        Object object = this.mux;
        synchronized (object) {
            GridNearAtomicUpdateResponse res = new GridNearAtomicUpdateResponse(this.cctx.cacheId(), req.nodeId(), req.futureVersion(), this.cctx.deploymentEnabled());
            res.addFailedKeys(req.keys(), e);
            this.onResult(req.nodeId(), res, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GridCacheVersion addAtomicFuture(AffinityTopologyVersion topVer) {
        GridCacheVersion futVer = this.cctx.versions().next(topVer);
        Object object = this.mux;
        synchronized (object) {
            assert (this.futVer == null) : this;
            assert (this.topVer == AffinityTopologyVersion.ZERO) : this;
            this.topVer = topVer;
            this.futVer = futVer;
        }
        if (this.storeFuture() && !this.cctx.mvcc().addAtomicFuture(futVer, this)) {
            return null;
        }
        return futVer;
    }
}

