/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.IgniteExternalizableExpiryPolicy;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicFullUpdateRequest
extends GridNearAtomicAbstractUpdateRequest {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private UUID nodeId;
    private GridCacheVersion futVer;
    private GridCacheVersion updateVer;
    private AffinityTopologyVersion topVer;
    private CacheWriteSynchronizationMode syncMode;
    private GridCacheOperation op;
    protected UUID subjId;
    protected int taskNameHash;
    @GridDirectTransient
    private GridNearAtomicUpdateResponse res;
    protected boolean fastMap;
    protected boolean topLocked;
    protected boolean hasPrimary;
    protected boolean skipStore;
    protected boolean clientReq;
    protected boolean keepBinary;
    protected boolean retval;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;
    @GridDirectCollection(value=CacheObject.class)
    private List<CacheObject> vals;
    @GridDirectCollection(value=int.class)
    private List<Integer> partIds;
    @GridDirectTransient
    private List<EntryProcessor<Object, Object, Object>> entryProcessors;
    @GridDirectCollection(value=byte[].class)
    private List<byte[]> entryProcessorsBytes;
    @GridDirectCollection(value=GridCacheVersion.class)
    private List<GridCacheVersion> conflictVers;
    private GridLongList conflictTtls;
    private GridLongList conflictExpireTimes;
    @GridDirectTransient
    private Object[] invokeArgs;
    private byte[][] invokeArgsBytes;
    @GridDirectTransient
    private ExpiryPolicy expiryPlc;
    private byte[] expiryPlcBytes;
    private CacheEntryPredicate[] filter;
    @GridDirectTransient
    private int initSize;

    public GridNearAtomicFullUpdateRequest() {
    }

    GridNearAtomicFullUpdateRequest(int cacheId, UUID nodeId, GridCacheVersion futVer, boolean fastMap, @Nullable GridCacheVersion updateVer, @NotNull AffinityTopologyVersion topVer, boolean topLocked, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, boolean retval, @Nullable ExpiryPolicy expiryPlc, @Nullable Object[] invokeArgs, @Nullable CacheEntryPredicate[] filter, @Nullable UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, boolean clientReq, boolean addDepInfo, int maxEntryCnt) {
        assert (futVer != null);
        this.cacheId = cacheId;
        this.nodeId = nodeId;
        this.futVer = futVer;
        this.fastMap = fastMap;
        this.updateVer = updateVer;
        this.topVer = topVer;
        this.topLocked = topLocked;
        this.syncMode = syncMode;
        this.op = op;
        this.retval = retval;
        this.expiryPlc = expiryPlc;
        this.invokeArgs = invokeArgs;
        this.filter = filter;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.skipStore = skipStore;
        this.keepBinary = keepBinary;
        this.clientReq = clientReq;
        this.addDepInfo = addDepInfo;
        this.initSize = Math.min(maxEntryCnt, 10);
        this.keys = new ArrayList<KeyCacheObject>(this.initSize);
        this.partIds = new ArrayList<Integer>(this.initSize);
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    @Override
    public UUID nodeId() {
        return this.nodeId;
    }

    @Override
    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public UUID subjectId() {
        return this.subjId;
    }

    @Override
    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public GridCacheVersion futureVersion() {
        return this.futVer;
    }

    @Override
    public GridCacheVersion updateVersion() {
        return this.updateVer;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public CacheWriteSynchronizationMode writeSynchronizationMode() {
        return this.syncMode;
    }

    @Override
    public GridCacheOperation operation() {
        return this.op;
    }

    @Override
    public boolean onResponse(GridNearAtomicUpdateResponse res) {
        if (this.res == null) {
            this.res = res;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public GridNearAtomicUpdateResponse response() {
        return this.res;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    @Override
    public void addUpdateEntry(KeyCacheObject key, @Nullable Object val, long conflictTtl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer, boolean primary) {
        int i;
        EntryProcessor entryProcessor = null;
        if (this.op == GridCacheOperation.TRANSFORM) {
            assert (val instanceof EntryProcessor) : val;
            entryProcessor = (EntryProcessor)val;
        }
        assert (val != null || this.op == GridCacheOperation.DELETE);
        this.keys.add(key);
        this.partIds.add(key.partition());
        if (entryProcessor != null) {
            if (this.entryProcessors == null) {
                this.entryProcessors = new ArrayList<EntryProcessor<Object, Object, Object>>(this.initSize);
            }
            this.entryProcessors.add(entryProcessor);
        } else if (val != null) {
            assert (val instanceof CacheObject) : val;
            if (this.vals == null) {
                this.vals = new ArrayList<CacheObject>(this.initSize);
            }
            this.vals.add((CacheObject)val);
        }
        this.hasPrimary |= primary;
        if (conflictVer != null) {
            if (this.conflictVers == null) {
                this.conflictVers = new ArrayList<GridCacheVersion>(this.initSize);
                for (i = 0; i < this.keys.size() - 1; ++i) {
                    this.conflictVers.add(null);
                }
            }
            this.conflictVers.add(conflictVer);
        } else if (this.conflictVers != null) {
            this.conflictVers.add(null);
        }
        if (conflictTtl >= 0L) {
            if (this.conflictTtls == null) {
                this.conflictTtls = new GridLongList(this.keys.size());
                for (i = 0; i < this.keys.size() - 1; ++i) {
                    this.conflictTtls.add(-1L);
                }
            }
            this.conflictTtls.add(conflictTtl);
        }
        if (conflictExpireTime >= 0L) {
            if (this.conflictExpireTimes == null) {
                this.conflictExpireTimes = new GridLongList(this.keys.size());
                for (i = 0; i < this.keys.size() - 1; ++i) {
                    this.conflictExpireTimes.add(-1L);
                }
            }
            this.conflictExpireTimes.add(conflictExpireTime);
        }
    }

    @Override
    public List<KeyCacheObject> keys() {
        return this.keys;
    }

    @Override
    public int size() {
        return this.keys != null ? this.keys.size() : 0;
    }

    @Override
    public KeyCacheObject key(int idx) {
        return this.keys.get(idx);
    }

    @Override
    public List<?> values() {
        return this.op == GridCacheOperation.TRANSFORM ? this.entryProcessors : this.vals;
    }

    @Override
    public CacheObject value(int idx) {
        assert (this.op == GridCacheOperation.UPDATE) : this.op;
        return this.vals.get(idx);
    }

    @Override
    public EntryProcessor<Object, Object, Object> entryProcessor(int idx) {
        assert (this.op == GridCacheOperation.TRANSFORM) : this.op;
        return this.entryProcessors.get(idx);
    }

    @Override
    public CacheObject writeValue(int idx) {
        if (this.vals != null) {
            return this.vals.get(idx);
        }
        return null;
    }

    @Override
    @Nullable
    public List<GridCacheVersion> conflictVersions() {
        return this.conflictVers;
    }

    @Override
    @Nullable
    public GridCacheVersion conflictVersion(int idx) {
        if (this.conflictVers != null) {
            assert (idx >= 0 && idx < this.conflictVers.size());
            return this.conflictVers.get(idx);
        }
        return null;
    }

    @Override
    public long conflictTtl(int idx) {
        if (this.conflictTtls != null) {
            assert (idx >= 0 && idx < this.conflictTtls.size());
            return this.conflictTtls.get(idx);
        }
        return -1L;
    }

    @Override
    public long conflictExpireTime(int idx) {
        if (this.conflictExpireTimes != null) {
            assert (idx >= 0 && idx < this.conflictExpireTimes.size());
            return this.conflictExpireTimes.get(idx);
        }
        return -1L;
    }

    @Override
    @Nullable
    public Object[] invokeArguments() {
        return this.invokeArgs;
    }

    @Override
    public boolean fastMap() {
        return this.fastMap;
    }

    @Override
    public boolean topologyLocked() {
        return this.topLocked;
    }

    @Override
    public boolean clientRequest() {
        return this.clientReq;
    }

    @Override
    public boolean returnValue() {
        return this.retval;
    }

    @Override
    public boolean skipStore() {
        return this.skipStore;
    }

    @Override
    public boolean keepBinary() {
        return this.keepBinary;
    }

    @Override
    public boolean hasPrimary() {
        return this.hasPrimary;
    }

    @Override
    @Nullable
    public CacheEntryPredicate[] filter() {
        return this.filter;
    }

    @Override
    public ExpiryPolicy expiry() {
        return this.expiryPlc;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.expiryPlc != null && this.expiryPlcBytes == null) {
            this.expiryPlcBytes = CU.marshal(cctx, new IgniteExternalizableExpiryPolicy(this.expiryPlc));
        }
        this.prepareMarshalCacheObjects(this.keys, cctx);
        if (this.filter != null) {
            boolean hasFilter = false;
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                hasFilter = true;
                p.prepareMarshal(cctx);
            }
            if (!hasFilter) {
                this.filter = null;
            }
        }
        if (this.op == GridCacheOperation.TRANSFORM) {
            if (!this.addDepInfo && ctx.deploymentEnabled()) {
                this.addDepInfo = true;
            }
            if (this.entryProcessorsBytes == null) {
                this.entryProcessorsBytes = this.marshalCollection(this.entryProcessors, cctx);
            }
            if (this.invokeArgsBytes == null) {
                this.invokeArgsBytes = this.marshalInvokeArguments(this.invokeArgs, cctx);
            }
        } else {
            this.prepareMarshalCacheObjects(this.vals, cctx);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.expiryPlcBytes != null && this.expiryPlc == null) {
            this.expiryPlc = (ExpiryPolicy)U.unmarshal(ctx, this.expiryPlcBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        this.finishUnmarshalCacheObjects(this.keys, cctx, ldr);
        if (this.filter != null) {
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                p.finishUnmarshal(cctx, ldr);
            }
        }
        if (this.op == GridCacheOperation.TRANSFORM) {
            if (this.entryProcessors == null) {
                this.entryProcessors = this.unmarshalCollection(this.entryProcessorsBytes, ctx, ldr);
            }
            if (this.invokeArgs == null) {
                this.invokeArgs = this.unmarshalInvokeArguments(this.invokeArgsBytes, ctx, ldr);
            }
        } else {
            this.finishUnmarshalCacheObjects(this.vals, cctx, ldr);
        }
        if (this.partIds != null && !this.partIds.isEmpty()) {
            assert (this.partIds.size() == this.keys.size());
            for (int i = 0; i < this.keys.size(); ++i) {
                this.keys.get(i).partition(this.partIds.get(i));
            }
        }
    }

    @Override
    public int partition() {
        return this.partIds != null && !this.partIds.isEmpty() ? this.partIds.get(0) : -1;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeBoolean("clientReq", this.clientReq)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMessage("conflictExpireTimes", this.conflictExpireTimes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("conflictTtls", this.conflictTtls)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeCollection("conflictVers", this.conflictVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeCollection("entryProcessorsBytes", this.entryProcessorsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByteArray("expiryPlcBytes", this.expiryPlcBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeBoolean("fastMap", this.fastMap)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeObjectArray("filter", this.filter, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMessage("futVer", this.futVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeBoolean("hasPrimary", this.hasPrimary)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeObjectArray("invokeArgsBytes", (T[])this.invokeArgsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeBoolean("keepBinary", this.keepBinary)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeByte("op", this.op != null ? (byte)this.op.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeCollection("partIds", this.partIds, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeBoolean("retval", this.retval)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeBoolean("skipStore", this.skipStore)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeByte("syncMode", this.syncMode != null ? (byte)this.syncMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeBoolean("topLocked", this.topLocked)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeMessage("updateVer", this.updateVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeCollection("vals", this.vals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.clientReq = reader.readBoolean("clientReq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.conflictExpireTimes = (GridLongList)reader.readMessage("conflictExpireTimes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.conflictTtls = (GridLongList)reader.readMessage("conflictTtls");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.conflictVers = (List)reader.readCollection("conflictVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.entryProcessorsBytes = (List)reader.readCollection("entryProcessorsBytes", MessageCollectionItemType.BYTE_ARR);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.expiryPlcBytes = reader.readByteArray("expiryPlcBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.fastMap = reader.readBoolean("fastMap");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.filter = reader.readObjectArray("filter", MessageCollectionItemType.MSG, CacheEntryPredicate.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.futVer = (GridCacheVersion)reader.readMessage("futVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.hasPrimary = reader.readBoolean("hasPrimary");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.invokeArgsBytes = reader.readObjectArray("invokeArgsBytes", MessageCollectionItemType.BYTE_ARR, byte[].class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.keepBinary = reader.readBoolean("keepBinary");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                byte opOrd = reader.readByte("op");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.op = GridCacheOperation.fromOrdinal(opOrd);
                reader.incrementState();
            }
            case 17: {
                this.partIds = (List)reader.readCollection("partIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.retval = reader.readBoolean("retval");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.skipStore = reader.readBoolean("skipStore");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 21: {
                byte syncModeOrd = reader.readByte("syncMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.syncMode = CacheWriteSynchronizationMode.fromOrdinal(syncModeOrd);
                reader.incrementState();
            }
            case 22: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.topLocked = reader.readBoolean("topLocked");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.updateVer = (GridCacheVersion)reader.readMessage("updateVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.vals = (List)reader.readCollection("vals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicFullUpdateRequest.class);
    }

    @Override
    public void cleanup(boolean clearKeys) {
        this.vals = null;
        this.entryProcessors = null;
        this.entryProcessorsBytes = null;
        this.invokeArgs = null;
        this.invokeArgsBytes = null;
        if (clearKeys) {
            this.keys = null;
        }
    }

    @Override
    public byte directType() {
        return 40;
    }

    @Override
    public byte fieldsCount() {
        return 27;
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicFullUpdateRequest.class, this, "filter", Arrays.toString(this.filter), "parent", super.toString());
    }
}

