/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.EntryProcessorResourceInjectorProxy;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheTryPutFailedException;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicFullUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateFilterRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateInvokeRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicSingleUpdateFuture
extends GridNearAtomicAbstractUpdateFuture {
    private static final IgniteProductVersion SINGLE_UPDATE_REQUEST = IgniteProductVersion.fromString("1.7.4");
    private Object key;
    private Object val;
    private GridNearAtomicAbstractUpdateRequest req;

    public GridNearAtomicSingleUpdateFuture(GridCacheContext cctx, GridDhtAtomicCache cache, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, Object key, @Nullable Object val, @Nullable Object[] invokeArgs, boolean retval, boolean rawRetval, @Nullable ExpiryPolicy expiryPlc, CacheEntryPredicate[] filter, UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, int remapCnt, boolean waitTopFut) {
        super(cctx, cache, syncMode, op, invokeArgs, retval, rawRetval, expiryPlc, filter, subjId, taskNameHash, skipStore, keepBinary, remapCnt, waitTopFut);
        assert (subjId != null);
        this.key = key;
        this.val = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheVersion version() {
        Object object = this.mux;
        synchronized (object) {
            return this.futVer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNodeLeft(UUID nodeId) {
        GridNearAtomicAbstractUpdateRequest req;
        GridNearAtomicUpdateResponse res = null;
        Object object = this.mux;
        synchronized (object) {
            GridNearAtomicAbstractUpdateRequest gridNearAtomicAbstractUpdateRequest = req = this.req != null && this.req.nodeId().equals(nodeId) ? this.req : null;
            if (req != null && req.response() == null) {
                res = new GridNearAtomicUpdateResponse(this.cctx.cacheId(), nodeId, req.futureVersion(), this.cctx.deploymentEnabled());
                ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Primary node left grid before response is received: " + nodeId);
                e.retryReadyFuture(this.cctx.shared().nextAffinityReadyFuture(req.topologyVersion()));
                res.addFailedKeys(req.keys(), e);
            }
        }
        if (res != null) {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near update single fut, node left [futId=" + req.futureVersion() + ", writeVer=" + req.updateVersion() + ", node=" + nodeId + ']');
            }
            this.onResult(nodeId, res, true);
        }
        return false;
    }

    @Override
    public IgniteInternalFuture<Void> completeFuture(AffinityTopologyVersion topVer) {
        return null;
    }

    @Override
    public boolean onDone(@Nullable Object res, @Nullable Throwable err) {
        Object retval;
        assert (res == null || res instanceof GridCacheReturn);
        GridCacheReturn ret = (GridCacheReturn)res;
        Object object = res == null ? null : (this.rawRetval ? ret : (retval = this.retval || this.op == GridCacheOperation.TRANSFORM ? this.cctx.unwrapBinaryIfNeeded(ret.value(), this.keepBinary) : Boolean.valueOf(ret.success())));
        if (this.op == GridCacheOperation.TRANSFORM && retval == null) {
            retval = Collections.emptyMap();
        }
        if (super.onDone(retval, err)) {
            GridCacheVersion futVer = this.onFutureDone();
            if (futVer != null) {
                this.cctx.mvcc().removeAtomicFuture(futVer);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(UUID nodeId, GridNearAtomicUpdateResponse res, boolean nodeErr) {
        GridNearAtomicAbstractUpdateRequest req;
        AffinityTopologyVersion remapTopVer = null;
        GridCacheReturn opRes0 = null;
        CachePartialUpdateCheckedException err0 = null;
        GridFutureAdapter fut0 = null;
        Object object = this.mux;
        synchronized (object) {
            ClusterTopologyCheckedException topErr;
            boolean remapKey;
            if (!res.futureVersion().equals(this.futVer)) {
                return;
            }
            if (!this.req.nodeId().equals(nodeId)) {
                return;
            }
            req = this.req;
            this.req = null;
            boolean bl = remapKey = !F.isEmpty(res.remapKeys());
            if (remapKey) {
                if (this.mapErrTopVer == null || this.mapErrTopVer.compareTo(req.topologyVersion()) < 0) {
                    this.mapErrTopVer = req.topologyVersion();
                }
            } else if (res.error() != null) {
                if (res.failedKeys() != null) {
                    if (this.err == null) {
                        this.err = new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
                    }
                    ArrayList<Object> keys = new ArrayList<Object>(res.failedKeys().size());
                    for (KeyCacheObject key : res.failedKeys()) {
                        keys.add(this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(key, this.keepBinary, false));
                    }
                    this.err.add(keys, res.error(), req.topologyVersion());
                }
            } else if (!req.fastMap() || req.hasPrimary()) {
                GridCacheReturn ret = res.returnValue();
                if (this.op == GridCacheOperation.TRANSFORM) {
                    if (ret != null) {
                        assert (ret.value() == null || ret.value() instanceof Map) : ret.value();
                        if (ret.value() != null) {
                            if (this.opRes != null) {
                                this.opRes.mergeEntryProcessResults(ret);
                            } else {
                                this.opRes = ret;
                            }
                        }
                    }
                } else {
                    this.opRes = ret;
                }
            }
            if (remapKey) {
                assert (this.mapErrTopVer != null);
                remapTopVer = this.cctx.shared().exchange().topologyVersion();
            } else if (this.err != null && X.hasCause(this.err, CachePartialUpdateCheckedException.class) && X.hasCause(this.err, ClusterTopologyCheckedException.class) && this.storeFuture() && --this.remapCnt > 0 && !((topErr = X.cause(this.err, ClusterTopologyCheckedException.class)) instanceof ClusterTopologyServerNotFoundException)) {
                CachePartialUpdateCheckedException cause = X.cause(this.err, CachePartialUpdateCheckedException.class);
                assert (cause != null && cause.topologyVersion() != null) : this.err;
                remapTopVer = new AffinityTopologyVersion(cause.topologyVersion().topologyVersion() + 1L);
                this.err = null;
                this.updVer = null;
            }
            if (remapTopVer == null) {
                err0 = this.err;
                opRes0 = this.opRes;
            } else {
                fut0 = this.topCompleteFut;
                this.topCompleteFut = null;
                this.cctx.mvcc().removeAtomicFuture(this.futVer);
                this.futVer = null;
                this.topVer = AffinityTopologyVersion.ZERO;
            }
        }
        if (res.error() != null && res.failedKeys() == null) {
            this.onDone(res.error());
            return;
        }
        if (this.nearEnabled && !nodeErr) {
            this.updateNear(req, res);
        }
        if (remapTopVer != null) {
            if (fut0 != null) {
                fut0.onDone();
            }
            if (!this.waitTopFut) {
                this.onDone(new GridCacheTryPutFailedException());
                return;
            }
            if (this.topLocked) {
                CachePartialUpdateCheckedException e = new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
                ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Failed to update keys, topology changed while execute atomic update inside transaction.");
                cause.retryReadyFuture(this.cctx.affinity().affinityReadyFuture(remapTopVer));
                e.add(Collections.singleton(this.cctx.toCacheKeyObject(this.key)), cause);
                this.onDone(e);
                return;
            }
            IgniteInternalFuture<?> fut = this.cctx.shared().exchange().affinityReadyFuture(remapTopVer);
            if (fut == null) {
                fut = new GridFinishedFuture<AffinityTopologyVersion>(remapTopVer);
            }
            fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                    GridNearAtomicSingleUpdateFuture.this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                        @Override
                        public void run() {
                            GridNearAtomicSingleUpdateFuture.this.mapOnTopology();
                        }
                    });
                }
            });
            return;
        }
        this.onDone(opRes0, (Throwable)err0);
    }

    private void updateNear(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
        assert (this.nearEnabled);
        if (res.remapKeys() != null || !req.hasPrimary()) {
            return;
        }
        GridNearAtomicCache near = (GridNearAtomicCache)this.cctx.dht().near();
        near.processNearAtomicUpdateResponse(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mapOnTopology() {
        GridCacheVersion futVer;
        AffinityTopologyVersion topVer;
        block12: {
            this.cache.topology().readLock();
            try {
                if (this.cache.topology().stopping()) {
                    this.onDone(new IgniteCheckedException("Failed to perform cache operation (cache is stopped): " + this.cache.name()));
                    return;
                }
                GridDhtTopologyFuture fut = this.cache.topology().topologyVersionFuture();
                if (fut.isDone()) {
                    Throwable err = fut.validateCache(this.cctx);
                    if (err != null) {
                        this.onDone(err);
                        return;
                    }
                    topVer = fut.topologyVersion();
                    futVer = this.addAtomicFuture(topVer);
                    break block12;
                }
                if (this.waitTopFut) {
                    assert (!this.topLocked) : this;
                    fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                        @Override
                        public void apply(IgniteInternalFuture<AffinityTopologyVersion> t) {
                            GridNearAtomicSingleUpdateFuture.this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                                @Override
                                public void run() {
                                    GridNearAtomicSingleUpdateFuture.this.mapOnTopology();
                                }
                            });
                        }
                    });
                } else {
                    this.onDone(new GridCacheTryPutFailedException());
                }
                return;
            }
            finally {
                this.cache.topology().readUnlock();
            }
        }
        if (futVer != null) {
            this.map(topVer, futVer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void map(AffinityTopologyVersion topVer, GridCacheVersion futVer) {
        GridCacheVersion updVer;
        Collection<ClusterNode> topNodes = CU.affinityNodes(this.cctx, topVer);
        if (F.isEmpty(topNodes)) {
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid)."));
            return;
        }
        if (this.cctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK) {
            updVer = this.updVer;
            if (updVer == null) {
                updVer = this.cctx.versions().next(topVer);
                if (log.isDebugEnabled()) {
                    log.debug("Assigned fast-map version for update on near node: " + updVer);
                }
            }
        } else {
            updVer = null;
        }
        Exception err = null;
        GridNearAtomicAbstractUpdateRequest singleReq0 = null;
        try {
            singleReq0 = this.mapSingleUpdate(topVer, futVer, updVer);
            Object object = this.mux;
            synchronized (object) {
                assert (this.futVer == futVer || this.isDone() && this.error() != null);
                assert (this.topVer == topVer);
                this.updVer = updVer;
                this.resCnt = 0;
                this.req = singleReq0;
            }
        }
        catch (Exception e) {
            err = e;
        }
        if (err != null) {
            this.onDone(err);
            return;
        }
        this.mapSingle(singleReq0.nodeId(), singleReq0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCacheVersion onFutureDone() {
        GridCacheVersion ver0;
        GridFutureAdapter fut0;
        Object object = this.mux;
        synchronized (object) {
            fut0 = this.topCompleteFut;
            this.topCompleteFut = null;
            ver0 = this.futVer;
            this.futVer = null;
        }
        if (fut0 != null) {
            fut0.onDone();
        }
        return ver0;
    }

    private GridNearAtomicAbstractUpdateRequest mapSingleUpdate(AffinityTopologyVersion topVer, GridCacheVersion futVer, @Nullable GridCacheVersion updVer) throws Exception {
        if (this.key == null) {
            throw new NullPointerException("Null key.");
        }
        EntryProcessor val = this.val;
        if (val == null && this.op != GridCacheOperation.DELETE) {
            throw new NullPointerException("Null value.");
        }
        KeyCacheObject cacheKey = this.cctx.toCacheKeyObject(this.key);
        val = this.op != GridCacheOperation.TRANSFORM ? this.cctx.toCacheObject(val) : EntryProcessorResourceInjectorProxy.wrap(this.cctx.kernalContext(), val);
        ClusterNode primary = this.cctx.affinity().primaryByKey(cacheKey, topVer);
        if (primary == null) {
            throw new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid).");
        }
        GridNearAtomicAbstractUpdateRequest req = this.canUseSingleRequest(primary) ? (this.op == GridCacheOperation.TRANSFORM ? new GridNearAtomicSingleUpdateInvokeRequest(this.cctx.cacheId(), primary.id(), futVer, false, updVer, topVer, this.topLocked, this.syncMode, this.op, this.retval, this.invokeArgs, this.subjId, this.taskNameHash, this.skipStore, this.keepBinary, this.cctx.kernalContext().clientNode(), this.cctx.deploymentEnabled()) : (this.filter == null || this.filter.length == 0 ? new GridNearAtomicSingleUpdateRequest(this.cctx.cacheId(), primary.id(), futVer, false, updVer, topVer, this.topLocked, this.syncMode, this.op, this.retval, this.subjId, this.taskNameHash, this.skipStore, this.keepBinary, this.cctx.kernalContext().clientNode(), this.cctx.deploymentEnabled()) : new GridNearAtomicSingleUpdateFilterRequest(this.cctx.cacheId(), primary.id(), futVer, false, updVer, topVer, this.topLocked, this.syncMode, this.op, this.retval, this.filter, this.subjId, this.taskNameHash, this.skipStore, this.keepBinary, this.cctx.kernalContext().clientNode(), this.cctx.deploymentEnabled()))) : new GridNearAtomicFullUpdateRequest(this.cctx.cacheId(), primary.id(), futVer, false, updVer, topVer, this.topLocked, this.syncMode, this.op, this.retval, this.expiryPlc, this.invokeArgs, this.filter, this.subjId, this.taskNameHash, this.skipStore, this.keepBinary, this.cctx.kernalContext().clientNode(), this.cctx.deploymentEnabled(), 1);
        ((GridNearAtomicAbstractUpdateRequest)req).addUpdateEntry(cacheKey, val, -1L, -1L, null, true);
        return req;
    }

    private boolean canUseSingleRequest(ClusterNode node) {
        return this.expiryPlc == null && node != null && node.version().compareToIgnoreTimestamp(SINGLE_UPDATE_REQUEST) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.mux;
        synchronized (object) {
            return S.toString(GridNearAtomicSingleUpdateFuture.class, this, super.toString());
        }
    }
}

