/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractSingleUpdateRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicSingleUpdateRequest
extends GridNearAtomicAbstractSingleUpdateRequest {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    protected KeyCacheObject key;
    protected CacheObject val;
    protected int partId;

    public GridNearAtomicSingleUpdateRequest() {
    }

    GridNearAtomicSingleUpdateRequest(int cacheId, UUID nodeId, GridCacheVersion futVer, boolean fastMap, @Nullable GridCacheVersion updateVer, @NotNull AffinityTopologyVersion topVer, boolean topLocked, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, boolean retval, @Nullable UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, boolean clientReq, boolean addDepInfo) {
        super(cacheId, nodeId, futVer, fastMap, updateVer, topVer, topLocked, syncMode, op, retval, subjId, taskNameHash, skipStore, keepBinary, clientReq, addDepInfo);
    }

    @Override
    public int partition() {
        return this.partId;
    }

    @Override
    public void addUpdateEntry(KeyCacheObject key, @Nullable Object val, long conflictTtl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer, boolean primary) {
        assert (this.op != GridCacheOperation.TRANSFORM);
        assert (val != null || this.op == GridCacheOperation.DELETE);
        assert (conflictTtl < 0L) : conflictTtl;
        assert (conflictExpireTime < 0L) : conflictExpireTime;
        assert (conflictVer == null) : conflictVer;
        this.key = key;
        this.partId = key.partition();
        if (val != null) {
            assert (val instanceof CacheObject) : val;
            this.val = (CacheObject)val;
        }
        this.hasPrimary(this.hasPrimary() | primary);
    }

    @Override
    public int size() {
        return this.key == null ? 0 : 1;
    }

    @Override
    public List<KeyCacheObject> keys() {
        return Collections.singletonList(this.key);
    }

    @Override
    public KeyCacheObject key(int idx) {
        assert (idx == 0) : idx;
        return this.key;
    }

    @Override
    public List<?> values() {
        return Collections.singletonList(this.val);
    }

    @Override
    public CacheObject value(int idx) {
        assert (idx == 0) : idx;
        return this.val;
    }

    @Override
    public EntryProcessor<Object, Object, Object> entryProcessor(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    public CacheObject writeValue(int idx) {
        assert (idx == 0) : idx;
        return this.val;
    }

    @Override
    @Nullable
    public List<GridCacheVersion> conflictVersions() {
        return null;
    }

    @Override
    @Nullable
    public GridCacheVersion conflictVersion(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    public long conflictTtl(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    public long conflictExpireTime(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObject(this.key, cctx);
        if (this.val != null) {
            this.prepareMarshalCacheObject(this.val, cctx);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.key.finishUnmarshal(cctx.cacheObjectContext(), ldr);
        if (this.val != null) {
            this.val.finishUnmarshal(cctx.cacheObjectContext(), ldr);
        }
        this.key.partition(this.partId);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 11: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeInt("partId", this.partId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeMessage("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 11: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.partId = reader.readInt("partId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicSingleUpdateRequest.class);
    }

    @Override
    public void cleanup(boolean clearKey) {
        this.val = null;
        if (clearKey) {
            this.key = null;
        }
    }

    @Override
    public byte directType() {
        return 125;
    }

    @Override
    public byte fieldsCount() {
        return 14;
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicSingleUpdateRequest.class, this, "parent", super.toString());
    }
}

