/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.EntryProcessorResourceInjectorProxy;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheTryPutFailedException;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicFullUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicUpdateFuture
extends GridNearAtomicAbstractUpdateFuture {
    private final boolean fastMap;
    private Collection<?> keys;
    private Collection<?> vals;
    private Collection<GridCacheDrInfo> conflictPutVals;
    private Collection<GridCacheVersion> conflictRmvVals;
    @GridToStringInclude
    private Map<UUID, GridNearAtomicFullUpdateRequest> mappings;
    private Collection<KeyCacheObject> remapKeys;
    private GridNearAtomicFullUpdateRequest singleReq;

    public GridNearAtomicUpdateFuture(GridCacheContext cctx, GridDhtAtomicCache cache, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, Collection<?> keys, @Nullable Collection<?> vals, @Nullable Object[] invokeArgs, @Nullable Collection<GridCacheDrInfo> conflictPutVals, @Nullable Collection<GridCacheVersion> conflictRmvVals, boolean retval, boolean rawRetval, @Nullable ExpiryPolicy expiryPlc, CacheEntryPredicate[] filter, UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, int remapCnt, boolean waitTopFut) {
        super(cctx, cache, syncMode, op, invokeArgs, retval, rawRetval, expiryPlc, filter, subjId, taskNameHash, skipStore, keepBinary, remapCnt, waitTopFut);
        assert (vals == null || vals.size() == keys.size());
        assert (conflictPutVals == null || conflictPutVals.size() == keys.size());
        assert (conflictRmvVals == null || conflictRmvVals.size() == keys.size());
        assert (subjId != null);
        this.keys = keys;
        this.vals = vals;
        this.conflictPutVals = conflictPutVals;
        this.conflictRmvVals = conflictRmvVals;
        this.fastMap = cache.isFastMap(filter, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheVersion version() {
        Object object = this.mux;
        synchronized (object) {
            return this.futVer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNodeLeft(UUID nodeId) {
        GridNearAtomicFullUpdateRequest req;
        GridNearAtomicUpdateResponse res = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.singleReq != null) {
                req = this.singleReq.nodeId().equals(nodeId) ? this.singleReq : null;
            } else {
                GridNearAtomicFullUpdateRequest gridNearAtomicFullUpdateRequest = req = this.mappings != null ? this.mappings.get(nodeId) : null;
            }
            if (req != null && req.response() == null) {
                res = new GridNearAtomicUpdateResponse(this.cctx.cacheId(), nodeId, req.futureVersion(), this.cctx.deploymentEnabled());
                ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Primary node left grid before response is received: " + nodeId);
                e.retryReadyFuture(this.cctx.shared().nextAffinityReadyFuture(req.topologyVersion()));
                res.addFailedKeys(req.keys(), e);
            }
        }
        if (res != null) {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near update fut, node left [futId=" + req.futureVersion() + ", writeVer=" + req.updateVersion() + ", node=" + nodeId + ']');
            }
            this.onResult(nodeId, res, true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Void> completeFuture(AffinityTopologyVersion topVer) {
        if (this.fastMap) {
            GridFutureAdapter fut;
            Object object = this.mux;
            synchronized (object) {
                if (this.topVer != AffinityTopologyVersion.ZERO && this.topVer.compareTo(topVer) < 0) {
                    if (this.topCompleteFut == null) {
                        this.topCompleteFut = new GridFutureAdapter();
                    }
                    fut = this.topCompleteFut;
                } else {
                    fut = null;
                }
            }
            if (fut != null && this.isDone()) {
                fut.onDone();
                return null;
            }
            return fut;
        }
        return null;
    }

    @Override
    public boolean onDone(@Nullable Object res, @Nullable Throwable err) {
        Object retval;
        assert (res == null || res instanceof GridCacheReturn);
        GridCacheReturn ret = (GridCacheReturn)res;
        Object object = res == null ? null : (this.rawRetval ? ret : (retval = this.retval || this.op == GridCacheOperation.TRANSFORM ? this.cctx.unwrapBinaryIfNeeded(ret.value(), this.keepBinary) : Boolean.valueOf(ret.success())));
        if (this.op == GridCacheOperation.TRANSFORM && retval == null) {
            retval = Collections.emptyMap();
        }
        if (super.onDone(retval, err)) {
            GridCacheVersion futVer = this.onFutureDone();
            if (futVer != null) {
                this.cctx.mvcc().removeAtomicFuture(futVer);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(UUID nodeId, GridNearAtomicUpdateResponse res, boolean nodeErr) {
        boolean rcvAll;
        GridNearAtomicFullUpdateRequest req;
        AffinityTopologyVersion remapTopVer = null;
        GridCacheReturn opRes0 = null;
        CachePartialUpdateCheckedException err0 = null;
        GridFutureAdapter fut0 = null;
        Object object = this.mux;
        synchronized (object) {
            if (!res.futureVersion().equals(this.futVer)) {
                return;
            }
            if (this.singleReq != null) {
                if (!this.singleReq.nodeId().equals(nodeId)) {
                    return;
                }
                req = this.singleReq;
                this.singleReq = null;
                rcvAll = true;
            } else {
                GridNearAtomicFullUpdateRequest gridNearAtomicFullUpdateRequest = req = this.mappings != null ? this.mappings.get(nodeId) : null;
                if (req != null && req.onResponse(res)) {
                    ++this.resCnt;
                    rcvAll = this.mappings.size() == this.resCnt;
                } else {
                    return;
                }
            }
            assert (req != null && req.topologyVersion().equals(this.topVer)) : req;
            if (res.remapKeys() != null) {
                assert (!this.fastMap || this.cctx.kernalContext().clientNode());
                if (this.remapKeys == null) {
                    this.remapKeys = U.newHashSet(res.remapKeys().size());
                }
                this.remapKeys.addAll(res.remapKeys());
                if (this.mapErrTopVer == null || this.mapErrTopVer.compareTo(req.topologyVersion()) < 0) {
                    this.mapErrTopVer = req.topologyVersion();
                }
            } else if (res.error() != null) {
                if (res.failedKeys() != null) {
                    if (this.err == null) {
                        this.err = new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
                    }
                    ArrayList<Object> keys = new ArrayList<Object>(res.failedKeys().size());
                    for (KeyCacheObject key : res.failedKeys()) {
                        keys.add(this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(key, this.keepBinary, false));
                    }
                    this.err.add(keys, res.error(), req.topologyVersion());
                }
            } else if (!req.fastMap() || req.hasPrimary()) {
                GridCacheReturn ret = res.returnValue();
                if (this.op == GridCacheOperation.TRANSFORM) {
                    if (ret != null) {
                        assert (ret.value() == null || ret.value() instanceof Map) : ret.value();
                        if (ret.value() != null) {
                            if (this.opRes != null) {
                                this.opRes.mergeEntryProcessResults(ret);
                            } else {
                                this.opRes = ret;
                            }
                        }
                    }
                } else {
                    this.opRes = ret;
                }
            }
            if (rcvAll) {
                ClusterTopologyCheckedException topErr;
                if (this.remapKeys != null) {
                    assert (this.mapErrTopVer != null);
                    remapTopVer = this.cctx.shared().exchange().topologyVersion();
                } else if (this.err != null && X.hasCause(this.err, CachePartialUpdateCheckedException.class) && X.hasCause(this.err, ClusterTopologyCheckedException.class) && this.storeFuture() && --this.remapCnt > 0 && !((topErr = X.cause(this.err, ClusterTopologyCheckedException.class)) instanceof ClusterTopologyServerNotFoundException)) {
                    CachePartialUpdateCheckedException cause = X.cause(this.err, CachePartialUpdateCheckedException.class);
                    assert (cause != null && cause.topologyVersion() != null) : this.err;
                    remapTopVer = new AffinityTopologyVersion(cause.topologyVersion().topologyVersion() + 1L);
                    this.err = null;
                    Collection failedKeys = cause.failedKeys();
                    this.remapKeys = new ArrayList<KeyCacheObject>(failedKeys.size());
                    for (Object key : failedKeys) {
                        this.remapKeys.add(this.cctx.toCacheKeyObject(key));
                    }
                    this.updVer = null;
                }
                if (remapTopVer == null) {
                    err0 = this.err;
                    opRes0 = this.opRes;
                } else {
                    fut0 = this.topCompleteFut;
                    this.topCompleteFut = null;
                    this.cctx.mvcc().removeAtomicFuture(this.futVer);
                    this.futVer = null;
                    this.topVer = AffinityTopologyVersion.ZERO;
                }
            }
        }
        if (res.error() != null && res.failedKeys() == null) {
            this.onDone(res.error());
            return;
        }
        if (rcvAll && this.nearEnabled) {
            if (this.mappings != null) {
                for (GridNearAtomicFullUpdateRequest req0 : this.mappings.values()) {
                    GridNearAtomicUpdateResponse res0 = req0.response();
                    assert (res0 != null) : req0;
                    this.updateNear(req0, res0);
                }
            } else if (!nodeErr) {
                this.updateNear(req, res);
            }
        }
        if (remapTopVer != null) {
            if (fut0 != null) {
                fut0.onDone();
            }
            if (!this.waitTopFut) {
                this.onDone(new GridCacheTryPutFailedException());
                return;
            }
            if (this.topLocked) {
                assert (!F.isEmpty(this.remapKeys)) : this.remapKeys;
                CachePartialUpdateCheckedException e = new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
                ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Failed to update keys, topology changed while execute atomic update inside transaction.");
                cause.retryReadyFuture(this.cctx.affinity().affinityReadyFuture(remapTopVer));
                e.add(this.remapKeys, cause);
                this.onDone(e);
                return;
            }
            IgniteInternalFuture<?> fut = this.cctx.shared().exchange().affinityReadyFuture(remapTopVer);
            if (fut == null) {
                fut = new GridFinishedFuture<AffinityTopologyVersion>(remapTopVer);
            }
            fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                    GridNearAtomicUpdateFuture.this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                        @Override
                        public void run() {
                            GridNearAtomicUpdateFuture.this.mapOnTopology();
                        }
                    });
                }
            });
            return;
        }
        if (rcvAll) {
            this.onDone(opRes0, (Throwable)err0);
        }
    }

    private void updateNear(GridNearAtomicFullUpdateRequest req, GridNearAtomicUpdateResponse res) {
        assert (this.nearEnabled);
        if (res.remapKeys() != null || !req.hasPrimary()) {
            return;
        }
        GridNearAtomicCache near = (GridNearAtomicCache)this.cctx.dht().near();
        near.processNearAtomicUpdateResponse(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mapOnTopology() {
        GridCacheVersion futVer;
        AffinityTopologyVersion topVer;
        block12: {
            this.cache.topology().readLock();
            try {
                if (this.cache.topology().stopping()) {
                    this.onDone(new IgniteCheckedException("Failed to perform cache operation (cache is stopped): " + this.cache.name()));
                    return;
                }
                GridDhtTopologyFuture fut = this.cache.topology().topologyVersionFuture();
                if (fut.isDone()) {
                    Throwable err = fut.validateCache(this.cctx);
                    if (err != null) {
                        this.onDone(err);
                        return;
                    }
                    topVer = fut.topologyVersion();
                    futVer = this.addAtomicFuture(topVer);
                    break block12;
                }
                if (this.waitTopFut) {
                    assert (!this.topLocked) : this;
                    fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                        @Override
                        public void apply(IgniteInternalFuture<AffinityTopologyVersion> t) {
                            GridNearAtomicUpdateFuture.this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                                @Override
                                public void run() {
                                    GridNearAtomicUpdateFuture.this.mapOnTopology();
                                }
                            });
                        }
                    });
                } else {
                    this.onDone(new GridCacheTryPutFailedException());
                }
                return;
            }
            finally {
                this.cache.topology().readUnlock();
            }
        }
        if (futVer != null) {
            this.map(topVer, futVer, this.remapKeys);
        }
    }

    private void doUpdate(Map<UUID, GridNearAtomicFullUpdateRequest> mappings) {
        UUID locNodeId = this.cctx.localNodeId();
        GridNearAtomicFullUpdateRequest locUpdate = null;
        for (GridNearAtomicFullUpdateRequest req : mappings.values()) {
            if (locNodeId.equals(req.nodeId())) {
                assert (locUpdate == null) : "Cannot have more than one local mapping [locUpdate=" + locUpdate + ", req=" + req + ']';
                locUpdate = req;
                continue;
            }
            try {
                this.cctx.io().send(req.nodeId(), (GridCacheMessage)req, this.cctx.ioPolicy());
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("Near update fut, sent request [futId=" + req.futureVersion() + ", writeVer=" + req.updateVersion() + ", node=" + req.nodeId() + ']');
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near update fut, failed to send request [futId=" + req.futureVersion() + ", writeVer=" + req.updateVersion() + ", node=" + req.nodeId() + ", err=" + e + ']');
                }
                this.onSendError(req, e);
            }
        }
        if (locUpdate != null) {
            this.cache.updateAllAsyncInternal(this.cctx.localNodeId(), locUpdate, (CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse>)new CI2<GridNearAtomicFullUpdateRequest, GridNearAtomicUpdateResponse>(){

                @Override
                public void apply(GridNearAtomicFullUpdateRequest req, GridNearAtomicUpdateResponse res) {
                    GridNearAtomicUpdateFuture.this.onResult(res.nodeId(), res, false);
                }
            });
        }
        if (this.syncMode == CacheWriteSynchronizationMode.FULL_ASYNC) {
            this.onDone(new GridCacheReturn(this.cctx, true, true, null, true));
        }
    }

    @Override
    protected void map(AffinityTopologyVersion topVer, GridCacheVersion futVer) {
        this.map(topVer, futVer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void map(AffinityTopologyVersion topVer, GridCacheVersion futVer, @Nullable Collection<KeyCacheObject> remapKeys) {
        GridCacheVersion updVer;
        Collection<ClusterNode> topNodes = CU.affinityNodes(this.cctx, topVer);
        if (F.isEmpty(topNodes)) {
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid)."));
            return;
        }
        if (this.cctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK) {
            updVer = this.updVer;
            if (updVer == null) {
                updVer = this.cctx.versions().next(topVer);
                if (log.isDebugEnabled()) {
                    log.debug("Assigned fast-map version for update on near node: " + updVer);
                }
            }
        } else {
            updVer = null;
        }
        Exception err = null;
        GridNearAtomicFullUpdateRequest singleReq0 = null;
        HashMap<UUID, GridNearAtomicFullUpdateRequest> mappings0 = null;
        int size = this.keys.size();
        try {
            Map<UUID, GridNearAtomicFullUpdateRequest> pendingMappings;
            if (size == 1 && !this.fastMap) {
                assert (remapKeys == null || remapKeys.size() == 1);
                singleReq0 = this.mapSingleUpdate(topVer, futVer, updVer);
            } else {
                pendingMappings = this.mapUpdate(topNodes, topVer, futVer, updVer, remapKeys);
                if (pendingMappings.size() == 1) {
                    singleReq0 = F.firstValue(pendingMappings);
                } else {
                    if (this.syncMode == CacheWriteSynchronizationMode.PRIMARY_SYNC) {
                        mappings0 = U.newHashMap(pendingMappings.size());
                        for (GridNearAtomicFullUpdateRequest req : pendingMappings.values()) {
                            if (!req.hasPrimary()) continue;
                            mappings0.put(req.nodeId(), req);
                        }
                    } else {
                        mappings0 = pendingMappings;
                    }
                    assert (!mappings0.isEmpty() || size == 0) : this;
                }
            }
            pendingMappings = this.mux;
            synchronized (pendingMappings) {
                assert (this.futVer == futVer || this.isDone() && this.error() != null);
                assert (this.topVer == topVer);
                this.updVer = updVer;
                this.resCnt = 0;
                this.singleReq = singleReq0;
                this.mappings = mappings0;
                this.remapKeys = null;
            }
        }
        catch (Exception e) {
            err = e;
        }
        if (err != null) {
            this.onDone(err);
            return;
        }
        if (singleReq0 != null) {
            this.mapSingle(singleReq0.nodeId(), singleReq0);
        } else {
            assert (mappings0 != null);
            if (size == 0) {
                this.onDone(new GridCacheReturn(this.cctx, true, true, null, true));
            } else {
                this.doUpdate(mappings0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCacheVersion onFutureDone() {
        GridCacheVersion ver0;
        GridFutureAdapter fut0;
        Object object = this.mux;
        synchronized (object) {
            fut0 = this.topCompleteFut;
            this.topCompleteFut = null;
            ver0 = this.futVer;
            this.futVer = null;
        }
        if (fut0 != null) {
            fut0.onDone();
        }
        return ver0;
    }

    private Map<UUID, GridNearAtomicFullUpdateRequest> mapUpdate(Collection<ClusterNode> topNodes, AffinityTopologyVersion topVer, GridCacheVersion futVer, @Nullable GridCacheVersion updVer, @Nullable Collection<KeyCacheObject> remapKeys) throws Exception {
        Iterator<?> it = null;
        if (this.vals != null) {
            it = this.vals.iterator();
        }
        Iterator<GridCacheDrInfo> conflictPutValsIt = null;
        if (this.conflictPutVals != null) {
            conflictPutValsIt = this.conflictPutVals.iterator();
        }
        Iterator<GridCacheVersion> conflictRmvValsIt = null;
        if (this.conflictRmvVals != null) {
            conflictRmvValsIt = this.conflictRmvVals.iterator();
        }
        HashMap<UUID, GridNearAtomicFullUpdateRequest> pendingMappings = U.newHashMap(topNodes.size());
        for (Object key : this.keys) {
            long conflictExpireTime;
            long conflictTtl;
            GridCacheVersion conflictVer;
            Object val;
            if (key == null) {
                throw new NullPointerException("Null key.");
            }
            if (this.vals != null) {
                val = it.next();
                conflictVer = null;
                conflictTtl = -1L;
                conflictExpireTime = -1L;
                if (val == null) {
                    throw new NullPointerException("Null value.");
                }
            } else if (this.conflictPutVals != null) {
                GridCacheDrInfo conflictPutVal = conflictPutValsIt.next();
                val = conflictPutVal.valueEx();
                conflictVer = conflictPutVal.version();
                conflictTtl = conflictPutVal.ttl();
                conflictExpireTime = conflictPutVal.expireTime();
            } else if (this.conflictRmvVals != null) {
                val = null;
                conflictVer = conflictRmvValsIt.next();
                conflictTtl = -1L;
                conflictExpireTime = -1L;
            } else {
                val = null;
                conflictVer = null;
                conflictTtl = -1L;
                conflictExpireTime = -1L;
            }
            if (val == null && this.op != GridCacheOperation.DELETE) continue;
            KeyCacheObject cacheKey = this.cctx.toCacheKeyObject(key);
            if (remapKeys != null && !remapKeys.contains(cacheKey)) continue;
            val = this.op != GridCacheOperation.TRANSFORM ? this.cctx.toCacheObject(val) : EntryProcessorResourceInjectorProxy.wrap(this.cctx.kernalContext(), (EntryProcessor)val);
            List<ClusterNode> affNodes = this.mapKey(cacheKey, topVer);
            if (affNodes.isEmpty()) {
                throw new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid).");
            }
            int i = 0;
            for (int n = 0; n < affNodes.size(); ++n) {
                ClusterNode affNode = affNodes.get(n);
                if (affNode == null) {
                    throw new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid).");
                }
                UUID nodeId = affNode.id();
                GridNearAtomicFullUpdateRequest mapped = (GridNearAtomicFullUpdateRequest)pendingMappings.get(nodeId);
                if (mapped == null) {
                    mapped = new GridNearAtomicFullUpdateRequest(this.cctx.cacheId(), nodeId, futVer, this.fastMap, updVer, topVer, this.topLocked, this.syncMode, this.op, this.retval, this.expiryPlc, this.invokeArgs, this.filter, this.subjId, this.taskNameHash, this.skipStore, this.keepBinary, this.cctx.kernalContext().clientNode(), this.cctx.deploymentEnabled(), this.keys.size());
                    pendingMappings.put(nodeId, mapped);
                }
                mapped.addUpdateEntry(cacheKey, val, conflictTtl, conflictExpireTime, conflictVer, i == 0);
                ++i;
            }
        }
        return pendingMappings;
    }

    private GridNearAtomicFullUpdateRequest mapSingleUpdate(AffinityTopologyVersion topVer, GridCacheVersion futVer, @Nullable GridCacheVersion updVer) throws Exception {
        long conflictExpireTime;
        long conflictTtl;
        GridCacheVersion conflictVer;
        Object val;
        Object key = F.first(this.keys);
        if (this.vals != null) {
            val = F.first(this.vals);
            conflictVer = null;
            conflictTtl = -1L;
            conflictExpireTime = -1L;
        } else if (this.conflictPutVals != null) {
            GridCacheDrInfo conflictPutVal = F.first(this.conflictPutVals);
            val = conflictPutVal.valueEx();
            conflictVer = conflictPutVal.version();
            conflictTtl = conflictPutVal.ttl();
            conflictExpireTime = conflictPutVal.expireTime();
        } else if (this.conflictRmvVals != null) {
            val = null;
            conflictVer = F.first(this.conflictRmvVals);
            conflictTtl = -1L;
            conflictExpireTime = -1L;
        } else {
            val = null;
            conflictVer = null;
            conflictTtl = -1L;
            conflictExpireTime = -1L;
        }
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (val == null && this.op != GridCacheOperation.DELETE) {
            throw new NullPointerException("Null value.");
        }
        KeyCacheObject cacheKey = this.cctx.toCacheKeyObject(key);
        val = this.op != GridCacheOperation.TRANSFORM ? this.cctx.toCacheObject(val) : EntryProcessorResourceInjectorProxy.wrap(this.cctx.kernalContext(), (EntryProcessor)val);
        ClusterNode primary = this.cctx.affinity().primaryByPartition(cacheKey.partition(), topVer);
        if (primary == null) {
            throw new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid).");
        }
        GridNearAtomicFullUpdateRequest req = new GridNearAtomicFullUpdateRequest(this.cctx.cacheId(), primary.id(), futVer, this.fastMap, updVer, topVer, this.topLocked, this.syncMode, this.op, this.retval, this.expiryPlc, this.invokeArgs, this.filter, this.subjId, this.taskNameHash, this.skipStore, this.keepBinary, this.cctx.kernalContext().clientNode(), this.cctx.deploymentEnabled(), 1);
        req.addUpdateEntry(cacheKey, val, conflictTtl, conflictExpireTime, conflictVer, true);
        return req;
    }

    private List<ClusterNode> mapKey(KeyCacheObject key, AffinityTopologyVersion topVer) {
        GridCacheAffinityManager affMgr = this.cctx.affinity();
        return this.fastMap ? this.cctx.topology().nodes(affMgr.partition(key), topVer) : Collections.singletonList(affMgr.primaryByKey(key, topVer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.mux;
        synchronized (object) {
            return S.toString(GridNearAtomicUpdateFuture.class, this, super.toString());
        }
    }
}

