/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicUpdateResponse
extends GridCacheMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    public static final int CACHE_MSG_IDX = GridNearAtomicUpdateResponse.nextIndexId();
    @GridDirectTransient
    private UUID nodeId;
    private GridCacheVersion futVer;
    @GridDirectTransient
    private volatile IgniteCheckedException err;
    private byte[] errBytes;
    @GridToStringInclude
    private GridCacheReturn ret;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private volatile Collection<KeyCacheObject> failedKeys;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> remapKeys;
    @GridDirectCollection(value=int.class)
    private List<Integer> nearValsIdxs;
    @GridDirectCollection(value=int.class)
    private List<Integer> nearSkipIdxs;
    @GridToStringInclude
    @GridDirectCollection(value=CacheObject.class)
    private List<CacheObject> nearVals;
    private GridCacheVersion nearVer;
    private GridLongList nearTtls;
    private GridLongList nearExpireTimes;

    public GridNearAtomicUpdateResponse() {
    }

    public GridNearAtomicUpdateResponse(int cacheId, UUID nodeId, GridCacheVersion futVer, boolean addDepInfo) {
        assert (futVer != null);
        this.cacheId = cacheId;
        this.nodeId = nodeId;
        this.futVer = futVer;
        this.addDepInfo = addDepInfo;
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public GridCacheVersion futureVersion() {
        return this.futVer;
    }

    public void error(IgniteCheckedException err) {
        this.err = err;
    }

    @Override
    public IgniteCheckedException error() {
        return this.err;
    }

    public Collection<KeyCacheObject> failedKeys() {
        return this.failedKeys;
    }

    public GridCacheReturn returnValue() {
        return this.ret;
    }

    public void returnValue(GridCacheReturn ret) {
        this.ret = ret;
    }

    public void remapKeys(List<KeyCacheObject> remapKeys) {
        this.remapKeys = remapKeys;
    }

    public Collection<KeyCacheObject> remapKeys() {
        return this.remapKeys;
    }

    public void addNearValue(int keyIdx, @Nullable CacheObject val, long ttl, long expireTime) {
        if (this.nearValsIdxs == null) {
            this.nearValsIdxs = new ArrayList<Integer>();
            this.nearVals = new ArrayList<CacheObject>();
        }
        this.addNearTtl(keyIdx, ttl, expireTime);
        this.nearValsIdxs.add(keyIdx);
        this.nearVals.add(val);
    }

    public void addNearTtl(int keyIdx, long ttl, long expireTime) {
        int i;
        if (ttl >= 0L && this.nearTtls == null) {
            this.nearTtls = new GridLongList(16);
            for (i = 0; i < keyIdx; ++i) {
                this.nearTtls.add(-1L);
            }
        }
        if (this.nearTtls != null) {
            this.nearTtls.add(ttl);
        }
        if (expireTime >= 0L && this.nearExpireTimes == null) {
            this.nearExpireTimes = new GridLongList(16);
            for (i = 0; i < keyIdx; ++i) {
                this.nearExpireTimes.add(-1L);
            }
        }
        if (this.nearExpireTimes != null) {
            this.nearExpireTimes.add(expireTime);
        }
    }

    public long nearExpireTime(int idx) {
        if (this.nearExpireTimes != null) {
            assert (idx >= 0 && idx < this.nearExpireTimes.size());
            return this.nearExpireTimes.get(idx);
        }
        return -1L;
    }

    public long nearTtl(int idx) {
        if (this.nearTtls != null) {
            assert (idx >= 0 && idx < this.nearTtls.size());
            return this.nearTtls.get(idx);
        }
        return -1L;
    }

    public void nearVersion(GridCacheVersion nearVer) {
        this.nearVer = nearVer;
    }

    public GridCacheVersion nearVersion() {
        return this.nearVer;
    }

    public void addSkippedIndex(int keyIdx) {
        if (this.nearSkipIdxs == null) {
            this.nearSkipIdxs = new ArrayList<Integer>();
        }
        this.nearSkipIdxs.add(keyIdx);
        this.addNearTtl(keyIdx, -1L, -1L);
    }

    @Nullable
    public List<Integer> skippedIndexes() {
        return this.nearSkipIdxs;
    }

    @Nullable
    public List<Integer> nearValuesIndexes() {
        return this.nearValsIdxs;
    }

    @Nullable
    public CacheObject nearValue(int idx) {
        return this.nearVals.get(idx);
    }

    public synchronized void addFailedKey(KeyCacheObject key, Throwable e) {
        if (this.failedKeys == null) {
            this.failedKeys = new ConcurrentLinkedQueue<KeyCacheObject>();
        }
        this.failedKeys.add(key);
        if (this.err == null) {
            this.err = new IgniteCheckedException("Failed to update keys on primary node.");
        }
        this.err.addSuppressed(e);
    }

    public synchronized void addFailedKeys(Collection<KeyCacheObject> keys, Throwable e) {
        if (keys != null) {
            if (this.failedKeys == null) {
                this.failedKeys = new ArrayList<KeyCacheObject>(keys.size());
            }
            this.failedKeys.addAll(keys);
        }
        if (this.err == null) {
            this.err = new IgniteCheckedException("Failed to update keys on primary node.");
        }
        this.err.addSuppressed(e);
    }

    public synchronized void addFailedKeys(Collection<KeyCacheObject> keys, Throwable e, GridCacheContext ctx) {
        if (this.failedKeys == null) {
            this.failedKeys = new ArrayList<KeyCacheObject>(keys.size());
        }
        this.failedKeys.addAll(keys);
        if (this.err == null) {
            this.err = new IgniteCheckedException("Failed to update keys on primary node.");
        }
        this.err.addSuppressed(e);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.err != null && this.errBytes == null) {
            this.errBytes = U.marshal(ctx, (Object)this.err);
        }
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObjects(this.failedKeys, cctx);
        this.prepareMarshalCacheObjects(this.remapKeys, cctx);
        this.prepareMarshalCacheObjects(this.nearVals, cctx);
        if (this.ret != null) {
            this.ret.prepareMarshal(cctx);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.errBytes != null && this.err == null) {
            this.err = (IgniteCheckedException)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalCacheObjects(this.failedKeys, cctx, ldr);
        this.finishUnmarshalCacheObjects(this.remapKeys, cctx, ldr);
        this.finishUnmarshalCacheObjects(this.nearVals, cctx, ldr);
        if (this.ret != null) {
            this.ret.finishUnmarshal(cctx, ldr);
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeCollection("failedKeys", this.failedKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("futVer", this.futVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMessage("nearExpireTimes", this.nearExpireTimes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeCollection("nearSkipIdxs", this.nearSkipIdxs, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeMessage("nearTtls", this.nearTtls)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeCollection("nearVals", this.nearVals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeCollection("nearValsIdxs", this.nearValsIdxs, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMessage("nearVer", this.nearVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeCollection("remapKeys", this.remapKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeMessage("ret", this.ret)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.failedKeys = reader.readCollection("failedKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.futVer = (GridCacheVersion)reader.readMessage("futVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.nearExpireTimes = (GridLongList)reader.readMessage("nearExpireTimes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.nearSkipIdxs = (List)reader.readCollection("nearSkipIdxs", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.nearTtls = (GridLongList)reader.readMessage("nearTtls");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.nearVals = (List)reader.readCollection("nearVals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.nearValsIdxs = (List)reader.readCollection("nearValsIdxs", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.nearVer = (GridCacheVersion)reader.readMessage("nearVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.remapKeys = (List)reader.readCollection("remapKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.ret = (GridCacheReturn)reader.readMessage("ret");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicUpdateResponse.class);
    }

    @Override
    public byte directType() {
        return 41;
    }

    @Override
    public byte fieldsCount() {
        return 14;
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicUpdateResponse.class, this, "parent");
    }
}

