/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtForceKeysResponse
extends GridCacheMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid futId;
    private IgniteUuid miniId;
    @GridDirectTransient
    private volatile IgniteCheckedException err;
    private byte[] errBytes;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> missedKeys;
    @GridToStringInclude
    @GridDirectCollection(value=GridCacheEntryInfo.class)
    private List<GridCacheEntryInfo> infos;

    public GridDhtForceKeysResponse() {
    }

    public GridDhtForceKeysResponse(int cacheId, IgniteUuid futId, IgniteUuid miniId, boolean addDepInfo) {
        assert (futId != null);
        assert (miniId != null);
        this.cacheId = cacheId;
        this.futId = futId;
        this.miniId = miniId;
        this.addDepInfo = addDepInfo;
    }

    public void error(IgniteCheckedException err) {
        this.err = err;
    }

    @Override
    public IgniteCheckedException error() {
        return this.err;
    }

    public Collection<KeyCacheObject> missedKeys() {
        return this.missedKeys == null ? Collections.emptyList() : this.missedKeys;
    }

    public Collection<GridCacheEntryInfo> forcedInfos() {
        return this.infos == null ? Collections.emptyList() : this.infos;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public void addMissed(KeyCacheObject key) {
        if (this.missedKeys == null) {
            this.missedKeys = new ArrayList<KeyCacheObject>();
        }
        this.missedKeys.add(key);
    }

    public void addInfo(GridCacheEntryInfo info) {
        assert (info != null);
        if (this.infos == null) {
            this.infos = new ArrayList<GridCacheEntryInfo>();
        }
        this.infos.add(info);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.missedKeys != null) {
            this.prepareMarshalCacheObjects(this.missedKeys, cctx);
        }
        if (this.infos != null) {
            for (GridCacheEntryInfo info : this.infos) {
                info.marshal(cctx);
            }
        }
        if (this.err != null && this.errBytes == null) {
            this.errBytes = U.marshal(ctx, (Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.missedKeys != null) {
            this.finishUnmarshalCacheObjects(this.missedKeys, cctx, ldr);
        }
        if (this.infos != null) {
            for (GridCacheEntryInfo info : this.infos) {
                info.unmarshal(cctx, ldr);
            }
        }
        if (this.errBytes != null && this.err == null) {
            this.err = (IgniteCheckedException)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("infos", this.infos, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeCollection("missedKeys", this.missedKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.infos = (List)reader.readCollection("infos", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.missedKeys = (List)reader.readCollection("missedKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtForceKeysResponse.class);
    }

    @Override
    public byte directType() {
        return 43;
    }

    @Override
    public byte fieldsCount() {
        return 8;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtForceKeysResponse.class, this, super.toString());
    }
}

