/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;

public class GridDhtPartitionDemandMessage
extends GridCacheMessage {
    private static final long serialVersionUID = 0L;
    private long updateSeq;
    @GridDirectCollection(value=int.class)
    private Collection<Integer> parts;
    @GridDirectTransient
    private Object topic;
    private byte[] topicBytes;
    private long timeout;
    private int workerId = -1;
    private AffinityTopologyVersion topVer;

    GridDhtPartitionDemandMessage(long updateSeq, @NotNull AffinityTopologyVersion topVer, int cacheId) {
        this.cacheId = cacheId;
        this.updateSeq = updateSeq;
        this.topVer = topVer;
    }

    GridDhtPartitionDemandMessage(GridDhtPartitionDemandMessage cp, Collection<Integer> parts) {
        this.cacheId = cp.cacheId;
        this.updateSeq = cp.updateSeq;
        this.topic = cp.topic;
        this.timeout = cp.timeout;
        this.workerId = cp.workerId;
        this.topVer = cp.topVer;
        this.parts = new HashSet<Integer>(parts);
    }

    public GridDhtPartitionDemandMessage() {
    }

    void addPartition(int p) {
        if (this.parts == null) {
            this.parts = new HashSet<Integer>();
        }
        this.parts.add(p);
    }

    Collection<Integer> partitions() {
        return this.parts;
    }

    void updateSequence(long updateSeq) {
        this.updateSeq = updateSeq;
    }

    long updateSequence() {
        return this.updateSeq;
    }

    long timeout() {
        return this.timeout;
    }

    void timeout(long timeout) {
        this.timeout = timeout;
    }

    Object topic() {
        return this.topic;
    }

    void topic(Object topic) {
        this.topic = topic;
    }

    int workerId() {
        return this.workerId;
    }

    void workerId(int workerId) {
        this.workerId = workerId;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.topic != null && this.topicBytes == null) {
            this.topicBytes = U.marshal(ctx, this.topic);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.topicBytes != null && this.topic == null) {
            this.topic = U.unmarshal(ctx, this.topicBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeCollection("parts", this.parts, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeByteArray("topicBytes", this.topicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeLong("updateSeq", this.updateSeq)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("workerId", this.workerId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.parts = reader.readCollection("parts", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.topicBytes = reader.readByteArray("topicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.updateSeq = reader.readLong("updateSeq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.workerId = reader.readInt("workerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionDemandMessage.class);
    }

    @Override
    public byte directType() {
        return 44;
    }

    @Override
    public byte fieldsCount() {
        return 9;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionDemandMessage.class, this, "partCnt", this.parts != null ? this.parts.size() : 0, "super", super.toString());
    }
}

