/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;

public class GridDhtPartitionMap2
implements Comparable<GridDhtPartitionMap2>,
Externalizable {
    private static final long serialVersionUID = 0L;
    public static final IgniteProductVersion SINCE = IgniteProductVersion.fromString("1.5.0");
    protected UUID nodeId;
    protected long updateSeq;
    protected AffinityTopologyVersion top;
    protected Map<Integer, GridDhtPartitionState> map;
    private volatile int moving;

    public GridDhtPartitionMap2() {
    }

    public GridDhtPartitionMap2(UUID nodeId, long updateSeq, AffinityTopologyVersion top, Map<Integer, GridDhtPartitionState> m, boolean onlyActive) {
        assert (nodeId != null);
        assert (updateSeq > 0L);
        this.nodeId = nodeId;
        this.updateSeq = updateSeq;
        this.top = top;
        this.map = U.newHashMap(m.size());
        for (Map.Entry<Integer, GridDhtPartitionState> e : m.entrySet()) {
            GridDhtPartitionState state = e.getValue();
            if (onlyActive && !state.active()) continue;
            this.put(e.getKey(), state);
        }
    }

    private GridDhtPartitionMap2(UUID nodeId, long updateSeq, AffinityTopologyVersion top, Map<Integer, GridDhtPartitionState> map, int moving) {
        this.nodeId = nodeId;
        this.updateSeq = updateSeq;
        this.top = top;
        this.map = map;
        this.moving = moving;
    }

    public GridDhtPartitionMap2 emptyCopy() {
        return new GridDhtPartitionMap2(this.nodeId, this.updateSeq, this.top, U.newHashMap(0), 0);
    }

    public void put(Integer part, GridDhtPartitionState state) {
        GridDhtPartitionState old = this.map.put(part, state);
        if (old == GridDhtPartitionState.MOVING) {
            --this.moving;
        }
        if (state == GridDhtPartitionState.MOVING) {
            ++this.moving;
        }
    }

    public boolean hasMovingPartitions() {
        assert (this.moving >= 0) : this.moving;
        return this.moving != 0;
    }

    public GridDhtPartitionState get(Integer part) {
        return this.map.get(part);
    }

    public boolean containsKey(Integer part) {
        return this.map.containsKey(part);
    }

    public Set<Map.Entry<Integer, GridDhtPartitionState>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public Set<Integer> keySet() {
        return this.map.keySet();
    }

    public Map<Integer, GridDhtPartitionState> map() {
        return this.map;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public long updateSequence() {
        return this.updateSeq;
    }

    public long updateSequence(long updateSeq, AffinityTopologyVersion topVer) {
        long old = this.updateSeq;
        assert (updateSeq >= old) : "Invalid update sequence [cur=" + old + ", new=" + updateSeq + ']';
        this.updateSeq = updateSeq;
        this.top = topVer;
        return old;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.top;
    }

    @Override
    public int compareTo(GridDhtPartitionMap2 o) {
        assert (this.nodeId.equals(o.nodeId));
        return Long.compare(this.updateSeq, o.updateSeq);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nodeId);
        out.writeLong(this.updateSeq);
        int size = this.map.size();
        out.writeInt(size);
        int i = 0;
        for (Map.Entry<Integer, GridDhtPartitionState> entry : this.map.entrySet()) {
            int ordinal = entry.getValue().ordinal();
            assert (ordinal == (ordinal & 3));
            assert (entry.getKey() < 16384) : entry.getKey();
            int coded = ordinal << 14 | entry.getKey();
            out.writeShort((short)coded);
            ++i;
        }
        assert (i == size);
        if (this.top != null) {
            out.writeLong(this.topologyVersion().topologyVersion());
            out.writeInt(this.topologyVersion().minorTopologyVersion());
        } else {
            out.writeLong(0L);
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid(in);
        this.updateSeq = in.readLong();
        int size = in.readInt();
        this.map = U.newHashMap(size);
        for (int i = 0; i < size; ++i) {
            int entry = in.readShort() & 0xFFFF;
            int part = entry & 0x3FFF;
            int ordinal = entry >> 14;
            this.put(part, GridDhtPartitionState.fromOrdinal(ordinal));
        }
        long ver = in.readLong();
        int minorVer = in.readInt();
        if (ver != 0L) {
            this.top = new AffinityTopologyVersion(ver, minorVer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        GridDhtPartitionMap2 other = (GridDhtPartitionMap2)o;
        return other.nodeId.equals(this.nodeId) && other.updateSeq == this.updateSeq;
    }

    public int hashCode() {
        return 31 * this.nodeId.hashCode() + (int)(this.updateSeq ^ this.updateSeq >>> 32);
    }

    public String toFullString() {
        return S.toString(GridDhtPartitionMap2.class, this, "size", (Object)this.size(), "map", (Object)this.map.toString(), "top", this.top);
    }

    public String toString() {
        return S.toString(GridDhtPartitionMap2.class, this, "size", this.size());
    }
}

