/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtPartitionSupplyMessage
extends GridCacheMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    private int workerId = -1;
    private long updateSeq;
    private boolean ack;
    @GridDirectCollection(value=int.class)
    private Collection<Integer> last;
    @GridToStringInclude
    @GridDirectCollection(value=int.class)
    private Collection<Integer> missed;
    @GridDirectMap(keyType=int.class, valueType=CacheEntryInfoCollection.class)
    private Map<Integer, CacheEntryInfoCollection> infos = new HashMap<Integer, CacheEntryInfoCollection>();
    @GridDirectTransient
    private int msgSize;

    GridDhtPartitionSupplyMessage(int workerId, long updateSeq, int cacheId, boolean addDepInfo) {
        assert (workerId >= 0);
        assert (updateSeq > 0L);
        this.cacheId = cacheId;
        this.updateSeq = updateSeq;
        this.workerId = workerId;
        this.addDepInfo = addDepInfo;
    }

    public GridDhtPartitionSupplyMessage() {
    }

    @Override
    public boolean ignoreClassErrors() {
        return true;
    }

    int workerId() {
        return this.workerId;
    }

    long updateSequence() {
        return this.updateSeq;
    }

    void markAck() {
        this.ack = true;
    }

    boolean ack() {
        return this.ack;
    }

    Collection<Integer> last() {
        return this.last == null ? Collections.emptySet() : this.last;
    }

    void last(int p) {
        if (this.last == null) {
            this.last = new HashSet<Integer>();
        }
        if (this.last.add(p)) {
            this.msgSize += 4;
            if (!this.infos.containsKey(p)) {
                CacheEntryInfoCollection infoCol = new CacheEntryInfoCollection();
                infoCol.init();
                this.infos.put(p, infoCol);
            }
        }
    }

    void missed(int p) {
        if (this.missed == null) {
            this.missed = new HashSet<Integer>();
        }
        if (this.missed.add(p)) {
            this.msgSize += 4;
        }
    }

    Collection<Integer> missed() {
        return this.missed == null ? Collections.emptySet() : this.missed;
    }

    Map<Integer, CacheEntryInfoCollection> infos() {
        return this.infos;
    }

    int messageSize() {
        return this.msgSize;
    }

    void addEntry(int p, GridCacheEntryInfo info, GridCacheContext ctx) throws IgniteCheckedException {
        assert (info != null);
        this.marshalInfo(info, ctx);
        this.msgSize += info.marshalledSize(ctx);
        CacheEntryInfoCollection infoCol = this.infos.get(p);
        if (infoCol == null) {
            this.msgSize += 4;
            infoCol = new CacheEntryInfoCollection();
            this.infos.put(p, infoCol);
            infoCol.init();
        }
        infoCol.add(info);
    }

    void addEntry0(int p, GridCacheEntryInfo info, GridCacheContext ctx) throws IgniteCheckedException {
        assert (info != null);
        assert (info.key() != null || info.keyBytes() != null);
        assert (info.value() != null);
        this.marshalInfo(info, ctx);
        this.msgSize += info.marshalledSize(ctx);
        CacheEntryInfoCollection infoCol = this.infos.get(p);
        if (infoCol == null) {
            this.msgSize += 4;
            infoCol = new CacheEntryInfoCollection();
            this.infos.put(p, infoCol);
            infoCol.init();
        }
        infoCol.add(info);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cacheCtx = ctx.cacheContext(this.cacheId);
        for (CacheEntryInfoCollection col : this.infos().values()) {
            List<GridCacheEntryInfo> entries = col.infos();
            for (int i = 0; i < entries.size(); ++i) {
                entries.get(i).unmarshal(cacheCtx, ldr);
            }
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    public int size() {
        return this.infos.size();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeBoolean("ack", this.ack)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMap("infos", this.infos, MessageCollectionItemType.INT, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("last", this.last, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeCollection("missed", this.missed, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeLong("updateSeq", this.updateSeq)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("workerId", this.workerId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.ack = reader.readBoolean("ack");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.infos = reader.readMap("infos", MessageCollectionItemType.INT, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.last = reader.readCollection("last", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.missed = reader.readCollection("missed", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.updateSeq = reader.readLong("updateSeq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.workerId = reader.readInt("workerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionSupplyMessage.class);
    }

    @Override
    public byte directType() {
        return 45;
    }

    @Override
    public byte fieldsCount() {
        return 9;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionSupplyMessage.class, this, "size", this.size(), "super", super.toString());
    }
}

