/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryTopologySnapshot;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridClientPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap2;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleRequest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridDhtPartitionsExchangeFuture
extends GridFutureAdapter<AffinityTopologyVersion>
implements Comparable<GridDhtPartitionsExchangeFuture>,
GridDhtTopologyFuture {
    public static final int DUMP_PENDING_OBJECTS_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_DUMP_PENDING_OBJECTS_THRESHOLD", 10);
    private static final long serialVersionUID = 0L;
    private final boolean dummy;
    private final boolean forcePreload;
    private final boolean reassign;
    private volatile DiscoveryEvent discoEvt;
    @GridToStringExclude
    private final Set<UUID> remaining = new HashSet<UUID>();
    @GridToStringExclude
    private int pendingSingleUpdates;
    @GridToStringExclude
    private List<ClusterNode> srvNodes;
    private ClusterNode crd;
    private final GridDhtPartitionExchangeId exchId;
    private final GridCacheSharedContext<?, ?> cctx;
    private ReadWriteLock busyLock;
    private AtomicBoolean added = new AtomicBoolean(false);
    @GridToStringExclude
    private CountDownLatch evtLatch = new CountDownLatch(1);
    private GridFutureAdapter<Boolean> initFut;
    @GridToStringExclude
    private final List<IgniteRunnable> discoEvts = new ArrayList<IgniteRunnable>();
    private boolean init;
    private AtomicReference<GridDiscoveryTopologySnapshot> topSnapshot = new AtomicReference();
    private AtomicReference<GridCacheVersion> lastVer = new AtomicReference();
    private final Map<ClusterNode, GridDhtPartitionsSingleMessage> singleMsgs = new ConcurrentHashMap8<ClusterNode, GridDhtPartitionsSingleMessage>();
    private final Map<ClusterNode, GridDhtPartitionsFullMessage> fullMsgs = new ConcurrentHashMap8<ClusterNode, GridDhtPartitionsFullMessage>();
    @GridToStringInclude
    private volatile IgniteInternalFuture<?> partReleaseFut;
    private final Object mux = new Object();
    private IgniteLogger log;
    private Collection<DynamicCacheChangeRequest> reqs;
    private CacheAffinityChangeMessage affChangeMsg;
    private volatile Map<Integer, Boolean> cacheValidRes;
    private boolean skipPreload;
    private boolean clientOnlyExchange;
    private long initTs;
    private boolean centralizedAff;
    private GridFutureAdapter<Boolean> forcedRebFut;

    public GridDhtPartitionsExchangeFuture(GridCacheSharedContext cctx, boolean reassign, DiscoveryEvent discoEvt, GridDhtPartitionExchangeId exchId) {
        this.dummy = true;
        this.forcePreload = false;
        this.exchId = exchId;
        this.reassign = reassign;
        this.discoEvt = discoEvt;
        this.cctx = cctx;
        this.onDone(exchId.topologyVersion());
    }

    public GridDhtPartitionsExchangeFuture(GridCacheSharedContext cctx, DiscoveryEvent discoEvt, GridDhtPartitionExchangeId exchId, GridFutureAdapter<Boolean> forcedRebFut) {
        this.dummy = false;
        this.forcePreload = true;
        this.exchId = exchId;
        this.discoEvt = discoEvt;
        this.cctx = cctx;
        this.forcedRebFut = forcedRebFut;
        this.reassign = true;
        this.onDone(exchId.topologyVersion());
    }

    public GridDhtPartitionsExchangeFuture(GridCacheSharedContext cctx, ReadWriteLock busyLock, GridDhtPartitionExchangeId exchId, Collection<DynamicCacheChangeRequest> reqs, CacheAffinityChangeMessage affChangeMsg) {
        assert (busyLock != null);
        assert (exchId != null);
        this.dummy = false;
        this.forcePreload = false;
        this.reassign = false;
        this.cctx = cctx;
        this.busyLock = busyLock;
        this.exchId = exchId;
        this.reqs = reqs;
        this.affChangeMsg = affChangeMsg;
        this.log = cctx.logger(this.getClass());
        this.initFut = new GridFutureAdapter();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating exchange future [localNode=" + cctx.localNodeId() + ", fut=" + this + ']');
        }
    }

    public void cacheChangeRequests(Collection<DynamicCacheChangeRequest> reqs) {
        this.reqs = reqs;
    }

    public void affinityChangeMessage(CacheAffinityChangeMessage affChangeMsg) {
        this.affChangeMsg = affChangeMsg;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.exchId.topologyVersion();
    }

    public boolean skipPreload() {
        return this.skipPreload;
    }

    public boolean dummy() {
        return this.dummy;
    }

    public boolean forcePreload() {
        return this.forcePreload;
    }

    public boolean reassign() {
        return this.reassign;
    }

    public boolean dummyReassign() {
        return (this.dummy() || this.forcePreload()) && this.reassign();
    }

    public boolean isCacheAdded(int cacheId, AffinityTopologyVersion topVer) {
        if (this.cacheStarted(cacheId)) {
            return true;
        }
        GridCacheContext<?, ?> cacheCtx = this.cctx.cacheContext(cacheId);
        return cacheCtx != null && F.eq(cacheCtx.startTopologyVersion(), topVer);
    }

    public boolean cacheStarted(int cacheId) {
        if (!F.isEmpty(this.reqs)) {
            for (DynamicCacheChangeRequest req : this.reqs) {
                if (!req.start() || req.clientStartOnly() || CU.cacheId(req.cacheName()) != cacheId) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onAdded() {
        return this.added.compareAndSet(false, true);
    }

    public void onEvent(GridDhtPartitionExchangeId exchId, DiscoveryEvent discoEvt) {
        assert (exchId.equals(this.exchId));
        this.discoEvt = discoEvt;
        this.evtLatch.countDown();
    }

    public DiscoveryEvent discoveryEvent() {
        return this.discoEvt;
    }

    public GridDhtPartitionExchangeId exchangeId() {
        return this.exchId;
    }

    @Nullable
    public GridFutureAdapter<Boolean> forcedRebalanceFuture() {
        return this.forcedRebFut;
    }

    private boolean enterBusy() {
        if (this.busyLock.readLock().tryLock()) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to enter busy state (exchanger is stopping): " + this);
        }
        return false;
    }

    private void leaveBusy() {
        this.busyLock.readLock().unlock();
    }

    public void init() throws IgniteInterruptedCheckedException {
        block20: {
            if (this.isDone()) {
                return;
            }
            this.initTs = U.currentTimeMillis();
            U.await(this.evtLatch);
            assert (this.discoEvt != null) : this;
            assert (this.exchId.nodeId().equals(this.discoEvt.eventNode().id())) : this;
            assert (!this.dummy && !this.forcePreload) : this;
            try {
                ExchangeType exchange;
                this.srvNodes = new ArrayList<ClusterNode>(this.cctx.discovery().serverNodes(this.topologyVersion()));
                this.remaining.addAll(F.nodeIds(F.view(this.srvNodes, F.remoteNodes(this.cctx.localNodeId()))));
                this.crd = this.srvNodes.isEmpty() ? null : this.srvNodes.get(0);
                boolean crdNode = this.crd != null && this.crd.isLocal();
                this.skipPreload = this.cctx.kernalContext().clientNode();
                if (this.discoEvt.type() == 18) {
                    if (!F.isEmpty(this.reqs)) {
                        exchange = this.onCacheChangeRequest(crdNode);
                    } else {
                        assert (this.affChangeMsg != null) : this;
                        exchange = this.onAffinityChangeRequest(crdNode);
                    }
                } else {
                    if (this.discoEvt.type() == 10) {
                        Collection<DynamicCacheDescriptor> receivedCaches = this.cctx.cache().startReceivedCaches(this.topologyVersion());
                        if (!this.discoEvt.eventNode().isLocal()) {
                            this.cctx.affinity().initStartedCaches(crdNode, this, receivedCaches);
                        }
                    }
                    exchange = CU.clientNode(this.discoEvt.eventNode()) ? this.onClientNodeEvent(crdNode) : this.onServerNodeEvent(crdNode);
                }
                this.updateTopologies(crdNode);
                switch (exchange) {
                    case ALL: {
                        this.distributedExchange();
                        break;
                    }
                    case CLIENT: {
                        this.initTopologies();
                        this.clientOnlyExchange();
                        break;
                    }
                    case NONE: {
                        this.initTopologies();
                        this.onDone(this.topologyVersion());
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                this.onDone(e);
                throw e;
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to reinitialize local partitions (preloading will be stopped): " + this.exchId, e);
                this.onDone(e);
                if (!(e instanceof Error)) break block20;
                throw (Error)e;
            }
        }
    }

    private void initTopologies() throws IgniteCheckedException {
        if (this.crd != null) {
            for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                if (cacheCtx.isLocal()) continue;
                cacheCtx.topology().beforeExchange(this, !this.centralizedAff);
            }
        }
    }

    private void updateTopologies(boolean crd) throws IgniteCheckedException {
        for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
            if (cacheCtx.isLocal()) continue;
            GridClientPartitionTopology clientTop = this.cctx.exchange().clearClientTopology(cacheCtx.cacheId());
            long updSeq = clientTop == null ? -1L : clientTop.lastUpdateSequence();
            GridDhtPartitionTopology top = cacheCtx.topology();
            if (crd) {
                boolean updateTop;
                boolean bl = updateTop = !cacheCtx.isLocal() && this.exchId.topologyVersion().equals(cacheCtx.startTopologyVersion());
                if (updateTop && clientTop != null) {
                    cacheCtx.topology().update(this.exchId, clientTop.partitionMap(true), clientTop.updateCounters(false));
                }
            }
            top.updateTopologyVersion(this.exchId, this, updSeq, this.stopping(cacheCtx.cacheId()));
        }
        for (GridClientPartitionTopology top : this.cctx.exchange().clientTopologies()) {
            top.updateTopologyVersion(this.exchId, this, -1L, this.stopping(top.cacheId()));
        }
    }

    private ExchangeType onCacheChangeRequest(boolean crd) throws IgniteCheckedException {
        assert (!F.isEmpty(this.reqs)) : this;
        boolean clientOnly = this.cctx.affinity().onCacheChangeRequest(this, crd, this.reqs);
        if (clientOnly) {
            boolean clientCacheStarted = false;
            for (DynamicCacheChangeRequest req : this.reqs) {
                if (!req.start() || !req.clientStartOnly() || !req.initiatingNodeId().equals(this.cctx.localNodeId())) continue;
                clientCacheStarted = true;
                break;
            }
            if (clientCacheStarted) {
                return ExchangeType.CLIENT;
            }
            return ExchangeType.NONE;
        }
        return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
    }

    private ExchangeType onAffinityChangeRequest(boolean crd) throws IgniteCheckedException {
        assert (this.affChangeMsg != null) : this;
        this.cctx.affinity().onChangeAffinityMessage(this, crd, this.affChangeMsg);
        if (this.cctx.kernalContext().clientNode()) {
            return ExchangeType.CLIENT;
        }
        return ExchangeType.ALL;
    }

    private ExchangeType onClientNodeEvent(boolean crd) throws IgniteCheckedException {
        assert (CU.clientNode(this.discoEvt.eventNode())) : this;
        if (this.discoEvt.type() == 11 || this.discoEvt.type() == 12) {
            this.onLeft();
            assert (!this.discoEvt.eventNode().isLocal()) : this.discoEvt;
        } else assert (this.discoEvt.type() == 10) : this.discoEvt;
        this.cctx.affinity().onClientEvent(this, crd);
        if (this.discoEvt.eventNode().isLocal()) {
            return ExchangeType.CLIENT;
        }
        return ExchangeType.NONE;
    }

    private ExchangeType onServerNodeEvent(boolean crd) throws IgniteCheckedException {
        assert (!CU.clientNode(this.discoEvt.eventNode())) : this;
        if (this.discoEvt.type() == 11 || this.discoEvt.type() == 12) {
            this.onLeft();
            this.warnNoAffinityNodes();
            this.centralizedAff = this.cctx.affinity().onServerLeft(this);
        } else {
            assert (this.discoEvt.type() == 10) : this.discoEvt;
            this.cctx.affinity().onServerJoin(this, crd);
        }
        if (this.cctx.kernalContext().clientNode()) {
            return ExchangeType.CLIENT;
        }
        return ExchangeType.ALL;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clientOnlyExchange() throws IgniteCheckedException {
        block9: {
            Iterator<GridCacheContext> i$;
            block8: {
                this.clientOnlyExchange = true;
                if (this.crd != null) {
                    if (this.crd.isLocal()) {
                        i$ = this.cctx.cacheContexts().iterator();
                        break block8;
                    } else {
                        if (!this.centralizedAff) {
                            this.sendLocalPartitions(this.crd);
                        }
                        this.initDone();
                        return;
                    }
                }
                if (this.centralizedAff) {
                    for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                        GridAffinityAssignmentCache aff = cacheCtx.affinity().affinityCache();
                        aff.initialize(this.topologyVersion(), aff.idealAssignment());
                    }
                }
                break block9;
            }
            block1: while (i$.hasNext()) {
                GridCacheContext cacheCtx = i$.next();
                boolean updateTop = !cacheCtx.isLocal() && this.exchId.topologyVersion().equals(cacheCtx.startTopologyVersion());
                if (!updateTop) continue;
                for (GridClientPartitionTopology top : this.cctx.exchange().clientTopologies()) {
                    if (top.cacheId() != cacheCtx.cacheId()) continue;
                    cacheCtx.topology().update(this.exchId, top.partitionMap(true), top.updateCounters(false));
                    continue block1;
                }
            }
        }
        this.onDone(this.topologyVersion());
    }

    private void distributedExchange() throws IgniteCheckedException {
        assert (this.crd != null);
        assert (!this.cctx.kernalContext().clientNode());
        for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
            if (cacheCtx.isLocal()) continue;
            cacheCtx.preloader().onTopologyChanged(this);
        }
        this.waitPartitionRelease();
        boolean topChanged = this.discoEvt.type() != 18 || this.affChangeMsg != null;
        for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
            if (cacheCtx.isLocal() || this.stopping(cacheCtx.cacheId())) continue;
            if (topChanged) {
                cacheCtx.continuousQueries().beforeExchange(this.exchId.topologyVersion());
                cacheCtx.store().forceFlush();
            }
            cacheCtx.topology().beforeExchange(this, !this.centralizedAff);
        }
        if (this.crd.isLocal()) {
            if (this.remaining.isEmpty()) {
                this.onAllReceived();
            }
        } else {
            this.sendPartitions(this.crd);
        }
        this.initDone();
    }

    private void waitPartitionRelease() throws IgniteCheckedException {
        IgniteInternalFuture<?> partReleaseFut = this.cctx.partitionReleaseFuture(this.topologyVersion());
        this.partReleaseFut = partReleaseFut;
        if (this.exchId.isLeft()) {
            this.cctx.mvcc().removeExplicitNodeLocks(this.exchId.nodeId(), this.exchId.topologyVersion());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Before waiting for partition release future: " + this);
        }
        int dumpedObjects = 0;
        while (true) {
            try {
                partReleaseFut.get(2L * this.cctx.gridConfig().getNetworkTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                if (dumpedObjects >= DUMP_PENDING_OBJECTS_THRESHOLD) continue;
                this.dumpPendingObjects();
                ++dumpedObjects;
                continue;
            }
            break;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("After waiting for partition release future: " + this);
        }
        IgniteInternalFuture<?> locksFut = this.cctx.mvcc().finishLocks(this.exchId.topologyVersion());
        dumpedObjects = 0;
        while (true) {
            try {
                locksFut.get(2L * this.cctx.gridConfig().getNetworkTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                if (dumpedObjects >= DUMP_PENDING_OBJECTS_THRESHOLD) continue;
                U.warn(this.log, "Failed to wait for locks release future. Dumping pending objects that might be the cause [topVer=" + this.topologyVersion() + ", nodeId=" + this.cctx.localNodeId() + "]: ");
                U.warn(this.log, "Locked keys:");
                for (IgniteTxKey key : this.cctx.mvcc().lockedKeys()) {
                    U.warn(this.log, "Locked key: " + key);
                }
                for (IgniteTxKey key : this.cctx.mvcc().nearLockedKeys()) {
                    U.warn(this.log, "Locked near key: " + key);
                }
                Map<IgniteTxKey, Collection<GridCacheMvccCandidate>> locks = this.cctx.mvcc().unfinishedLocks(this.exchId.topologyVersion());
                for (Map.Entry<IgniteTxKey, Collection<GridCacheMvccCandidate>> e : locks.entrySet()) {
                    U.warn(this.log, "Awaited locked entry [key=" + e.getKey() + ", mvcc=" + e.getValue() + ']');
                }
                ++dumpedObjects;
                if (!IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) continue;
                U.dumpThreads(this.log);
                continue;
            }
            break;
        }
    }

    private void onLeft() {
        for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
            if (cacheCtx.isLocal()) continue;
            cacheCtx.preloader().unwindUndeploys();
        }
        this.cctx.mvcc().removeExplicitNodeLocks(this.exchId.nodeId(), this.exchId.topologyVersion());
    }

    private void warnNoAffinityNodes() {
        ArrayList<String> cachesWithoutNodes = null;
        for (String name : this.cctx.cache().cacheNames()) {
            if (!this.cctx.discovery().cacheAffinityNodes(name, this.topologyVersion()).isEmpty()) continue;
            if (cachesWithoutNodes == null) {
                cachesWithoutNodes = new ArrayList<String>();
            }
            cachesWithoutNodes.add(name);
            if (!this.cctx.gridEvents().isRecordable(100)) continue;
            CacheEvent evt = new CacheEvent(name, this.cctx.localNode(), this.cctx.localNode(), "All server nodes have left the cluster.", 100, 0, false, null, null, null, null, false, null, false, null, null, null);
            this.cctx.gridEvents().record(evt);
        }
        if (cachesWithoutNodes != null) {
            StringBuilder sb = new StringBuilder("All server nodes for the following caches have left the cluster: ");
            for (int i = 0; i < cachesWithoutNodes.size(); ++i) {
                String cache = (String)cachesWithoutNodes.get(i);
                sb.append('\'').append(cache).append('\'');
                if (i == cachesWithoutNodes.size() - 1) continue;
                sb.append(", ");
            }
            U.quietAndWarn(this.log, sb.toString());
            U.quietAndWarn(this.log, "Must have server nodes for caches to operate.");
        }
    }

    private void dumpPendingObjects() {
        U.warn(this.log, "Failed to wait for partition release future [topVer=" + this.topologyVersion() + ", node=" + this.cctx.localNodeId() + "]. Dumping pending objects that might be the cause: ");
        try {
            this.cctx.exchange().dumpDebugInfo(this.topologyVersion());
        }
        catch (Exception e) {
            U.error(this.log, "Failed to dump debug information: " + e, e);
        }
        if (IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) {
            U.dumpThreads(this.log);
        }
    }

    public boolean stopping(int cacheId) {
        boolean stopping = false;
        if (!F.isEmpty(this.reqs)) {
            for (DynamicCacheChangeRequest req : this.reqs) {
                if (cacheId != CU.cacheId(req.cacheName())) continue;
                stopping = req.stop();
                break;
            }
        }
        return stopping;
    }

    private void sendLocalPartitions(ClusterNode node) throws IgniteCheckedException {
        block3: {
            GridDhtPartitionsSingleMessage m = this.cctx.exchange().createPartitionsSingleMessage(node, this.exchangeId(), this.clientOnlyExchange, true);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending local partitions [nodeId=" + node.id() + ", exchId=" + this.exchId + ", msg=" + m + ']');
            }
            try {
                this.cctx.io().send(node, (GridCacheMessage)m, (byte)2);
            }
            catch (ClusterTopologyCheckedException ignored) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("Node left during partition exchange [nodeId=" + node.id() + ", exchId=" + this.exchId + ']');
            }
        }
    }

    private GridDhtPartitionsFullMessage createPartitionsMessage(Collection<ClusterNode> nodes, boolean compress) {
        GridCacheVersion last = this.lastVer.get();
        return this.cctx.exchange().createPartitionsFullMessage(nodes, this.exchangeId(), last != null ? last : this.cctx.versions().last(), compress);
    }

    private void sendAllPartitions(Collection<ClusterNode> nodes) throws IgniteCheckedException {
        GridDhtPartitionsFullMessage m = this.createPartitionsMessage(nodes, true);
        assert (!nodes.contains(this.cctx.localNode()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending full partition map [nodeIds=" + F.viewReadOnly(nodes, F.node2id(), new IgnitePredicate[0]) + ", exchId=" + this.exchId + ", msg=" + m + ']');
        }
        this.cctx.io().safeSend(nodes, m, (byte)2, null);
    }

    private void sendPartitions(ClusterNode oldestNode) {
        try {
            this.sendLocalPartitions(oldestNode);
        }
        catch (ClusterTopologyCheckedException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Oldest node left during partition exchange [nodeId=" + oldestNode.id() + ", exchId=" + this.exchId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send local partitions to oldest node (will retry after timeout) [oldestNodeId=" + oldestNode.id() + ", exchId=" + this.exchId + ']', e);
        }
    }

    @Override
    public boolean onDone(@Nullable AffinityTopologyVersion res, @Nullable Throwable err) {
        boolean realExchange;
        boolean bl = realExchange = !this.dummy && !this.forcePreload;
        if (err == null && realExchange) {
            for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                GridCacheContext drCacheCtx;
                if (cacheCtx.isLocal()) continue;
                try {
                    if (this.centralizedAff) {
                        cacheCtx.topology().initPartitions(this);
                    }
                }
                catch (IgniteInterruptedCheckedException e) {
                    U.error(this.log, "Failed to initialize partitions.", e);
                }
                if (!(drCacheCtx = cacheCtx.isNear() ? cacheCtx.near().dht().context() : cacheCtx).isDrEnabled()) continue;
                try {
                    drCacheCtx.dr().onExchange(this.topologyVersion(), this.exchId.isLeft());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to notify DR: " + e, e);
                }
            }
            Map<Integer, Boolean> m = null;
            for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                if (cacheCtx.config().getTopologyValidator() == null || CU.isSystemCache(cacheCtx.name())) continue;
                if (m == null) {
                    m = new HashMap();
                }
                m.put(cacheCtx.cacheId(), cacheCtx.config().getTopologyValidator().validate(this.discoEvt.topologyNodes()));
            }
            this.cacheValidRes = m != null ? m : Collections.emptyMap();
        }
        this.cctx.exchange().onExchangeDone(this, err);
        this.cctx.cache().onExchangeDone(this.exchId.topologyVersion(), this.reqs, err);
        if (super.onDone(res, err) && realExchange) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completed partition exchange [localNode=" + this.cctx.localNodeId() + ", exchange= " + this + "duration=" + this.duration() + ", durationFromInit=" + (U.currentTimeMillis() - this.initTs) + ']');
            }
            this.initFut.onDone(err == null);
            if (this.exchId.isLeft()) {
                for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                    cacheCtx.config().getAffinity().removeNode(this.exchId.nodeId());
                }
            }
            this.reqs = null;
            if (this.discoEvt instanceof DiscoveryCustomEvent) {
                ((DiscoveryCustomEvent)this.discoEvt).customMessage(null);
            }
            return true;
        }
        return this.dummy;
    }

    @Override
    public Throwable validateCache(GridCacheContext cctx) {
        Boolean res;
        Throwable err = this.error();
        if (err != null) {
            return err;
        }
        if (cctx.config().getTopologyValidator() != null && (res = this.cacheValidRes.get(cctx.cacheId())) != null && !res.booleanValue()) {
            return new IgniteCheckedException("Failed to perform cache operation (cache topology is not valid): " + cctx.name());
        }
        return null;
    }

    public void cleanUp() {
        this.topSnapshot.set(null);
        this.singleMsgs.clear();
        this.fullMsgs.clear();
        this.crd = null;
        this.partReleaseFut = null;
    }

    private void updateLastVersion(GridCacheVersion ver) {
        GridCacheVersion old;
        assert (ver != null);
        while (!((old = this.lastVer.get()) != null && Long.compare(old.order(), ver.order()) >= 0 || this.lastVer.compareAndSet(old, ver))) {
        }
    }

    public void onReceive(final ClusterNode node, final GridDhtPartitionsSingleMessage msg) {
        assert (msg != null);
        assert (msg.exchangeId().equals(this.exchId)) : msg;
        assert (msg.lastVersion() != null) : msg;
        if (!msg.client()) {
            this.updateLastVersion(msg.lastVersion());
        }
        if (this.isDone()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received message for finished future (will reply only to sender) [msg=" + msg + ", fut=" + this + ']');
            }
            if (!this.centralizedAff) {
                this.sendAllPartitions(node.id(), this.cctx.gridConfig().getNetworkSendRetryCount());
            }
        } else {
            this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

                @Override
                public void apply(IgniteInternalFuture<Boolean> f) {
                    try {
                        if (!f.get().booleanValue()) {
                            return;
                        }
                    }
                    catch (IgniteCheckedException e) {
                        U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to initialize exchange future: " + this, e);
                        return;
                    }
                    GridDhtPartitionsExchangeFuture.this.processMessage(node, msg);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        boolean allReceived = false;
        boolean updateSingleMap = false;
        Object object = this.mux;
        synchronized (object) {
            assert (this.crd != null);
            if (this.crd.isLocal()) {
                if (this.remaining.remove(node.id())) {
                    updateSingleMap = true;
                    ++this.pendingSingleUpdates;
                    allReceived = this.remaining.isEmpty();
                }
            } else {
                this.singleMsgs.put(node, msg);
            }
        }
        if (updateSingleMap) {
            try {
                this.updatePartitionSingleMap(msg);
            }
            finally {
                object = this.mux;
                synchronized (object) {
                    assert (this.pendingSingleUpdates > 0);
                    --this.pendingSingleUpdates;
                    if (this.pendingSingleUpdates == 0) {
                        this.mux.notifyAll();
                    }
                }
            }
        }
        if (allReceived) {
            this.awaitSingleMapUpdates();
            this.onAllReceived();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitSingleMapUpdates() {
        Object object = this.mux;
        synchronized (object) {
            try {
                while (this.pendingSingleUpdates > 0) {
                    U.wait(this.mux);
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                U.warn(this.log, "Failed to wait for partition map updates, thread was interrupted: " + e);
            }
        }
    }

    private void onAffinityInitialized(IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> fut) {
        try {
            assert (fut.isDone());
            Map<Integer, Map<Integer, List<UUID>>> assignmentChange = fut.get();
            GridDhtPartitionsFullMessage m = this.createPartitionsMessage(null, false);
            CacheAffinityChangeMessage msg = new CacheAffinityChangeMessage(this.exchId, m, assignmentChange);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Centralized affinity exchange, send affinity change message: " + msg);
            }
            this.cctx.discovery().sendCustomEvent(msg);
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAllReceived() {
        block13: {
            try {
                ArrayList<ClusterNode> nodes;
                assert (this.crd.isLocal());
                if (!this.crd.equals(this.cctx.discovery().serverNodes(this.topologyVersion()).get(0))) {
                    for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                        if (cacheCtx.isLocal()) continue;
                        cacheCtx.topology().beforeExchange(this, !this.centralizedAff);
                    }
                }
                for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                    if (cacheCtx.isLocal()) continue;
                    cacheCtx.topology().checkEvictions();
                }
                this.updateLastVersion(this.cctx.versions().last());
                this.cctx.versions().onExchange(this.lastVer.get().order());
                if (this.centralizedAff) {
                    IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> fut = this.cctx.affinity().initAffinityOnNodeLeft(this);
                    if (!fut.isDone()) {
                        fut.listen(new IgniteInClosure<IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>>>(){

                            @Override
                            public void apply(IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> fut) {
                                GridDhtPartitionsExchangeFuture.this.onAffinityInitialized(fut);
                            }
                        });
                    } else {
                        this.onAffinityInitialized(fut);
                    }
                    break block13;
                }
                Object object = this.mux;
                synchronized (object) {
                    this.srvNodes.remove(this.cctx.localNode());
                    nodes = new ArrayList<ClusterNode>(this.srvNodes);
                }
                if (!nodes.isEmpty()) {
                    this.sendAllPartitions(nodes);
                }
                this.onDone(this.exchangeId().topologyVersion());
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
            }
        }
    }

    private void sendAllPartitions(final UUID nodeId, final int retryCnt) {
        ClusterNode n = this.cctx.node(nodeId);
        try {
            if (n != null) {
                this.sendAllPartitions(F.asList(n));
            }
        }
        catch (IgniteCheckedException e) {
            if (e instanceof ClusterTopologyCheckedException || !this.cctx.discovery().alive(n)) {
                this.log.debug("Failed to send full partition map to node, node left grid [rmtNode=" + nodeId + ", exchangeId=" + this.exchId + ']');
                return;
            }
            if (retryCnt > 0) {
                long timeout = this.cctx.gridConfig().getNetworkSendRetryDelay();
                LT.error(this.log, e, "Failed to send full partition map to node (will retry after timeout) [node=" + nodeId + ", exchangeId=" + this.exchId + ", timeout=" + timeout + ']');
                this.cctx.time().addTimeoutObject(new GridTimeoutObjectAdapter(timeout){

                    @Override
                    public void onTimeout() {
                        GridDhtPartitionsExchangeFuture.this.sendAllPartitions(nodeId, retryCnt - 1);
                    }
                });
            }
            U.error(this.log, "Failed to send full partition map [node=" + n + ", exchangeId=" + this.exchId + ']', e);
        }
    }

    public void onReceive(final ClusterNode node, final GridDhtPartitionsFullMessage msg) {
        assert (msg != null);
        UUID nodeId = node.id();
        if (this.isDone()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received message for finished future [msg=" + msg + ", fut=" + this + ']');
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received full partition map from node [nodeId=" + nodeId + ", msg=" + msg + ']');
        }
        this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

            @Override
            public void apply(IgniteInternalFuture<Boolean> f) {
                try {
                    if (!f.get().booleanValue()) {
                        return;
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to initialize exchange future: " + this, e);
                    return;
                }
                GridDhtPartitionsExchangeFuture.this.processMessage(node, msg);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(ClusterNode node, GridDhtPartitionsFullMessage msg) {
        assert (msg.exchangeId().equals(this.exchId)) : msg;
        assert (msg.lastVersion() != null) : msg;
        Object object = this.mux;
        synchronized (object) {
            if (this.crd == null) {
                return;
            }
            if (!this.crd.equals(node)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received full partition map from unexpected node [oldest=" + this.crd.id() + ", nodeId=" + node.id() + ']');
                }
                if (node.order() > this.crd.order()) {
                    this.fullMsgs.put(node, msg);
                }
                return;
            }
        }
        this.updatePartitionFullMap(msg);
        this.onDone(this.exchId.topologyVersion());
    }

    private void updatePartitionFullMap(GridDhtPartitionsFullMessage msg) {
        this.cctx.versions().onExchange(msg.lastVersion().order());
        for (Map.Entry<Integer, GridDhtPartitionFullMap> entry : msg.partitions().entrySet()) {
            Integer cacheId = entry.getKey();
            Map<Integer, Long> cntrMap = msg.partitionUpdateCounters(cacheId);
            GridCacheContext<?, ?> cacheCtx = this.cctx.cacheContext(cacheId);
            if (cacheCtx != null) {
                cacheCtx.topology().update(this.exchId, entry.getValue(), cntrMap);
                continue;
            }
            ClusterNode oldest = this.cctx.discovery().oldestAliveCacheServerNode(AffinityTopologyVersion.NONE);
            if (oldest == null || !oldest.isLocal()) continue;
            this.cctx.exchange().clientTopology(cacheId, this).update(this.exchId, entry.getValue(), cntrMap);
        }
    }

    private void updatePartitionSingleMap(GridDhtPartitionsSingleMessage msg) {
        for (Map.Entry<Integer, GridDhtPartitionMap2> entry : msg.partitions().entrySet()) {
            Integer cacheId = entry.getKey();
            GridCacheContext<?, ?> cacheCtx = this.cctx.cacheContext(cacheId);
            GridDhtPartitionTopology top = cacheCtx != null ? cacheCtx.topology() : this.cctx.exchange().clientTopology(cacheId, this);
            top.update(this.exchId, entry.getValue(), msg.partitionUpdateCounters(cacheId), false);
        }
    }

    public void onAffinityChangeMessage(final ClusterNode node, final CacheAffinityChangeMessage msg) {
        assert (this.exchId.equals(msg.exchangeId())) : msg;
        this.onDiscoveryEvent(new IgniteRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (GridDhtPartitionsExchangeFuture.this.isDone() || !GridDhtPartitionsExchangeFuture.this.enterBusy()) {
                    return;
                }
                try {
                    assert (GridDhtPartitionsExchangeFuture.this.centralizedAff);
                    if (GridDhtPartitionsExchangeFuture.this.crd.equals(node)) {
                        GridDhtPartitionsExchangeFuture.this.cctx.affinity().onExchangeChangeAffinityMessage(GridDhtPartitionsExchangeFuture.this, GridDhtPartitionsExchangeFuture.this.crd.isLocal(), msg);
                        if (!GridDhtPartitionsExchangeFuture.this.crd.isLocal()) {
                            GridDhtPartitionsFullMessage partsMsg = msg.partitionsMessage();
                            assert (partsMsg != null) : msg;
                            assert (partsMsg.lastVersion() != null) : partsMsg;
                            GridDhtPartitionsExchangeFuture.this.updatePartitionFullMap(partsMsg);
                        }
                        GridDhtPartitionsExchangeFuture.this.onDone(GridDhtPartitionsExchangeFuture.this.topologyVersion());
                    } else if (GridDhtPartitionsExchangeFuture.this.log.isDebugEnabled()) {
                        GridDhtPartitionsExchangeFuture.this.log.debug("Ignore affinity change message, coordinator changed [node=" + node.id() + ", crd=" + GridDhtPartitionsExchangeFuture.this.crd.id() + ", msg=" + msg + ']');
                    }
                }
                finally {
                    GridDhtPartitionsExchangeFuture.this.leaveBusy();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDiscoveryEvent(IgniteRunnable c) {
        List<IgniteRunnable> list = this.discoEvts;
        synchronized (list) {
            if (!this.init) {
                this.discoEvts.add(c);
                return;
            }
            assert (this.discoEvts.isEmpty()) : this.discoEvts;
        }
        c.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDone() {
        while (!this.isDone()) {
            ArrayList<IgniteRunnable> evts;
            List<IgniteRunnable> list = this.discoEvts;
            synchronized (list) {
                if (this.discoEvts.isEmpty()) {
                    this.init = true;
                    break;
                }
                evts = new ArrayList<IgniteRunnable>(this.discoEvts);
                this.discoEvts.clear();
            }
            for (IgniteRunnable c : evts) {
                c.run();
            }
        }
        this.initFut.onDone(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeLeft(final ClusterNode node) {
        if (this.isDone() || !this.enterBusy()) {
            return;
        }
        this.cctx.mvcc().removeExplicitNodeLocks(node.id(), this.topologyVersion());
        try {
            this.onDiscoveryEvent(new IgniteRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (GridDhtPartitionsExchangeFuture.this.isDone() || !GridDhtPartitionsExchangeFuture.this.enterBusy()) {
                        return;
                    }
                    try {
                        ClusterNode crd0;
                        boolean crdChanged = false;
                        boolean allReceived = false;
                        HashSet reqFrom = null;
                        Object object = GridDhtPartitionsExchangeFuture.this.mux;
                        synchronized (object) {
                            block30: {
                                if (GridDhtPartitionsExchangeFuture.this.srvNodes.remove(node)) break block30;
                                return;
                            }
                            boolean rmvd = GridDhtPartitionsExchangeFuture.this.remaining.remove(node.id());
                            if (node.equals(GridDhtPartitionsExchangeFuture.this.crd)) {
                                crdChanged = true;
                                GridDhtPartitionsExchangeFuture.this.crd = GridDhtPartitionsExchangeFuture.this.srvNodes.size() > 0 ? (ClusterNode)GridDhtPartitionsExchangeFuture.this.srvNodes.get(0) : null;
                            }
                            if (GridDhtPartitionsExchangeFuture.this.crd != null && GridDhtPartitionsExchangeFuture.this.crd.isLocal()) {
                                if (rmvd) {
                                    allReceived = GridDhtPartitionsExchangeFuture.this.remaining.isEmpty();
                                }
                                if (crdChanged && !GridDhtPartitionsExchangeFuture.this.remaining.isEmpty()) {
                                    reqFrom = new HashSet(GridDhtPartitionsExchangeFuture.this.remaining);
                                }
                            }
                            crd0 = GridDhtPartitionsExchangeFuture.this.crd;
                        }
                        if (crd0 == null) {
                            assert (GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().clientNode() || GridDhtPartitionsExchangeFuture.this.cctx.localNode().isDaemon()) : GridDhtPartitionsExchangeFuture.access$800(GridDhtPartitionsExchangeFuture.this).localNode();
                            List empty = Collections.emptyList();
                            for (GridCacheContext cacheCtx : GridDhtPartitionsExchangeFuture.this.cctx.cacheContexts()) {
                                ArrayList<List<ClusterNode>> affAssignment = new ArrayList<List<ClusterNode>>(cacheCtx.affinity().partitions());
                                for (int i = 0; i < cacheCtx.affinity().partitions(); ++i) {
                                    affAssignment.add(empty);
                                }
                                cacheCtx.affinity().affinityCache().initialize(GridDhtPartitionsExchangeFuture.this.topologyVersion(), affAssignment);
                            }
                            GridDhtPartitionsExchangeFuture.this.onDone(GridDhtPartitionsExchangeFuture.this.topologyVersion());
                            return;
                        }
                        if (crd0.isLocal()) {
                            if (allReceived) {
                                GridDhtPartitionsExchangeFuture.this.awaitSingleMapUpdates();
                                GridDhtPartitionsExchangeFuture.this.onAllReceived();
                                return;
                            }
                            if (crdChanged && reqFrom != null) {
                                GridDhtPartitionsSingleRequest req = new GridDhtPartitionsSingleRequest(GridDhtPartitionsExchangeFuture.this.exchId);
                                for (UUID nodeId : reqFrom) {
                                    try {
                                        GridDhtPartitionsExchangeFuture.this.cctx.io().send(nodeId, (GridCacheMessage)req, (byte)2);
                                    }
                                    catch (ClusterTopologyCheckedException ignored) {
                                        if (!GridDhtPartitionsExchangeFuture.this.log.isDebugEnabled()) continue;
                                        GridDhtPartitionsExchangeFuture.this.log.debug("Node left during partition exchange [nodeId=" + nodeId + ", exchId=" + GridDhtPartitionsExchangeFuture.this.exchId + ']');
                                    }
                                    catch (IgniteCheckedException e) {
                                        U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to request partitions from node: " + nodeId, e);
                                    }
                                }
                            }
                            for (Map.Entry m : GridDhtPartitionsExchangeFuture.this.singleMsgs.entrySet()) {
                                GridDhtPartitionsExchangeFuture.this.processMessage((ClusterNode)m.getKey(), (GridDhtPartitionsSingleMessage)m.getValue());
                            }
                        } else if (crdChanged) {
                            GridDhtPartitionsExchangeFuture.this.sendPartitions(crd0);
                            for (Map.Entry m : GridDhtPartitionsExchangeFuture.this.fullMsgs.entrySet()) {
                                GridDhtPartitionsExchangeFuture.this.processMessage((ClusterNode)m.getKey(), (GridDhtPartitionsFullMessage)m.getValue());
                            }
                        }
                    }
                    finally {
                        GridDhtPartitionsExchangeFuture.this.leaveBusy();
                    }
                }
            });
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public int compareTo(GridDhtPartitionsExchangeFuture fut) {
        return this.exchId.compareTo(fut.exchId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        GridDhtPartitionsExchangeFuture fut = (GridDhtPartitionsExchangeFuture)o;
        return this.exchId.equals(fut.exchId);
    }

    public int hashCode() {
        return this.exchId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ArrayList<ClusterNode> srvNodes;
        HashSet<UUID> remaining;
        Object object = this.mux;
        synchronized (object) {
            remaining = new HashSet<UUID>(this.remaining);
            srvNodes = this.srvNodes != null ? new ArrayList<ClusterNode>(this.srvNodes) : null;
        }
        return S.toString(GridDhtPartitionsExchangeFuture.class, this, "evtLatch", this.evtLatch == null ? "null" : Long.valueOf(this.evtLatch.getCount()), "remaining", remaining, "srvNodes", srvNodes, "super", super.toString());
    }

    static enum ExchangeType {
        CLIENT,
        ALL,
        NONE;

    }
}

