/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap2;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsAbstractMessage;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsFullMessage
extends GridDhtPartitionsAbstractMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, GridDhtPartitionFullMap> parts;
    @GridDirectMap(keyType=Integer.class, valueType=Integer.class)
    private Map<Integer, Integer> dupPartsData;
    private byte[] partsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, Map<Integer, Long>> partCntrs;
    private byte[] partCntrsBytes;
    private AffinityTopologyVersion topVer;
    @GridDirectTransient
    private transient boolean compress;

    public GridDhtPartitionsFullMessage() {
    }

    public GridDhtPartitionsFullMessage(@Nullable GridDhtPartitionExchangeId id, @Nullable GridCacheVersion lastVer, @NotNull AffinityTopologyVersion topVer) {
        super(id, lastVer);
        assert (id == null || topVer.equals(id.topologyVersion()));
        this.topVer = topVer;
    }

    public void compress(boolean compress) {
        this.compress = compress;
    }

    public Map<Integer, GridDhtPartitionFullMap> partitions() {
        return this.parts;
    }

    public boolean containsCache(int cacheId) {
        return this.parts != null && this.parts.containsKey(cacheId);
    }

    public void addFullPartitionsMap(int cacheId, GridDhtPartitionFullMap fullMap, @Nullable Integer dupDataCache) {
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionFullMap>();
        }
        if (!this.parts.containsKey(cacheId)) {
            this.parts.put(cacheId, fullMap);
            if (dupDataCache != null) {
                assert (this.compress);
                assert (this.parts.containsKey(dupDataCache));
                if (this.dupPartsData == null) {
                    this.dupPartsData = new HashMap<Integer, Integer>();
                }
                this.dupPartsData.put(cacheId, dupDataCache);
            }
        }
    }

    public void addPartitionUpdateCounters(int cacheId, Map<Integer, Long> cntrMap) {
        if (this.partCntrs == null) {
            this.partCntrs = new HashMap<Integer, Map<Integer, Long>>();
        }
        if (!this.partCntrs.containsKey(cacheId)) {
            this.partCntrs.put(cacheId, cntrMap);
        }
    }

    public Map<Integer, Long> partitionUpdateCounters(int cacheId) {
        if (this.partCntrs != null) {
            Map<Integer, Long> res = this.partCntrs.get(cacheId);
            return res != null ? res : Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        boolean marshal;
        super.prepareMarshal(ctx);
        boolean bl = marshal = this.parts != null && this.partsBytes == null || this.partCntrs != null && this.partCntrsBytes == null;
        if (marshal) {
            byte[] partsBytes0 = null;
            byte[] partCntrsBytes0 = null;
            if (this.parts != null && this.partsBytes == null) {
                partsBytes0 = U.marshal(ctx, this.parts);
            }
            if (this.partCntrs != null && this.partCntrsBytes == null) {
                partCntrsBytes0 = U.marshal(ctx, this.partCntrs);
            }
            if (this.compress) {
                assert (!this.compressed());
                try {
                    byte[] partsBytesZip = U.zip(partsBytes0);
                    byte[] partCntrsBytesZip = U.zip(partCntrsBytes0);
                    partsBytes0 = partsBytesZip;
                    partCntrsBytes0 = partCntrsBytesZip;
                    this.compressed(true);
                }
                catch (IgniteCheckedException e) {
                    U.error(ctx.logger(this.getClass()), "Failed to compress partitions data: " + e, e);
                }
            }
            this.partsBytes = partsBytes0;
            this.partCntrsBytes = partCntrsBytes0;
        }
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.partsBytes != null && this.parts == null) {
            this.parts = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
            if (this.dupPartsData != null) {
                assert (this.parts != null);
                for (Map.Entry<Integer, Integer> e : this.dupPartsData.entrySet()) {
                    GridDhtPartitionFullMap map1 = this.parts.get(e.getKey());
                    GridDhtPartitionFullMap map2 = this.parts.get(e.getValue());
                    assert (map1 != null) : e.getKey();
                    assert (map2 != null) : e.getValue();
                    assert (map1.size() == map2.size());
                    for (Map.Entry e0 : map2.entrySet()) {
                        GridDhtPartitionMap2 partMap1 = (GridDhtPartitionMap2)map1.get(e0.getKey());
                        assert (partMap1 != null && partMap1.map().isEmpty()) : partMap1;
                        assert (!partMap1.hasMovingPartitions()) : partMap1;
                        GridDhtPartitionMap2 partMap2 = (GridDhtPartitionMap2)e0.getValue();
                        assert (partMap2 != null);
                        for (Map.Entry<Integer, GridDhtPartitionState> stateEntry : partMap2.entrySet()) {
                            partMap1.put(stateEntry.getKey(), stateEntry.getValue());
                        }
                    }
                }
            }
        }
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionFullMap>();
        }
        if (this.partCntrsBytes != null && this.partCntrs == null) {
            this.partCntrs = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partCntrs == null) {
            this.partCntrs = new HashMap<Integer, Map<Integer, Long>>();
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 6: {
                if (!writer.writeMap("dupPartsData", this.dupPartsData, MessageCollectionItemType.INT, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeByteArray("partCntrsBytes", this.partCntrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByteArray("partsBytes", this.partsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 6: {
                this.dupPartsData = reader.readMap("dupPartsData", MessageCollectionItemType.INT, MessageCollectionItemType.INT, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.partCntrsBytes = reader.readByteArray("partCntrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.partsBytes = reader.readByteArray("partsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionsFullMessage.class);
    }

    @Override
    public byte directType() {
        return 46;
    }

    @Override
    public byte fieldsCount() {
        return 10;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionsFullMessage.class, this, "partCnt", this.parts != null ? this.parts.size() : 0, "super", super.toString());
    }
}

