/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap2;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsAbstractMessage;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsSingleMessage
extends GridDhtPartitionsAbstractMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, GridDhtPartitionMap2> parts;
    @GridDirectMap(keyType=Integer.class, valueType=Integer.class)
    private Map<Integer, Integer> dupPartsData;
    private byte[] partsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, Map<Integer, Long>> partCntrs;
    private byte[] partCntrsBytes;
    private boolean client;
    @GridDirectTransient
    private transient boolean compress;

    public GridDhtPartitionsSingleMessage() {
    }

    public GridDhtPartitionsSingleMessage(GridDhtPartitionExchangeId exchId, boolean client, @Nullable GridCacheVersion lastVer, boolean compress) {
        super(exchId, lastVer);
        this.client = client;
        this.compress = compress;
    }

    public boolean client() {
        return this.client;
    }

    public void addLocalPartitionMap(int cacheId, GridDhtPartitionMap2 locMap, @Nullable Integer dupDataCache) {
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionMap2>();
        }
        this.parts.put(cacheId, locMap);
        if (dupDataCache != null) {
            assert (this.compress);
            assert (F.isEmpty(locMap.map()));
            assert (this.parts.containsKey(dupDataCache));
            if (this.dupPartsData == null) {
                this.dupPartsData = new HashMap<Integer, Integer>();
            }
            this.dupPartsData.put(cacheId, dupDataCache);
        }
    }

    public void partitionUpdateCounters(int cacheId, Map<Integer, Long> cntrMap) {
        if (this.partCntrs == null) {
            this.partCntrs = new HashMap<Integer, Map<Integer, Long>>();
        }
        this.partCntrs.put(cacheId, cntrMap);
    }

    public Map<Integer, Long> partitionUpdateCounters(int cacheId) {
        if (this.partCntrs != null) {
            Map<Integer, Long> res = this.partCntrs.get(cacheId);
            return res != null ? res : Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    public Map<Integer, GridDhtPartitionMap2> partitions() {
        return this.parts;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        boolean marshal;
        super.prepareMarshal(ctx);
        boolean bl = marshal = this.parts != null && this.partsBytes == null || this.partCntrs != null && this.partCntrsBytes == null;
        if (marshal) {
            byte[] partsBytes0 = null;
            byte[] partCntrsBytes0 = null;
            if (this.parts != null && this.partsBytes == null) {
                partsBytes0 = U.marshal(ctx, this.parts);
            }
            if (this.partCntrs != null && this.partCntrsBytes == null) {
                partCntrsBytes0 = U.marshal(ctx, this.partCntrs);
            }
            if (this.compress) {
                assert (!this.compressed());
                try {
                    byte[] partsBytesZip = U.zip(partsBytes0);
                    byte[] partCntrsBytesZip = U.zip(partCntrsBytes0);
                    partsBytes0 = partsBytesZip;
                    partCntrsBytes0 = partCntrsBytesZip;
                    this.compressed(true);
                }
                catch (IgniteCheckedException e) {
                    U.error(ctx.logger(this.getClass()), "Failed to compress partitions data: " + e, e);
                }
            }
            this.partsBytes = partsBytes0;
            this.partCntrsBytes = partCntrsBytes0;
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.partsBytes != null && this.parts == null) {
            this.parts = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partCntrsBytes != null && this.partCntrs == null) {
            this.partCntrs = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.dupPartsData != null) {
            assert (this.parts != null);
            for (Map.Entry<Integer, Integer> e : this.dupPartsData.entrySet()) {
                GridDhtPartitionMap2 map1 = this.parts.get(e.getKey());
                assert (map1 != null) : e.getKey();
                assert (F.isEmpty(map1.map()));
                assert (!map1.hasMovingPartitions());
                GridDhtPartitionMap2 map2 = this.parts.get(e.getValue());
                assert (map2 != null) : e.getValue();
                assert (map2.map() != null);
                for (Map.Entry<Integer, GridDhtPartitionState> e0 : map2.map().entrySet()) {
                    map1.put(e0.getKey(), e0.getValue());
                }
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 6: {
                if (!writer.writeBoolean("client", this.client)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMap("dupPartsData", this.dupPartsData, MessageCollectionItemType.INT, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByteArray("partCntrsBytes", this.partCntrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeByteArray("partsBytes", this.partsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 6: {
                this.client = reader.readBoolean("client");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.dupPartsData = reader.readMap("dupPartsData", MessageCollectionItemType.INT, MessageCollectionItemType.INT, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.partCntrsBytes = reader.readByteArray("partCntrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.partsBytes = reader.readByteArray("partsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionsSingleMessage.class);
    }

    @Override
    public byte directType() {
        return 47;
    }

    @Override
    public byte fieldsCount() {
        return 10;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionsSingleMessage.class, this, super.toString());
    }
}

