/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateAtomicResult;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.util.GridCircularBuffer;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicCache<K, V>
extends GridNearCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private GridDhtCacheAdapter<K, V> dht;
    private GridCircularBuffer<T2<KeyCacheObject, GridCacheVersion>> rmvQueue;

    public GridNearAtomicCache() {
    }

    public GridNearAtomicCache(GridCacheContext<K, V> ctx) {
        super(ctx);
        int size = CU.isSystemCache(ctx.name()) ? 100 : Integer.getInteger("IGNITE_ATOMIC_CACHE_DELETE_HISTORY_SIZE", 1000000);
        this.rmvQueue = new GridCircularBuffer(U.ceilPow2(size / 10));
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.ctx.io().addHandler(this.ctx.cacheId(), GridNearGetResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearGetResponse>(){

            @Override
            public void apply(UUID nodeId, GridNearGetResponse res) {
                GridNearAtomicCache.this.processGetResponse(nodeId, res);
            }
        });
    }

    public void dht(GridDhtAtomicCache<K, V> dht) {
        this.dht = dht;
    }

    @Override
    public GridDhtCacheAdapter<K, V> dht() {
        return this.dht;
    }

    public void processNearAtomicUpdateResponse(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
        if (F.size(res.failedKeys(), new IgnitePredicate[0]) == req.size()) {
            return;
        }
        Collection<KeyCacheObject> failed = res.failedKeys();
        List<Integer> nearValsIdxs = res.nearValuesIndexes();
        List<Integer> skipped = res.skippedIndexes();
        GridCacheVersion ver = req.updateVersion();
        if (ver == null) {
            ver = res.nearVersion();
        }
        assert (ver != null) : "Failed to find version [req=" + req + ", res=" + res + ']';
        int nearValIdx = 0;
        String taskName = this.ctx.kernalContext().task().resolveTaskName(req.taskNameHash());
        for (int i = 0; i < req.size(); ++i) {
            KeyCacheObject key;
            if (F.contains(skipped, Integer.valueOf(i)) || F.contains(failed, key = req.key(i))) continue;
            if (this.ctx.affinity().partitionBelongs(this.ctx.localNode(), this.ctx.affinity().partition(key), req.topologyVersion())) {
                GridCacheEntryEx entry = this.peekEx(key);
                if (entry == null || !entry.markObsolete(ver)) continue;
                this.removeEntry(entry);
                continue;
            }
            CacheObject val = null;
            if (F.contains(nearValsIdxs, Integer.valueOf(i))) {
                val = res.nearValue(nearValIdx);
                ++nearValIdx;
            } else {
                assert (req.operation() != GridCacheOperation.TRANSFORM);
                if (req.operation() != GridCacheOperation.DELETE) {
                    val = req.value(i);
                }
            }
            long ttl = res.nearTtl(i);
            long expireTime = res.nearExpireTime(i);
            if (ttl != -1L && expireTime == -1L) {
                expireTime = CU.toExpireTime(ttl);
            }
            try {
                this.processNearAtomicUpdateResponse(ver, key, val, null, ttl, expireTime, req.keepBinary(), req.nodeId(), req.subjectId(), taskName);
                continue;
            }
            catch (IgniteCheckedException e) {
                res.addFailedKey(key, new IgniteCheckedException("Failed to update key in near cache: " + key, e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNearAtomicUpdateResponse(GridCacheVersion ver, KeyCacheObject key, @Nullable CacheObject val, @Nullable byte[] valBytes, long ttl, long expireTime, boolean keepBinary, UUID nodeId, UUID subjId, String taskName) throws IgniteCheckedException {
        try {
            while (true) {
                GridCacheMapEntry entry = null;
                AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
                try {
                    entry = this.entryEx(key, topVer);
                    GridCacheOperation op = val != null || valBytes != null ? GridCacheOperation.UPDATE : GridCacheOperation.DELETE;
                    GridCacheUpdateAtomicResult updRes = entry.innerUpdate(ver, nodeId, nodeId, op, val, null, false, false, false, keepBinary, null, true, true, false, true, topVer, CU.empty0(), GridDrType.DR_NONE, ttl, expireTime, null, false, false, subjId, taskName, null, null, null);
                    if (updRes.removeVersion() != null) {
                        this.ctx.onDeferredDelete(entry, updRes.removeVersion());
                    }
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Got removed entry while updating near cache value (will retry): " + key);
                    }
                    entry = null;
                    continue;
                }
                finally {
                    if (entry == null) continue;
                    this.ctx.evicts().touch(entry, topVer);
                    continue;
                }
                break;
            }
        }
        catch (GridDhtInvalidPartitionException gridDhtInvalidPartitionException) {
            // empty catch block
        }
    }

    public void processDhtAtomicUpdateRequest(UUID nodeId, GridDhtAtomicAbstractUpdateRequest req, GridDhtAtomicUpdateResponse res) {
        GridCacheVersion ver = req.writeVersion();
        assert (ver != null);
        boolean intercept = req.forceTransformBackups() && this.ctx.config().getInterceptor() != null;
        String taskName = this.ctx.kernalContext().task().resolveTaskName(req.taskNameHash());
        block4: for (int i = 0; i < req.nearSize(); ++i) {
            KeyCacheObject key = req.nearKey(i);
            try {
                while (true) {
                    try {
                        GridCacheEntryEx entry = this.peekEx(key);
                        if (entry == null) {
                            res.addNearEvicted(key);
                            continue block4;
                        }
                        if (req.hasKey(key)) {
                            if (!entry.markObsolete(ver)) continue block4;
                            this.removeEntry(entry);
                            continue block4;
                        }
                        CacheObject val = req.nearValue(i);
                        EntryProcessor<Object, Object, Object> entryProcessor = req.nearEntryProcessor(i);
                        GridCacheOperation op = entryProcessor != null ? GridCacheOperation.TRANSFORM : (val != null ? GridCacheOperation.UPDATE : GridCacheOperation.DELETE);
                        long ttl = req.nearTtl(i);
                        long expireTime = req.nearExpireTime(i);
                        GridCacheUpdateAtomicResult updRes = entry.innerUpdate(ver, nodeId, nodeId, op, op == GridCacheOperation.TRANSFORM ? entryProcessor : val, op == GridCacheOperation.TRANSFORM ? req.invokeArguments() : null, false, false, false, req.keepBinary(), null, true, true, false, !req.forceTransformBackups(), req.topologyVersion(), CU.empty0(), GridDrType.DR_NONE, ttl, expireTime, null, false, intercept, req.subjectId(), taskName, null, null, null);
                        if (updRes.removeVersion() == null) continue block4;
                        this.ctx.onDeferredDelete(entry, updRes.removeVersion());
                        continue block4;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Got removed entry while updating near value (will retry): " + key);
                        continue;
                    }
                    break;
                }
            }
            catch (IgniteCheckedException e) {
                res.addFailedKey(key, new IgniteCheckedException("Failed to update near cache key: " + key, e));
            }
        }
    }

    @Override
    protected IgniteInternalFuture<Map<K, V>> getAllAsync(@Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, String taskName, boolean deserializeBinary, boolean skipVals, boolean canRemap, boolean needVer) {
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture(Collections.emptyMap());
        }
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        subjId = this.ctx.subjectIdPerCall(subjId, opCtx);
        return this.loadAsync(null, this.ctx.cacheKeysView(keys), forcePrimary, subjId, taskName, deserializeBinary, skipVals ? null : (opCtx != null ? opCtx.expiry() : null), skipVals, opCtx != null && opCtx.skipStore(), canRemap, needVer);
    }

    @Override
    public V getAndPut(K key, V val, @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        return this.dht.getAndPut(key, val, filter);
    }

    @Override
    public boolean put(K key, V val, CacheEntryPredicate filter) throws IgniteCheckedException {
        return this.dht.put(key, val, filter);
    }

    @Override
    public IgniteInternalFuture<V> getAndPutAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.dht.getAndPutAsync0(key, val, filter);
    }

    @Override
    public IgniteInternalFuture<Boolean> putAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.dht.putAsync0(key, val, filter);
    }

    @Override
    @Nullable
    public V tryGetAndPut(K key, V val) throws IgniteCheckedException {
        return this.dht.tryGetAndPut(key, val);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        this.dht.putAll(m);
    }

    @Override
    public IgniteInternalFuture<?> putAllAsync(Map<? extends K, ? extends V> m) {
        return this.dht.putAllAsync(m);
    }

    @Override
    public void putAllConflict(Map<KeyCacheObject, GridCacheDrInfo> drMap) throws IgniteCheckedException {
        this.dht.putAllConflict(drMap);
    }

    @Override
    public IgniteInternalFuture<?> putAllConflictAsync(Map<KeyCacheObject, GridCacheDrInfo> drMap) throws IgniteCheckedException {
        return this.dht.putAllConflictAsync(drMap);
    }

    @Override
    public <T> EntryProcessorResult<T> invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.dht.invoke(key, entryProcessor, args);
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.dht.invokeAll(keys, entryProcessor, args);
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        return this.dht.invokeAllAsync(map, args);
    }

    @Override
    public <T> IgniteInternalFuture<EntryProcessorResult<T>> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws EntryProcessorException {
        return this.dht.invokeAsync(key, entryProcessor, args);
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws IgniteCheckedException {
        return this.dht.invokeAllAsync(map, args).get();
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.dht.invokeAllAsync(keys, entryProcessor, args);
    }

    @Override
    public boolean remove(K key, @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        return this.dht.remove(key, filter);
    }

    @Override
    public V getAndRemove(K key) throws IgniteCheckedException {
        return this.dht.getAndRemove(key);
    }

    @Override
    public IgniteInternalFuture<V> getAndRemoveAsync(K key) {
        return this.dht.getAndRemoveAsync(key);
    }

    @Override
    public void removeAll(Collection<? extends K> keys) throws IgniteCheckedException {
        this.dht.removeAll(keys);
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync(Collection<? extends K> keys) {
        return this.dht.removeAllAsync(keys);
    }

    @Override
    public boolean remove(K key) throws IgniteCheckedException {
        return this.dht.remove(key);
    }

    @Override
    public IgniteInternalFuture<Boolean> removeAsync(K key, @Nullable CacheEntryPredicate filter) {
        return this.dht.removeAsync(key, filter);
    }

    @Override
    public void removeAll() throws IgniteCheckedException {
        this.dht.removeAll();
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        return this.dht.removeAllAsync();
    }

    @Override
    public void removeAllConflict(Map<KeyCacheObject, GridCacheVersion> drMap) throws IgniteCheckedException {
        this.dht.removeAllConflict(drMap);
    }

    @Override
    public IgniteInternalFuture<?> removeAllConflictAsync(Map<KeyCacheObject, GridCacheVersion> drMap) throws IgniteCheckedException {
        return this.dht.removeAllConflictAsync(drMap);
    }

    @Override
    protected IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> keys, long timeout, @Nullable IgniteTxLocalEx tx, boolean isInvalidate, boolean isRead, boolean retval, @Nullable TransactionIsolation isolation, long createTtl, long accessTtl) {
        return this.dht.lockAllAsync(null, timeout);
    }

    @Override
    public void unlockAll(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        this.dht.unlockAll(keys);
    }

    @Override
    public void onDeferredDelete(GridCacheEntryEx entry, GridCacheVersion ver) {
        assert (entry.isNear());
        try {
            T2<KeyCacheObject, GridCacheVersion> evicted = this.rmvQueue.add(new T2<KeyCacheObject, GridCacheVersion>(entry.key(), ver));
            if (evicted != null) {
                this.removeVersionedEntry((KeyCacheObject)evicted.get1(), (GridCacheVersion)evicted.get2());
            }
        }
        catch (InterruptedException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to enqueue deleted entry [key=" + entry.key() + ", ver=" + ver + ']');
            }
            Thread.currentThread().interrupt();
        }
    }
}

