/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class GridNearCacheEntry
extends GridDistributedCacheEntry {
    private static final int NEAR_SIZE_OVERHEAD = 52;
    private volatile AffinityTopologyVersion topVer = AffinityTopologyVersion.NONE;
    private GridCacheVersion dhtVer;
    private int part;
    private short evictReservations;

    public GridNearCacheEntry(GridCacheContext ctx, KeyCacheObject key, int hash, CacheObject val) {
        super(ctx, key, hash, val);
        this.part = ctx.affinity().partition(key);
    }

    @Override
    public int memorySize() throws IgniteCheckedException {
        return super.memorySize() + 52;
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public boolean isNear() {
        return true;
    }

    @Override
    public boolean valid(AffinityTopologyVersion topVer) {
        assert (topVer.topologyVersion() > 0L) : "Topology version is invalid: " + topVer;
        AffinityTopologyVersion topVer0 = this.topVer;
        if (topVer0.equals(topVer)) {
            return true;
        }
        if (topVer0.equals(AffinityTopologyVersion.NONE) || topVer.compareTo(topVer0) < 0) {
            return false;
        }
        try {
            if (this.cctx.affinity().primaryChanged(this.partition(), topVer0, topVer)) {
                this.topVer = AffinityTopologyVersion.NONE;
                return false;
            }
            if (this.cctx.affinity().backupByPartition(this.cctx.localNode(), this.part, topVer)) {
                this.topVer = AffinityTopologyVersion.NONE;
                return false;
            }
            this.topVer = topVer;
            return true;
        }
        catch (IllegalStateException ignore) {
            this.topVer = AffinityTopologyVersion.NONE;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFromDht(AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        GridCacheEntryInfo e;
        GridDhtCacheEntry entry = this.cctx.near().dht().peekExx(this.key);
        if (entry != null && (e = entry.info()) != null) {
            GridCacheVersion enqueueVer = null;
            try {
                GridNearCacheEntry gridNearCacheEntry = this;
                synchronized (gridNearCacheEntry) {
                    this.checkObsolete();
                    if (this.isNew() || !this.valid(topVer)) {
                        ClusterNode primaryNode;
                        this.update(e.value(), e.expireTime(), e.ttl(), e.isNew() ? this.ver : e.version(), true);
                        if (this.cctx.deferredDelete() && !this.isNew() && !this.isInternal()) {
                            boolean deleted;
                            boolean bl = deleted = this.val == null;
                            if (deleted != this.deletedUnlocked()) {
                                this.deletedUnlocked(deleted);
                                if (deleted) {
                                    enqueueVer = e.version();
                                }
                            }
                        }
                        if ((primaryNode = this.cctx.affinity().primaryByKey(this.key, topVer)) == null) {
                            this.topVer = AffinityTopologyVersion.NONE;
                        } else {
                            this.recordNodeId(primaryNode.id(), topVer);
                        }
                        this.dhtVer = e.isNew() || e.isDeleted() ? null : e.version();
                    }
                }
            }
            finally {
                if (enqueueVer != null) {
                    this.cctx.onDeferredDelete(this, enqueueVer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetFromPrimary(CacheObject val, GridCacheVersion ver, GridCacheVersion dhtVer, UUID primaryNodeId, AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        assert (dhtVer != null);
        this.cctx.versions().onReceived(primaryNodeId, dhtVer);
        GridNearCacheEntry gridNearCacheEntry = this;
        synchronized (gridNearCacheEntry) {
            this.checkObsolete();
            this.primaryNode(primaryNodeId, topVer);
            if (!F.eq(this.dhtVer, dhtVer)) {
                this.value(val);
                this.ver = ver;
                this.dhtVer = dhtVer;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrEvict(GridCacheVersion dhtVer, @Nullable CacheObject val, long expireTime, long ttl, UUID primaryNodeId, AffinityTopologyVersion topVer) {
        assert (dhtVer != null);
        this.cctx.versions().onReceived(primaryNodeId, dhtVer);
        GridNearCacheEntry gridNearCacheEntry = this;
        synchronized (gridNearCacheEntry) {
            if (!this.obsolete()) {
                if (F.eq(this.dhtVer, dhtVer)) {
                    this.dhtVer = null;
                }
                if (this.dhtVer == null && !this.markObsolete(dhtVer)) {
                    this.value(val);
                    this.ttlAndExpireTimeExtras((int)ttl, expireTime);
                    this.primaryNode(primaryNodeId, topVer);
                }
            }
        }
    }

    @Nullable
    public synchronized GridCacheVersion dhtVersion() throws GridCacheEntryRemovedException {
        this.checkObsolete();
        return this.dhtVer;
    }

    @Nullable
    public synchronized IgniteBiTuple<GridCacheVersion, CacheObject> versionedValue() throws GridCacheEntryRemovedException {
        this.checkObsolete();
        if (this.dhtVer == null) {
            return null;
        }
        CacheObject val0 = this.valueBytesUnlocked();
        return F.t(this.dhtVer, val0);
    }

    @Override
    protected void recordNodeId(UUID primaryNodeId, AffinityTopologyVersion topVer) {
        assert (Thread.holdsLock(this));
        assert (topVer.compareTo(this.cctx.affinity().affinityTopologyVersion()) <= 0) : "Affinity not ready [topVer=" + topVer + ", readyVer=" + this.cctx.affinity().affinityTopologyVersion() + ", cache=" + this.cctx.name() + ']';
        this.primaryNode(primaryNodeId, topVer);
    }

    public final boolean recordDhtVersion(GridCacheVersion dhtVer) {
        assert (dhtVer != null);
        assert (Thread.holdsLock(this));
        if (this.dhtVer == null || this.dhtVer.compareTo(dhtVer) <= 0) {
            this.dhtVer = dhtVer;
            return true;
        }
        return false;
    }

    @Override
    protected Object readThrough(IgniteInternalTx tx, KeyCacheObject key, boolean reload, UUID subjId, String taskName) throws IgniteCheckedException {
        return this.cctx.near().loadAsync(tx, F.asList(key), false, subjId, taskName, true, null, false, false, true, false).get().get(this.keyValue(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadedValue(@Nullable IgniteInternalTx tx, UUID primaryNodeId, CacheObject val, GridCacheVersion ver, GridCacheVersion dhtVer, long ttl, long expireTime, boolean evt, boolean keepBinary, AffinityTopologyVersion topVer, UUID subjId) throws IgniteCheckedException, GridCacheEntryRemovedException {
        assert (dhtVer != null);
        GridCacheVersion enqueueVer = null;
        try {
            GridNearCacheEntry gridNearCacheEntry = this;
            synchronized (gridNearCacheEntry) {
                this.checkObsolete();
                if (this.cctx.cache().configuration().isStatisticsEnabled()) {
                    this.cctx.cache().metrics0().onRead(false);
                }
                boolean ret = false;
                CacheObject old = this.val;
                boolean hasVal = this.hasValueUnlocked();
                if (this.dhtVer == null || this.dhtVer.compareTo(dhtVer) < 0) {
                    this.primaryNode(primaryNodeId, topVer);
                    this.update(val, expireTime, ttl, ver, true);
                    if (this.cctx.deferredDelete() && !this.isInternal()) {
                        boolean deleted;
                        boolean bl = deleted = val == null;
                        if (deleted != this.deletedUnlocked()) {
                            this.deletedUnlocked(deleted);
                            if (deleted) {
                                enqueueVer = ver;
                            }
                        }
                    }
                    this.dhtVer = dhtVer;
                    ret = true;
                }
                if (evt && this.cctx.events().isRecordable(64)) {
                    this.cctx.events().addEvent(this.partition(), this.key, tx, null, 64, val, val != null, old, hasVal, subjId, null, null, keepBinary);
                }
                boolean bl = ret;
                return bl;
            }
        }
        finally {
            if (enqueueVer != null) {
                this.cctx.onDeferredDelete(this, enqueueVer);
            }
        }
    }

    @Override
    protected void updateIndex(CacheObject val, long expireTime, GridCacheVersion ver, CacheObject old) throws IgniteCheckedException {
    }

    @Override
    protected void clearIndex(CacheObject val) {
    }

    @Override
    public GridCacheMvccCandidate addLocal(long threadId, GridCacheVersion ver, AffinityTopologyVersion topVer, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException {
        return this.addNearLocal(null, threadId, ver, topVer, timeout, reenter, tx, implicitSingle, read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    GridCacheMvccCandidate addNearLocal(@Nullable UUID dhtNodeId, long threadId, GridCacheVersion ver, AffinityTopologyVersion topVer, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException {
        CacheObject val;
        GridCacheMvccCandidate cand;
        CacheLockCandidates prev;
        CacheLockCandidates owner = null;
        UUID locId = this.cctx.nodeId();
        GridNearCacheEntry gridNearCacheEntry = this;
        synchronized (gridNearCacheEntry) {
            GridCacheMvccCandidate c;
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null) {
                mvcc = new GridCacheMvcc(this.cctx);
                this.mvccExtras(mvcc);
            }
            if ((c = mvcc.localCandidate(locId, threadId)) != null) {
                return reenter ? c.reenter() : null;
            }
            prev = mvcc.allOwners();
            boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
            if (timeout < 0L && !emptyBefore) {
                return null;
            }
            cand = mvcc.addNearLocal(this, locId, dhtNodeId, threadId, ver, tx, implicitSingle, read);
            cand.topologyVersion(topVer);
            boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
            this.checkCallbacks(emptyBefore, emptyAfter);
            val = this.val;
            if (emptyAfter) {
                this.mvccExtras(null);
            } else {
                owner = mvcc.allOwners();
            }
        }
        this.checkOwnerChanged(prev, owner, val);
        return cand;
    }

    @Nullable
    public synchronized GridCacheMvccCandidate dhtNodeId(GridCacheVersion ver, UUID dhtNodeId) throws GridCacheEntryRemovedException {
        GridCacheMvccCandidate cand;
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        GridCacheMvccCandidate gridCacheMvccCandidate = cand = mvcc == null ? null : mvcc.candidate(ver);
        if (cand == null) {
            return null;
        }
        cand.otherNodeId(dhtNodeId);
        return cand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GridCacheMvccCandidate removeLock() {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        UUID locId = this.cctx.nodeId();
        GridCacheMvccCandidate cand = null;
        GridNearCacheEntry gridNearCacheEntry = this;
        synchronized (gridNearCacheEntry) {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                cand = mvcc.localCandidate(locId, Thread.currentThread().getId());
                assert (cand == null || cand.nearLocal());
                if (cand != null && cand.owner()) {
                    GridCacheMvccCandidate reentry = cand.unenter();
                    if (reentry != null) {
                        assert (reentry.reentry());
                        return reentry;
                    }
                } else {
                    return null;
                }
                mvcc.remove(cand.version());
                owner = mvcc.allOwners();
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                this.checkCallbacks(emptyBefore, emptyAfter);
                if (emptyAfter) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        assert (cand != null);
        assert (owner != prev);
        if (log.isDebugEnabled()) {
            log.debug("Released local candidate from entry [owner=" + owner + ", prev=" + prev + ", entry=" + this + ']');
        }
        this.cctx.mvcc().removeExplicitLock(cand);
        this.checkThreadChain(cand);
        this.checkOwnerChanged(prev, owner, val);
        return cand;
    }

    @Override
    protected void onInvalidate() {
        this.topVer = AffinityTopologyVersion.NONE;
        this.dhtVer = null;
    }

    synchronized void reserveEviction() throws GridCacheEntryRemovedException {
        this.checkObsolete();
        this.evictReservations = (short)(this.evictReservations + 1);
    }

    synchronized void releaseEviction() {
        assert (this.evictReservations > 0) : this;
        assert (!this.obsolete()) : this;
        this.evictReservations = (short)(this.evictReservations - 1);
    }

    @Override
    protected boolean evictionDisabled() {
        assert (Thread.holdsLock(this));
        return this.evictReservations > 0;
    }

    private void primaryNode(UUID nodeId, AffinityTopologyVersion topVer) {
        assert (Thread.holdsLock(this));
        assert (nodeId != null);
        ClusterNode primary = null;
        try {
            primary = this.cctx.affinity().primaryByPartition(this.part, topVer);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (primary == null || !nodeId.equals(primary.id())) {
            this.topVer = AffinityTopologyVersion.NONE;
            return;
        }
        if (topVer.compareTo(this.topVer) > 0) {
            this.topVer = topVer;
        }
    }

    @Override
    public synchronized String toString() {
        return S.toString(GridNearCacheEntry.class, this, "super", super.toString());
    }
}

