/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionable;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;

public class GridNearGetRequest
extends GridCacheMessage
implements GridCacheDeployable,
GridCacheVersionable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid futId;
    private IgniteUuid miniId;
    private GridCacheVersion ver;
    @GridToStringInclude
    @GridDirectTransient
    private LinkedHashMap<KeyCacheObject, Boolean> keyMap;
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;
    @GridDirectCollection(value=int.class)
    private List<Integer> partIds;
    @GridDirectCollection(value=boolean.class)
    private Collection<Boolean> flags;
    private boolean reload;
    private boolean readThrough;
    private boolean skipVals;
    private AffinityTopologyVersion topVer;
    private UUID subjId;
    private int taskNameHash;
    private long createTtl;
    private long accessTtl;

    public GridNearGetRequest() {
    }

    public GridNearGetRequest(int cacheId, IgniteUuid futId, IgniteUuid miniId, GridCacheVersion ver, Map<KeyCacheObject, Boolean> keys, boolean readThrough, @NotNull AffinityTopologyVersion topVer, UUID subjId, int taskNameHash, long createTtl, long accessTtl, boolean skipVals, boolean addDepInfo) {
        assert (futId != null);
        assert (miniId != null);
        assert (keys != null);
        this.cacheId = cacheId;
        this.futId = futId;
        this.miniId = miniId;
        this.ver = ver;
        this.keys = new ArrayList<KeyCacheObject>(keys.size());
        this.flags = new ArrayList<Boolean>(keys.size());
        this.partIds = new ArrayList<Integer>(keys.size());
        for (Map.Entry<KeyCacheObject, Boolean> entry : keys.entrySet()) {
            this.keys.add(entry.getKey());
            this.flags.add(entry.getValue());
            this.partIds.add(entry.getKey().partition());
        }
        this.readThrough = readThrough;
        this.topVer = topVer;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.createTtl = createTtl;
        this.accessTtl = accessTtl;
        this.skipVals = skipVals;
        this.addDepInfo = addDepInfo;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public GridCacheVersion version() {
        return this.ver;
    }

    public LinkedHashMap<KeyCacheObject, Boolean> keys() {
        return this.keyMap;
    }

    public boolean reload() {
        return this.reload;
    }

    public boolean readThrough() {
        return this.readThrough;
    }

    public boolean skipValues() {
        return this.skipVals;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public long createTtl() {
        return this.createTtl;
    }

    public long accessTtl() {
        return this.accessTtl;
    }

    @Override
    public int partition() {
        return this.partIds != null && !this.partIds.isEmpty() ? this.partIds.get(0) : -1;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        assert (ctx != null);
        assert (!F.isEmpty(this.keys));
        assert (this.keys.size() == this.flags.size());
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObjects(this.keys, cctx);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalCacheObjects(this.keys, cctx, ldr);
        assert (!F.isEmpty(this.keys));
        assert (this.keys.size() == this.flags.size());
        if (this.keyMap == null) {
            this.keyMap = U.newLinkedHashMap(this.keys.size());
            Iterator<KeyCacheObject> keysIt = this.keys.iterator();
            Iterator<Boolean> flagsIt = this.flags.iterator();
            while (keysIt.hasNext()) {
                this.keyMap.put(keysIt.next(), flagsIt.next());
            }
        }
        if (this.partIds != null && !this.partIds.isEmpty()) {
            assert (this.partIds.size() == this.keys.size());
            for (int i = 0; i < this.keys.size(); ++i) {
                this.keys.get(i).partition(this.partIds.get(i));
            }
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeLong("accessTtl", this.accessTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("createTtl", this.createTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("flags", this.flags, MessageCollectionItemType.BOOLEAN)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeCollection("partIds", this.partIds, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeBoolean("readThrough", this.readThrough)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeBoolean("reload", this.reload)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeBoolean("skipVals", this.skipVals)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeMessage("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.accessTtl = reader.readLong("accessTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.createTtl = reader.readLong("createTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.flags = reader.readCollection("flags", MessageCollectionItemType.BOOLEAN);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.partIds = (List)reader.readCollection("partIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.readThrough = reader.readBoolean("readThrough");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.reload = reader.readBoolean("reload");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.skipVals = reader.readBoolean("skipVals");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.ver = (GridCacheVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearGetRequest.class);
    }

    @Override
    public byte directType() {
        return 49;
    }

    @Override
    public byte fieldsCount() {
        return 17;
    }

    @Override
    public String toString() {
        return S.toString(GridNearGetRequest.class, this);
    }
}

