/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearLockRequest
extends GridDistributedLockRequest {
    private static final long serialVersionUID = 0L;
    private AffinityTopologyVersion topVer;
    private IgniteUuid miniId;
    private CacheEntryPredicate[] filter;
    private boolean implicitTx;
    private boolean implicitSingleTx;
    private boolean onePhaseCommit;
    @GridToStringInclude
    private GridCacheVersion[] dhtVers;
    private UUID subjId;
    private int taskNameHash;
    private boolean hasTransforms;
    private boolean syncCommit;
    private long createTtl;
    private long accessTtl;
    private boolean retVal;
    private boolean firstClientReq;

    public GridNearLockRequest() {
    }

    public GridNearLockRequest(int cacheId, @NotNull AffinityTopologyVersion topVer, UUID nodeId, long threadId, IgniteUuid futId, GridCacheVersion lockVer, boolean isInTx, boolean implicitTx, boolean implicitSingleTx, boolean isRead, boolean retVal, TransactionIsolation isolation, boolean isInvalidate, long timeout, int keyCnt, int txSize, boolean syncCommit, @Nullable UUID subjId, int taskNameHash, long createTtl, long accessTtl, boolean skipStore, boolean keepBinary, boolean firstClientReq, boolean addDepInfo) {
        super(cacheId, nodeId, lockVer, threadId, futId, lockVer, isInTx, isRead, isolation, isInvalidate, timeout, keyCnt, txSize, skipStore, keepBinary, addDepInfo);
        assert (topVer.compareTo(AffinityTopologyVersion.ZERO) > 0);
        this.topVer = topVer;
        this.implicitTx = implicitTx;
        this.implicitSingleTx = implicitSingleTx;
        this.syncCommit = syncCommit;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.createTtl = createTtl;
        this.accessTtl = accessTtl;
        this.retVal = retVal;
        this.firstClientReq = firstClientReq;
        this.dhtVers = new GridCacheVersion[keyCnt];
    }

    public boolean firstClientRequest() {
        return this.firstClientReq;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public boolean implicitTx() {
        return this.implicitTx;
    }

    public boolean implicitSingleTx() {
        return this.implicitSingleTx;
    }

    public boolean syncCommit() {
        return this.syncCommit;
    }

    public CacheEntryPredicate[] filter() {
        return this.filter;
    }

    public void filter(CacheEntryPredicate[] filter, GridCacheContext ctx) throws IgniteCheckedException {
        this.filter = filter;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public void miniId(IgniteUuid miniId) {
        this.miniId = miniId;
    }

    public void hasTransforms(boolean hasTransforms) {
        this.hasTransforms = hasTransforms;
    }

    public boolean hasTransforms() {
        return this.hasTransforms;
    }

    public boolean needReturnValue() {
        return this.retVal;
    }

    public void addKeyBytes(KeyCacheObject key, boolean retVal, @Nullable GridCacheVersion dhtVer, GridCacheContext ctx) throws IgniteCheckedException {
        this.dhtVers[this.idx] = dhtVer;
        this.addKeyBytes(key, retVal, ctx);
    }

    public GridCacheVersion dhtVersion(int idx) {
        return this.dhtVers[idx];
    }

    public long createTtl() {
        return this.createTtl;
    }

    public long accessTtl() {
        return this.accessTtl;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.filter != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId);
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                p.prepareMarshal(cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.filter != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId);
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                p.finishUnmarshal(cctx, ldr);
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 20: {
                if (!writer.writeLong("accessTtl", this.accessTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeLong("createTtl", this.createTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeObjectArray("dhtVers", this.dhtVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeObjectArray("filter", this.filter, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeBoolean("firstClientReq", this.firstClientReq)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeBoolean("hasTransforms", this.hasTransforms)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeBoolean("implicitSingleTx", this.implicitSingleTx)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeBoolean("implicitTx", this.implicitTx)) {
                    return false;
                }
                writer.incrementState();
            }
            case 28: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 29: {
                if (!writer.writeBoolean("onePhaseCommit", this.onePhaseCommit)) {
                    return false;
                }
                writer.incrementState();
            }
            case 30: {
                if (!writer.writeBoolean("retVal", this.retVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 31: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 32: {
                if (!writer.writeBoolean("syncCommit", this.syncCommit)) {
                    return false;
                }
                writer.incrementState();
            }
            case 33: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 34: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 35: {
                if (!writer.writeCollection("partIds", this.partIds, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 20: {
                this.accessTtl = reader.readLong("accessTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 21: {
                this.createTtl = reader.readLong("createTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.dhtVers = reader.readObjectArray("dhtVers", MessageCollectionItemType.MSG, GridCacheVersion.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.filter = reader.readObjectArray("filter", MessageCollectionItemType.MSG, CacheEntryPredicate.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.firstClientReq = reader.readBoolean("firstClientReq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.hasTransforms = reader.readBoolean("hasTransforms");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.implicitSingleTx = reader.readBoolean("implicitSingleTx");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.implicitTx = reader.readBoolean("implicitTx");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 28: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 29: {
                this.onePhaseCommit = reader.readBoolean("onePhaseCommit");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 30: {
                this.retVal = reader.readBoolean("retVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 31: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 32: {
                this.syncCommit = reader.readBoolean("syncCommit");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 33: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 34: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 35: {
                this.partIds = (List)reader.readCollection("partIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearLockRequest.class);
    }

    @Override
    public byte directType() {
        return 51;
    }

    @Override
    public byte fieldsCount() {
        return 36;
    }

    @Override
    public String toString() {
        return S.toString(GridNearLockRequest.class, this, "filter", Arrays.toString(this.filter), "super", super.toString());
    }
}

