/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridNearOptimisticSerializableTxPrepareFuture
extends GridNearOptimisticTxPrepareFutureAdapter {
    public static final IgniteProductVersion SER_TX_SINCE = IgniteProductVersion.fromString("1.5.0");
    @GridToStringExclude
    private GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture keyLockFut;
    @GridToStringExclude
    private ClientRemapFuture remapFut;

    public GridNearOptimisticSerializableTxPrepareFuture(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.optimistic() && tx.serializable()) : tx;
    }

    @Override
    protected boolean ignoreFailure(Throwable err) {
        return IgniteCheckedException.class.isAssignableFrom(err.getClass());
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        IgniteTxEntry txEntry;
        if (log.isDebugEnabled()) {
            log.debug("Transaction future received owner changed callback: " + entry);
        }
        if ((entry.context().isNear() || entry.context().isLocal()) && owner != null && (txEntry = this.tx.entry(entry.txKey())) != null) {
            GridCacheVersion serReadVer;
            if (entry.context().isLocal() && (serReadVer = txEntry.entryReadVersion()) != null) {
                GridCacheContext ctx = entry.context();
                while (true) {
                    try {
                        if (entry.checkSerializableReadVersion(serReadVer)) break;
                        Object key = entry.key().value(ctx.cacheObjectContext(), false);
                        IgniteTxOptimisticCheckedException err0 = new IgniteTxOptimisticCheckedException("Failed to prepare transaction, read/write conflict [key=" + key + ", cache=" + ctx.name() + ']');
                        ERR_UPD.compareAndSet(this, null, err0);
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        entry = ctx.cache().entryEx(entry.key(), this.tx.topologyVersion());
                        txEntry.cached(entry);
                        continue;
                    }
                    break;
                }
            }
            if (this.keyLockFut != null) {
                this.keyLockFut.onKeyLocked(entry.txKey());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Remote node left grid: " + nodeId);
            e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
            f.onNodeLeft(e);
            found = true;
        }
        return found;
    }

    private void onError(@Nullable GridDistributedTxMapping m, Throwable e) {
        if ((X.hasCause(e, ClusterTopologyCheckedException.class) || X.hasCause(e, ClusterTopologyException.class)) && this.tx.onePhaseCommit()) {
            this.tx.markForBackupCheck();
            this.onComplete();
            return;
        }
        if ((e instanceof IgniteTxOptimisticCheckedException || e instanceof IgniteTxTimeoutCheckedException) && m != null) {
            this.tx.removeMapping(m.node().id());
        }
        ERR_UPD.compareAndSet(this, null, e);
        if (this.keyLockFut != null) {
            this.keyLockFut.onDone(e);
        }
    }

    @Override
    public void onResult(UUID nodeId, GridNearTxPrepareResponse res) {
        MiniFuture mini;
        if (!this.isDone() && (mini = this.miniFuture(res.miniId())) != null) {
            mini.onResult(res);
        }
    }

    @Override
    public boolean onDone(IgniteInternalTx t, Throwable err) {
        if (this.isDone()) {
            return false;
        }
        if (err != null) {
            ERR_UPD.compareAndSet(this, null, err);
            if (this.keyLockFut != null) {
                this.keyLockFut.onDone(err);
            }
        }
        return this.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(IgniteUuid miniId) {
        Object object = this.sync;
        synchronized (object) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || !(mini = (MiniFuture)fut).futureId().equals(miniId)) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private boolean onComplete() {
        Throwable err0 = this.err;
        if (err0 == null || this.tx.needCheckBackup()) {
            this.tx.state(TransactionState.PREPARED);
        }
        if (super.onDone(this.tx, err0)) {
            if (err0 != null) {
                this.tx.setRollbackOnly();
            }
            this.cctx.mvcc().removeMvccFuture(this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepare0(boolean remap, boolean topLocked) {
        boolean txStateCheck;
        boolean bl = remap ? this.tx.state() == TransactionState.PREPARING : (txStateCheck = this.tx.state(TransactionState.PREPARING));
        if (!txStateCheck) {
            if (this.tx.setRollbackOnly()) {
                if (this.tx.timedOut()) {
                    this.onError(null, new IgniteTxTimeoutCheckedException("Transaction timed out and was rolled back: " + this));
                } else {
                    this.onError(null, new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'));
                }
            } else {
                this.onError(null, new IgniteTxRollbackCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'));
            }
            return;
        }
        boolean set = this.cctx.tm().setTxTopologyHint(this.tx.topologyVersionSnapshot());
        try {
            this.prepare(this.tx.readEntries(), this.tx.writeEntries(), remap, topLocked);
            this.markInitialized();
        }
        finally {
            if (set) {
                this.cctx.tm().setTxTopologyHint(null);
            }
        }
    }

    private void prepare(Iterable<IgniteTxEntry> reads, Iterable<IgniteTxEntry> writes, boolean remap, boolean topLocked) {
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        assert (topVer.topologyVersion() > 0L);
        this.txMapping = new GridDhtTxMapping();
        HashMap<IgniteBiTuple<ClusterNode, Boolean>, GridDistributedTxMapping> mappings = new HashMap<IgniteBiTuple<ClusterNode, Boolean>, GridDistributedTxMapping>();
        for (IgniteTxEntry write : writes) {
            this.map(write, topVer, mappings, remap, topLocked);
        }
        for (IgniteTxEntry read : reads) {
            this.map(read, topVer, mappings, remap, topLocked);
        }
        if (this.keyLockFut != null) {
            this.keyLockFut.onAllKeysAdded();
        }
        if (this.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug("Abandoning (re)map because future is done: " + this);
            }
            return;
        }
        this.tx.addEntryMapping(mappings.values());
        this.cctx.mvcc().recheckPendingLocks();
        this.tx.transactionNodes(this.txMapping.transactionNodes());
        this.checkOnePhase();
        for (GridDistributedTxMapping m : mappings.values()) {
            assert (!m.empty());
            this.add(new MiniFuture(this, m));
        }
        Collection futs = this.futures();
        Iterator it = futs.iterator();
        while (it.hasNext()) {
            MiniFuture fut;
            IgniteCheckedException err;
            IgniteInternalFuture fut0 = it.next();
            if (this.skipFuture(remap, fut0) || (err = this.prepare(fut = (MiniFuture)fut0)) == null) continue;
            while (it.hasNext()) {
                fut0 = it.next();
                if (this.skipFuture(remap, fut0)) continue;
                fut = (MiniFuture)fut0;
                this.tx.removeMapping(fut.mapping().node().id());
                fut.onResult(new IgniteCheckedException("Failed to prepare transaction.", err));
            }
            break block3;
        }
        this.markInitialized();
    }

    private boolean skipFuture(boolean remap, IgniteInternalFuture<?> fut) {
        return !this.isMini(fut) || remap && ((MiniFuture)fut).rcvRes == 1;
    }

    @Nullable
    private IgniteCheckedException prepare(final MiniFuture fut) {
        GridDistributedTxMapping m = fut.mapping();
        ClusterNode n = m.node();
        long timeout = this.tx.remainingTime();
        if (timeout == -1L) {
            IgniteCheckedException err = this.tx.timeoutException();
            fut.onResult(err);
            return err;
        }
        GridNearTxPrepareRequest req = new GridNearTxPrepareRequest(this.futId, this.tx.topologyVersion(), this.tx, timeout, m.reads(), m.writes(), m.near(), this.txMapping.transactionNodes(), m.last(), this.tx.onePhaseCommit(), this.tx.needReturnValue() && this.tx.implicit(), this.tx.implicitSingle(), m.explicitLock(), this.tx.subjectId(), this.tx.taskNameHash(), m.clientFirst(), this.tx.activeCachesDeploymentEnabled());
        for (IgniteTxEntry txEntry : m.entries()) {
            if (txEntry.op() != GridCacheOperation.TRANSFORM) continue;
            req.addDhtVersion(txEntry.txKey(), null);
        }
        if (m.near()) {
            try {
                this.tx.optimisticLockEntries(m.entries());
                this.tx.userPrepare();
            }
            catch (IgniteCheckedException e) {
                fut.onResult(e);
                return e;
            }
        }
        req.miniId(fut.futureId());
        if (n.isLocal()) {
            IgniteInternalFuture<GridNearTxPrepareResponse> prepFut = this.cctx.tm().txHandler().prepareTx(n.id(), this.tx, req);
            prepFut.listen((IgniteInClosure<IgniteInternalFuture<GridNearTxPrepareResponse>>)new CI1<IgniteInternalFuture<GridNearTxPrepareResponse>>(){

                @Override
                public void apply(IgniteInternalFuture<GridNearTxPrepareResponse> prepFut) {
                    try {
                        fut.onResult(prepFut.get());
                    }
                    catch (IgniteCheckedException e) {
                        fut.onResult(e);
                    }
                }
            });
        } else {
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
            }
            catch (ClusterTopologyCheckedException e) {
                e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                fut.onNodeLeft(e);
                return e;
            }
            catch (IgniteCheckedException e) {
                fut.onResult(e);
                return e;
            }
        }
        return null;
    }

    private void map(IgniteTxEntry entry, AffinityTopologyVersion topVer, Map<IgniteBiTuple<ClusterNode, Boolean>, GridDistributedTxMapping> curMapping, boolean remap, boolean topLocked) {
        IgniteBiTuple<ClusterNode, Boolean> key;
        GridDistributedTxMapping cur;
        GridCacheContext<?, ?> cacheCtx = entry.context();
        List<ClusterNode> nodes = cacheCtx.isLocal() ? cacheCtx.affinity().nodesByKey(entry.key(), topVer) : cacheCtx.topology().nodes(cacheCtx.affinity().partition(entry.key()), topVer);
        this.txMapping.addMapping(nodes);
        ClusterNode primary = F.first(nodes);
        assert (primary != null);
        if (log.isDebugEnabled()) {
            log.debug("Mapped key to primary node [key=" + entry.key() + ", part=" + cacheCtx.affinity().partition(entry.key()) + ", primary=" + U.toShortString(primary) + ", topVer=" + topVer + ']');
        }
        if (primary.version().compareTo(SER_TX_SINCE) < 0) {
            this.onDone(new IgniteCheckedException("Optimistic serializable transactions can be used only with node version starting from " + SER_TX_SINCE));
            return;
        }
        if (cacheCtx.isNear()) {
            entry.cached(cacheCtx.nearTx().entryExx(entry.key(), topVer));
        } else if (!cacheCtx.isLocal()) {
            entry.cached(cacheCtx.colocated().entryExx(entry.key(), topVer, true));
        } else {
            entry.cached(cacheCtx.local().entryEx(entry.key(), topVer));
        }
        if (!remap && (cacheCtx.isNear() || cacheCtx.isLocal()) && entry.explicitVersion() == null) {
            if (this.keyLockFut == null) {
                this.keyLockFut = new GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture();
                this.add(this.keyLockFut);
            }
            this.keyLockFut.addLockKey(entry.txKey());
        }
        if ((cur = curMapping.get(key = F.t(primary, cacheCtx.isNear()))) == null) {
            cur = new GridDistributedTxMapping(primary);
            curMapping.put(key, cur);
            if (primary.isLocal()) {
                if (entry.context().isNear()) {
                    this.tx.nearLocallyMapped(true);
                } else if (entry.context().isColocated()) {
                    this.tx.colocatedLocallyMapped(true);
                }
            }
            cur.near(cacheCtx.isNear());
            cur.clientFirst(!topLocked && this.cctx.kernalContext().clientNode());
            cur.last(true);
        }
        cur.add(entry);
        if (entry.explicitVersion() != null) {
            this.tx.markExplicit(primary.id());
            cur.markExplicitLock();
        }
        entry.nodeId(primary.id());
        if (cacheCtx.isNear()) {
            while (true) {
                try {
                    GridNearCacheEntry cached = (GridNearCacheEntry)entry.cached();
                    cached.dhtNodeId(this.tx.xidVersion(), primary.id());
                }
                catch (GridCacheEntryRemovedException ignore) {
                    entry.cached(cacheCtx.near().entryEx(entry.key(), topVer));
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
            }
        }, new P1<IgniteInternalFuture<?>>(){

            @Override
            public boolean apply(IgniteInternalFuture<?> f) {
                return GridNearOptimisticSerializableTxPrepareFuture.this.isMini(f);
            }
        });
        return S.toString(GridNearOptimisticSerializableTxPrepareFuture.class, this, "innerFuts", futs, "keyLockFut", (Object)this.keyLockFut, "tx", this.tx, "super", super.toString());
    }

    private static class MiniFuture
    extends GridFutureAdapter<GridNearTxPrepareResponse> {
        private static final long serialVersionUID = 0L;
        private static AtomicIntegerFieldUpdater<MiniFuture> RCV_RES_UPD = AtomicIntegerFieldUpdater.newUpdater(MiniFuture.class, "rcvRes");
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        private final GridNearOptimisticSerializableTxPrepareFuture parent;
        @GridToStringInclude
        private GridDistributedTxMapping m;
        private volatile int rcvRes;

        MiniFuture(GridNearOptimisticSerializableTxPrepareFuture parent, GridDistributedTxMapping m) {
            this.parent = parent;
            this.m = m;
        }

        IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.m.node();
        }

        public GridDistributedTxMapping mapping() {
            return this.m;
        }

        void onResult(Throwable e) {
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                this.parent.onError(this.m, e);
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
                }
                this.onDone(e);
            } else {
                U.warn(GridNearTxPrepareFutureAdapter.log, "Received error after another result has been processed [fut=" + this.parent + ", mini=" + this + ']', e);
            }
        }

        void onNodeLeft(ClusterTopologyCheckedException e) {
            if (this.isDone()) {
                return;
            }
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("Remote node left grid while sending or waiting for reply (will not retry): " + this);
                }
                this.parent.onError(null, e);
                this.onDone(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(final GridNearTxPrepareResponse res) {
            if (this.isDone()) {
                return;
            }
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (res.error() != null) {
                    this.parent.onError(this.m, res.error());
                    this.onDone(res.error());
                } else if (res.clientRemapVersion() != null) {
                    assert (this.parent.cctx.kernalContext().clientNode());
                    assert (this.m.clientFirst());
                    this.parent.tx.removeMapping(this.m.node().id());
                    ClientRemapFuture remapFut0 = null;
                    GridNearOptimisticSerializableTxPrepareFuture gridNearOptimisticSerializableTxPrepareFuture = this.parent;
                    synchronized (gridNearOptimisticSerializableTxPrepareFuture) {
                        if (this.parent.remapFut == null) {
                            this.parent.remapFut = new ClientRemapFuture();
                            remapFut0 = this.parent.remapFut;
                        }
                    }
                    if (remapFut0 != null) {
                        Collection futs = this.parent.futures();
                        for (IgniteInternalFuture fut : futs) {
                            if (!this.parent.isMini(fut) || fut == this) continue;
                            remapFut0.add((MiniFuture)fut);
                        }
                        remapFut0.markInitialized();
                        remapFut0.listen(new CI1<IgniteInternalFuture<Boolean>>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void apply(IgniteInternalFuture<Boolean> remapFut0) {
                                block10: {
                                    try {
                                        IgniteInternalFuture<?> affFut = ((MiniFuture)MiniFuture.this).parent.cctx.exchange().affinityReadyFuture(res.clientRemapVersion());
                                        if (affFut == null) {
                                            affFut = new GridFinishedFuture();
                                        }
                                        if (((Boolean)MiniFuture.this.parent.remapFut.get()).booleanValue()) {
                                            if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                                                GridNearTxPrepareFutureAdapter.log.debug("Will remap client tx [fut=" + MiniFuture.this.parent + ", topVer=" + res.topologyVersion() + ']');
                                            }
                                            GridNearOptimisticSerializableTxPrepareFuture gridNearOptimisticSerializableTxPrepareFuture = MiniFuture.this.parent;
                                            synchronized (gridNearOptimisticSerializableTxPrepareFuture) {
                                                assert (remapFut0 == MiniFuture.this.parent.remapFut);
                                                MiniFuture.this.parent.remapFut = null;
                                            }
                                            affFut.listen(new CI1<IgniteInternalFuture<?>>(){

                                                @Override
                                                public void apply(IgniteInternalFuture<?> affFut) {
                                                    try {
                                                        affFut.get();
                                                        MiniFuture.this.remap(res);
                                                    }
                                                    catch (IgniteCheckedException e) {
                                                        GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(MiniFuture.this.parent, null, e);
                                                        MiniFuture.this.onDone(e);
                                                    }
                                                }
                                            });
                                            break block10;
                                        }
                                        ClusterTopologyCheckedException err0 = new ClusterTopologyCheckedException("Cluster topology changed while client transaction is preparing.");
                                        err0.retryReadyFuture(affFut);
                                        GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(MiniFuture.this.parent, null, err0);
                                        MiniFuture.this.onDone(err0);
                                    }
                                    catch (IgniteCheckedException e) {
                                        if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                                            GridNearTxPrepareFutureAdapter.log.debug("Prepare failed, will not remap tx: " + MiniFuture.this.parent);
                                        }
                                        GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(MiniFuture.this.parent, null, e);
                                        MiniFuture.this.onDone(e);
                                    }
                                }
                            }
                        });
                    } else {
                        this.onDone(res);
                    }
                } else {
                    this.parent.onPrepareResponse(this.m, res);
                    this.onDone(this.parent.cctx.kernalContext().clientNode() ? res : null);
                }
            }
        }

        private void remap(final GridNearTxPrepareResponse res) {
            this.parent.prepareOnTopology(true, new Runnable(){

                @Override
                public void run() {
                    MiniFuture.this.onDone(res);
                }
            });
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }

    private static class ClientRemapFutureReducer
    implements IgniteReducer<GridNearTxPrepareResponse, Boolean> {
        private static final long serialVersionUID = 0L;
        private boolean remap = true;

        private ClientRemapFutureReducer() {
        }

        @Override
        public boolean collect(@Nullable GridNearTxPrepareResponse res) {
            assert (res != null);
            if (res.clientRemapVersion() == null) {
                this.remap = false;
            }
            return true;
        }

        @Override
        public Boolean reduce() {
            return this.remap;
        }
    }

    private static class ClientRemapFuture
    extends GridCompoundFuture<GridNearTxPrepareResponse, Boolean> {
        private static final long serialVersionUID = 0L;

        public ClientRemapFuture() {
            super(new ClientRemapFutureReducer());
        }
    }
}

