/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.TxDeadlock;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.apache.ignite.transactions.TransactionState;
import org.apache.ignite.transactions.TransactionTimeoutException;
import org.jetbrains.annotations.Nullable;

public class GridNearOptimisticTxPrepareFuture
extends GridNearOptimisticTxPrepareFutureAdapter {
    @GridToStringExclude
    private GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture keyLockFut;

    public GridNearOptimisticTxPrepareFuture(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.optimistic() && !tx.serializable()) : tx;
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        if (log.isDebugEnabled()) {
            log.debug("Transaction future received owner changed callback: " + entry);
        }
        if (this.tx.remainingTime() == -1L) {
            return false;
        }
        if ((entry.context().isNear() || entry.context().isLocal()) && owner != null && this.tx.hasWriteKey(entry.txKey())) {
            if (this.keyLockFut != null) {
                this.keyLockFut.onKeyLocked(entry.txKey());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Remote node left grid: " + nodeId);
            e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
            f.onNodeLeft(e, true);
            found = true;
        }
        return found;
    }

    void onError(Throwable e, boolean discoThread) {
        if (e instanceof IgniteTxTimeoutCheckedException) {
            this.onTimeout();
            return;
        }
        if ((X.hasCause(e, ClusterTopologyCheckedException.class) || X.hasCause(e, ClusterTopologyException.class)) && this.tx.onePhaseCommit()) {
            this.tx.markForBackupCheck();
            this.onComplete();
            return;
        }
        if (ERR_UPD.compareAndSet(this, null, e)) {
            boolean marked = this.tx.setRollbackOnly();
            if (e instanceof IgniteTxRollbackCheckedException && marked) {
                try {
                    this.tx.rollback();
                }
                catch (IgniteCheckedException ex) {
                    U.error(log, "Failed to automatically rollback transaction: " + this.tx, ex);
                }
            }
            this.onComplete();
        }
    }

    @Override
    public void onResult(UUID nodeId, GridNearTxPrepareResponse res) {
        if (!this.isDone()) {
            MiniFuture mini = this.miniFuture(res.miniId());
            if (mini != null) {
                assert (mini.node().id().equals(nodeId));
                mini.onResult(res);
            } else if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near optimistic prepare fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near optimistic prepare fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IgniteTxKey> requestedKeys() {
        Object object = this.sync;
        synchronized (object) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || fut.isDone()) continue;
                MiniFuture miniFut = (MiniFuture)fut;
                Collection<IgniteTxEntry> entries = miniFut.mapping().entries();
                HashSet<IgniteTxKey> keys = U.newHashSet(entries.size());
                for (IgniteTxEntry entry : entries) {
                    keys.add(entry.txKey());
                }
                return keys;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(IgniteUuid miniId) {
        Object object = this.sync;
        synchronized (object) {
            int size = this.futuresCountNoLock();
            for (int i = size - 1; i >= 0; --i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || !(mini = (MiniFuture)fut).futureId().equals(miniId)) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean onDone(IgniteInternalTx t, Throwable err) {
        if (this.isDone()) {
            return false;
        }
        ERR_UPD.compareAndSet(this, null, err);
        return this.onComplete();
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private boolean onComplete() {
        Throwable err0 = this.err;
        if (err0 == null || this.tx.needCheckBackup()) {
            this.tx.state(TransactionState.PREPARED);
        }
        if (super.onDone(this.tx, err0)) {
            this.cctx.mvcc().removeMvccFuture(this);
            return true;
        }
        return false;
    }

    @Override
    protected void prepare0(boolean remap, boolean topLocked) {
        try {
            boolean txStateCheck;
            boolean bl = remap ? this.tx.state() == TransactionState.PREPARING : (txStateCheck = this.tx.state(TransactionState.PREPARING));
            if (!txStateCheck) {
                if (this.tx.setRollbackOnly()) {
                    if (this.tx.remainingTime() == -1L) {
                        this.onError(new IgniteTxTimeoutCheckedException("Transaction timed out and was rolled back: " + this), false);
                    } else {
                        this.onError(new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'), false);
                    }
                } else {
                    this.onError(new IgniteTxRollbackCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'), false);
                }
                return;
            }
            IgniteTxEntry singleWrite = this.tx.singleWrite();
            if (singleWrite != null) {
                this.prepareSingle(singleWrite, topLocked, remap);
            } else {
                this.prepare(this.tx.writeEntries(), topLocked, remap);
            }
            this.markInitialized();
        }
        catch (TransactionTimeoutException e) {
            this.onError(e, false);
        }
    }

    private void prepareSingle(IgniteTxEntry write, boolean topLocked, boolean remap) {
        write.clearEntryReadVersion();
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        assert (topVer.topologyVersion() > 0L);
        this.txMapping = new GridDhtTxMapping();
        GridDistributedTxMapping mapping = this.map(write, topVer, null, topLocked, remap);
        if (mapping.node().isLocal()) {
            if (write.context().isNear()) {
                this.tx.nearLocallyMapped(true);
            } else if (write.context().isColocated()) {
                this.tx.colocatedLocallyMapped(true);
            }
        }
        if (this.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug("Abandoning (re)map because future is done: " + this);
            }
            return;
        }
        if (this.keyLockFut != null) {
            this.keyLockFut.onAllKeysAdded();
        }
        this.tx.addSingleEntryMapping(mapping, write);
        this.cctx.mvcc().recheckPendingLocks();
        mapping.last(true);
        this.tx.transactionNodes(this.txMapping.transactionNodes());
        this.checkOnePhase();
        this.proceedPrepare(mapping, null);
    }

    private void prepare(Iterable<IgniteTxEntry> writes, boolean topLocked, boolean remap) {
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        assert (topVer.topologyVersion() > 0L);
        this.txMapping = new GridDhtTxMapping();
        HashMap<UUID, GridDistributedTxMapping> map = new HashMap<UUID, GridDistributedTxMapping>();
        GridDistributedTxMapping cur = null;
        ArrayDeque<GridDistributedTxMapping> mappings = new ArrayDeque<GridDistributedTxMapping>();
        for (IgniteTxEntry write : writes) {
            write.clearEntryReadVersion();
            GridDistributedTxMapping updated = this.map(write, topVer, cur, topLocked, remap);
            if (cur == updated) continue;
            mappings.offer(updated);
            updated.last(true);
            GridDistributedTxMapping prev = map.put(updated.node().id(), updated);
            if (prev != null) {
                prev.last(false);
            }
            if (updated.node().isLocal()) {
                if (write.context().isNear()) {
                    this.tx.nearLocallyMapped(true);
                } else if (write.context().isColocated()) {
                    this.tx.colocatedLocallyMapped(true);
                }
            }
            cur = updated;
        }
        if (this.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug("Abandoning (re)map because future is done: " + this);
            }
            return;
        }
        if (this.keyLockFut != null) {
            this.keyLockFut.onAllKeysAdded();
        }
        this.tx.addEntryMapping(mappings);
        this.cctx.mvcc().recheckPendingLocks();
        this.tx.transactionNodes(this.txMapping.transactionNodes());
        this.checkOnePhase();
        this.proceedPrepare(mappings);
    }

    private void proceedPrepare(Queue<GridDistributedTxMapping> mappings) {
        GridDistributedTxMapping m = mappings.poll();
        if (m == null) {
            return;
        }
        this.proceedPrepare(m, mappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedPrepare(GridDistributedTxMapping m, @Nullable Queue<GridDistributedTxMapping> mappings) {
        block17: {
            if (this.isDone()) {
                return;
            }
            boolean set = this.cctx.tm().setTxTopologyHint(this.tx.topologyVersionSnapshot());
            try {
                assert (!m.empty());
                ClusterNode n = m.node();
                long timeout = this.tx.remainingTime();
                if (timeout != -1L) {
                    GridNearTxPrepareRequest req = new GridNearTxPrepareRequest(this.futId, this.tx.topologyVersion(), this.tx, timeout, null, m.writes(), m.near(), this.txMapping.transactionNodes(), m.last(), this.tx.onePhaseCommit(), this.tx.needReturnValue() && this.tx.implicit(), this.tx.implicitSingle(), m.explicitLock(), this.tx.subjectId(), this.tx.taskNameHash(), m.clientFirst(), this.tx.activeCachesDeploymentEnabled());
                    for (IgniteTxEntry txEntry : m.entries()) {
                        if (txEntry.op() != GridCacheOperation.TRANSFORM) continue;
                        req.addDhtVersion(txEntry.txKey(), null);
                    }
                    if (m.near()) {
                        try {
                            this.tx.optimisticLockEntries(req.writes());
                            this.tx.userPrepare();
                        }
                        catch (IgniteCheckedException e) {
                            this.onError(e, false);
                        }
                    }
                    final MiniFuture fut = new MiniFuture(this, m, mappings);
                    req.miniId(fut.futureId());
                    this.add(fut);
                    if (n.isLocal()) {
                        IgniteInternalFuture<GridNearTxPrepareResponse> prepFut = this.cctx.tm().txHandler().prepareTx(n.id(), this.tx, req);
                        prepFut.listen((IgniteInClosure<IgniteInternalFuture<GridNearTxPrepareResponse>>)new CI1<IgniteInternalFuture<GridNearTxPrepareResponse>>(){

                            @Override
                            public void apply(IgniteInternalFuture<GridNearTxPrepareResponse> prepFut) {
                                try {
                                    fut.onResult(prepFut.get());
                                }
                                catch (IgniteCheckedException e) {
                                    fut.onResult(e);
                                }
                            }
                        });
                        break block17;
                    }
                    try {
                        this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                        if (msgLog.isDebugEnabled()) {
                            msgLog.debug("Near optimistic prepare fut, sent request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ']');
                        }
                        break block17;
                    }
                    catch (ClusterTopologyCheckedException e) {
                        e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                        fut.onNodeLeft(e, false);
                    }
                    catch (IgniteCheckedException e) {
                        if (msgLog.isDebugEnabled()) {
                            msgLog.debug("Near optimistic prepare fut, failed to sent request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ", err=" + e + ']');
                        }
                        fut.onResult(e);
                    }
                    break block17;
                }
                this.onTimeout();
            }
            finally {
                if (set) {
                    this.cctx.tm().setTxTopologyHint(null);
                }
            }
        }
    }

    private GridDistributedTxMapping map(IgniteTxEntry entry, AffinityTopologyVersion topVer, @Nullable GridDistributedTxMapping cur, boolean topLocked, boolean remap) {
        GridCacheContext<?, ?> cacheCtx = entry.context();
        GridCacheEntryEx cached0 = entry.cached();
        List<ClusterNode> nodes = cached0.isDht() ? cacheCtx.topology().nodes(cached0.partition(), topVer) : (cacheCtx.isLocal() ? cacheCtx.affinity().nodesByKey(entry.key(), topVer) : cacheCtx.topology().nodes(cacheCtx.affinity().partition(entry.key()), topVer));
        this.txMapping.addMapping(nodes);
        ClusterNode primary = F.first(nodes);
        assert (primary != null);
        if (log.isDebugEnabled()) {
            log.debug("Mapped key to primary node [key=" + entry.key() + ", part=" + cacheCtx.affinity().partition(entry.key()) + ", primary=" + U.toShortString(primary) + ", topVer=" + topVer + ']');
        }
        if (cacheCtx.isNear()) {
            entry.cached(cacheCtx.nearTx().entryExx(entry.key(), topVer));
        } else if (!cacheCtx.isLocal()) {
            entry.cached(cacheCtx.colocated().entryExx(entry.key(), topVer, true));
        } else {
            entry.cached(cacheCtx.local().entryEx(entry.key(), topVer));
        }
        if ((cacheCtx.isNear() || cacheCtx.isLocal()) && entry.explicitVersion() == null && !remap) {
            if (this.keyLockFut == null) {
                this.keyLockFut = new GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture();
                this.add(this.keyLockFut);
            }
            this.keyLockFut.addLockKey(entry.txKey());
        }
        if (cur == null || !cur.node().id().equals(primary.id()) || cur.near() != cacheCtx.isNear()) {
            boolean clientFirst = cur == null && !topLocked && this.cctx.kernalContext().clientNode();
            cur = new GridDistributedTxMapping(primary);
            cur.near(cacheCtx.isNear());
            cur.clientFirst(clientFirst);
        }
        cur.add(entry);
        if (entry.explicitVersion() != null) {
            this.tx.markExplicit(primary.id());
            cur.markExplicitLock();
        }
        entry.nodeId(primary.id());
        if (cacheCtx.isNear()) {
            while (true) {
                try {
                    GridNearCacheEntry cached = (GridNearCacheEntry)entry.cached();
                    cached.dhtNodeId(this.tx.xidVersion(), primary.id());
                }
                catch (GridCacheEntryRemovedException ignore) {
                    entry.cached(cacheCtx.near().entryEx(entry.key(), topVer));
                    continue;
                }
                break;
            }
        }
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimeout() {
        if (this.cctx.tm().deadlockDetectionEnabled()) {
            HashSet<IgniteTxKey> keys = null;
            if (this.keyLockFut != null) {
                keys = new HashSet<IgniteTxKey>(this.keyLockFut.lockKeys);
            } else {
                Object object = this.sync;
                synchronized (object) {
                    int size = this.futuresCountNoLock();
                    for (int i = 0; i < size; ++i) {
                        IgniteInternalFuture fut = this.future(i);
                        if (!this.isMini(fut) || fut.isDone()) continue;
                        MiniFuture miniFut = (MiniFuture)fut;
                        Collection<IgniteTxEntry> entries = miniFut.mapping().entries();
                        keys = U.newHashSet(entries.size());
                        for (IgniteTxEntry entry : entries) {
                            keys.add(entry.txKey());
                        }
                        break;
                    }
                }
            }
            this.add(new GridEmbeddedFuture<GridNearTxPrepareResponse, TxDeadlock>(new IgniteBiClosure<TxDeadlock, Exception, GridNearTxPrepareResponse>(){

                @Override
                public GridNearTxPrepareResponse apply(TxDeadlock deadlock, Exception e) {
                    if (e != null) {
                        U.warn(GridNearTxPrepareFutureAdapter.log, "Failed to detect deadlock.", e);
                    } else {
                        e = new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + GridNearOptimisticTxPrepareFuture.this.tx.timeout() + ", tx=" + GridNearOptimisticTxPrepareFuture.this.tx + ']', deadlock != null ? new TransactionDeadlockException(deadlock.toString(GridNearOptimisticTxPrepareFuture.this.cctx)) : null);
                    }
                    GridNearOptimisticTxPrepareFuture.this.onDone(null, (Throwable)e);
                    return null;
                }
            }, this.cctx.tm().detectDeadlock(this.tx, keys)));
        } else {
            ERR_UPD.compareAndSet(this, null, new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + this.tx.timeout() + ", tx=" + this.tx + ']'));
            this.onComplete();
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
            }
        }, new P1<IgniteInternalFuture<GridNearTxPrepareResponse>>(){

            @Override
            public boolean apply(IgniteInternalFuture<GridNearTxPrepareResponse> fut) {
                return GridNearOptimisticTxPrepareFuture.this.isMini(fut);
            }
        });
        return S.toString(GridNearOptimisticTxPrepareFuture.class, this, "innerFuts", futs, "keyLockFut", (Object)this.keyLockFut, "tx", this.tx, "super", super.toString());
    }

    private static class MiniFuture
    extends GridFutureAdapter<GridNearTxPrepareResponse> {
        private static final long serialVersionUID = 0L;
        private static final AtomicIntegerFieldUpdater<MiniFuture> RCV_RES_UPD = AtomicIntegerFieldUpdater.newUpdater(MiniFuture.class, "rcvRes");
        private final GridNearOptimisticTxPrepareFuture parent;
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        @GridToStringInclude
        private GridDistributedTxMapping m;
        private volatile int rcvRes;
        private Queue<GridDistributedTxMapping> mappings;

        MiniFuture(GridNearOptimisticTxPrepareFuture parent, GridDistributedTxMapping m, Queue<GridDistributedTxMapping> mappings) {
            this.parent = parent;
            this.m = m;
            this.mappings = mappings;
        }

        IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.m.node();
        }

        public GridDistributedTxMapping mapping() {
            return this.m;
        }

        void onResult(Throwable e) {
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
                }
                this.onDone(e);
            } else {
                U.warn(GridNearTxPrepareFutureAdapter.log, "Received error after another result has been processed [fut=" + this.parent + ", mini=" + this + ']', e);
            }
        }

        void onNodeLeft(ClusterTopologyCheckedException e, boolean discoThread) {
            if (GridNearTxPrepareFutureAdapter.msgLog.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.msgLog.debug("Near optimistic prepare fut, mini future node left [txId=" + this.parent.tx.nearXidVersion() + ", node=" + this.m.node().id() + ']');
            }
            if (this.isDone()) {
                return;
            }
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("Remote node left grid while sending or waiting for reply (will not retry): " + this);
                }
                this.parent.onError(e, discoThread);
            }
        }

        void onResult(GridNearTxPrepareResponse res) {
            if (this.isDone()) {
                return;
            }
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (this.parent.cctx.tm().deadlockDetectionEnabled() && (this.parent.tx.remainingTime() == -1L || res.error() instanceof IgniteTxTimeoutCheckedException)) {
                    this.parent.onTimeout();
                    return;
                }
                if (res.error() != null) {
                    this.parent.onError(res.error(), false);
                } else if (res.clientRemapVersion() != null) {
                    assert (this.parent.cctx.kernalContext().clientNode());
                    assert (this.m.clientFirst());
                    IgniteInternalFuture<?> affFut = this.parent.cctx.exchange().affinityReadyFuture(res.clientRemapVersion());
                    if (affFut != null && !affFut.isDone()) {
                        affFut.listen(new CI1<IgniteInternalFuture<?>>(){

                            @Override
                            public void apply(IgniteInternalFuture<?> fut) {
                                try {
                                    fut.get();
                                    MiniFuture.this.remap();
                                }
                                catch (IgniteCheckedException e) {
                                    MiniFuture.this.onDone(e);
                                }
                            }
                        });
                    } else {
                        this.remap();
                    }
                } else {
                    this.parent.onPrepareResponse(this.m, res);
                    if (this.mappings != null) {
                        this.parent.proceedPrepare(this.mappings);
                    }
                    this.onDone((GridNearTxPrepareResponse)null);
                }
            }
        }

        private void remap() {
            this.parent.prepareOnTopology(true, new Runnable(){

                @Override
                public void run() {
                    MiniFuture.this.onDone((GridNearTxPrepareResponse)null);
                }
            });
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }
}

