/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearOptimisticTxPrepareFutureAdapter
extends GridNearTxPrepareFutureAdapter {
    public GridNearOptimisticTxPrepareFutureAdapter(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.optimistic()) : tx;
    }

    @Override
    public final void prepare() {
        long threadId = Thread.currentThread().getId();
        AffinityTopologyVersion topVer = this.cctx.mvcc().lastExplicitLockTopologyVersion(threadId);
        if (topVer == null && this.tx.system() && (topVer = this.cctx.tm().lockedTopologyVersion(threadId, this.tx)) == null) {
            topVer = this.tx.topologyVersionSnapshot();
        }
        if (topVer != null) {
            this.tx.topologyVersion(topVer);
            this.cctx.mvcc().addFuture(this);
            this.prepare0(false, true);
            return;
        }
        this.prepareOnTopology(false, null);
    }

    protected final GridDhtTopologyFuture topologyReadLock() {
        return this.tx.txState().topologyReadLock(this.cctx, this);
    }

    protected final void topologyReadUnlock() {
        this.tx.txState().topologyReadUnlock(this.cctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void prepareOnTopology(final boolean remap, final @Nullable Runnable c) {
        GridDhtTopologyFuture topFut = this.topologyReadLock();
        AffinityTopologyVersion topVer = null;
        try {
            if (topFut == null) {
                assert (this.isDone());
                return;
            }
            if (topFut.isDone()) {
                topVer = topFut.topologyVersion();
                if (remap) {
                    this.tx.onRemap(topVer);
                } else {
                    this.tx.topologyVersion(topVer);
                }
                if (!remap) {
                    this.cctx.mvcc().addFuture(this);
                }
            }
        }
        finally {
            this.topologyReadUnlock();
        }
        if (topVer != null) {
            IgniteCheckedException err = this.tx.txState().validateTopology(this.cctx, topFut);
            if (err != null) {
                this.onDone(err);
                return;
            }
            this.prepare0(remap, false);
            if (c != null) {
                c.run();
            }
        } else {
            topFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(final IgniteInternalFuture<AffinityTopologyVersion> fut) {
                    GridNearOptimisticTxPrepareFutureAdapter.this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                fut.get();
                                GridNearOptimisticTxPrepareFutureAdapter.this.prepareOnTopology(remap, c);
                            }
                            catch (IgniteCheckedException e) {
                                GridNearOptimisticTxPrepareFutureAdapter.this.onDone(e);
                            }
                            finally {
                                GridNearOptimisticTxPrepareFutureAdapter.this.cctx.txContextReset();
                            }
                        }
                    });
                }
            });
        }
    }

    protected abstract void prepare0(boolean var1, boolean var2);

    protected static class KeyLockFuture
    extends GridFutureAdapter<GridNearTxPrepareResponse> {
        @GridToStringInclude
        protected Collection<IgniteTxKey> lockKeys = new GridConcurrentHashSet<IgniteTxKey>();
        private volatile boolean allKeysAdded;

        protected KeyLockFuture() {
        }

        protected void addLockKey(IgniteTxKey key) {
            assert (!this.allKeysAdded);
            this.lockKeys.add(key);
        }

        protected void onKeyLocked(IgniteTxKey key) {
            this.lockKeys.remove(key);
            this.checkLocks();
        }

        protected void onAllKeysAdded() {
            this.allKeysAdded = true;
            this.checkLocks();
        }

        private boolean checkLocks() {
            boolean locked = this.lockKeys.isEmpty();
            if (locked && this.allKeysAdded) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("All locks are acquired for near prepare future: " + this);
                }
                this.onDone((GridNearTxPrepareResponse)null);
            } else if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.log.debug("Still waiting for locks [fut=" + this + ", keys=" + this.lockKeys + ']');
            }
            return locked;
        }

        @Override
        public String toString() {
            return S.toString(KeyLockFuture.class, this, super.toString());
        }
    }
}

