/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridNearPessimisticTxPrepareFuture
extends GridNearTxPrepareFutureAdapter {
    public GridNearPessimisticTxPrepareFuture(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.pessimistic()) : tx;
    }

    @Override
    protected boolean ignoreFailure(Throwable err) {
        return IgniteCheckedException.class.isAssignableFrom(err.getClass());
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f = (MiniFuture)fut;
            if (!f.node().id().equals(nodeId)) continue;
            ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Remote node left grid: " + nodeId);
            e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
            f.onNodeLeft(e);
            found = true;
        }
        return found;
    }

    @Override
    public void onResult(UUID nodeId, GridNearTxPrepareResponse res) {
        if (!this.isDone()) {
            assert (res.clientRemapVersion() == null) : res;
            MiniFuture f = this.miniFuture(res.miniId());
            if (f != null) {
                assert (f.node().id().equals(nodeId));
                f.onResult(res);
            } else if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near pessimistic prepare, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near pessimistic prepare, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(IgniteUuid miniId) {
        Object object = this.sync;
        synchronized (object) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                MiniFuture mini = (MiniFuture)this.future(i);
                if (!mini.futureId().equals(miniId)) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void prepare() {
        if (!this.tx.state(TransactionState.PREPARING)) {
            if (this.tx.setRollbackOnly()) {
                if (this.tx.remainingTime() == -1L) {
                    this.onDone(new IgniteTxTimeoutCheckedException("Transaction timed out and was rolled back: " + this.tx));
                } else {
                    this.onDone(new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'));
                }
            } else {
                this.onDone(new IgniteTxRollbackCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'));
            }
            return;
        }
        try {
            this.tx.userPrepare();
            this.cctx.mvcc().addFuture(this);
            this.preparePessimistic();
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }

    private void preparePessimistic() {
        HashMap<IgniteBiTuple<ClusterNode, Boolean>, GridDistributedTxMapping> mappings = new HashMap<IgniteBiTuple<ClusterNode, Boolean>, GridDistributedTxMapping>();
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        this.txMapping = new GridDhtTxMapping();
        for (IgniteTxEntry txEntry : this.tx.allEntries()) {
            txEntry.clearEntryReadVersion();
            GridCacheContext<?, ?> cacheCtx = txEntry.context();
            List<ClusterNode> nodes = cacheCtx.isLocal() ? cacheCtx.affinity().nodesByKey(txEntry.key(), topVer) : cacheCtx.topology().nodes(cacheCtx.affinity().partition(txEntry.key()), topVer);
            ClusterNode primary = F.first(nodes);
            boolean near = cacheCtx.isNear();
            IgniteBiTuple<ClusterNode, Boolean> key = F.t(primary, near);
            GridDistributedTxMapping nodeMapping = (GridDistributedTxMapping)mappings.get(key);
            if (nodeMapping == null) {
                nodeMapping = new GridDistributedTxMapping(primary);
                nodeMapping.near(cacheCtx.isNear());
                mappings.put(key, nodeMapping);
            }
            txEntry.nodeId(primary.id());
            nodeMapping.add(txEntry);
            this.txMapping.addMapping(nodes);
        }
        this.tx.transactionNodes(this.txMapping.transactionNodes());
        this.checkOnePhase();
        long timeout = this.tx.remainingTime();
        if (timeout == -1L) {
            this.onDone(new IgniteTxTimeoutCheckedException("Transaction timed out and was rolled back: " + this.tx));
        }
        for (GridDistributedTxMapping m : mappings.values()) {
            ClusterNode node = m.node();
            GridNearTxPrepareRequest req = new GridNearTxPrepareRequest(this.futId, this.tx.topologyVersion(), this.tx, timeout, m.reads(), m.writes(), m.near(), this.txMapping.transactionNodes(), true, this.tx.onePhaseCommit(), this.tx.needReturnValue() && this.tx.implicit(), this.tx.implicitSingle(), m.explicitLock(), this.tx.subjectId(), this.tx.taskNameHash(), false, this.tx.activeCachesDeploymentEnabled());
            for (IgniteTxEntry txEntry : m.entries()) {
                if (txEntry.op() != GridCacheOperation.TRANSFORM) continue;
                req.addDhtVersion(txEntry.txKey(), null);
            }
            final MiniFuture fut = new MiniFuture(m);
            req.miniId(fut.futureId());
            this.add(fut);
            if (node.isLocal()) {
                IgniteInternalFuture<GridNearTxPrepareResponse> prepFut = this.cctx.tm().txHandler().prepareTx(node.id(), this.tx, req);
                prepFut.listen((IgniteInClosure<IgniteInternalFuture<GridNearTxPrepareResponse>>)new CI1<IgniteInternalFuture<GridNearTxPrepareResponse>>(){

                    @Override
                    public void apply(IgniteInternalFuture<GridNearTxPrepareResponse> prepFut) {
                        try {
                            fut.onResult(prepFut.get());
                        }
                        catch (IgniteCheckedException e) {
                            fut.onError(e);
                        }
                    }
                });
                continue;
            }
            try {
                this.cctx.io().send(node, (GridCacheMessage)req, this.tx.ioPolicy());
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("Near pessimistic prepare, sent request [txId=" + this.tx.nearXidVersion() + ", node=" + node.id() + ']');
            }
            catch (ClusterTopologyCheckedException e) {
                e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(topVer));
                fut.onNodeLeft(e);
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near pessimistic prepare, failed send request [txId=" + this.tx.nearXidVersion() + ", node=" + node.id() + ", err=" + e + ']');
                }
                fut.onError(e);
                break;
            }
        }
        this.markInitialized();
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        return false;
    }

    @Override
    public boolean onDone(@Nullable IgniteInternalTx res, @Nullable Throwable err) {
        if (err != null) {
            ERR_UPD.compareAndSet(this, null, err);
        }
        if ((err = this.err) == null || this.tx.needCheckBackup()) {
            this.tx.state(TransactionState.PREPARED);
        }
        if (super.onDone(this.tx, err)) {
            this.cctx.mvcc().removeMvccFuture(this);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearPessimisticTxPrepareFuture.class, this, "innerFuts", futs, "super", super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<GridNearTxPrepareResponse> {
        private static final long serialVersionUID = 0L;
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        private GridDistributedTxMapping m;

        MiniFuture(GridDistributedTxMapping m) {
            this.m = m;
        }

        IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.m.node();
        }

        void onResult(GridNearTxPrepareResponse res) {
            if (res.error() != null) {
                this.onError(res.error());
            } else {
                GridNearPessimisticTxPrepareFuture.this.onPrepareResponse(this.m, res);
                this.onDone(res);
            }
        }

        void onNodeLeft(ClusterTopologyCheckedException e) {
            if (GridNearTxPrepareFutureAdapter.msgLog.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.msgLog.debug("Near pessimistic prepare, mini future node left [txId=" + GridNearPessimisticTxPrepareFuture.this.tx.nearXidVersion() + ", nodeId=" + this.m.node().id() + ']');
            }
            if (GridNearPessimisticTxPrepareFuture.this.tx.onePhaseCommit()) {
                GridNearPessimisticTxPrepareFuture.this.tx.markForBackupCheck();
                this.onDone((GridNearTxPrepareResponse)null);
            }
            this.onError(e);
        }

        void onError(Throwable e) {
            if (this.isDone()) {
                U.warn(GridNearTxPrepareFutureAdapter.log, "Received error when future is done [fut=" + this + ", err=" + e + ", tx=" + GridNearPessimisticTxPrepareFuture.this.tx + ']');
                return;
            }
            if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.log.debug("Error on tx prepare [fut=" + this + ", err=" + e + ", tx=" + GridNearPessimisticTxPrepareFuture.this.tx + ']');
            }
            if (GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(GridNearPessimisticTxPrepareFuture.this, null, e)) {
                GridNearPessimisticTxPrepareFuture.this.tx.setRollbackOnly();
            }
            this.onDone(e);
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }
}

