/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedUnlockRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLockRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtUnlockRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxRemote;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearUnlockRequest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridNearTransactionalCache<K, V>
extends GridNearCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private GridDhtCache<K, V> dht;

    public GridNearTransactionalCache() {
    }

    public GridNearTransactionalCache(GridCacheContext<K, V> ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.ctx.io().addHandler(this.ctx.cacheId(), GridNearGetResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearGetResponse>(){

            @Override
            public void apply(UUID nodeId, GridNearGetResponse res) {
                GridNearTransactionalCache.this.processGetResponse(nodeId, res);
            }
        });
        this.ctx.io().addHandler(this.ctx.cacheId(), GridNearLockResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearLockResponse>(){

            @Override
            public void apply(UUID nodeId, GridNearLockResponse res) {
                GridNearTransactionalCache.this.processLockResponse(nodeId, res);
            }
        });
    }

    public void dht(GridDhtCache<K, V> dht) {
        this.dht = dht;
    }

    @Override
    public GridDhtCache<K, V> dht() {
        return this.dht;
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(final @Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, String taskName, final boolean deserializeBinary, final boolean skipVals, boolean canRemap, final boolean needVer) {
        boolean skipStore;
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture(Collections.emptyMap());
        }
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        IgniteTxLocalAdapter tx = (IgniteTxLocalAdapter)this.ctx.tm().threadLocalTx(this.ctx);
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        boolean bl = skipStore = opCtx != null && opCtx.skipStore();
        if (tx != null && !tx.implicit() && !skipTx) {
            return this.asyncOp(tx, new GridCacheAdapter.AsyncOp<Map<K, V>>(keys){

                @Override
                public IgniteInternalFuture<Map<K, V>> op(IgniteTxLocalAdapter tx, AffinityTopologyVersion readyTopVer) {
                    return tx.getAllAsync(GridNearTransactionalCache.this.ctx, readyTopVer, GridNearTransactionalCache.this.ctx.cacheKeysView(keys), deserializeBinary, skipVals, false, skipStore, needVer);
                }
            }, opCtx);
        }
        subjId = this.ctx.subjectIdPerCall(subjId, opCtx);
        return this.loadAsync(null, this.ctx.cacheKeysView(keys), forcePrimary, subjId, taskName, deserializeBinary, skipVals ? null : (opCtx != null ? opCtx.expiry() : null), skipVals, skipStore, canRemap, needVer);
    }

    IgniteInternalFuture<Map<K, V>> txLoadAsync(GridNearTxLocal tx, AffinityTopologyVersion topVer, @Nullable Collection<KeyCacheObject> keys, boolean readThrough, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer) {
        assert (tx != null);
        GridNearGetFuture fut = new GridNearGetFuture(this.ctx, keys, readThrough, needVer || !this.ctx.config().isReadFromBackup(), tx, CU.subjectId(tx, this.ctx.shared()), tx.resolveTaskName(), deserializeBinary, expiryPlc, skipVals, true, needVer, true);
        fut.init(topVer);
        return fut;
    }

    public void clearLocks(UUID nodeId, GridDhtUnlockRequest req) {
        assert (nodeId != null);
        GridCacheVersion obsoleteVer = this.ctx.versions().next();
        List<KeyCacheObject> keys = req.nearKeys();
        if (keys != null) {
            AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
            block2: for (KeyCacheObject key : keys) {
                while (true) {
                    GridNearCacheEntry entry = this.peekExx(key);
                    try {
                        if (entry != null) {
                            entry.doneRemote(req.version(), req.version(), null, req.committedVersions(), req.rolledbackVersions(), false);
                            if (entry.removeLock(req.version())) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Removed lock [lockId=" + req.version() + ", key=" + key + ']');
                                }
                                this.evictNearEntry(entry, obsoleteVer, topVer);
                            } else if (this.log.isDebugEnabled()) {
                                this.log.debug("Received unlock request for unknown candidate (added to cancelled locks set): " + req);
                            }
                            this.ctx.evicts().touch(entry, topVer);
                            continue block2;
                        }
                        if (!this.log.isDebugEnabled()) continue block2;
                        this.log.debug("Received unlock request for entry that could not be found: " + req);
                        continue block2;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Received remove lock request for removed entry (will retry) [entry=" + entry + ", req=" + req + ']');
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Nullable
    public GridNearTxRemote startRemoteTx(UUID nodeId, GridDhtLockRequest req) throws IgniteCheckedException, GridDistributedLockCancelledException {
        List<KeyCacheObject> nearKeys = req.nearKeys();
        GridNearTxRemote tx = null;
        ClassLoader ldr = this.ctx.deploy().globalLoader();
        if (ldr != null) {
            LinkedList<IgniteTxKey> evicted = null;
            block2: for (int i = 0; i < nearKeys.size(); ++i) {
                KeyCacheObject key = nearKeys.get(i);
                if (key == null) continue;
                IgniteTxKey txKey = this.ctx.txKey(key);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unmarshalled key: " + key);
                }
                GridNearCacheEntry entry = null;
                while (true) {
                    try {
                        entry = this.peekExx(key);
                        if (entry != null) {
                            if (req.inTx()) {
                                tx = (GridNearTxRemote)this.ctx.tm().nearTx(req.version());
                                if (tx == null) {
                                    tx = new GridNearTxRemote(this.ctx.shared(), req.topologyVersion(), nodeId, req.nearNodeId(), req.nearXidVersion(), req.version(), null, this.ctx.systemTx(), this.ctx.ioPolicy(), TransactionConcurrency.PESSIMISTIC, req.isolation(), req.isInvalidate(), req.timeout(), req.txSize(), req.subjectId(), req.taskNameHash());
                                    tx = this.ctx.tm().onCreated(null, tx);
                                    if (tx == null || !this.ctx.tm().onStarted(tx)) {
                                        throw new IgniteTxRollbackCheckedException("Failed to acquire lock (transaction has been completed): " + req.version());
                                    }
                                }
                                tx.addEntry(this.ctx, txKey, GridCacheOperation.NOOP, null, null, req.skipStore(), req.keepBinary());
                            }
                            entry.addRemote(req.nodeId(), nodeId, req.threadId(), req.version(), tx != null, tx != null && tx.implicitSingle(), req.owned(entry.key()));
                            if (!req.inTx()) {
                                this.ctx.evicts().touch(entry, req.topologyVersion());
                            }
                        } else {
                            if (evicted == null) {
                                evicted = new LinkedList<IgniteTxKey>();
                            }
                            evicted.add(txKey);
                        }
                        if (this.ctx.discovery().node(req.nodeId()) != null) continue block2;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Node requesting lock left grid (lock request will be ignored): " + req);
                        }
                        if (tx != null) {
                            tx.rollback();
                        }
                        return null;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        assert (entry.obsoleteVersion() != null) : "Obsolete flag not set on removed entry: " + entry;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Received entry removed exception (will retry on renewed entry): " + entry);
                        }
                        if (tx == null) continue;
                        tx.clearEntry(txKey);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Cleared removed entry from remote transaction (will retry) [entry=" + entry + ", tx=" + tx + ']');
                        continue;
                    }
                    break;
                }
            }
            if (tx != null && evicted != null) {
                assert (!evicted.isEmpty());
                for (IgniteTxKey evict : evicted) {
                    tx.addEvicted(evict);
                }
            }
        } else {
            String err = "Failed to acquire deployment class loader for message: " + req;
            U.warn(this.log, err);
            throw new IgniteCheckedException(err);
        }
        return tx;
    }

    private void processLockResponse(UUID nodeId, GridNearLockResponse res) {
        assert (nodeId != null);
        assert (res != null);
        GridNearLockFuture fut = (GridNearLockFuture)this.ctx.mvcc().mvccFuture(res.version(), res.futureId());
        if (fut != null) {
            fut.onResult(nodeId, res);
        }
    }

    @Override
    protected IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isInvalidate, boolean isRead, boolean retval, TransactionIsolation isolation, long createTtl, long accessTtl) {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        GridNearLockFuture fut = new GridNearLockFuture(this.ctx, keys, (GridNearTxLocal)tx, isRead, retval, timeout, createTtl, accessTtl, CU.empty0(), opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary());
        if (!this.ctx.mvcc().addFuture(fut)) {
            throw new IllegalStateException("Duplicate future ID: " + fut);
        }
        fut.map();
        return fut;
    }

    protected boolean isNearLocallyMapped(GridCacheEntryEx e, AffinityTopologyVersion topVer) {
        return this.ctx.affinity().partitionBelongs(this.ctx.localNode(), e.partition(), topVer);
    }

    protected boolean evictNearEntry(GridCacheEntryEx e, GridCacheVersion obsoleteVer, AffinityTopologyVersion topVer) {
        assert (e != null);
        assert (obsoleteVer != null);
        if (this.isNearLocallyMapped(e, topVer)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Evicting dht-local entry from near cache [entry=" + e + ", tx=" + this + ']');
            }
            if (e.markObsolete(obsoleteVer)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void unlockAll(Collection<? extends K> keys) {
        if (keys.isEmpty()) {
            return;
        }
        try {
            GridCacheVersion ver = null;
            int keyCnt = -1;
            HashMap<ClusterNode, GridNearUnlockRequest> map = null;
            LinkedList<KeyCacheObject> locKeys = new LinkedList<KeyCacheObject>();
            block4: for (K k : keys) {
                KeyCacheObject cacheKey;
                GridNearCacheEntry entry;
                while ((entry = this.peekExx(cacheKey = this.ctx.toCacheKeyObject(k))) != null) {
                    try {
                        GridCacheMvccCandidate cand = entry.candidate(this.ctx.nodeId(), Thread.currentThread().getId());
                        AffinityTopologyVersion topVer = AffinityTopologyVersion.NONE;
                        if (cand != null) {
                            GridCacheMvccCandidate rmv;
                            assert (cand.nearLocal()) : "Got non-near-local candidate in near cache: " + cand;
                            ver = cand.version();
                            if (map == null) {
                                Collection<ClusterNode> affNodes = CU.allNodes(this.ctx, cand.topologyVersion());
                                if (F.isEmpty(affNodes)) {
                                    return;
                                }
                                keyCnt = (int)Math.ceil((double)keys.size() / (double)affNodes.size());
                                map = U.newHashMap(affNodes.size());
                            }
                            topVer = cand.topologyVersion();
                            ClusterNode primary = this.ctx.affinity().primaryByKey(k, topVer);
                            if (primary == null) {
                                if (!this.log.isDebugEnabled()) continue block4;
                                this.log.debug("Failed to unlock key (all partition nodes left the grid).");
                                continue block4;
                            }
                            GridNearUnlockRequest req = (GridNearUnlockRequest)map.get(primary);
                            if (req == null) {
                                req = new GridNearUnlockRequest(this.ctx.cacheId(), keyCnt, this.ctx.deploymentEnabled());
                                map.put(primary, req);
                                req.version(ver);
                            }
                            if ((rmv = ((GridDistributedCacheEntry)entry).removeLock()) != null) {
                                if (!rmv.reentry()) {
                                    if (ver != null && !ver.equals(rmv.version())) {
                                        throw new IgniteCheckedException("Failed to unlock (if keys were locked separately, then they need to be unlocked separately): " + keys);
                                    }
                                    if (!primary.isLocal()) {
                                        assert (req != null);
                                        req.addKey(entry.key(), this.ctx);
                                    } else {
                                        locKeys.add(cacheKey);
                                    }
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Removed lock (will distribute): " + rmv);
                                    }
                                } else if (this.log.isDebugEnabled()) {
                                    this.log.debug("Current thread still owns lock (or there are no other nodes) [lock=" + rmv + ", curThreadId=" + Thread.currentThread().getId() + ']');
                                }
                            }
                        }
                        assert (!topVer.equals(AffinityTopologyVersion.NONE) || cand == null);
                        if (topVer.equals(AffinityTopologyVersion.NONE)) {
                            topVer = this.ctx.affinity().affinityTopologyVersion();
                        }
                        this.ctx.evicts().touch(entry, topVer);
                        continue block4;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Attempted to unlock removed entry (will retry): " + entry);
                    }
                }
            }
            if (ver == null) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                ClusterNode n = (ClusterNode)entry.getKey();
                GridDistributedUnlockRequest req = (GridDistributedUnlockRequest)entry.getValue();
                if (n.isLocal()) {
                    this.dht.removeLocks(this.ctx.nodeId(), req.version(), locKeys, true);
                    continue;
                }
                if (F.isEmpty(req.keys())) continue;
                this.ctx.io().send(n, (GridCacheMessage)req, this.ctx.ioPolicy());
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to unlock the lock for keys: " + keys, ex);
        }
    }

    public void removeLocks(GridCacheVersion ver, Collection<KeyCacheObject> keys) {
        if (keys.isEmpty()) {
            return;
        }
        try {
            int keyCnt = -1;
            HashMap<ClusterNode, GridNearUnlockRequest> map = null;
            block4: for (KeyCacheObject key : keys) {
                GridNearUnlockRequest req = null;
                while (true) {
                    GridNearCacheEntry entry = this.peekExx(key);
                    try {
                        ClusterNode primary;
                        GridCacheMvccCandidate cand;
                        if (entry == null || (cand = entry.candidate(ver)) == null) continue block4;
                        if (map == null) {
                            Collection<ClusterNode> affNodes = CU.allNodes(this.ctx, cand.topologyVersion());
                            if (F.isEmpty(affNodes)) {
                                return;
                            }
                            keyCnt = (int)Math.ceil((double)keys.size() / (double)affNodes.size());
                            map = U.newHashMap(affNodes.size());
                        }
                        if ((primary = this.ctx.affinity().primaryByKey(key, cand.topologyVersion())) == null) {
                            if (!this.log.isDebugEnabled()) continue block4;
                            this.log.debug("Failed to unlock key (all partition nodes left the grid).");
                            continue block4;
                        }
                        if (!primary.isLocal() && (req = (GridNearUnlockRequest)map.get(primary)) == null) {
                            req = new GridNearUnlockRequest(this.ctx.cacheId(), keyCnt, this.ctx.deploymentEnabled());
                            map.put(primary, req);
                            req.version(ver);
                        }
                        if (!entry.removeLock(cand.version())) continue block4;
                        if (primary.isLocal()) {
                            this.dht.removeLocks(primary.id(), ver, F.asList(key), true);
                            assert (req == null);
                            continue;
                        }
                        req.addKey(entry.key(), this.ctx);
                        continue block4;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Attempted to remove lock from removed entry (will retry) [rmvVer=" + ver + ", entry=" + entry + ']');
                        continue;
                    }
                    break;
                }
            }
            if (map == null || map.isEmpty()) {
                return;
            }
            IgnitePair<Collection<GridCacheVersion>> versPair = this.ctx.tm().versions(ver);
            Collection committed = (Collection)versPair.get1();
            Collection rolledback = (Collection)versPair.get2();
            for (Map.Entry mapping : map.entrySet()) {
                ClusterNode n = (ClusterNode)mapping.getKey();
                GridDistributedUnlockRequest req = (GridDistributedUnlockRequest)mapping.getValue();
                if (F.isEmpty(req.keys())) continue;
                req.completedVersions(committed, rolledback);
                this.ctx.io().send(n, (GridCacheMessage)req, this.ctx.ioPolicy());
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to unlock the lock for keys: " + keys, ex);
        }
    }

    @Override
    public void onDeferredDelete(GridCacheEntryEx entry, GridCacheVersion ver) {
        assert (false) : "Should not be called";
    }

    @Override
    public String toString() {
        return S.toString(GridNearTransactionalCache.class, this);
    }
}

