/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.util.future.GridCompoundIdentityFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.apache.ignite.transactions.TransactionState;

public final class GridNearTxFinishFuture<K, V>
extends GridCompoundIdentityFuture<IgniteInternalTx>
implements GridCacheFuture<IgniteInternalTx> {
    public static final IgniteProductVersion FINISH_NEAR_ONE_PHASE_SINCE = IgniteProductVersion.fromString("1.4.0");
    public static final IgniteProductVersion WAIT_REMOTE_TXS_SINCE = IgniteProductVersion.fromString("1.5.1");
    public static final IgniteProductVersion PRIMARY_SYNC_TXS_SINCE = IgniteProductVersion.fromString("1.6.0");
    public static final IgniteProductVersion ACK_DHT_ONE_PHASE_SINCE = IgniteProductVersion.fromString("1.6.8");
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    protected static IgniteLogger msgLog;
    private GridCacheSharedContext<K, V> cctx;
    private final IgniteUuid futId;
    @GridToStringInclude
    private GridNearTxLocal tx;
    private boolean commit;
    private IgniteTxMappings mappings;
    private boolean trackable = true;
    private boolean finishOnePhaseCalled;

    public GridNearTxFinishFuture(GridCacheSharedContext<K, V> cctx, GridNearTxLocal tx, boolean commit) {
        super(F.identityReducer(tx));
        this.cctx = cctx;
        this.tx = tx;
        this.commit = commit;
        this.ignoreInterrupts(true);
        this.mappings = tx.mappings();
        this.futId = IgniteUuid.randomUuid();
        CacheWriteSynchronizationMode syncMode = tx.explicitLock() ? CacheWriteSynchronizationMode.FULL_SYNC : tx.syncMode();
        tx.syncMode(syncMode);
        if (log == null) {
            msgLog = cctx.txFinishMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridNearTxFinishFuture.class);
        }
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MinFuture f;
            if (!this.isMini(fut) || !(f = (MinFuture)fut).onNodeLeft(nodeId, true)) continue;
            this.mappings.remove(nodeId);
            found = true;
        }
        return found;
    }

    public GridNearTxLocal tx() {
        return this.tx;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(UUID nodeId, GridNearTxFinishResponse res) {
        if (!this.isDone()) {
            FinishMiniFuture finishFut = null;
            Object object = this.sync;
            synchronized (object) {
                int size = this.futuresCountNoLock();
                for (int i = 0; i < size; ++i) {
                    FinishMiniFuture f;
                    IgniteInternalFuture fut = this.future(i);
                    if (fut.getClass() != FinishMiniFuture.class || !(f = (FinishMiniFuture)fut).futureId().equals(res.miniId())) continue;
                    assert (f.node().id().equals(nodeId));
                    finishFut = f;
                    break;
                }
            }
            if (finishFut != null) {
                finishFut.onNearFinishResponse(res);
            } else if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near finish fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    public void onResult(UUID nodeId, GridDhtTxFinishResponse res) {
        if (!this.isDone()) {
            boolean found = false;
            for (IgniteInternalFuture fut : this.futures()) {
                MinFuture f;
                if (fut.getClass() == CheckBackupMiniFuture.class) {
                    f = (CheckBackupMiniFuture)fut;
                    if (!f.futureId().equals(res.miniId())) continue;
                    found = true;
                    assert (((CheckBackupMiniFuture)f).node().id().equals(nodeId));
                    if (res.returnValue() != null) {
                        this.tx.implicitSingleResult(res.returnValue());
                    }
                    ((CheckBackupMiniFuture)f).onDhtFinishResponse(res);
                    continue;
                }
                if (fut.getClass() != CheckRemoteTxMiniFuture.class || !(f = (CheckRemoteTxMiniFuture)fut).futureId().equals(res.miniId())) continue;
                ((CheckRemoteTxMiniFuture)f).onDhtFinishResponse(nodeId, false);
            }
            if (!found && msgLog.isDebugEnabled()) {
                msgLog.debug("Near finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near finish fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onDone(IgniteInternalTx tx0, Throwable err) {
        if (this.isDone()) {
            return false;
        }
        GridNearTxFinishFuture gridNearTxFinishFuture = this;
        synchronized (gridNearTxFinishFuture) {
            if (this.isDone()) {
                return false;
            }
            if (err != null) {
                this.tx.setRollbackOnly();
            }
            if (this.commit) {
                if (this.tx.commitError() != null) {
                    err = this.tx.commitError();
                } else if (err != null) {
                    this.tx.commitError(err);
                }
            }
            if (this.initialized() || err != null) {
                block25: {
                    if (this.tx.needCheckBackup()) {
                        assert (this.tx.onePhaseCommit());
                        if (err != null) {
                            err = new TransactionRollbackException("Failed to commit transaction.", err);
                        }
                        try {
                            this.tx.finish(err == null);
                        }
                        catch (IgniteCheckedException e) {
                            if (err != null) {
                                err.addSuppressed(e);
                            }
                            err = e;
                        }
                    }
                    if (this.tx.onePhaseCommit()) {
                        boolean commit = this.commit && err == null;
                        this.finishOnePhase(commit);
                        try {
                            this.tx.tmFinish(commit);
                        }
                        catch (IgniteCheckedException e) {
                            U.error(log, "Failed to finish tx: " + this.tx, e);
                            if (err != null) break block25;
                            err = e;
                        }
                    }
                }
                if (super.onDone(tx0, err)) {
                    if (this.error() instanceof IgniteTxHeuristicCheckedException) {
                        AffinityTopologyVersion topVer = this.tx.topologyVersion();
                        for (IgniteTxEntry e : this.tx.writeMap().values()) {
                            GridCacheContext<?, ?> cacheCtx = e.context();
                            try {
                                GridCacheEntryEx entry;
                                if (e.op() == GridCacheOperation.NOOP || cacheCtx.affinity().keyLocalNode(e.key(), topVer) || (entry = cacheCtx.cache().peekEx(e.key())) == null) continue;
                                entry.invalidate(null, this.tx.xidVersion());
                            }
                            catch (Throwable t) {
                                U.error(log, "Failed to invalidate entry.", t);
                                if (!(t instanceof Error)) continue;
                                throw (Error)t;
                            }
                        }
                    }
                    this.cctx.mvcc().removeFuture(this.futId);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isMini(IgniteInternalFuture<?> fut) {
        return fut.getClass() == FinishMiniFuture.class || fut.getClass() == CheckBackupMiniFuture.class || fut.getClass() == CheckRemoteTxMiniFuture.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(boolean commit) {
        if (this.tx.onNeedCheckBackup()) {
            assert (this.tx.onePhaseCommit());
            this.checkBackup();
            this.markInitialized();
            return;
        }
        try {
            if (this.tx.finish(commit) || !commit && this.tx.state() == TransactionState.UNKNOWN) {
                if (this.tx.onePhaseCommit() && this.needFinishOnePhase(commit) || !this.tx.onePhaseCommit() && this.mappings != null) {
                    if (this.mappings.single()) {
                        GridDistributedTxMapping mapping = this.mappings.singleMapping();
                        if (mapping != null) {
                            this.finish(mapping, commit);
                        }
                    } else {
                        this.finish(this.mappings.mappings(), commit);
                    }
                }
                this.markInitialized();
            } else {
                this.onDone(new IgniteCheckedException("Failed to commit transaction: " + CU.txString(this.tx)));
            }
        }
        catch (Error | RuntimeException e) {
            this.onDone(e);
            throw e;
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
        finally {
            if (commit && this.tx.onePhaseCommit() && !this.tx.writeMap().isEmpty()) {
                this.ackBackup();
            }
        }
    }

    private void ackBackup() {
        if (this.mappings.empty()) {
            return;
        }
        if (!this.tx.needReturnValue() || !this.tx.implicit()) {
            return;
        }
        GridDistributedTxMapping mapping = this.mappings.singleMapping();
        if (mapping != null) {
            UUID nodeId = mapping.node().id();
            Collection<UUID> backups = this.tx.transactionNodes().get(nodeId);
            if (!F.isEmpty(backups)) {
                assert (backups.size() == 1) : backups;
                UUID backupId = F.first(backups);
                ClusterNode backup = this.cctx.discovery().node(backupId);
                if (backup != null) {
                    if (backup.isLocal()) {
                        this.cctx.tm().removeTxReturn(this.tx.xidVersion());
                    } else if (ACK_DHT_ONE_PHASE_SINCE.compareToIgnoreTimestamp(backup.version()) <= 0) {
                        this.cctx.tm().sendDeferredAckResponse(backupId, this.tx.xidVersion());
                    }
                }
            }
        }
    }

    private void checkBackup() {
        block25: {
            GridDistributedTxMapping mapping = this.mappings.singleMapping();
            if (mapping != null) {
                UUID nodeId = mapping.node().id();
                Collection<UUID> backups = this.tx.transactionNodes().get(nodeId);
                if (!F.isEmpty(backups)) {
                    assert (backups.size() == 1);
                    UUID backupId = F.first(backups);
                    ClusterNode backup = this.cctx.discovery().node(backupId);
                    if (backup == null) {
                        this.readyNearMappingFromBackup(mapping);
                        ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Backup node left grid: " + backupId);
                        cause.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                        this.onDone(new IgniteTxRollbackCheckedException("Failed to commit transaction (backup has left grid): " + this.tx.xidVersion(), cause));
                    } else {
                        final CheckBackupMiniFuture mini = new CheckBackupMiniFuture(backup, mapping);
                        this.add(mini);
                        if (backup.isLocal()) {
                            boolean committed = !this.cctx.tm().addRolledbackTx(this.tx);
                            this.readyNearMappingFromBackup(mapping);
                            if (committed) {
                                try {
                                    if (this.tx.needReturnValue() && this.tx.implicit()) {
                                        GridCacheReturnCompletableWrapper wrapper = this.cctx.tm().getCommittedTxReturn(this.tx.xidVersion());
                                        assert (wrapper != null) : this.tx.xidVersion();
                                        GridCacheReturn retVal = wrapper.fut().get();
                                        assert (retVal != null);
                                        this.tx.implicitSingleResult(retVal);
                                    }
                                    if (this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC) {
                                        GridCacheVersion nearXidVer = this.tx.nearXidVersion();
                                        assert (nearXidVer != null) : this.tx;
                                        IgniteInternalFuture<?> fut = this.cctx.tm().remoteTxFinishFuture(nearXidVer);
                                        fut.listen(new CI1<IgniteInternalFuture<?>>(){

                                            @Override
                                            public void apply(IgniteInternalFuture<?> fut) {
                                                mini.onDone(GridNearTxFinishFuture.this.tx);
                                            }
                                        });
                                        return;
                                    }
                                    mini.onDone(this.tx);
                                }
                                catch (IgniteCheckedException e) {
                                    if (msgLog.isDebugEnabled()) {
                                        msgLog.debug("Near finish fut, failed to finish [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ", err=" + e + ']');
                                    }
                                    mini.onDone(e);
                                }
                            } else {
                                ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Primary node left grid: " + nodeId);
                                cause.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                                mini.onDone(new IgniteTxRollbackCheckedException("Failed to commit transaction (transaction has been rolled back on backup node): " + this.tx.xidVersion(), cause));
                            }
                        } else {
                            GridDhtTxFinishRequest finishReq = this.checkCommittedRequest(mini.futureId(), false);
                            if (WAIT_REMOTE_TXS_SINCE.compareTo(backup.version()) > 0) {
                                finishReq.syncCommit(true);
                            }
                            try {
                                if (FINISH_NEAR_ONE_PHASE_SINCE.compareTo(backup.version()) <= 0) {
                                    this.cctx.io().send(backup, (GridCacheMessage)finishReq, this.tx.ioPolicy());
                                    if (msgLog.isDebugEnabled()) {
                                        msgLog.debug("Near finish fut, sent check committed request [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ']');
                                    }
                                    break block25;
                                }
                                mini.onDone(new IgniteTxHeuristicCheckedException("Failed to check for tx commit on the backup node (node has an old Ignite version) [rmtNodeId=" + backup.id() + ", ver=" + backup.version() + ']'));
                            }
                            catch (ClusterTopologyCheckedException ignored) {
                                mini.onNodeLeft(backupId, false);
                            }
                            catch (IgniteCheckedException e) {
                                if (msgLog.isDebugEnabled()) {
                                    msgLog.debug("Near finish fut, failed to send check committed request [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ", err=" + e + ']');
                                }
                                mini.onDone(e);
                            }
                        }
                    }
                } else {
                    this.readyNearMappingFromBackup(mapping);
                }
            }
        }
    }

    private boolean needFinishOnePhase(boolean commit) {
        boolean finish;
        if (this.tx.mappings().empty()) {
            return false;
        }
        boolean bl = finish = this.tx.txState().hasNearCache(this.cctx) || !commit;
        if (finish) {
            GridDistributedTxMapping mapping = this.tx.mappings().singleMapping();
            assert (mapping != null) : this.tx;
            if (FINISH_NEAR_ONE_PHASE_SINCE.compareTo(mapping.node().version()) > 0) {
                finish = false;
            }
        }
        return finish;
    }

    private void finishOnePhase(boolean commit) {
        IgniteInternalFuture<IgniteInternalTx> fut;
        assert (Thread.holdsLock(this));
        if (this.finishOnePhaseCalled) {
            return;
        }
        this.finishOnePhaseCalled = true;
        GridDistributedTxMapping locMapping = this.mappings.localMapping();
        if (locMapping != null && (fut = this.cctx.tm().txHandler().finishColocatedLocal(commit, this.tx)) != null) {
            this.add(fut);
        }
    }

    private void readyNearMappingFromBackup(GridDistributedTxMapping mapping) {
        if (mapping.near()) {
            GridCacheVersion xidVer = this.tx.xidVersion();
            mapping.dhtVersion(xidVer, xidVer);
            this.tx.readyNearLocks(mapping, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    private void finish(Iterable<GridDistributedTxMapping> mappings, boolean commit) {
        for (GridDistributedTxMapping m : mappings) {
            this.finish(m, commit);
        }
    }

    private void finish(GridDistributedTxMapping m, boolean commit) {
        ClusterNode n = m.node();
        assert (!m.empty());
        CacheWriteSynchronizationMode syncMode = this.tx.syncMode();
        if (m.explicitLock()) {
            syncMode = CacheWriteSynchronizationMode.FULL_SYNC;
        }
        GridCacheVersion completedVer = !commit && this.tx.timeout() > 0L ? this.tx.xidVersion() : null;
        GridNearTxFinishRequest req = new GridNearTxFinishRequest(this.futId, this.tx.xidVersion(), this.tx.threadId(), commit, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), syncMode, m.explicitLock(), this.tx.storeEnabled(), this.tx.topologyVersion(), completedVer, null, null, this.tx.size(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled());
        if (n.isLocal()) {
            req.miniId(IgniteUuid.randomUuid());
            IgniteInternalFuture<IgniteInternalTx> fut = this.cctx.tm().txHandler().finish(n.id(), this.tx, req);
            if (fut != null && syncMode == CacheWriteSynchronizationMode.FULL_SYNC) {
                this.add(fut);
            }
        } else {
            FinishMiniFuture fut = new FinishMiniFuture(m);
            req.miniId(fut.futureId());
            this.add(fut);
            if (this.tx.pessimistic()) {
                this.cctx.tm().beforeFinishRemote(n.id(), this.tx.threadId());
            }
            try {
                boolean wait;
                this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, sent request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ']');
                }
                if (syncMode == CacheWriteSynchronizationMode.PRIMARY_SYNC) {
                    wait = n.version().compareToIgnoreTimestamp(PRIMARY_SYNC_TXS_SINCE) >= 0;
                } else {
                    boolean bl = wait = syncMode == CacheWriteSynchronizationMode.FULL_SYNC;
                }
                if (!wait) {
                    fut.onDone();
                }
            }
            catch (ClusterTopologyCheckedException ignored) {
                this.mappings.remove(m.node().id());
                fut.onNodeLeft(n.id(), false);
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, failed to send request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ", err=" + e + ']');
                }
                fut.onDone(e);
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (f.getClass() == FinishMiniFuture.class) {
                    FinishMiniFuture fut = (FinishMiniFuture)f;
                    ClusterNode node = fut.node();
                    if (node != null) {
                        return "FinishFuture[node=" + node.id() + ", loc=" + node.isLocal() + ", done=" + fut.isDone() + ']';
                    }
                    return "FinishFuture[node=null, done=" + fut.isDone() + ']';
                }
                if (f.getClass() == CheckBackupMiniFuture.class) {
                    CheckBackupMiniFuture fut = (CheckBackupMiniFuture)f;
                    ClusterNode node = fut.node();
                    if (node != null) {
                        return "CheckBackupFuture[node=" + node.id() + ", loc=" + node.isLocal() + ", done=" + f.isDone() + "]";
                    }
                    return "CheckBackupFuture[node=null, done=" + f.isDone() + "]";
                }
                if (f.getClass() == CheckRemoteTxMiniFuture.class) {
                    CheckRemoteTxMiniFuture fut = (CheckRemoteTxMiniFuture)f;
                    return "CheckRemoteTxMiniFuture[nodes=" + fut.nodes() + ", done=" + f.isDone() + "]";
                }
                return "[loc=true, done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearTxFinishFuture.class, this, "innerFuts", futs, "super", super.toString());
    }

    private GridDhtTxFinishRequest checkCommittedRequest(IgniteUuid miniId, boolean waitRemoteTxs) {
        GridDhtTxFinishRequest finishReq = new GridDhtTxFinishRequest(this.cctx.localNodeId(), this.futureId(), miniId, this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), this.tx.isolation(), true, false, this.tx.system(), this.tx.ioPolicy(), false, this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC, this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC, null, null, null, null, 0, null, 0, this.tx.activeCachesDeploymentEnabled(), !waitRemoteTxs && this.tx.needReturnValue() && this.tx.implicit(), waitRemoteTxs);
        finishReq.checkCommitted(true);
        return finishReq;
    }

    private class CheckRemoteTxMiniFuture
    extends MinFuture {
        private Set<UUID> nodes;

        public CheckRemoteTxMiniFuture(Set<UUID> nodes) {
            this.nodes = nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<UUID> nodes() {
            CheckRemoteTxMiniFuture checkRemoteTxMiniFuture = this;
            synchronized (checkRemoteTxMiniFuture) {
                return new HashSet<UUID>(this.nodes);
            }
        }

        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            return this.onResponse(nodeId);
        }

        void onDhtFinishResponse(UUID nodeId, boolean discoThread) {
            this.onResponse(nodeId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onResponse(UUID nodeId) {
            boolean done;
            boolean ret;
            CheckRemoteTxMiniFuture checkRemoteTxMiniFuture = this;
            synchronized (checkRemoteTxMiniFuture) {
                ret = this.nodes.remove(nodeId);
                done = this.nodes.isEmpty();
            }
            if (done) {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
            return ret;
        }

        @Override
        public String toString() {
            return S.toString(CheckRemoteTxMiniFuture.class, this);
        }
    }

    private class CheckBackupMiniFuture
    extends MinFuture {
        @GridToStringInclude
        private GridDistributedTxMapping m;
        private ClusterNode backup;

        CheckBackupMiniFuture(ClusterNode backup, GridDistributedTxMapping m) {
            this.backup = backup;
            this.m = m;
        }

        public ClusterNode node() {
            return this.backup;
        }

        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            if (nodeId.equals(this.backup.id())) {
                GridNearTxFinishFuture.this.readyNearMappingFromBackup(this.m);
                this.onDone(new ClusterTopologyCheckedException("Remote node left grid: " + nodeId));
                return true;
            }
            return false;
        }

        void onDhtFinishResponse(GridDhtTxFinishResponse res) {
            GridNearTxFinishFuture.this.readyNearMappingFromBackup(this.m);
            Throwable err = res.checkCommittedError();
            if (err != null) {
                ClusterTopologyCheckedException cause;
                if (err instanceof IgniteCheckedException && (cause = ((IgniteCheckedException)err).getCause(ClusterTopologyCheckedException.class)) != null) {
                    cause.retryReadyFuture(GridNearTxFinishFuture.this.cctx.nextAffinityReadyFuture(GridNearTxFinishFuture.this.tx.topologyVersion()));
                }
                this.onDone(err);
            } else {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
        }
    }

    private class FinishMiniFuture
    extends MinFuture {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude
        private GridDistributedTxMapping m;

        FinishMiniFuture(GridDistributedTxMapping m) {
            this.m = m;
        }

        ClusterNode node() {
            return this.m.node();
        }

        public GridDistributedTxMapping mapping() {
            return this.m;
        }

        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            if (nodeId.equals(this.m.node().id())) {
                Collection<UUID> backups;
                Map<UUID, Collection<UUID>> txNodes;
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, mini future node left [txId=" + GridNearTxFinishFuture.this.tx.nearXidVersion() + ", node=" + this.m.node().id() + ']');
                }
                if (GridNearTxFinishFuture.this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC && (txNodes = GridNearTxFinishFuture.this.tx.transactionNodes()) != null && !F.isEmpty(backups = txNodes.get(nodeId))) {
                    final CheckRemoteTxMiniFuture mini = new CheckRemoteTxMiniFuture(new HashSet<UUID>(backups));
                    GridNearTxFinishFuture.this.add(mini);
                    GridDhtTxFinishRequest req = GridNearTxFinishFuture.this.checkCommittedRequest(mini.futureId(), true);
                    for (UUID backupId : backups) {
                        ClusterNode backup = GridNearTxFinishFuture.this.cctx.discovery().node(backupId);
                        if (backup != null && WAIT_REMOTE_TXS_SINCE.compareTo(backup.version()) <= 0) {
                            if (backup.isLocal()) {
                                IgniteInternalFuture<?> fut = GridNearTxFinishFuture.this.cctx.tm().remoteTxFinishFuture(GridNearTxFinishFuture.this.tx.nearXidVersion());
                                fut.listen(new CI1<IgniteInternalFuture<?>>(){

                                    @Override
                                    public void apply(IgniteInternalFuture<?> fut) {
                                        mini.onDhtFinishResponse(GridNearTxFinishFuture.this.cctx.localNodeId(), true);
                                    }
                                });
                                continue;
                            }
                            try {
                                GridNearTxFinishFuture.this.cctx.io().send(backup, (GridCacheMessage)req, GridNearTxFinishFuture.this.tx.ioPolicy());
                            }
                            catch (ClusterTopologyCheckedException ignored) {
                                mini.onNodeLeft(backupId, discoThread);
                            }
                            catch (IgniteCheckedException e) {
                                mini.onDone(e);
                            }
                            continue;
                        }
                        mini.onDhtFinishResponse(backupId, true);
                    }
                }
                this.onDone(GridNearTxFinishFuture.this.tx);
                return true;
            }
            return false;
        }

        void onNearFinishResponse(GridNearTxFinishResponse res) {
            if (res.error() != null) {
                this.onDone(res.error());
            } else {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
        }

        @Override
        public String toString() {
            return S.toString(FinishMiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }

    private abstract class MinFuture
    extends GridFutureAdapter<IgniteInternalTx> {
        private final IgniteUuid futId = IgniteUuid.randomUuid();

        private MinFuture() {
        }

        abstract boolean onNodeLeft(UUID var1, boolean var2);

        final IgniteUuid futureId() {
            return this.futId;
        }
    }
}

