/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxFinishRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearTxFinishRequest
extends GridDistributedTxFinishRequest {
    private static final long serialVersionUID = 0L;
    private IgniteUuid miniId;
    private boolean explicitLock;
    private boolean storeEnabled;
    private AffinityTopologyVersion topVer;
    private UUID subjId;
    private int taskNameHash;
    private CacheWriteSynchronizationMode syncMode;

    public GridNearTxFinishRequest() {
    }

    public GridNearTxFinishRequest(IgniteUuid futId, GridCacheVersion xidVer, long threadId, boolean commit, boolean invalidate, boolean sys, byte plc, CacheWriteSynchronizationMode syncMode, boolean explicitLock, boolean storeEnabled, @NotNull AffinityTopologyVersion topVer, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, int txSize, @Nullable UUID subjId, int taskNameHash, boolean addDepInfo) {
        super(xidVer, futId, null, threadId, commit, invalidate, sys, plc, syncMode == CacheWriteSynchronizationMode.FULL_SYNC, syncMode == CacheWriteSynchronizationMode.FULL_SYNC, baseVer, committedVers, rolledbackVers, txSize, addDepInfo);
        this.syncMode = syncMode;
        this.explicitLock = explicitLock;
        this.storeEnabled = storeEnabled;
        this.topVer = topVer;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
    }

    @Nullable
    public CacheWriteSynchronizationMode syncMode() {
        return this.syncMode;
    }

    public boolean explicitLock() {
        return this.explicitLock;
    }

    public boolean storeEnabled() {
        return this.storeEnabled;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public void miniId(IgniteUuid miniId) {
        this.miniId = miniId;
    }

    @Nullable
    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 18: {
                if (!writer.writeBoolean("explicitLock", this.explicitLock)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeBoolean("storeEnabled", this.storeEnabled)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeByte("syncMode", this.syncMode != null ? (byte)this.syncMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 18: {
                this.explicitLock = reader.readBoolean("explicitLock");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.storeEnabled = reader.readBoolean("storeEnabled");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 21: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                byte syncModeOrd = reader.readByte("syncMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.syncMode = CacheWriteSynchronizationMode.fromOrdinal(syncModeOrd);
                reader.incrementState();
            }
            case 23: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxFinishRequest.class);
    }

    @Override
    public byte directType() {
        return 53;
    }

    @Override
    public byte fieldsCount() {
        return 25;
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridNearTxFinishRequest.class, this, "super", super.toString());
    }
}

