/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxFinishResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearTxFinishResponse
extends GridDistributedTxFinishResponse {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private Throwable err;
    private byte[] errBytes;
    private IgniteUuid miniId;
    private long nearThreadId;

    public GridNearTxFinishResponse() {
    }

    public GridNearTxFinishResponse(GridCacheVersion xid, long nearThreadId, IgniteUuid futId, IgniteUuid miniId, @Nullable Throwable err) {
        super(xid, futId);
        assert (miniId != null);
        this.nearThreadId = nearThreadId;
        this.miniId = miniId;
        this.err = err;
    }

    @Override
    @Nullable
    public Throwable error() {
        return this.err;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public long threadId() {
        return this.nearThreadId;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.err != null && this.errBytes == null) {
            this.errBytes = U.marshal(ctx, (Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.errBytes != null && this.err == null) {
            this.err = (Throwable)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 5: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeLong("nearThreadId", this.nearThreadId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 5: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.nearThreadId = reader.readLong("nearThreadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxFinishResponse.class);
    }

    @Override
    public byte directType() {
        return 54;
    }

    @Override
    public byte fieldsCount() {
        return 8;
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxFinishResponse.class, this, "super", super.toString());
    }
}

