/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheMvccFuture;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticSerializableTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearPessimisticTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappingsImpl;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappingsSingleImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridInClosure3;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridNearTxLocal
extends GridDhtTxLocalAdapter {
    private static final long serialVersionUID = 0L;
    private static final AtomicReferenceFieldUpdater<GridNearTxLocal, IgniteInternalFuture> PREP_FUT_UPD = AtomicReferenceFieldUpdater.newUpdater(GridNearTxLocal.class, IgniteInternalFuture.class, "prepFut");
    private static final AtomicReferenceFieldUpdater<GridNearTxLocal, GridNearTxFinishFuture> COMMIT_FUT_UPD = AtomicReferenceFieldUpdater.newUpdater(GridNearTxLocal.class, GridNearTxFinishFuture.class, "commitFut");
    private static final AtomicReferenceFieldUpdater<GridNearTxLocal, GridNearTxFinishFuture> ROLLBACK_FUT_UPD = AtomicReferenceFieldUpdater.newUpdater(GridNearTxLocal.class, GridNearTxFinishFuture.class, "rollbackFut");
    private IgniteTxMappings mappings;
    @GridToStringExclude
    private volatile IgniteInternalFuture<?> prepFut;
    @GridToStringExclude
    private volatile GridNearTxFinishFuture commitFut;
    @GridToStringExclude
    private volatile GridNearTxFinishFuture rollbackFut;
    private Collection<IgniteTxEntry> optimisticLockEntries = Collections.emptyList();
    private boolean nearLocallyMapped;
    private boolean colocatedLocallyMapped;
    private Map<IgniteTxKey, IgniteCacheExpiryPolicy> accessMap;
    private Boolean needCheckBackup;
    private boolean hasRemoteLocks;

    public GridNearTxLocal() {
    }

    public GridNearTxLocal(GridCacheSharedContext ctx, boolean implicit, boolean implicitSingle, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, boolean storeEnabled, int txSize, @Nullable UUID subjId, int taskNameHash) {
        super(ctx, ctx.versions().next(), implicit, implicitSingle, sys, false, plc, concurrency, isolation, timeout, false, storeEnabled, false, txSize, subjId, taskNameHash);
        this.mappings = implicitSingle ? new IgniteTxMappingsSingleImpl() : new IgniteTxMappingsImpl();
        this.initResult();
    }

    @Override
    public boolean near() {
        return true;
    }

    @Override
    public boolean colocated() {
        return true;
    }

    @Override
    public GridCacheVersion nearXidVersion() {
        return this.xidVer;
    }

    @Override
    protected UUID nearNodeId() {
        return this.cctx.localNodeId();
    }

    @Override
    protected IgniteUuid nearFutureId() {
        assert (false) : "nearFutureId should not be called for colocated transactions.";
        return null;
    }

    @Override
    protected IgniteInternalFuture<Boolean> addReader(long msgId, GridDhtCacheEntry cached, IgniteTxEntry entry, AffinityTopologyVersion topVer) {
        return null;
    }

    @Override
    protected void sendFinishReply(@Nullable Throwable err) {
    }

    @Override
    protected void clearPrepareFuture(GridDhtTxPrepareFuture fut) {
        PREP_FUT_UPD.compareAndSet(this, fut, null);
    }

    public void markForBackupCheck() {
        this.needCheckBackup = true;
    }

    public boolean onNeedCheckBackup() {
        Boolean check = this.needCheckBackup;
        if (check != null && check.booleanValue()) {
            this.needCheckBackup = false;
            return true;
        }
        return false;
    }

    public boolean needCheckBackup() {
        return this.needCheckBackup != null;
    }

    public boolean nearLocallyMapped() {
        return this.nearLocallyMapped;
    }

    public void nearLocallyMapped(boolean nearLocallyMapped) {
        this.nearLocallyMapped = nearLocallyMapped;
    }

    public boolean colocatedLocallyMapped() {
        return this.colocatedLocallyMapped;
    }

    public void colocatedLocallyMapped(boolean colocatedLocallyMapped) {
        this.colocatedLocallyMapped = colocatedLocallyMapped;
    }

    @Override
    public boolean ownsLockUnsafe(GridCacheEntryEx entry) {
        return entry.detached() || super.ownsLockUnsafe(entry);
    }

    @Override
    public boolean ownsLock(GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
        return entry.detached() || super.ownsLock(entry);
    }

    @Override
    public Collection<IgniteTxEntry> optimisticLockEntries() {
        return this.optimisticLockEntries;
    }

    public void optimisticLockEntries(Collection<IgniteTxEntry> optimisticLockEntries) {
        this.optimisticLockEntries = optimisticLockEntries;
    }

    @Override
    public IgniteInternalFuture<Void> loadMissing(GridCacheContext cacheCtx, AffinityTopologyVersion topVer, boolean readThrough, boolean async, final Collection<KeyCacheObject> keys, final boolean skipVals, final boolean needVer, boolean keepBinary, ExpiryPolicy expiryPlc, final GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c) {
        IgniteCacheExpiryPolicy expiryPlc0;
        IgniteCacheExpiryPolicy igniteCacheExpiryPolicy = expiryPlc0 = this.optimistic() ? this.accessPolicy(cacheCtx, keys) : cacheCtx.cache().expiryPolicy(expiryPlc);
        if (cacheCtx.isNear()) {
            return cacheCtx.nearTx().txLoadAsync(this, topVer, keys, readThrough, false, expiryPlc0, skipVals, needVer).chain(new C1<IgniteInternalFuture<Map<Object, Object>>, Void>(){

                @Override
                public Void apply(IgniteInternalFuture<Map<Object, Object>> f) {
                    try {
                        Map<Object, Object> map = f.get();
                        GridNearTxLocal.this.processLoaded(map, keys, needVer, c);
                        return null;
                    }
                    catch (Exception e) {
                        GridNearTxLocal.this.setRollbackOnly();
                        throw new GridClosureException(e);
                    }
                }
            });
        }
        if (cacheCtx.isColocated()) {
            if (keys.size() == 1) {
                final KeyCacheObject key = F.first(keys);
                return cacheCtx.colocated().loadAsync(key, readThrough, needVer || !cacheCtx.config().isReadFromBackup(), topVer, CU.subjectId(this, this.cctx), this.resolveTaskName(), false, expiryPlc0, skipVals, true, needVer, true).chain(new C1<IgniteInternalFuture<Object>, Void>(){

                    @Override
                    public Void apply(IgniteInternalFuture<Object> f) {
                        try {
                            Object val = f.get();
                            GridNearTxLocal.this.processLoaded(key, val, needVer, skipVals, c);
                            return null;
                        }
                        catch (Exception e) {
                            GridNearTxLocal.this.setRollbackOnly();
                            throw new GridClosureException(e);
                        }
                    }
                });
            }
            return cacheCtx.colocated().loadAsync(keys, readThrough, needVer || !cacheCtx.config().isReadFromBackup(), topVer, CU.subjectId(this, this.cctx), this.resolveTaskName(), false, expiryPlc0, skipVals, true, needVer, true).chain(new C1<IgniteInternalFuture<Map<Object, Object>>, Void>(){

                @Override
                public Void apply(IgniteInternalFuture<Map<Object, Object>> f) {
                    try {
                        Map<Object, Object> map = f.get();
                        GridNearTxLocal.this.processLoaded(map, keys, needVer, c);
                        return null;
                    }
                    catch (Exception e) {
                        GridNearTxLocal.this.setRollbackOnly();
                        throw new GridClosureException(e);
                    }
                }
            });
        }
        assert (cacheCtx.isLocal());
        return super.loadMissing(cacheCtx, topVer, readThrough, async, keys, skipVals, keepBinary, needVer, expiryPlc, c);
    }

    private void processLoaded(Map<Object, Object> map, Collection<KeyCacheObject> keys, boolean needVer, GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c) {
        for (KeyCacheObject key : keys) {
            this.processLoaded(key, map.get(key), needVer, false, c);
        }
    }

    private void processLoaded(KeyCacheObject key, @Nullable Object val, boolean needVer, boolean skipVals, GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c) {
        if (val != null) {
            GridCacheVersion ver;
            Object v;
            if (needVer) {
                EntryGetResult getRes = (EntryGetResult)val;
                v = getRes.value();
                ver = getRes.version();
            } else {
                v = val;
                ver = null;
            }
            if (skipVals && v == Boolean.FALSE) {
                c.apply(key, null, IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER);
            } else {
                c.apply(key, v, ver);
            }
        } else {
            c.apply(key, null, IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER);
        }
    }

    @Override
    protected void updateExplicitVersion(IgniteTxEntry txEntry, GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
        if (entry.detached()) {
            GridCacheMvccCandidate cand = this.cctx.mvcc().explicitLock(this.threadId(), entry.txKey());
            if (cand != null && !this.xidVersion().equals(cand.version())) {
                GridCacheVersion candVer = cand.version();
                txEntry.explicitVersion(candVer);
                if (candVer.compareTo(this.minVer) < 0) {
                    this.minVer = candVer;
                }
            }
        } else {
            super.updateExplicitVersion(txEntry, entry);
        }
    }

    IgniteTxMappings mappings() {
        return this.mappings;
    }

    @Override
    public boolean removeMapping(UUID nodeId) {
        if (this.mappings.remove(nodeId) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Removed mapping for node [nodeId=" + nodeId + ", tx=" + this + ']');
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Mapping for node was not found [nodeId=" + nodeId + ", tx=" + this + ']');
        }
        return false;
    }

    public void addKeyMapping(IgniteTxKey key, ClusterNode node) {
        GridDistributedTxMapping m = this.mappings.get(node.id());
        if (m == null) {
            m = new GridDistributedTxMapping(node);
            this.mappings.put(m);
        }
        IgniteTxEntry txEntry = this.entry(key);
        assert (txEntry != null);
        txEntry.nodeId(node.id());
        m.add(txEntry);
        if (log.isDebugEnabled()) {
            log.debug("Added mappings to transaction [locId=" + this.cctx.localNodeId() + ", key=" + key + ", node=" + node + ", tx=" + this + ']');
        }
    }

    @Nullable
    IgniteTxEntry singleWrite() {
        return this.txState.singleWrite();
    }

    void addEntryMapping(@Nullable Collection<GridDistributedTxMapping> maps) {
        if (!F.isEmpty(maps)) {
            for (GridDistributedTxMapping map : maps) {
                ClusterNode n = map.node();
                GridDistributedTxMapping m = this.mappings.get(n.id());
                if (m == null) {
                    m = new GridDistributedTxMapping(n);
                    this.mappings.put(m);
                    m.near(map.near());
                    if (map.explicitLock()) {
                        m.markExplicitLock();
                    }
                }
                for (IgniteTxEntry entry : map.entries()) {
                    m.add(entry);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Added mappings to transaction [locId=" + this.cctx.localNodeId() + ", mappings=" + maps + ", tx=" + this + ']');
            }
        }
    }

    void addSingleEntryMapping(GridDistributedTxMapping map, IgniteTxEntry entry) {
        ClusterNode n = map.node();
        GridDistributedTxMapping m = new GridDistributedTxMapping(n);
        this.mappings.put(m);
        m.near(map.near());
        if (map.explicitLock()) {
            m.markExplicitLock();
        }
        m.add(entry);
    }

    public boolean markExplicit(UUID nodeId) {
        this.explicitLock = true;
        GridDistributedTxMapping m = this.mappings.get(nodeId);
        if (m != null) {
            m.markExplicitLock();
            return true;
        }
        return false;
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        GridCacheMvccFuture fut = (GridCacheMvccFuture)this.prepFut;
        return fut != null && fut.onOwnerChanged(entry, owner);
    }

    void readyNearLocks(GridDistributedTxMapping mapping, Collection<GridCacheVersion> pendingVers, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers) {
        for (IgniteTxEntry txEntry : mapping.entries()) {
            if (!CU.writes().apply(txEntry)) continue;
            this.readyNearLock(txEntry, mapping.dhtVersion(), pendingVers, committedVers, rolledbackVers);
        }
        for (IgniteTxEntry txEntry : mapping.entries()) {
            if (!CU.reads().apply(txEntry)) continue;
            this.readyNearLock(txEntry, mapping.dhtVersion(), pendingVers, committedVers, rolledbackVers);
        }
    }

    void readyNearLock(IgniteTxEntry txEntry, GridCacheVersion dhtVer, Collection<GridCacheVersion> pendingVers, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers) {
        while (true) {
            GridCacheContext cacheCtx = txEntry.cached().context();
            assert (cacheCtx.isNear());
            GridDistributedCacheEntry entry = (GridDistributedCacheEntry)txEntry.cached();
            try {
                GridCacheVersion explicit = txEntry.explicitVersion();
                if (explicit != null) break;
                entry.readyNearLock(this.xidVer, dhtVer, committedVers, rolledbackVers, pendingVers);
            }
            catch (GridCacheEntryRemovedException ignored) {
                assert (entry.obsoleteVersion() != null);
                if (log.isDebugEnabled()) {
                    log.debug("Replacing obsolete entry in remote transaction [entry=" + entry + ", tx=" + this + ']');
                }
                txEntry.cached(txEntry.context().cache().entryEx(txEntry.key(), this.topologyVersion()));
                continue;
            }
            break;
        }
    }

    @Override
    public boolean finish(boolean commit) throws IgniteCheckedException {
        IgniteCheckedException err;
        block17: {
            if (log.isDebugEnabled()) {
                log.debug("Finishing near local tx [tx=" + this + ", commit=" + commit + "]");
            }
            if (commit) {
                if (!this.state(TransactionState.COMMITTING)) {
                    TransactionState state = this.state();
                    if (state != TransactionState.COMMITTING && state != TransactionState.COMMITTED) {
                        throw new IgniteCheckedException("Invalid transaction state for commit [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']');
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Invalid transaction state for commit (another thread is committing): " + this);
                    }
                    return false;
                }
            } else if (!this.state(TransactionState.ROLLING_BACK)) {
                if (log.isDebugEnabled()) {
                    log.debug("Invalid transaction state for rollback [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']');
                }
                return false;
            }
            err = null;
            try {
                if (commit && !this.isRollbackOnly()) {
                    this.userCommit();
                } else {
                    this.userRollback();
                }
            }
            catch (IgniteCheckedException e) {
                err = e;
                commit = false;
                if (this.isRollbackOnly()) break block17;
                this.invalidate = true;
                this.systemInvalidate(true);
                U.warn(log, "Set transaction invalidation flag to true due to error [tx=" + this + ", err=" + err + ']');
            }
        }
        if (err != null) {
            this.state(TransactionState.UNKNOWN);
            throw err;
        }
        if (commit) {
            if (!this.onePhaseCommit() && !this.state(TransactionState.COMMITTED)) {
                this.state(TransactionState.UNKNOWN);
                throw new IgniteCheckedException("Invalid transaction state for commit: " + this);
            }
        } else if (!this.state(TransactionState.ROLLED_BACK)) {
            this.state(TransactionState.UNKNOWN);
            throw new IgniteCheckedException("Invalid transaction state for rollback: " + this);
        }
        return true;
    }

    @Override
    public IgniteInternalFuture<?> prepareAsync() {
        GridNearTxPrepareFutureAdapter fut = (GridNearTxPrepareFutureAdapter)this.prepFut;
        if (fut == null) {
            long timeout = this.remainingTime();
            fut = this.optimistic() ? (this.serializable() ? new GridNearOptimisticSerializableTxPrepareFuture(this.cctx, this) : new GridNearOptimisticTxPrepareFuture(this.cctx, this)) : new GridNearPessimisticTxPrepareFuture(this.cctx, this);
            if (!PREP_FUT_UPD.compareAndSet(this, null, fut)) {
                return this.prepFut;
            }
            if (timeout == -1L) {
                fut.onDone(this, this.timeoutException());
                return fut;
            }
        } else {
            return fut;
        }
        this.mapExplicitLocks();
        fut.prepare();
        return fut;
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> commitAsync() {
        if (log.isDebugEnabled()) {
            log.debug("Committing near local tx: " + this);
        }
        if (this.fastFinish()) {
            this.state(TransactionState.PREPARING);
            this.state(TransactionState.PREPARED);
            this.state(TransactionState.COMMITTING);
            this.cctx.tm().fastFinishTx(this, true);
            this.state(TransactionState.COMMITTED);
            return new GridFinishedFuture<IgniteInternalTx>(this);
        }
        this.prepareAsync();
        GridNearTxFinishFuture fut = this.commitFut;
        if (fut == null && !COMMIT_FUT_UPD.compareAndSet(this, null, fut = new GridNearTxFinishFuture(this.cctx, this, true))) {
            return this.commitFut;
        }
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        final IgniteInternalFuture<?> prepareFut = this.prepFut;
        prepareFut.listen(new CI1<IgniteInternalFuture<?>>(){

            @Override
            public void apply(IgniteInternalFuture<?> f) {
                GridNearTxFinishFuture fut0 = GridNearTxLocal.this.commitFut;
                try {
                    prepareFut.get();
                    fut0.finish(true);
                }
                catch (Error | RuntimeException e) {
                    COMMIT_ERR_UPD.compareAndSet(GridNearTxLocal.this, null, e);
                    fut0.finish(false);
                    throw e;
                }
                catch (IgniteCheckedException e) {
                    COMMIT_ERR_UPD.compareAndSet(GridNearTxLocal.this, null, e);
                    fut0.finish(false);
                }
            }
        });
        return fut;
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> rollbackAsync() {
        if (log.isDebugEnabled()) {
            log.debug("Rolling back near tx: " + this);
        }
        if (this.fastFinish()) {
            this.state(TransactionState.PREPARING);
            this.state(TransactionState.PREPARED);
            this.state(TransactionState.ROLLING_BACK);
            this.cctx.tm().fastFinishTx(this, false);
            this.state(TransactionState.ROLLED_BACK);
            return new GridFinishedFuture<IgniteInternalTx>(this);
        }
        GridNearTxFinishFuture fut = this.rollbackFut;
        if (fut != null) {
            return fut;
        }
        fut = new GridNearTxFinishFuture(this.cctx, this, false);
        if (!ROLLBACK_FUT_UPD.compareAndSet(this, null, fut)) {
            return this.rollbackFut;
        }
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        IgniteInternalFuture<?> prepFut = this.prepFut;
        if (prepFut == null || prepFut.isDone()) {
            block9: {
                try {
                    if (prepFut != null) {
                        prepFut.get();
                    }
                }
                catch (IgniteCheckedException e) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug("Got optimistic tx failure [tx=" + this + ", err=" + e + ']');
                }
            }
            fut.finish(false);
        } else {
            prepFut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f) {
                    block2: {
                        try {
                            f.get();
                        }
                        catch (IgniteCheckedException e) {
                            if (!log.isDebugEnabled()) break block2;
                            log.debug("Got optimistic tx failure [tx=" + this + ", err=" + e + ']');
                        }
                    }
                    GridNearTxFinishFuture fut0 = GridNearTxLocal.this.rollbackFut;
                    fut0.finish(false);
                }
            });
        }
        return fut;
    }

    private boolean fastFinish() {
        return this.writeMap().isEmpty() && (this.optimistic() || this.readMap().isEmpty());
    }

    public IgniteInternalFuture<GridNearTxPrepareResponse> prepareAsyncLocal(@Nullable Collection<IgniteTxEntry> reads, @Nullable Collection<IgniteTxEntry> writes, Map<UUID, Collection<UUID>> txNodes, boolean last) {
        long timeout = this.remainingTime();
        if (this.state() != TransactionState.PREPARING) {
            if (timeout == -1L) {
                return new GridFinishedFuture<GridNearTxPrepareResponse>(new IgniteTxTimeoutCheckedException("Transaction timed out: " + this));
            }
            this.setRollbackOnly();
            return new GridFinishedFuture<GridNearTxPrepareResponse>(new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']'));
        }
        if (timeout == -1L) {
            return new GridFinishedFuture<GridNearTxPrepareResponse>(this.timeoutException());
        }
        this.init();
        GridDhtTxPrepareFuture fut = new GridDhtTxPrepareFuture(this.cctx, this, timeout, IgniteUuid.randomUuid(), Collections.emptyMap(), last, this.needReturnValue() && this.implicit());
        try {
            this.optimisticLockEntries = this.serializable() && this.optimistic() ? F.concat(false, writes, reads) : writes;
            this.userPrepare();
            this.cctx.mvcc().addFuture(fut);
            if (this.isSystemInvalidate()) {
                fut.complete();
            } else {
                fut.prepare(reads, writes, txNodes);
            }
        }
        catch (IgniteTxOptimisticCheckedException | IgniteTxTimeoutCheckedException e) {
            fut.onError(e);
        }
        catch (IgniteCheckedException e) {
            this.setRollbackOnly();
            fut.onError(new IgniteTxRollbackCheckedException("Failed to prepare transaction: " + this, e));
            try {
                this.rollback();
            }
            catch (IgniteTxOptimisticCheckedException e1) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed optimistically to prepare transaction [tx=" + this + ", e=" + e1 + ']');
                }
                fut.onError(e);
            }
            catch (IgniteCheckedException e1) {
                U.error(log, "Failed to rollback transaction: " + this, e1);
            }
        }
        return this.chainOnePhasePrepare(fut);
    }

    public IgniteInternalFuture<IgniteInternalTx> commitAsyncLocal() {
        if (log.isDebugEnabled()) {
            log.debug("Committing colocated tx locally: " + this);
        }
        if (this.pessimistic()) {
            this.prepareAsync();
        }
        IgniteInternalFuture<IgniteInternalTx> prep = this.prepFut;
        if (F.isEmpty(this.dhtMap) && F.isEmpty(this.nearMap)) {
            if (prep != null) {
                return prep;
            }
            return new GridFinishedFuture<IgniteInternalTx>(this);
        }
        final GridDhtTxFinishFuture fut = new GridDhtTxFinishFuture(this.cctx, this, true);
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        if (prep == null || prep.isDone()) {
            assert (prep != null || this.optimistic());
            IgniteCheckedException err = null;
            try {
                if (prep != null) {
                    prep.get();
                }
            }
            catch (IgniteCheckedException e) {
                err = e;
                U.error(log, "Failed to prepare transaction: " + this, e);
            }
            if (err != null) {
                fut.rollbackOnError(err);
            } else {
                fut.finish(true);
            }
        } else {
            prep.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f) {
                    IgniteCheckedException err = null;
                    try {
                        f.get();
                    }
                    catch (IgniteCheckedException e) {
                        err = e;
                        U.error(log, "Failed to prepare transaction: " + this, e);
                    }
                    if (err != null) {
                        fut.rollbackOnError(err);
                    } else {
                        fut.finish(true);
                    }
                }
            });
        }
        return fut;
    }

    public IgniteInternalFuture<IgniteInternalTx> rollbackAsyncLocal() {
        if (log.isDebugEnabled()) {
            log.debug("Rolling back colocated tx locally: " + this);
        }
        final GridDhtTxFinishFuture fut = new GridDhtTxFinishFuture(this.cctx, this, false);
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        IgniteInternalFuture<?> prep = this.prepFut;
        if (prep == null || prep.isDone()) {
            block6: {
                try {
                    if (prep != null) {
                        prep.get();
                    }
                }
                catch (IgniteCheckedException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("Failed to prepare transaction during rollback (will ignore) [tx=" + this + ", msg=" + e.getMessage() + ']');
                }
            }
            fut.finish(false);
        } else {
            prep.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f) {
                    try {
                        f.get();
                    }
                    catch (IgniteCheckedException e) {
                        log.debug("Failed to prepare transaction during rollback (will ignore) [tx=" + this + ", msg=" + e.getMessage() + ']');
                    }
                    fut.finish(false);
                }
            });
        }
        return fut;
    }

    public <K> IgniteInternalFuture<GridCacheReturn> lockAllAsync(GridCacheContext cacheCtx, final Collection<? extends K> keys, boolean retval, boolean read, long createTtl, long accessTtl, boolean skipStore, boolean keepBinary) {
        long timeout;
        assert (this.pessimistic());
        try {
            this.checkValid();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture<GridCacheReturn>(ret);
        }
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Before acquiring transaction lock on keys: " + keys);
        }
        if ((timeout = this.remainingTime()) == -1L) {
            return new GridFinishedFuture<GridCacheReturn>(this.timeoutException());
        }
        GridDhtFuture<Boolean> fut = cacheCtx.colocated().lockAllAsyncInternal(keys, timeout, this, this.isInvalidate(), read, retval, this.isolation, createTtl, accessTtl, CU.empty0(), skipStore, keepBinary);
        return new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, new IgniteTxLocalAdapter.PLC1<GridCacheReturn>(ret, false){

            @Override
            protected GridCacheReturn postLock(GridCacheReturn ret) {
                if (log.isDebugEnabled()) {
                    log.debug("Acquired transaction lock on keys: " + keys);
                }
                return ret;
            }
        });
    }

    @Override
    protected GridCacheEntryEx entryEx(GridCacheContext cacheCtx, IgniteTxKey key) {
        if (cacheCtx.isColocated()) {
            IgniteTxEntry txEntry = this.entry(key);
            if (txEntry == null) {
                return cacheCtx.colocated().entryExx(key.key(), this.topologyVersion(), true);
            }
            GridCacheEntryEx cached = txEntry.cached();
            assert (cached != null);
            if (cached.detached()) {
                return cached;
            }
            if (cached.obsoleteVersion() != null) {
                cached = cacheCtx.colocated().entryExx(key.key(), this.topologyVersion(), true);
                txEntry.cached(cached);
            }
            return cached;
        }
        return cacheCtx.cache().entryEx(key.key());
    }

    @Override
    protected GridCacheEntryEx entryEx(GridCacheContext cacheCtx, IgniteTxKey key, AffinityTopologyVersion topVer) {
        if (cacheCtx.isColocated()) {
            IgniteTxEntry txEntry = this.entry(key);
            if (txEntry == null) {
                return cacheCtx.colocated().entryExx(key.key(), topVer, true);
            }
            GridCacheEntryEx cached = txEntry.cached();
            assert (cached != null);
            if (cached.detached()) {
                return cached;
            }
            if (cached.obsoleteVersion() != null) {
                cached = cacheCtx.colocated().entryExx(key.key(), topVer, true);
                txEntry.cached(cached);
            }
            return cached;
        }
        return cacheCtx.cache().entryEx(key.key(), topVer);
    }

    @Override
    protected IgniteCacheExpiryPolicy accessPolicy(GridCacheContext ctx, IgniteTxKey key, @Nullable ExpiryPolicy expiryPlc) {
        assert (this.optimistic());
        IgniteCacheExpiryPolicy plc = ctx.cache().expiryPolicy(expiryPlc);
        if (plc != null) {
            if (this.accessMap == null) {
                this.accessMap = new HashMap<IgniteTxKey, IgniteCacheExpiryPolicy>();
            }
            this.accessMap.put(key, plc);
        }
        return plc;
    }

    @Override
    protected IgniteCacheExpiryPolicy accessPolicy(GridCacheContext cacheCtx, Collection<KeyCacheObject> keys) {
        assert (this.optimistic());
        if (this.accessMap != null) {
            for (Map.Entry<IgniteTxKey, IgniteCacheExpiryPolicy> e : this.accessMap.entrySet()) {
                if (e.getKey().cacheId() != cacheCtx.cacheId() || !keys.contains(e.getKey().key())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    @Override
    public void close() throws IgniteCheckedException {
        super.close();
        if (this.accessMap != null) {
            assert (this.optimistic());
            for (Map.Entry<IgniteTxKey, IgniteCacheExpiryPolicy> e : this.accessMap.entrySet()) {
                if (e.getValue().entries() == null) continue;
                GridCacheContext cctx0 = this.cctx.cacheContext(e.getKey().cacheId());
                if (cctx0.isNear()) {
                    cctx0.near().dht().sendTtlUpdateRequest(e.getValue());
                    continue;
                }
                cctx0.dht().sendTtlUpdateRequest(e.getValue());
            }
            this.accessMap = null;
        }
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> currentPrepareFuture() {
        return this.prepFut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemap(AffinityTopologyVersion topVer) {
        assert (this.cctx.kernalContext().clientNode());
        this.mapped = false;
        this.nearLocallyMapped = false;
        this.colocatedLocallyMapped = false;
        this.txNodes = null;
        this.onePhaseCommit = false;
        this.nearMap.clear();
        this.dhtMap.clear();
        this.mappings.clear();
        GridNearTxLocal gridNearTxLocal = this;
        synchronized (gridNearTxLocal) {
            this.topVer = topVer;
        }
    }

    public void hasRemoteLocks(boolean hasRemoteLocks) {
        this.hasRemoteLocks = hasRemoteLocks;
    }

    public boolean hasRemoteLocks() {
        return this.hasRemoteLocks;
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxLocal.class, this, "thread", (Object)IgniteUtils.threadName(this.threadId), "mappings", this.mappings, "super", super.toString());
    }
}

