/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccFuture;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtDetachedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.CacheVersionedValue;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteUuid;

public abstract class GridNearTxPrepareFutureAdapter
extends GridCompoundFuture<GridNearTxPrepareResponse, IgniteInternalTx>
implements GridCacheMvccFuture<IgniteInternalTx> {
    protected static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    protected static final AtomicReferenceFieldUpdater<GridNearTxPrepareFutureAdapter, Throwable> ERR_UPD = AtomicReferenceFieldUpdater.newUpdater(GridNearTxPrepareFutureAdapter.class, Throwable.class, "err");
    private static final IgniteReducer<GridNearTxPrepareResponse, IgniteInternalTx> REDUCER = new IgniteReducer<GridNearTxPrepareResponse, IgniteInternalTx>(){

        @Override
        public boolean collect(GridNearTxPrepareResponse e) {
            return true;
        }

        @Override
        public IgniteInternalTx reduce() {
            return null;
        }
    };
    protected static IgniteLogger log;
    protected static IgniteLogger msgLog;
    protected GridCacheSharedContext<?, ?> cctx;
    @GridToStringInclude
    protected IgniteUuid futId;
    @GridToStringInclude
    protected GridNearTxLocal tx;
    @GridToStringExclude
    protected volatile Throwable err;
    protected boolean trackable = true;
    protected GridDhtTxMapping txMapping;

    public GridNearTxPrepareFutureAdapter(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(REDUCER);
        assert (cctx != null);
        assert (tx != null);
        this.cctx = cctx;
        this.tx = tx;
        this.futId = IgniteUuid.randomUuid();
        if (log == null) {
            msgLog = cctx.txFinishMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridNearTxPrepareFutureAdapter.class);
        }
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public GridCacheVersion version() {
        return this.tx.xidVersion();
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    public IgniteInternalTx tx() {
        return this.tx;
    }

    public abstract void prepare();

    public abstract void onResult(UUID var1, GridNearTxPrepareResponse var2);

    protected final void checkOnePhase() {
        if (this.tx.storeUsed()) {
            return;
        }
        Map<UUID, Collection<UUID>> map = this.txMapping.transactionNodes();
        if (map.size() == 1) {
            Map.Entry<UUID, Collection<UUID>> entry = map.entrySet().iterator().next();
            assert (entry != null);
            Collection<UUID> backups = entry.getValue();
            if (backups.size() <= 1) {
                this.tx.onePhaseCommit(true);
            }
        }
    }

    protected final void onPrepareResponse(GridDistributedTxMapping m, GridNearTxPrepareResponse res) {
        IgniteTxEntry txEntry;
        if (res == null) {
            return;
        }
        assert (res.error() == null) : res;
        assert (F.isEmpty(res.invalidPartitions())) : res;
        UUID nodeId = m.node().id();
        block2: for (Map.Entry<IgniteTxKey, CacheVersionedValue> entry : res.ownedValues().entrySet()) {
            txEntry = this.tx.entry(entry.getKey());
            assert (txEntry != null);
            GridCacheContext<?, ?> cacheCtx = txEntry.context();
            while (true) {
                try {
                    CacheVersionedValue tup;
                    if (cacheCtx.isNear()) {
                        GridNearCacheEntry nearEntry = (GridNearCacheEntry)txEntry.cached();
                        tup = entry.getValue();
                        nearEntry.resetFromPrimary(tup.value(), this.tx.xidVersion(), tup.version(), nodeId, this.tx.topologyVersion());
                        continue block2;
                    }
                    if (!txEntry.cached().detached()) continue block2;
                    GridDhtDetachedCacheEntry detachedEntry = (GridDhtDetachedCacheEntry)txEntry.cached();
                    tup = entry.getValue();
                    detachedEntry.resetFromPrimary(tup.value(), this.tx.xidVersion());
                    continue block2;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    txEntry.cached(cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion()));
                    continue;
                }
                break;
            }
        }
        this.tx.implicitSingleResult(res.returnValue());
        for (IgniteTxKey key : res.filterFailedKeys()) {
            txEntry = this.tx.entry(key);
            assert (txEntry != null) : "Missing tx entry for write key: " + key;
            txEntry.op(GridCacheOperation.NOOP);
            assert (txEntry.context() != null);
            ExpiryPolicy expiry = txEntry.context().expiryForTxEntry(txEntry);
            if (expiry == null) continue;
            txEntry.ttl(CU.toTtl(expiry.getExpiryForAccess()));
        }
        if (!m.empty()) {
            GridCacheVersion writeVer = res.writeVersion();
            if (writeVer == null) {
                writeVer = res.dhtVersion();
            }
            this.cctx.versions().onReceived(nodeId, res.dhtVersion());
            m.dhtVersion(res.dhtVersion(), writeVer);
            GridDistributedTxMapping map = this.tx.mappings().get(nodeId);
            if (map != null) {
                map.dhtVersion(res.dhtVersion(), writeVer);
            }
            if (m.near()) {
                this.tx.readyNearLocks(m, res.pending(), res.committedVersions(), res.rolledbackVersions());
            }
        }
    }
}

