/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearTxPrepareRequest
extends GridDistributedTxPrepareRequest {
    private static final long serialVersionUID = 0L;
    private IgniteUuid futId;
    private IgniteUuid miniId;
    private boolean near;
    private AffinityTopologyVersion topVer;
    private boolean last;
    @GridDirectCollection(value=UUID.class)
    @GridToStringInclude
    private Collection<UUID> lastBackups;
    private boolean retVal;
    private boolean implicitSingle;
    private boolean explicitLock;
    private UUID subjId;
    private int taskNameHash;
    private boolean firstClientReq;

    public GridNearTxPrepareRequest() {
    }

    public GridNearTxPrepareRequest(IgniteUuid futId, AffinityTopologyVersion topVer, IgniteInternalTx tx, long timeout, Collection<IgniteTxEntry> reads, Collection<IgniteTxEntry> writes, boolean near, Map<UUID, Collection<UUID>> txNodes, boolean last, boolean onePhaseCommit, boolean retVal, boolean implicitSingle, boolean explicitLock, @Nullable UUID subjId, int taskNameHash, boolean firstClientReq, boolean addDepInfo) {
        super(tx, timeout, reads, writes, txNodes, onePhaseCommit, addDepInfo);
        assert (futId != null);
        assert (!firstClientReq || tx.optimistic()) : tx;
        this.futId = futId;
        this.topVer = topVer;
        this.near = near;
        this.last = last;
        this.retVal = retVal;
        this.implicitSingle = implicitSingle;
        this.explicitLock = explicitLock;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.firstClientReq = firstClientReq;
    }

    public boolean firstClientRequest() {
        return this.firstClientReq;
    }

    public boolean last() {
        return this.last;
    }

    public boolean near() {
        return this.near;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public void miniId(IgniteUuid miniId) {
        this.miniId = miniId;
    }

    @Nullable
    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public boolean returnValue() {
        return this.retVal;
    }

    public boolean implicitSingle() {
        return this.implicitSingle;
    }

    public boolean explicitLock() {
        return this.explicitLock;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void cloneEntries() {
        this.reads(this.cloneEntries(this.reads()));
        this.writes(this.cloneEntries(this.writes()));
    }

    private Collection<IgniteTxEntry> cloneEntries(Collection<IgniteTxEntry> c) {
        if (F.isEmpty(c)) {
            return c;
        }
        ArrayList<IgniteTxEntry> cp = new ArrayList<IgniteTxEntry>(c.size());
        for (IgniteTxEntry e : c) {
            GridCacheContext<?, ?> cacheCtx = e.context();
            if (cacheCtx.isNear()) {
                cp.add(e.cleanCopy(cacheCtx.nearTx().dht().context()));
                continue;
            }
            cp.add(e);
        }
        return cp;
    }

    @Override
    protected boolean transferExpiryPolicy() {
        return true;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 23: {
                if (!writer.writeBoolean("explicitLock", this.explicitLock)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeBoolean("firstClientReq", this.firstClientReq)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeBoolean("implicitSingle", this.implicitSingle)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeBoolean("last", this.last)) {
                    return false;
                }
                writer.incrementState();
            }
            case 28: {
                if (!writer.writeCollection("lastBackups", this.lastBackups, MessageCollectionItemType.UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 29: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 30: {
                if (!writer.writeBoolean("near", this.near)) {
                    return false;
                }
                writer.incrementState();
            }
            case 31: {
                if (!writer.writeBoolean("retVal", this.retVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 32: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 33: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 34: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 23: {
                this.explicitLock = reader.readBoolean("explicitLock");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.firstClientReq = reader.readBoolean("firstClientReq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.implicitSingle = reader.readBoolean("implicitSingle");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.last = reader.readBoolean("last");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 28: {
                this.lastBackups = reader.readCollection("lastBackups", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 29: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 30: {
                this.near = reader.readBoolean("near");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 31: {
                this.retVal = reader.readBoolean("retVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 32: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 33: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 34: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxPrepareRequest.class);
    }

    @Override
    public byte directType() {
        return 55;
    }

    @Override
    public byte fieldsCount() {
        return 35;
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxPrepareRequest.class, this, super.toString());
    }
}

