/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesMvccObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesMvccTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCacheAttributesMvccEntryExtras
extends GridCacheEntryExtrasAdapter {
    private GridCacheMvcc mvcc;

    public GridCacheAttributesMvccEntryExtras(GridCacheMvcc mvcc) {
        assert (mvcc != null);
        this.mvcc = mvcc;
    }

    @Override
    public GridCacheMvcc mvcc() {
        return this.mvcc;
    }

    @Override
    public GridCacheEntryExtras mvcc(@Nullable GridCacheMvcc mvcc) {
        if (mvcc != null) {
            this.mvcc = mvcc;
            return this;
        }
        return new GridCacheAttributesEntryExtras();
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        return obsoleteVer != null ? new GridCacheAttributesMvccObsoleteEntryExtras(this.mvcc, obsoleteVer) : this;
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        return ttl != 0L ? new GridCacheAttributesMvccTtlEntryExtras(this.mvcc, ttl, expireTime) : this;
    }

    @Override
    public int size() {
        return 8;
    }

    public String toString() {
        return S.toString(GridCacheAttributesMvccEntryExtras.class, this);
    }
}

