/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheMvccTtlEntryExtras
extends GridCacheEntryExtrasAdapter {
    private GridCacheMvcc mvcc;
    private long ttl;
    private long expireTime;

    public GridCacheMvccTtlEntryExtras(GridCacheMvcc mvcc, long ttl, long expireTime) {
        assert (mvcc != null);
        assert (ttl != 0L);
        this.mvcc = mvcc;
        this.ttl = ttl;
        this.expireTime = expireTime;
    }

    @Override
    public GridCacheMvcc mvcc() {
        return this.mvcc;
    }

    @Override
    public GridCacheEntryExtras mvcc(GridCacheMvcc mvcc) {
        if (mvcc != null) {
            this.mvcc = mvcc;
            return this;
        }
        return new GridCacheTtlEntryExtras(this.ttl, this.expireTime);
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        return obsoleteVer != null ? new GridCacheMvccObsoleteTtlEntryExtras(this.mvcc, obsoleteVer, this.ttl, this.expireTime) : this;
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        if (ttl != 0L) {
            this.ttl = ttl;
            this.expireTime = expireTime;
            return this;
        }
        return new GridCacheMvccEntryExtras(this.mvcc);
    }

    @Override
    public int size() {
        return 24;
    }

    public String toString() {
        return S.toString(GridCacheMvccTtlEntryExtras.class, this);
    }
}

