/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheObsoleteEntryExtras
extends GridCacheEntryExtrasAdapter {
    private GridCacheVersion obsoleteVer;

    public GridCacheObsoleteEntryExtras(GridCacheVersion obsoleteVer) {
        assert (obsoleteVer != null);
        this.obsoleteVer = obsoleteVer;
    }

    @Override
    public GridCacheEntryExtras mvcc(GridCacheMvcc mvcc) {
        return mvcc != null ? new GridCacheMvccObsoleteEntryExtras(mvcc, this.obsoleteVer) : this;
    }

    @Override
    public GridCacheVersion obsoleteVersion() {
        return this.obsoleteVer;
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        if (obsoleteVer != null) {
            this.obsoleteVer = obsoleteVer;
            return this;
        }
        return null;
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        return ttl != 0L ? new GridCacheObsoleteTtlEntryExtras(this.obsoleteVer, ttl, expireTime) : this;
    }

    @Override
    public int size() {
        return 8;
    }

    public String toString() {
        return S.toString(GridCacheObsoleteEntryExtras.class, this);
    }
}

