/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheTtlEntryExtras
extends GridCacheEntryExtrasAdapter {
    private long ttl;
    private long expireTime;

    public GridCacheTtlEntryExtras(long ttl, long expireTime) {
        assert (ttl != 0L);
        this.ttl = ttl;
        this.expireTime = expireTime;
    }

    @Override
    public GridCacheEntryExtras mvcc(GridCacheMvcc mvcc) {
        return mvcc != null ? new GridCacheMvccTtlEntryExtras(mvcc, this.ttl, this.expireTime) : this;
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        return obsoleteVer != null ? new GridCacheObsoleteTtlEntryExtras(obsoleteVer, this.ttl, this.expireTime) : this;
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        if (ttl != 0L) {
            this.ttl = ttl;
            this.expireTime = expireTime;
            return this;
        }
        return null;
    }

    @Override
    public int size() {
        return 16;
    }

    public String toString() {
        return S.toString(GridCacheTtlEntryExtras.class, this);
    }
}

