/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.local.GridLocalCacheEntry;
import org.apache.ignite.internal.processors.cache.local.GridLocalLockFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridLocalCache<K, V>
extends GridCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private GridCachePreloader preldr;

    public GridLocalCache() {
    }

    public GridLocalCache(GridCacheContext<K, V> ctx) {
        super(ctx, ctx.config().getStartSize());
        this.preldr = new GridCachePreloaderAdapter(ctx);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public GridCachePreloader preloader() {
        return this.preldr;
    }

    @Override
    protected GridCacheMapEntryFactory entryFactory() {
        return new GridCacheMapEntryFactory(){

            @Override
            public GridCacheMapEntry create(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key, int hash, CacheObject val) {
                return new GridLocalCacheEntry(ctx, key, hash, val);
            }
        };
    }

    @Nullable
    GridLocalCacheEntry peekExx(KeyCacheObject key) {
        return (GridLocalCacheEntry)this.peekEx(key);
    }

    GridLocalCacheEntry entryExx(KeyCacheObject key) {
        return (GridLocalCacheEntry)this.entryEx(key);
    }

    @Override
    public IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isRead, boolean retval, TransactionIsolation isolation, boolean invalidate, long createTtl, long accessTtl) {
        return this.lockAllAsync(keys, timeout, tx, CU.empty0());
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<? extends K> keys, long timeout) {
        IgniteTxLocalEx tx = (IgniteTxLocalEx)this.ctx.tm().localTx();
        return this.lockAllAsync(this.ctx.cacheKeysView(keys), timeout, tx, CU.empty0());
    }

    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> keys, long timeout, @Nullable IgniteTxLocalEx tx, CacheEntryPredicate[] filter) {
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture<Boolean>(true);
        }
        GridLocalLockFuture fut = new GridLocalLockFuture(this.ctx, keys, tx, this, timeout, filter);
        try {
            block4: for (KeyCacheObject key : keys) {
                while (true) {
                    GridLocalCacheEntry entry = null;
                    try {
                        entry = this.entryExx(key);
                        entry.unswap(false);
                        if (!this.ctx.isAll((GridCacheEntryEx)entry, filter)) {
                            fut.onFailed();
                            return fut;
                        }
                        GridCacheMvccCandidate cand = fut.addEntry(entry);
                        if (cand != null || !fut.isDone()) continue block4;
                        return fut;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug("Got removed entry in lockAsync(..) method (will retry): " + entry);
                        continue;
                    }
                    break;
                }
            }
            if (!this.ctx.mvcc().addFuture(fut)) {
                fut.onError(new IgniteCheckedException("Duplicate future ID (internal error): " + fut));
            }
            fut.checkLocks();
            return fut;
        }
        catch (IgniteCheckedException e) {
            fut.onError(e);
            return fut;
        }
    }

    @Override
    public void unlockAll(Collection<? extends K> keys) throws IgniteCheckedException {
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        for (K key : keys) {
            GridLocalCacheEntry entry = this.peekExx(this.ctx.toCacheKeyObject(key));
            if (entry == null || !this.ctx.isAll((GridCacheEntryEx)entry, CU.empty0())) continue;
            entry.releaseLocal();
            this.ctx.evicts().touch(entry, topVer);
        }
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        return this.ctx.closures().callLocalSafe(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridLocalCache.this.removeAll();
                return null;
            }
        });
    }

    @Override
    public void onDeferredDelete(GridCacheEntryEx entry, GridCacheVersion ver) {
        assert (false) : "Should not be called";
    }

    void onFutureDone(GridLocalLockFuture fut) {
        if (this.ctx.mvcc().removeMvccFuture(fut) && this.log().isDebugEnabled()) {
            this.log().debug("Explicitly removed future from map of futures: " + fut);
        }
    }
}

