/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridLocalCacheEntry
extends GridCacheMapEntry {
    private long valPtr;

    GridLocalCacheEntry(GridCacheContext ctx, KeyCacheObject key, int hash, CacheObject val) {
        super(ctx, key, hash, val);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    GridCacheMvccCandidate addLocal(long threadId, GridCacheVersion ver, @Nullable GridCacheVersion serOrder, @Nullable GridCacheVersion serReadVer, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException {
        CacheObject val;
        GridCacheMvccCandidate cand;
        CacheLockCandidates prev;
        assert (serReadVer == null || serOrder != null);
        CacheLockCandidates owner = null;
        GridLocalCacheEntry gridLocalCacheEntry = this;
        synchronized (gridLocalCacheEntry) {
            this.checkObsolete();
            if (serReadVer != null && !this.checkSerializableReadVersion(serReadVer)) {
                return null;
            }
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null) {
                mvcc = new GridCacheMvcc(this.cctx);
                this.mvccExtras(mvcc);
            }
            prev = mvcc.localOwners();
            cand = mvcc.addLocal(this, null, null, threadId, ver, timeout, serOrder, reenter, tx, implicitSingle, false, read);
            if (mvcc.isEmpty(new GridCacheVersion[0])) {
                this.mvccExtras(null);
            } else {
                owner = mvcc.localOwners();
            }
            val = this.val;
        }
        if (cand != null && !cand.reentry()) {
            this.cctx.mvcc().addNext(this.cctx, cand);
        }
        this.checkOwnerChanged(prev, owner, val);
        return cand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readyLocal(GridCacheMvccCandidate cand) {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        GridLocalCacheEntry gridLocalCacheEntry = this;
        synchronized (gridLocalCacheEntry) {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.localOwners();
                owner = mvcc.readyLocal(cand);
                if (mvcc.isEmpty(new GridCacheVersion[0])) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    @Override
    public boolean tmLock(IgniteInternalTx tx, long timeout, @Nullable GridCacheVersion serOrder, GridCacheVersion serReadVer, boolean read) throws GridCacheEntryRemovedException {
        GridCacheMvccCandidate cand = this.addLocal(tx.threadId(), tx.xidVersion(), serOrder, serReadVer, timeout, false, true, tx.implicitSingle(), read);
        if (cand != null) {
            this.readyLocal(cand);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recheck() {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        GridLocalCacheEntry gridLocalCacheEntry = this;
        synchronized (gridLocalCacheEntry) {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                owner = mvcc.recheck();
                if (mvcc.isEmpty(new GridCacheVersion[0])) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    @Override
    protected void checkThreadChain(GridCacheMvccCandidate owner) {
        assert (!Thread.holdsLock(this));
        assert (owner != null);
        assert (owner.owner() || owner.used()) : "Neither owner or used flags are set on ready local candidate: " + owner;
        if (owner.next() != null) {
            for (GridCacheMvccCandidate cand = owner.next(); cand != null; cand = cand.next()) {
                assert (cand.local());
                if (cand.used()) continue;
                GridCacheContext cctx0 = cand.parent().context();
                GridLocalCacheEntry e = (GridLocalCacheEntry)cctx0.cache().peekEx(cand.parent().key());
                if (e == null) break;
                e.recheck();
                break;
            }
        }
    }

    @Override
    public void txUnlock(IgniteInternalTx tx) throws GridCacheEntryRemovedException {
        this.removeLock(tx.xidVersion());
    }

    void releaseLocal() {
        this.releaseLocal(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLocal(long threadId) {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        GridLocalCacheEntry gridLocalCacheEntry = this;
        synchronized (gridLocalCacheEntry) {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.localOwners();
                mvcc.releaseLocal(threadId);
                if (mvcc.isEmpty(new GridCacheVersion[0])) {
                    this.mvccExtras(null);
                } else {
                    owner = mvcc.allOwners();
                }
            }
            val = this.val;
        }
        if (prev != null) {
            for (int i = 0; i < prev.size(); ++i) {
                boolean unlocked;
                GridCacheMvccCandidate cand = prev.candidate(i);
                boolean bl = unlocked = owner == null || !owner.hasCandidate(cand.version());
                if (!unlocked) continue;
                this.checkThreadChain(cand);
            }
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLock(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        CacheObject val;
        GridCacheMvccCandidate doomed;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        GridLocalCacheEntry gridLocalCacheEntry = this;
        synchronized (gridLocalCacheEntry) {
            GridCacheMvcc mvcc;
            GridCacheVersion obsoleteVer = this.obsoleteVersionExtras();
            if (obsoleteVer != null && !obsoleteVer.equals(ver)) {
                this.checkObsolete();
            }
            GridCacheMvccCandidate gridCacheMvccCandidate = doomed = (mvcc = this.mvccExtras()) == null ? null : mvcc.candidate(ver);
            if (doomed != null) {
                prev = mvcc.allOwners();
                mvcc.remove(ver);
                if (mvcc.isEmpty(new GridCacheVersion[0])) {
                    this.mvccExtras(null);
                } else {
                    owner = mvcc.allOwners();
                }
            }
            val = this.val;
        }
        if (doomed != null) {
            this.checkThreadChain(doomed);
        }
        this.checkOwnerChanged(prev, owner, val);
        return doomed != null;
    }

    @Override
    protected boolean hasOffHeapPointer() {
        return this.valPtr != 0L;
    }

    @Override
    protected long offHeapPointer() {
        return this.valPtr;
    }

    @Override
    protected void offHeapPointer(long valPtr) {
        this.valPtr = valPtr;
    }

    @Override
    public synchronized String toString() {
        return S.toString(GridLocalCacheEntry.class, this, super.toString());
    }
}

