/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local.atomic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.CacheStorePartialUpdateException;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.local.GridLocalCache;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.resource.GridResourceIoc;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridLocalAtomicCache<K, V>
extends GridLocalCache<K, V> {
    private static final long serialVersionUID = 0L;
    private GridCachePreloader preldr;

    public GridLocalAtomicCache() {
    }

    public GridLocalAtomicCache(GridCacheContext<K, V> ctx) {
        super(ctx);
        this.preldr = new GridCachePreloaderAdapter(ctx);
    }

    @Override
    protected void checkJta() throws IgniteCheckedException {
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public GridCachePreloader preloader() {
        return this.preldr;
    }

    @Override
    protected V getAndPut0(K key, V val, @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return (V)this.updateAllInternal(GridCacheOperation.UPDATE, Collections.singleton(key), Collections.singleton(val), null, this.expiryPerCall(), true, false, filter, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    protected boolean put0(K key, V val, CacheEntryPredicate filter) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        Boolean res = (Boolean)this.updateAllInternal(GridCacheOperation.UPDATE, Collections.singleton(key), Collections.singleton(val), null, this.expiryPerCall(), false, false, filter, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
        assert (res != null);
        return res;
    }

    @Override
    public IgniteInternalFuture<V> getAndPutAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.updateAllAsync0(F0.asMap(key, val), null, null, true, false, filter);
    }

    @Override
    public IgniteInternalFuture<Boolean> putAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.updateAllAsync0(F0.asMap(key, val), null, null, false, false, filter);
    }

    @Override
    protected void putAll0(Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        this.updateAllInternal(GridCacheOperation.UPDATE, m.keySet(), m.values(), null, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<?> putAllAsync0(Map<? extends K, ? extends V> m) {
        return this.updateAllAsync0(m, null, null, false, false, null).chain(RET2NULL);
    }

    @Override
    protected V getAndRemove0(K key) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return (V)this.updateAllInternal(GridCacheOperation.DELETE, Collections.singleton(key), null, null, this.expiryPerCall(), true, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<V> getAndRemoveAsync0(K key) {
        return this.removeAllAsync0(Collections.singletonList(key), true, false, null);
    }

    @Override
    public void removeAll0(Collection<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        this.updateAllInternal(GridCacheOperation.DELETE, keys, null, null, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<Object> removeAllAsync0(Collection<? extends K> keys) {
        return this.removeAllAsync0(keys, false, false, null).chain(RET2NULL);
    }

    @Override
    public boolean remove0(K key, CacheEntryPredicate filter) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        Boolean rmv = (Boolean)this.updateAllInternal(GridCacheOperation.DELETE, Collections.singleton(key), null, null, this.expiryPerCall(), false, false, filter, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
        assert (rmv != null);
        return rmv;
    }

    @Override
    public IgniteInternalFuture<Boolean> removeAsync0(K key, @Nullable CacheEntryPredicate filter) {
        return this.removeAllAsync0(Collections.singletonList(key), false, false, filter);
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        return this.ctx.closures().callLocalSafe(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridLocalAtomicCache.this.removeAll();
                return null;
            }
        });
    }

    @Override
    protected V get0(K key, String taskName, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        Map<K, V> m = this.getAllInternal(Collections.singleton(key), this.ctx.isSwapOrOffheapEnabled(), this.ctx.readThrough(), taskName, deserializeBinary, false, needVer);
        assert (m.isEmpty() || m.size() == 1) : m.size();
        return F.firstValue(m);
    }

    @Override
    public final Map<K, V> getAll0(Collection<? extends K> keys, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        A.notNull(keys, "keys");
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        return this.getAllInternal(keys, this.ctx.isSwapOrOffheapEnabled(), this.ctx.readThrough(), taskName, deserializeBinary, false, needVer);
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(final @Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, final String taskName, final boolean deserializeBinary, final boolean skipVals, boolean canRemap, final boolean needVer) {
        A.notNull(keys, "keys");
        final boolean swapOrOffheap = this.ctx.isSwapOrOffheapEnabled();
        final boolean storeEnabled = this.ctx.readThrough();
        return this.asyncOp(new Callable<Map<K, V>>(){

            @Override
            public Map<K, V> call() throws Exception {
                return GridLocalAtomicCache.this.getAllInternal(keys, swapOrOffheap, storeEnabled, taskName, deserializeBinary, skipVals, needVer);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getAllInternal(@Nullable Collection<? extends K> keys, boolean swapOrOffheap, boolean storeEnabled, String taskName, boolean deserializeBinary, boolean skipVals, boolean needVer) throws IgniteCheckedException {
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (F.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        UUID subjId = this.ctx.subjectIdPerCall(null, opCtx);
        HashMap vals = new HashMap(keys.size(), 1.0f);
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        IgniteCacheExpiryPolicy expiry = this.expiryPolicy(opCtx != null ? opCtx.expiry() : null);
        boolean success = true;
        block5: for (K key : keys) {
            if (key == null) {
                throw new NullPointerException("Null key.");
            }
            GridCacheEntryEx entry = null;
            KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
            do {
                try {
                    GridCacheEntryEx gridCacheEntryEx = entry = swapOrOffheap ? this.entryEx(cacheKey) : this.peekEx(cacheKey);
                    if (entry != null) {
                        if (needVer) {
                            EntryGetResult res = entry.innerGetVersioned(null, null, swapOrOffheap, true, false, !skipVals, subjId, null, taskName, expiry, !deserializeBinary, null);
                            if (res != null) {
                                this.ctx.addResult(vals, cacheKey, res, skipVals, false, deserializeBinary, true, needVer);
                                continue block5;
                            }
                            success = false;
                            continue block5;
                        }
                        CacheObject v = entry.innerGet(null, null, swapOrOffheap, false, true, !skipVals, false, subjId, null, taskName, expiry, !deserializeBinary);
                        if (v != null) {
                            this.ctx.addResult(vals, cacheKey, v, skipVals, false, deserializeBinary, true, null, 0L, 0L);
                            continue block5;
                        }
                        success = false;
                        continue block5;
                    }
                    if (!storeEnabled && this.configuration().isStatisticsEnabled() && !skipVals) {
                        this.metrics0().onRead(false);
                    }
                    success = false;
                    continue block5;
                }
                catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                }
                finally {
                    if (entry == null) continue block5;
                    this.ctx.evicts().touch(entry, this.ctx.affinity().affinityTopologyVersion());
                    continue block5;
                }
            } while (success || !storeEnabled);
        }
        if (success || !storeEnabled) {
            return vals;
        }
        return this.getAllAsync(keys, null, opCtx == null || !opCtx.skipStore(), false, subjId, taskName, deserializeBinary, false, expiry, skipVals, true, needVer).get();
    }

    @Override
    public <T> EntryProcessorResult<T> invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        CacheInvokeResult res = this.invokeAsync(key, entryProcessor, args).get();
        return res != null ? res : new CacheInvokeResult();
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor>(){

            @Override
            public EntryProcessor apply(K k) {
                return entryProcessor;
            }
        }, new IgnitePredicate[0]);
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        return (Map)this.updateAllInternal(GridCacheOperation.TRANSFORM, invokeMap.keySet(), invokeMap.values(), args, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), keepBinary);
    }

    @Override
    public <T> IgniteInternalFuture<EntryProcessorResult<T>> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws EntryProcessorException {
        A.notNull(key, "key", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKey(key);
        }
        Map<K, EntryProcessor<K, V, T>> invokeMap = Collections.singletonMap(key, entryProcessor);
        IgniteInternalFuture fut = this.updateAllAsync0(null, invokeMap, args, false, false, null);
        return fut.chain(new CX1<IgniteInternalFuture<Map<K, EntryProcessorResult<T>>>, EntryProcessorResult<T>>(){

            @Override
            public EntryProcessorResult<T> applyx(IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> fut) throws IgniteCheckedException {
                Map resMap = fut.get();
                if (resMap != null) {
                    assert (resMap.isEmpty() || resMap.size() == 1) : resMap.size();
                    return resMap.isEmpty() ? null : resMap.values().iterator().next();
                }
                return null;
            }
        });
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor>(){

            @Override
            public EntryProcessor apply(K k) {
                return entryProcessor;
            }
        }, new IgnitePredicate[0]);
        return this.updateAllAsync0(null, invokeMap, args, true, false, null);
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws IgniteCheckedException {
        A.notNull(map, "map");
        if (this.keyCheck) {
            this.validateCacheKeys(map.keySet());
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return (Map)this.updateAllInternal(GridCacheOperation.TRANSFORM, map.keySet(), map.values(), args, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        A.notNull(map, "map");
        if (this.keyCheck) {
            this.validateCacheKeys(map.keySet());
        }
        return this.updateAllAsync0(null, map, args, true, false, null);
    }

    private IgniteInternalFuture updateAllAsync0(@Nullable Map<? extends K, ? extends V> map, @Nullable Map<? extends K, ? extends EntryProcessor> invokeMap, final @Nullable Object[] invokeArgs, final boolean retval, final boolean rawRetval, final @Nullable CacheEntryPredicate filter) {
        Set<K> keys;
        GridCacheOperation op;
        GridCacheOperation gridCacheOperation = op = invokeMap != null ? GridCacheOperation.TRANSFORM : GridCacheOperation.UPDATE;
        Set<Object> set = map != null ? map.keySet() : (keys = invokeMap != null ? invokeMap.keySet() : null);
        final Collection<? extends V> vals = map != null ? map.values() : (invokeMap != null ? invokeMap.values() : null);
        final boolean writeThrough = this.ctx.writeThrough();
        final boolean readThrough = this.ctx.readThrough();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final ExpiryPolicy expiry = this.expiryPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        return this.asyncOp(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return GridLocalAtomicCache.this.updateAllInternal(op, keys, vals, invokeArgs, expiry, retval, rawRetval, filter, writeThrough, readThrough, keepBinary);
            }
        });
    }

    private IgniteInternalFuture removeAllAsync0(final @Nullable Collection<? extends K> keys, final boolean retval, final boolean rawRetval, final @Nullable CacheEntryPredicate filter) {
        final boolean writeThrough = this.ctx.writeThrough();
        final boolean readThrough = this.ctx.readThrough();
        final ExpiryPolicy expiryPlc = this.expiryPerCall();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        return this.asyncOp(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return GridLocalAtomicCache.this.updateAllInternal(GridCacheOperation.DELETE, keys, null, null, expiryPlc, retval, rawRetval, filter, writeThrough, readThrough, keepBinary);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object updateAllInternal(GridCacheOperation op, Collection<? extends K> keys, @Nullable Iterable<?> vals, @Nullable Object[] invokeArgs, @Nullable ExpiryPolicy expiryPlc, boolean retval, boolean rawRetval, CacheEntryPredicate filter, boolean writeThrough, boolean readThrough, boolean keepBinary) throws IgniteCheckedException {
        Object ret;
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        if (op == GridCacheOperation.DELETE) {
            this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        } else {
            this.ctx.checkSecurity(SecurityPermission.CACHE_PUT);
        }
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        GridCacheVersion ver = this.ctx.versions().next();
        UUID subjId = this.ctx.subjectIdPerCall(null);
        CacheEntryPredicate[] filters = CU.filterArray(filter);
        if (writeThrough && keys.size() > 1) {
            return this.updateWithBatch(op, keys, vals, invokeArgs, expiryPlc, ver, filters, keepBinary, subjId, taskName);
        }
        Iterator<?> valsIter = vals != null ? vals.iterator() : null;
        IgniteBiTuple res = null;
        CachePartialUpdateCheckedException err = null;
        boolean intercept = this.ctx.config().getInterceptor() != null;
        block7: for (K key : keys) {
            CacheObject val;
            if (key == null) {
                throw new NullPointerException("Null key.");
            }
            CacheObject cacheObject = val = valsIter != null ? (CacheObject)valsIter.next() : null;
            if (val == null && op != GridCacheOperation.DELETE) {
                throw new NullPointerException("Null value.");
            }
            KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
            if (op == GridCacheOperation.UPDATE) {
                val = this.ctx.toCacheObject(val);
            } else if (op == GridCacheOperation.TRANSFORM) {
                this.ctx.kernalContext().resource().inject((Object)val, GridResourceIoc.AnnotationSet.ENTRY_PROCESSOR, this.ctx.name());
            }
            while (true) {
                GridCacheEntryEx entry = null;
                try {
                    entry = this.entryEx(cacheKey);
                    GridTuple3<Boolean, Object, EntryProcessorResult<Object>> t = entry.innerUpdateLocal(ver, val == null ? GridCacheOperation.DELETE : op, val, invokeArgs, writeThrough, readThrough, retval, keepBinary, expiryPlc, true, true, filters, intercept, subjId, taskName);
                    if (op == GridCacheOperation.TRANSFORM) {
                        Map<K, EntryProcessorResult<Object>> computedMap;
                        if (t.get3() == null) continue block7;
                        if (res == null) {
                            computedMap = U.newHashMap(keys.size());
                            res = new IgniteBiTuple(true, computedMap);
                        } else {
                            computedMap = (Map)res.get2();
                        }
                        computedMap.put(key, t.get3());
                        continue block7;
                    }
                    if (res != null) continue block7;
                    res = new T2<Boolean, Object>(t.get1(), t.get2());
                    continue block7;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Got removed entry while updating (will retry): " + key);
                    }
                    entry = null;
                    continue;
                }
                catch (IgniteCheckedException e) {
                    if (err == null) {
                        err = GridLocalAtomicCache.partialUpdateException();
                    }
                    err.add(F.asList(key), e);
                    U.error(this.log, "Failed to update key : " + key, e);
                    continue block7;
                }
                finally {
                    if (entry == null) continue;
                    this.ctx.evicts().touch(entry, this.ctx.affinity().affinityTopologyVersion());
                    continue;
                }
                break;
            }
        }
        if (err != null) {
            throw err;
        }
        Object object = res == null ? null : (rawRetval ? new GridCacheReturn(this.ctx, true, keepBinary, res.get2(), (Boolean)res.get1()) : (ret = retval || op == GridCacheOperation.TRANSFORM ? res.get2() : res.get1()));
        if (op == GridCacheOperation.TRANSFORM && ret == null) {
            ret = Collections.emptyMap();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, EntryProcessorResult> updateWithBatch(GridCacheOperation op, Collection<? extends K> keys, @Nullable Iterable<?> vals, @Nullable Object[] invokeArgs, @Nullable ExpiryPolicy expiryPlc, GridCacheVersion ver, @Nullable CacheEntryPredicate[] filter, boolean keepBinary, UUID subjId, String taskName) throws IgniteCheckedException {
        List<GridCacheEntryEx> locked = this.lockEntries(keys);
        try {
            int size = locked.size();
            LinkedHashMap<Object, Object> putMap = null;
            ArrayList<Object> rmvKeys = null;
            ArrayList<CacheObject> writeVals = null;
            HashMap invokeResMap = op == GridCacheOperation.TRANSFORM ? U.newHashMap(size) : null;
            ArrayList<GridCacheEntryEx> filtered = new ArrayList<GridCacheEntryEx>(size);
            CachePartialUpdateCheckedException err = null;
            Iterator<?> valsIter = vals != null ? vals.iterator() : null;
            boolean intercept = this.ctx.config().getInterceptor() != null;
            for (int i = 0; i < size; ++i) {
                Object val;
                GridCacheEntryEx entry = locked.get(i);
                Object v = val = valsIter != null ? (Object)valsIter.next() : null;
                if (val == null && op != GridCacheOperation.DELETE) {
                    throw new NullPointerException("Null value.");
                }
                try {
                    CacheObject old;
                    block38: {
                        try {
                            if (!this.ctx.isAllLocked(entry, filter)) {
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Entry did not pass the filter (will skip write) [entry=" + entry + ", filter=" + Arrays.toString(filter) + ']');
                            }
                            break block38;
                        }
                        catch (IgniteCheckedException e) {
                            if (err == null) {
                                err = GridLocalAtomicCache.partialUpdateException();
                            }
                            err.add(F.asList(entry.key()), e);
                        }
                        continue;
                    }
                    if (op == GridCacheOperation.TRANSFORM) {
                        CacheObject updated;
                        this.ctx.kernalContext().resource().inject(val, GridResourceIoc.AnnotationSet.ENTRY_PROCESSOR, this.ctx.name());
                        EntryProcessor entryProcessor = (EntryProcessor)val;
                        old = entry.innerGet(null, null, true, true, true, true, true, subjId, entryProcessor, taskName, null, keepBinary);
                        Object oldVal = null;
                        CacheInvokeEntry invokeEntry = new CacheInvokeEntry(entry.key(), old, entry.version(), keepBinary, entry);
                        Object updatedVal = null;
                        CacheInvokeResult invokeRes = null;
                        try {
                            Object computed = entryProcessor.process(invokeEntry, invokeArgs);
                            updatedVal = this.ctx.unwrapTemporary(invokeEntry.getValue());
                            updated = this.ctx.toCacheObject(updatedVal);
                            if (computed != null) {
                                invokeRes = CacheInvokeResult.fromResult(this.ctx.unwrapTemporary(computed));
                            }
                        }
                        catch (Exception e) {
                            invokeRes = CacheInvokeResult.fromError(e);
                            updated = old;
                        }
                        if (invokeRes != null) {
                            invokeResMap.put(entry.key().value(this.ctx.cacheObjectContext(), false), invokeRes);
                        }
                        if (updated == null) {
                            IgniteBiTuple<Boolean, Object> interceptorRes;
                            if (intercept && this.ctx.cancelRemove(interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry(this.ctx, entry.key(), invokeEntry.key(), old, oldVal, keepBinary)))) continue;
                            if (putMap != null) {
                                err = this.updatePartialBatch(filtered, ver, writeVals, putMap, null, expiryPlc, keepBinary, err, subjId, taskName);
                                putMap = null;
                                writeVals = null;
                                filtered = new ArrayList();
                            }
                            if (rmvKeys == null) {
                                rmvKeys = new ArrayList(size);
                            }
                            rmvKeys.add(entry.key().value(this.ctx.cacheObjectContext(), false));
                        } else {
                            if (intercept) {
                                Object interceptorVal = this.ctx.config().getInterceptor().onBeforePut(new CacheLazyEntry(this.ctx, entry.key(), invokeEntry.getKey(), old, oldVal, keepBinary), updatedVal);
                                if (interceptorVal == null) continue;
                                updated = this.ctx.toCacheObject(this.ctx.unwrapTemporary(interceptorVal));
                            }
                            if (rmvKeys != null) {
                                err = this.updatePartialBatch(filtered, ver, null, null, rmvKeys, expiryPlc, keepBinary, err, subjId, taskName);
                                rmvKeys = null;
                                filtered = new ArrayList();
                            }
                            if (putMap == null) {
                                putMap = new LinkedHashMap(size, 1.0f);
                                writeVals = new ArrayList(size);
                            }
                            putMap.put(CU.value(entry.key(), this.ctx, false), CU.value(updated, this.ctx, false));
                            writeVals.add(updated);
                        }
                    } else if (op == GridCacheOperation.UPDATE) {
                        CacheObject cacheVal = this.ctx.toCacheObject(val);
                        if (intercept) {
                            old = entry.innerGet(null, null, true, this.ctx.loadPreviousValue(), true, true, true, subjId, null, taskName, null, keepBinary);
                            Object interceptorVal = this.ctx.config().getInterceptor().onBeforePut(new CacheLazyEntry(this.ctx, entry.key(), old, keepBinary), val);
                            if (interceptorVal == null) continue;
                            cacheVal = this.ctx.toCacheObject(this.ctx.unwrapTemporary(interceptorVal));
                        }
                        if (putMap == null) {
                            putMap = new LinkedHashMap<Object, Object>(size, 1.0f);
                            writeVals = new ArrayList<CacheObject>(size);
                        }
                        putMap.put(CU.value(entry.key(), this.ctx, false), CU.value(cacheVal, this.ctx, false));
                        writeVals.add(cacheVal);
                    } else {
                        assert (op == GridCacheOperation.DELETE);
                        if (intercept) {
                            CacheObject old2 = entry.innerGet(null, null, true, this.ctx.loadPreviousValue(), true, true, true, subjId, null, taskName, null, keepBinary);
                            IgniteBiTuple interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry(this.ctx, entry.key(), old2, keepBinary));
                            if (this.ctx.cancelRemove(interceptorRes)) continue;
                        }
                        if (rmvKeys == null) {
                            rmvKeys = new ArrayList<Object>(size);
                        }
                        rmvKeys.add(entry.key().value(this.ctx.cacheObjectContext(), false));
                    }
                    filtered.add(entry);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    if (err == null) {
                        err = GridLocalAtomicCache.partialUpdateException();
                    }
                    err.add(F.asList(entry.key()), e);
                    continue;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    assert (false) : "Entry cannot become obsolete while holding lock.";
                    continue;
                }
            }
            if (putMap != null || rmvKeys != null) {
                err = this.updatePartialBatch(filtered, ver, writeVals, putMap, rmvKeys, expiryPlc, keepBinary, err, subjId, taskName);
            } else assert (filtered.isEmpty());
            if (err != null) {
                throw err;
            }
            HashMap hashMap = invokeResMap;
            return hashMap;
        }
        finally {
            this.unlockEntries(locked);
        }
    }

    @Nullable
    private CachePartialUpdateCheckedException updatePartialBatch(List<GridCacheEntryEx> entries, final GridCacheVersion ver, @Nullable List<CacheObject> writeVals, @Nullable Map<Object, Object> putMap, @Nullable Collection<Object> rmvKeys, @Nullable ExpiryPolicy expiryPlc, boolean keepBinary, @Nullable CachePartialUpdateCheckedException err, UUID subjId, String taskName) {
        GridCacheOperation op;
        CacheStorePartialUpdateException storeErr;
        block18: {
            assert (putMap == null ^ rmvKeys == null);
            storeErr = null;
            try {
                if (putMap != null) {
                    try {
                        this.ctx.store().putAll(null, F.viewReadOnly(putMap, new C1<Object, IgniteBiTuple<Object, GridCacheVersion>>(){

                            @Override
                            public IgniteBiTuple<Object, GridCacheVersion> apply(Object v) {
                                return F.t(v, ver);
                            }
                        }, new IgnitePredicate[0]));
                    }
                    catch (CacheStorePartialUpdateException e) {
                        storeErr = e;
                    }
                    op = GridCacheOperation.UPDATE;
                    break block18;
                }
                try {
                    this.ctx.store().removeAll(null, rmvKeys);
                }
                catch (CacheStorePartialUpdateException e) {
                    storeErr = e;
                }
                op = GridCacheOperation.DELETE;
            }
            catch (IgniteCheckedException e) {
                if (err == null) {
                    err = GridLocalAtomicCache.partialUpdateException();
                }
                err.add(putMap != null ? putMap.keySet() : rmvKeys, e);
                return err;
            }
        }
        boolean intercept = this.ctx.config().getInterceptor() != null;
        for (int i = 0; i < entries.size(); ++i) {
            GridCacheEntryEx entry = entries.get(i);
            assert (Thread.holdsLock(entry));
            if (entry.obsolete() || storeErr != null && storeErr.failedKeys().contains(entry.key().value(this.ctx.cacheObjectContext(), false))) continue;
            try {
                CacheObject writeVal;
                CacheObject cacheObject = writeVal = op == GridCacheOperation.UPDATE ? writeVals.get(i) : null;
                assert (writeVal != null || op == GridCacheOperation.DELETE) : "null write value found.";
                GridTuple3<Boolean, Object, EntryProcessorResult<Object>> t = entry.innerUpdateLocal(ver, op, writeVal, null, false, false, false, keepBinary, expiryPlc, true, true, null, false, subjId, taskName);
                if (!intercept) continue;
                if (op == GridCacheOperation.UPDATE) {
                    this.ctx.config().getInterceptor().onAfterPut(new CacheLazyEntry(this.ctx, entry.key(), writeVal, keepBinary));
                    continue;
                }
                this.ctx.config().getInterceptor().onAfterRemove(new CacheLazyEntry(this.ctx, entry.key(), t.get2(), keepBinary));
                continue;
            }
            catch (GridCacheEntryRemovedException ignore) {
                assert (false) : "Entry cannot become obsolete while holding lock.";
                continue;
            }
            catch (IgniteCheckedException e) {
                if (err == null) {
                    err = GridLocalAtomicCache.partialUpdateException();
                }
                err.add(Collections.singleton(entry.key()), e);
            }
        }
        return err;
    }

    private List<GridCacheEntryEx> lockEntries(Collection<? extends K> keys) {
        boolean nullKeys;
        ArrayList<GridCacheEntryEx> locked;
        block7: {
            locked = new ArrayList<GridCacheEntryEx>(keys.size());
            nullKeys = false;
            block0: do {
                for (K key : keys) {
                    if (key == null) {
                        nullKeys = true;
                        break;
                    }
                    GridCacheEntryEx entry = this.entryEx(this.ctx.toCacheKeyObject(key));
                    locked.add(entry);
                }
                if (nullKeys) break block7;
                for (int i = 0; i < locked.size(); ++i) {
                    GridCacheEntryEx entry = (GridCacheEntryEx)locked.get(i);
                    GridUnsafe.monitorEnter(entry);
                    if (!entry.obsolete()) continue;
                    for (int j = 0; j <= i; ++j) {
                        GridUnsafe.monitorExit(locked.get(j));
                    }
                    locked.clear();
                    continue block0;
                }
            } while (locked.isEmpty());
            return locked;
        }
        assert (nullKeys);
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        for (GridCacheEntryEx entry : locked) {
            this.ctx.evicts().touch(entry, topVer);
        }
        throw new NullPointerException("Null key.");
    }

    private void unlockEntries(Iterable<GridCacheEntryEx> locked) {
        for (GridCacheEntryEx entry : locked) {
            GridUnsafe.monitorExit(entry);
        }
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        for (GridCacheEntryEx entry : locked) {
            this.ctx.evicts().touch(entry, topVer);
        }
    }

    private static CachePartialUpdateCheckedException partialUpdateException() {
        return new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
    }

    @Override
    public IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isRead, boolean retval, TransactionIsolation isolation, boolean invalidate, long createTtl, long accessTtl) {
        return new GridFinishedFuture<Boolean>(new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)"));
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(@Nullable Collection<? extends K> keys, long timeout) {
        return new GridFinishedFuture<Boolean>(new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)"));
    }

    @Override
    public void unlockAll(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        throw new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)");
    }

    @Nullable
    private ExpiryPolicy expiryPerCall() {
        ExpiryPolicy expiry;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        ExpiryPolicy expiryPolicy = expiry = opCtx != null ? opCtx.expiry() : null;
        if (expiry == null) {
            expiry = this.ctx.expiry();
        }
        return expiry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture asyncOp(final Callable<?> op) {
        IgniteInternalFuture fail = this.asyncOpAcquire();
        if (fail != null) {
            return fail;
        }
        GridCacheAdapter.FutureHolder holder = (GridCacheAdapter.FutureHolder)this.lastFut.get();
        holder.lock();
        try {
            IgniteInternalFuture fut = holder.future();
            if (fut != null && !fut.isDone()) {
                GridEmbeddedFuture f = new GridEmbeddedFuture(fut, new C2<Object, Exception, IgniteInternalFuture>(){

                    @Override
                    public IgniteInternalFuture apply(Object t, Exception e) {
                        return GridLocalAtomicCache.this.ctx.closures().callLocalSafe(op);
                    }
                });
                this.saveFuture(holder, f);
                GridEmbeddedFuture gridEmbeddedFuture = f;
                return gridEmbeddedFuture;
            }
            IgniteInternalFuture<?> f = this.ctx.closures().callLocalSafe(op);
            this.saveFuture(holder, f);
            IgniteInternalFuture<?> igniteInternalFuture = f;
            return igniteInternalFuture;
        }
        finally {
            holder.unlock();
        }
    }

    @Override
    public void onDeferredDelete(GridCacheEntryEx entry, GridCacheVersion ver) {
        assert (false) : "Should not be called";
    }
}

