/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheOffheapSwapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntryImpl;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtUnreservedPartitionException;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheLocalQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsKey;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryInfo;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMetricsAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryRequest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.datastructures.GridSetQueryPredicate;
import org.apache.ignite.internal.processors.datastructures.SetItemKey;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryFilter;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexType;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.GridBoundedPriorityQueue;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridSpiCloseableIteratorWrapper;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.CX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public abstract class GridCacheQueryManager<K, V>
extends GridCacheManagerAdapter<K, V> {
    private static final int QRY_DETAIL_METRICS_EVICTION_LIMIT = 10000;
    private static final Comparator<GridCacheQueryDetailMetricsAdapter> QRY_DETAIL_METRICS_PRIORITY_NEW_CMP = new Comparator<GridCacheQueryDetailMetricsAdapter>(){

        @Override
        public int compare(GridCacheQueryDetailMetricsAdapter m1, GridCacheQueryDetailMetricsAdapter m2) {
            return Long.compare(m1.lastStartTime(), m2.lastStartTime());
        }
    };
    private static final Comparator<GridCacheQueryDetailMetricsAdapter> QRY_DETAIL_METRICS_PRIORITY_OLD_CMP = new Comparator<GridCacheQueryDetailMetricsAdapter>(){

        @Override
        public int compare(GridCacheQueryDetailMetricsAdapter m1, GridCacheQueryDetailMetricsAdapter m2) {
            return Long.compare(m2.lastStartTime(), m1.lastStartTime());
        }
    };
    private static final ConcurrentHashMap8.BiFun QRY_DETAIL_METRICS_MERGE_FX = new ConcurrentHashMap8.BiFun<GridCacheQueryDetailMetricsAdapter, GridCacheQueryDetailMetricsAdapter, GridCacheQueryDetailMetricsAdapter>(){

        @Override
        public GridCacheQueryDetailMetricsAdapter apply(GridCacheQueryDetailMetricsAdapter oldVal, GridCacheQueryDetailMetricsAdapter newVal) {
            return oldVal.aggregate(newVal);
        }
    };
    private final boolean isIndexingSpiAllowsBinary = !IgniteSystemProperties.getBoolean("IGNITE_UNWRAP_BINARY_FOR_INDEXING_SPI");
    private GridQueryProcessor qryProc;
    private String space;
    private int maxIterCnt;
    private volatile GridCacheQueryMetricsAdapter metrics = new GridCacheQueryMetricsAdapter();
    private int detailMetricsSz;
    private ConcurrentHashMap8<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter> detailMetrics;
    private final ConcurrentMap<UUID, RequestFutureMap> qryIters = new ConcurrentHashMap8<UUID, RequestFutureMap>();
    private final ConcurrentMap<UUID, Map<Long, GridFutureAdapter<FieldsResult>>> fieldsQryRes = new ConcurrentHashMap8<UUID, Map<Long, GridFutureAdapter<FieldsResult>>>();
    private volatile ConcurrentMap<Object, CachedResult<?>> qryResCache = new ConcurrentHashMap8();
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private GridLocalEventListener lsnr;
    private boolean enabled;
    private boolean qryProcEnabled;
    private AffinityTopologyVersion qryTopVer;

    @Override
    public void start0() throws IgniteCheckedException {
        CacheConfiguration ccfg = this.cctx.config();
        this.qryProcEnabled = GridQueryProcessor.isEnabled(ccfg);
        this.qryProc = this.cctx.kernalContext().query();
        this.space = this.cctx.name();
        this.enabled = this.qryProcEnabled || this.isIndexingSpiEnabled() && !CU.isSystemCache(this.space);
        this.maxIterCnt = ccfg.getMaxQueryIteratorsCount();
        this.detailMetricsSz = ccfg.getQueryDetailMetricsSize();
        if (this.detailMetricsSz > 0) {
            this.detailMetrics = new ConcurrentHashMap8(this.detailMetricsSz);
        }
        this.lsnr = new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                Map fieldsFuts;
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                Map futs = (Map)GridCacheQueryManager.this.qryIters.remove(nodeId);
                if (futs != null) {
                    for (Map.Entry entry : futs.entrySet()) {
                        final Object rcpt = GridCacheQueryManager.recipient(nodeId, (Long)entry.getKey());
                        ((GridFutureAdapter)entry.getValue()).listen(new CIX1<IgniteInternalFuture<QueryResult<K, V>>>(){

                            @Override
                            public void applyx(IgniteInternalFuture<QueryResult<K, V>> f) throws IgniteCheckedException {
                                f.get().closeIfNotShared(rcpt);
                            }
                        });
                    }
                }
                if ((fieldsFuts = (Map)GridCacheQueryManager.this.fieldsQryRes.remove(nodeId)) != null) {
                    for (Map.Entry entry : fieldsFuts.entrySet()) {
                        final Object rcpt = GridCacheQueryManager.recipient(nodeId, (Long)entry.getKey());
                        ((GridFutureAdapter)entry.getValue()).listen(new CIX1<IgniteInternalFuture<FieldsResult>>(){

                            @Override
                            public void applyx(IgniteInternalFuture<FieldsResult> f) throws IgniteCheckedException {
                                f.get().closeIfNotShared(rcpt);
                            }
                        });
                    }
                }
            }
        };
        this.cctx.events().addListener(this.lsnr, 11, 12);
        this.qryTopVer = this.cctx.startTopologyVersion();
        if (this.qryTopVer == null) {
            this.qryTopVer = new AffinityTopologyVersion(this.cctx.localNode().order(), 0);
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.busyLock.block();
        this.cctx.events().removeListener(this.lsnr);
        if (cancel) {
            this.onCancelAtStop();
        } else {
            this.onWaitAtStop();
        }
    }

    private boolean enterBusy() {
        return this.busyLock.enterBusy();
    }

    private void leaveBusy() {
        this.busyLock.leaveBusy();
    }

    @Override
    public final void stop0(boolean cancel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped cache query manager.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> rebuildIndexes(String typeName) {
        if (!this.enterBusy()) {
            throw new IllegalStateException("Failed to rebuild indexes (grid is stopping).");
        }
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.qryProc.rebuildIndexes(this.space, typeName);
            return igniteInternalFuture;
        }
        finally {
            this.leaveBusy();
        }
    }

    void onQueryFutureCanceled(long reqId) {
    }

    void onCancelAtStop() {
    }

    void onWaitAtStop() {
    }

    void processQueryRequest(UUID sndId, GridCacheQueryRequest req) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSwap(CacheObject key) throws IgniteCheckedException {
        if (!this.enabled) {
            return;
        }
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (this.isIndexingSpiEnabled()) {
                Object key0 = this.unwrapIfNeeded(key, this.cctx.cacheObjectContext());
                this.cctx.kernalContext().indexing().onSwap(this.space, key0);
            }
            if (this.qryProcEnabled) {
                this.qryProc.onSwap(this.space, key);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    private boolean isIndexingSpiEnabled() {
        return this.cctx.kernalContext().indexing().enabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnswap(CacheObject key, CacheObject val) throws IgniteCheckedException {
        if (!this.enabled) {
            return;
        }
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (this.isIndexingSpiEnabled()) {
                CacheObjectContext coctx = this.cctx.cacheObjectContext();
                Object key0 = this.unwrapIfNeeded(key, coctx);
                Object val0 = this.unwrapIfNeeded(val, coctx);
                this.cctx.kernalContext().indexing().onUnswap(this.space, key0, val0);
            }
            if (this.qryProcEnabled) {
                this.qryProc.onUnswap(this.space, key, val);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    private void invalidateResultCache() {
        if (!this.qryResCache.isEmpty()) {
            this.qryResCache = new ConcurrentHashMap8();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(CacheObject key, CacheObject val, GridCacheVersion ver, long expirationTime) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        assert (this.enabled());
        if (key instanceof GridCacheInternal) {
            return;
        }
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (this.isIndexingSpiEnabled()) {
                CacheObjectContext coctx = this.cctx.cacheObjectContext();
                Object key0 = this.unwrapIfNeeded(key, coctx);
                Object val0 = this.unwrapIfNeeded(val, coctx);
                this.cctx.kernalContext().indexing().store(this.space, key0, val0, expirationTime);
            }
            if (this.qryProcEnabled) {
                this.qryProc.store(this.space, key, val, CU.versionToBytes(ver), expirationTime);
            }
        }
        finally {
            this.invalidateResultCache();
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CacheObject key, CacheObject val) throws IgniteCheckedException {
        assert (key != null);
        if (!GridQueryProcessor.isEnabled(this.cctx.config()) && !(key instanceof GridCacheInternal)) {
            return;
        }
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (this.isIndexingSpiEnabled()) {
                Object key0 = this.unwrapIfNeeded(key, this.cctx.cacheObjectContext());
                this.cctx.kernalContext().indexing().remove(this.space, key0);
            }
            if (this.qryProcEnabled) {
                this.qryProc.remove(this.space, key, val);
            }
        }
        finally {
            this.invalidateResultCache();
            this.leaveBusy();
        }
    }

    public void onUndeploy(ClassLoader ldr) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            this.qryProc.onUndeploy(this.space, ldr);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            this.invalidateResultCache();
            this.leaveBusy();
        }
    }

    public CacheQueryFuture<?> queryLocal(GridCacheQueryBean qry) {
        GridCacheLocalQueryFuture fut;
        block4: {
            assert (qry.query().type() != GridCacheQueryType.SCAN) : qry;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Executing query on local node: " + qry);
            }
            fut = new GridCacheLocalQueryFuture(this.cctx, qry);
            try {
                qry.query().validate();
                fut.execute();
            }
            catch (IgniteCheckedException e) {
                if (fut == null) break block4;
                fut.onDone(e);
            }
        }
        return fut;
    }

    public abstract CacheQueryFuture<?> queryDistributed(GridCacheQueryBean var1, Collection<ClusterNode> var2);

    public abstract GridCloseableIterator scanQueryDistributed(GridCacheQueryAdapter var1, Collection<ClusterNode> var2) throws IgniteCheckedException;

    public abstract void loadPage(long var1, GridCacheQueryAdapter<?> var3, Collection<ClusterNode> var4, boolean var5);

    public abstract CacheQueryFuture<?> queryFieldsLocal(GridCacheQueryBean var1);

    public abstract CacheQueryFuture<?> queryFieldsDistributed(GridCacheQueryBean var1, Collection<ClusterNode> var2);

    private Object unwrapIfNeeded(CacheObject obj, CacheObjectContext coctx) {
        return this.isIndexingSpiAllowsBinary && this.cctx.cacheObjects().isBinaryObject(obj) ? obj : obj.value(coctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult<K, V> executeQuery(GridCacheQueryAdapter<?> qry, @Nullable Object[] args, boolean loc, @Nullable UUID subjId, @Nullable String taskName, Object rcpt) throws IgniteCheckedException {
        QueryResult res;
        block22: {
            if (qry.type() == null) {
                assert (!loc);
                throw new IgniteCheckedException("Received next page request after iterator was removed. Consider increasing maximum number of stored iterators (see CacheConfiguration.getMaxQueryIteratorsCount() configuration property).");
            }
            T3<String, String, List<Object[]>> resKey = null;
            if (qry.type() == GridCacheQueryType.SQL) {
                resKey = new T3<String, String, List<Object[]>>(qry.queryClassName(), qry.clause(), F.asList(args));
                res = (QueryResult)this.qryResCache.get(resKey);
                if (res != null && res.addRecipient(rcpt)) {
                    return res;
                }
                res = new QueryResult(qry.type(), rcpt);
                if (this.qryResCache.putIfAbsent(resKey, res) != null) {
                    resKey = null;
                }
            } else {
                res = new QueryResult(qry.type(), rcpt);
            }
            try {
                GridCloseableIterator<IgniteBiTuple<K, V>> iter;
                switch (qry.type()) {
                    case SQL: {
                        throw new IllegalStateException("Should never be called.");
                    }
                    case SCAN: {
                        if (this.cctx.gridEvents().isRecordable(96)) {
                            this.cctx.gridEvents().record(new CacheQueryExecutedEvent(this.cctx.localNode(), "Scan query executed.", 96, CacheQueryType.SCAN.name(), this.cctx.namex(), null, null, qry.scanFilter(), null, null, subjId, taskName));
                        }
                        iter = this.scanIterator(qry, false);
                        break;
                    }
                    case TEXT: {
                        if (this.cctx.gridEvents().isRecordable(96)) {
                            this.cctx.gridEvents().record(new CacheQueryExecutedEvent(this.cctx.localNode(), "Full text query executed.", 96, CacheQueryType.FULL_TEXT.name(), this.cctx.namex(), qry.queryClassName(), qry.clause(), null, null, null, subjId, taskName));
                        }
                        iter = this.qryProc.queryText(this.space, qry.clause(), qry.queryClassName(), this.filter(qry));
                        break;
                    }
                    case SET: {
                        iter = this.setIterator(qry);
                        break;
                    }
                    case SQL_FIELDS: {
                        assert (false) : "SQL fields query is incorrectly processed.";
                    }
                    default: {
                        throw new IgniteCheckedException("Unknown query type: " + (Object)((Object)qry.type()));
                    }
                }
                res.onDone(iter);
                if (resKey == null) break block22;
                this.qryResCache.remove(resKey, res);
            }
            catch (Exception e) {
                res.onDone(e);
            }
            finally {
                if (resKey != null) {
                    this.qryResCache.remove(resKey, res);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldsResult executeFieldsQuery(GridCacheQueryAdapter<?> qry, @Nullable Object[] args, boolean loc, @Nullable UUID subjId, @Nullable String taskName, Object rcpt) throws IgniteCheckedException {
        FieldsResult res;
        block17: {
            assert (qry != null);
            T2<String, List<Object[]>> resKey = null;
            if (qry.clause() == null && qry.type() != GridCacheQueryType.SPI) {
                assert (!loc);
                throw new IgniteCheckedException("Received next page request after iterator was removed. Consider increasing maximum number of stored iterators (see CacheConfiguration.getMaxQueryIteratorsCount() configuration property).");
            }
            if (qry.type() == GridCacheQueryType.SQL_FIELDS) {
                if (this.cctx.gridEvents().isRecordable(96)) {
                    this.cctx.gridEvents().record(new CacheQueryExecutedEvent(this.cctx.localNode(), "SQL fields query executed.", 96, CacheQueryType.SQL_FIELDS.name(), this.cctx.namex(), null, qry.clause(), null, null, args, subjId, taskName));
                }
                if ((res = (FieldsResult)this.qryResCache.get(resKey = new T2<String, List<Object[]>>(qry.clause(), F.asList(args)))) != null && res.addRecipient(rcpt)) {
                    return res;
                }
                res = new FieldsResult(rcpt);
                if (this.qryResCache.putIfAbsent(resKey, res) != null) {
                    resKey = null;
                }
            } else {
                assert (qry.type() == GridCacheQueryType.SPI) : "Unexpected query type: " + (Object)((Object)qry.type());
                if (this.cctx.gridEvents().isRecordable(96)) {
                    this.cctx.gridEvents().record(new CacheQueryExecutedEvent(this.cctx.localNode(), "SPI query executed.", 96, CacheQueryType.SPI.name(), this.cctx.namex(), null, null, null, null, args, subjId, taskName));
                }
                res = new FieldsResult(rcpt);
            }
            try {
                if (qry.type() != GridCacheQueryType.SPI) {
                    assert (qry.type() == GridCacheQueryType.SQL_FIELDS);
                    throw new IllegalStateException("Should never be called.");
                }
                IgniteSpiCloseableIterator<?> iter = this.cctx.kernalContext().indexing().query(this.space, F.asList(args), this.filter(qry));
                res.onDone(iter);
                if (resKey == null) break block17;
                this.qryResCache.remove(resKey, res);
            }
            catch (Exception e) {
                try {
                    res.onDone(e);
                    if (resKey == null) break block17;
                    this.qryResCache.remove(resKey, res);
                }
                catch (Throwable throwable) {
                    if (resKey != null) {
                        this.qryResCache.remove(resKey, res);
                    }
                    throw throwable;
                }
            }
        }
        return res;
    }

    private GridCloseableIterator<IgniteBiTuple<K, V>> setIterator(GridCacheQueryAdapter<?> qry) {
        final GridSetQueryPredicate filter = (GridSetQueryPredicate)qry.scanFilter();
        filter.init(this.cctx);
        IgniteUuid id = filter.setId();
        Collection<SetItemKey> data = this.cctx.dataStructures().setData(id);
        if (data == null) {
            data = Collections.emptyList();
        }
        final GridIterator it = F.iterator(data, new C1<SetItemKey, IgniteBiTuple<K, V>>(){

            @Override
            public IgniteBiTuple<K, V> apply(SetItemKey e) {
                return new IgniteBiTuple<Object, Boolean>(e.item(), Boolean.TRUE);
            }
        }, true, new P1<SetItemKey>(){

            @Override
            public boolean apply(SetItemKey e) {
                return filter.apply(e, null);
            }
        });
        return new GridCloseableIteratorAdapter<IgniteBiTuple<K, V>>(){

            @Override
            protected boolean onHasNext() {
                return it.hasNext();
            }

            @Override
            protected IgniteBiTuple<K, V> onNext() {
                return (IgniteBiTuple)it.next();
            }

            @Override
            protected void onRemove() {
                it.remove();
            }

            @Override
            protected void onClose() {
            }
        };
    }

    private GridCloseableIterator<IgniteBiTuple<K, V>> scanIterator(GridCacheQueryAdapter<?> qry, boolean locNode) throws IgniteCheckedException {
        final IgniteBiPredicate keyValFilter = qry.scanFilter();
        try {
            GridIterator it;
            this.injectResources(keyValFilter);
            ExpiryPolicy plc = this.cctx.expiry();
            AffinityTopologyVersion topVer = GridQueryProcessor.getRequestAffinityTopologyVersion();
            if (topVer == null) {
                topVer = this.cctx.affinity().affinityTopologyVersion();
            }
            boolean backups = qry.includeBackups() || this.cctx.isReplicated();
            final GridIterator heapIt = this.onheapIterator(qry, topVer, keyValFilter, backups, plc, locNode);
            if (this.cctx.isSwapOrOffheapEnabled()) {
                ArrayList<GridIterator<IgniteBiTuple<K, V>>> iters = new ArrayList<GridIterator<IgniteBiTuple<K, V>>>(3);
                iters.add(heapIt);
                if (this.cctx.isOffHeapEnabled()) {
                    iters.add(this.offheapIterator(qry, topVer, backups, plc, locNode));
                }
                if (this.cctx.swap().swapEnabled()) {
                    iters.add(this.swapIterator(qry, topVer, backups, plc, locNode));
                }
                it = new CompoundIterator(iters);
            } else {
                it = heapIt;
            }
            return new GridCloseableIteratorAdapter<IgniteBiTuple<K, V>>(){

                @Override
                protected boolean onHasNext() {
                    return it.hasNext();
                }

                @Override
                protected IgniteBiTuple<K, V> onNext() {
                    return (IgniteBiTuple)it.next();
                }

                @Override
                protected void onRemove() {
                    it.remove();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onClose() throws IgniteCheckedException {
                    try {
                        if (heapIt instanceof IgniteSpiCloseableIterator) {
                            ((IgniteSpiCloseableIterator)((Object)heapIt)).close();
                        }
                    }
                    finally {
                        GridCacheQueryManager.closeScanFilter(keyValFilter);
                    }
                }
            };
        }
        catch (RuntimeException | IgniteCheckedException e) {
            GridCacheQueryManager.closeScanFilter(keyValFilter);
            throw e;
        }
    }

    private static void closeScanFilter(Object f) {
        if (f instanceof PlatformCacheEntryFilter) {
            ((PlatformCacheEntryFilter)f).onClose();
        }
    }

    private GridIterator<IgniteBiTuple<K, V>> swapIterator(GridCacheQueryAdapter<?> qry, AffinityTopologyVersion topVer, boolean backups, ExpiryPolicy expPlc, boolean locNode) throws IgniteCheckedException {
        GridCloseableIterator<Map.Entry<byte[], byte[]>> it;
        IgniteBiPredicate filter = qry.scanFilter();
        Integer part = qry.partition();
        GridCloseableIterator<Map.Entry<byte[], byte[]>> gridCloseableIterator = it = part == null ? this.cctx.swap().rawSwapIterator(true, backups, topVer) : this.cctx.swap().rawSwapIterator(part);
        if (expPlc != null) {
            return this.scanExpiryIterator(it, topVer, filter, expPlc, qry.keepBinary(), locNode);
        }
        return this.scanIterator(it, filter, qry.keepBinary(), locNode);
    }

    private GridIterator<IgniteBiTuple<K, V>> onheapIterator(GridCacheQueryAdapter<?> qry, AffinityTopologyVersion topVer, final IgniteBiPredicate<K, V> keyValFilter, boolean backups, ExpiryPolicy plc, boolean locNode) throws GridDhtUnreservedPartitionException {
        Iterator<Object> keyIter;
        GridDhtLocalPartition locPart = null;
        Integer part = qry.partition();
        if (part == null || this.cctx.isLocal()) {
            if (locNode && plc == null && !this.cctx.isLocal()) {
                GridDhtCacheAdapter cache = this.cctx.isNear() ? this.cctx.near().dht() : this.cctx.dht();
                final Iterator iter = cache.localEntriesIterator(true, backups, cache.context().keepBinary(), topVer);
                return new GridIteratorAdapter<IgniteBiTuple<K, V>>(){
                    private IgniteBiTuple<K, V> next;
                    {
                        this.advance();
                    }

                    @Override
                    public boolean hasNextX() throws IgniteCheckedException {
                        return this.next != null;
                    }

                    @Override
                    public IgniteBiTuple<K, V> nextX() throws IgniteCheckedException {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        IgniteBiTuple next0 = this.next;
                        this.advance();
                        return next0;
                    }

                    @Override
                    public void removeX() throws IgniteCheckedException {
                    }

                    private void advance() {
                        IgniteBiTuple next0 = null;
                        while (iter.hasNext()) {
                            Cache.Entry cacheEntry = (Cache.Entry)iter.next();
                            if (keyValFilter != null && !keyValFilter.apply(cacheEntry.getKey(), cacheEntry.getValue())) continue;
                            next0 = new IgniteBiTuple(cacheEntry.getKey(), cacheEntry.getValue());
                            break;
                        }
                        this.next = next0;
                    }
                };
            }
            IgniteInternalCache keepBinaryCache = this.cctx.cache().keepBinary();
            keyIter = backups ? keepBinaryCache.keySetx().iterator() : keepBinaryCache.primaryKeySet().iterator();
        } else if (part < 0 || part >= this.cctx.affinity().partitions()) {
            keyIter = new GridEmptyIterator();
        } else {
            GridDhtCacheAdapter dht = this.cctx.isNear() ? this.cctx.near().dht() : this.cctx.dht();
            locPart = dht.topology().localPartition(part, topVer, false);
            if (locPart == null || locPart.state() != GridDhtPartitionState.OWNING || !locPart.reserve() || locPart.state() != GridDhtPartitionState.OWNING) {
                throw new GridDhtUnreservedPartitionException(part, this.cctx.affinity().affinityTopologyVersion(), "Partition can not be reserved.");
            }
            final GridDhtLocalPartition locPart0 = locPart;
            keyIter = new Iterator<K>(){
                private Iterator<KeyCacheObject> iter0;
                {
                    this.iter0 = locPart0.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter0.hasNext();
                }

                @Override
                public K next() {
                    return this.iter0.next();
                }

                @Override
                public void remove() {
                    this.iter0.remove();
                }
            };
        }
        final GridDhtLocalPartition locPart0 = locPart;
        return new PeekValueExpiryAwareIterator(keyIter, plc, topVer, keyValFilter, qry.keepBinary(), locNode, true){

            @Override
            protected void onClose() {
                super.onClose();
                if (locPart0 != null) {
                    locPart0.release();
                }
            }
        };
    }

    private GridIterator<IgniteBiTuple<K, V>> offheapIterator(GridCacheQueryAdapter<?> qry, AffinityTopologyVersion topVer, boolean backups, ExpiryPolicy expPlc, boolean locNode) {
        IgniteBiPredicate filter = qry.scanFilter();
        if (expPlc != null) {
            return this.scanExpiryIterator(this.cctx.swap().rawOffHeapIterator(qry.partition(), true, backups), topVer, filter, expPlc, qry.keepBinary(), locNode);
        }
        if (this.cctx.offheapTiered() && filter != null) {
            OffheapIteratorClosure c = new OffheapIteratorClosure(filter, qry.keepBinary(), locNode);
            return this.cctx.swap().rawOffHeapIterator(c, qry.partition(), true, backups);
        }
        GridCloseableIterator<Map.Entry<byte[], byte[]>> it = this.cctx.swap().rawOffHeapIterator(qry.partition(), true, backups);
        return this.scanIterator(it, filter, qry.keepBinary(), locNode);
    }

    private GridIteratorAdapter<IgniteBiTuple<K, V>> scanIterator(final @Nullable Iterator<Map.Entry<byte[], byte[]>> it, final @Nullable IgniteBiPredicate<K, V> filter, final boolean keepBinary, final boolean locNode) {
        if (it == null) {
            return new GridEmptyCloseableIterator<IgniteBiTuple<K, V>>();
        }
        return new GridIteratorAdapter<IgniteBiTuple<K, V>>(){
            private IgniteBiTuple<K, V> next;
            {
                this.advance();
            }

            @Override
            public boolean hasNextX() {
                return this.next != null;
            }

            @Override
            public IgniteBiTuple<K, V> nextX() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                IgniteBiTuple next0 = this.next;
                this.advance();
                return next0;
            }

            @Override
            public void removeX() {
                throw new UnsupportedOperationException();
            }

            private void advance() {
                this.next = null;
                while (it.hasNext()) {
                    LazySwapEntry e = new LazySwapEntry((Map.Entry)it.next());
                    Object key = e.key();
                    Object val = e.value();
                    key = GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(key, keepBinary);
                    if (filter != null || locNode) {
                        val = GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(val, keepBinary);
                    }
                    if (filter != null && !filter.apply(key, val)) continue;
                    this.next = new IgniteBiTuple(key, val);
                    break;
                }
            }
        };
    }

    private GridIterator<IgniteBiTuple<K, V>> scanExpiryIterator(final Iterator<Map.Entry<byte[], byte[]>> it, AffinityTopologyVersion topVer, @Nullable IgniteBiPredicate<K, V> filter, ExpiryPolicy expPlc, final boolean keepBinary, boolean locNode) {
        Iterator keyIter = new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public K next() {
                try {
                    KeyCacheObject key = GridCacheQueryManager.this.cctx.toCacheKeyObject((byte[])((Map.Entry)it.next()).getKey());
                    return GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(key, keepBinary);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
        return new PeekValueExpiryAwareIterator(keyIter, expPlc, topVer, filter, keepBinary, locNode, false);
    }

    private void injectResources(@Nullable Object o) throws IgniteCheckedException {
        if (o != null) {
            GridKernalContext ctx = this.cctx.kernalContext();
            ClassLoader ldr = o.getClass().getClassLoader();
            if (ctx.deploy().isGlobalLoader(ldr)) {
                ctx.resource().inject(ctx.deploy().getDeployment(ctx.deploy().getClassLoaderId(ldr)), o.getClass(), o);
            } else {
                ctx.resource().inject(ctx.deploy().getDeployment(o.getClass().getName()), o.getClass(), o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runFieldsQuery(GridCacheQueryInfo qryInfo) {
        assert (qryInfo != null);
        if (!this.enterBusy()) {
            if (!this.cctx.localNodeId().equals(qryInfo.senderId())) return;
            throw new IllegalStateException("Failed to process query request (grid is stopping).");
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Running query: " + qryInfo);
            }
            boolean rmvRes = true;
            CachedResult res = null;
            boolean statsEnabled = this.cctx.config().isStatisticsEnabled();
            boolean readEvt = this.cctx.gridEvents().isRecordable(97);
            try {
                ArrayList<GridQueryFieldMetadata> meta;
                IgniteReducer<?, Object> rdc = qryInfo.reducer();
                this.injectResources(rdc);
                GridCacheQueryAdapter<?> qry = qryInfo.query();
                int pageSize = qry.pageSize();
                List<Object> data = null;
                ArrayList entities = null;
                if (qryInfo.local() || rdc != null || this.cctx.isLocalNode(qryInfo.senderId())) {
                    data = new ArrayList(pageSize);
                } else {
                    entities = new ArrayList(pageSize);
                }
                String taskName = this.cctx.kernalContext().task().resolveTaskName(qry.taskHash());
                CachedResult cachedResult = res = qryInfo.local() ? this.executeFieldsQuery(qry, qryInfo.arguments(), qryInfo.local(), qry.subjectId(), taskName, GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId())) : this.fieldsQueryResult(qryInfo, taskName);
                ArrayList<GridQueryFieldMetadata> arrayList = qryInfo.includeMetaData() ? (((FieldsResult)res).metaData() != null ? new ArrayList<GridQueryFieldMetadata>(((FieldsResult)res).metaData()) : null) : (meta = ((FieldsResult)res).metaData());
                if (!qryInfo.includeMetaData()) {
                    meta = null;
                }
                GridSpiCloseableIteratorWrapper it = new GridSpiCloseableIteratorWrapper(res.iterator(GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId())));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received fields iterator [iterHasNext=" + it.hasNext() + ']');
                }
                if (!it.hasNext()) {
                    if (rdc != null) {
                        data = Collections.singletonList(rdc.reduce());
                    }
                    this.onFieldsPageReady(qryInfo.local(), qryInfo, meta, entities, data, true, null);
                    return;
                }
                int cnt = 0;
                boolean metaSent = false;
                while (!Thread.currentThread().isInterrupted() && it.hasNext()) {
                    long start = statsEnabled ? System.nanoTime() : 0L;
                    Object row = it.next();
                    if (row == null) {
                        this.onPageReady(qryInfo.local(), qryInfo, null, true, null);
                        break;
                    }
                    if (statsEnabled) {
                        CacheMetricsImpl metrics = this.cctx.cache().metrics0();
                        metrics.onRead(true);
                        metrics.addGetTimeNanos(System.nanoTime() - start);
                    }
                    if (readEvt) {
                        this.cctx.gridEvents().record(new CacheQueryReadEvent<Object, Object>(this.cctx.localNode(), "SQL fields query result set row read.", 97, CacheQueryType.SQL_FIELDS.name(), this.cctx.namex(), null, qry.clause(), null, null, qryInfo.arguments(), qry.subjectId(), taskName, null, null, null, row));
                    }
                    if (qryInfo.local() || rdc != null || this.cctx.isLocalNode(qryInfo.senderId())) {
                        if (rdc != null) {
                            if (!rdc.collect(row)) {
                                break;
                            }
                        } else {
                            data.add(row);
                        }
                    } else {
                        entities.add(row);
                    }
                    if (rdc != null || (qryInfo.allPages() || ++cnt != pageSize) && it.hasNext()) continue;
                    this.onFieldsPageReady(qryInfo.local(), qryInfo, !metaSent ? meta : null, entities, data, !it.hasNext(), null);
                    if (it.hasNext()) {
                        rmvRes = false;
                    }
                    if (qryInfo.allPages()) continue;
                    return;
                }
                if (rdc == null) return;
                this.onFieldsPageReady(qryInfo.local(), qryInfo, meta, null, Collections.singletonList(rdc.reduce()), true, null);
                return;
            }
            catch (IgniteCheckedException e) {
                if (this.log.isDebugEnabled() || !e.hasCause(SQLException.class)) {
                    U.error(this.log, "Failed to run fields query [qry=" + qryInfo + ", node=" + this.cctx.nodeId() + ']', e);
                } else if (e.hasCause(SQLException.class)) {
                    U.error(this.log, "Failed to run fields query [node=" + this.cctx.nodeId() + ", msg=" + e.getCause(SQLException.class).getMessage() + ']');
                } else {
                    U.error(this.log, "Failed to run fields query [node=" + this.cctx.nodeId() + ", msg=" + e.getMessage() + ']');
                }
                this.onFieldsPageReady(qryInfo.local(), qryInfo, null, null, null, true, e);
                return;
            }
            catch (Throwable e) {
                block55: {
                    U.error(this.log, "Failed to run fields query [qry=" + qryInfo + ", node=" + this.cctx.nodeId() + "]", e);
                    this.onFieldsPageReady(qryInfo.local(), qryInfo, null, null, null, true, e);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (!qryInfo.local()) break block55;
                    if (!rmvRes) return;
                    if (res == null) return;
                    try {
                        res.closeIfNotShared(GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId()));
                        return;
                    }
                    catch (IgniteCheckedException e2) {
                        U.error(this.log, "Failed to close local iterator [qry=" + qryInfo + ", node=" + this.cctx.nodeId() + "]", e2);
                        return;
                    }
                }
                if (!rmvRes) return;
                this.removeFieldsQueryResult(qryInfo.senderId(), qryInfo.requestId());
                return;
            }
            finally {
                if (qryInfo.local()) {
                    if (rmvRes && res != null) {
                        try {
                            res.closeIfNotShared(GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId()));
                        }
                        catch (IgniteCheckedException e) {
                            U.error(this.log, "Failed to close local iterator [qry=" + qryInfo + ", node=" + this.cctx.nodeId() + "]", e);
                        }
                    }
                } else if (rmvRes) {
                    this.removeFieldsQueryResult(qryInfo.senderId(), qryInfo.requestId());
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Exception decompiling
     */
    protected void runQuery(GridCacheQueryInfo qryInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 26[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected GridCloseableIterator scanQueryLocal(final GridCacheQueryAdapter qry, boolean updStatisticsIfNeeded) throws IgniteCheckedException {
        if (!this.enterBusy()) {
            throw new IllegalStateException("Failed to process query request (grid is stopping).");
        }
        final boolean statsEnabled = this.cctx.config().isStatisticsEnabled();
        boolean needUpdStatistics = updStatisticsIfNeeded && statsEnabled;
        long startTime = U.currentTimeMillis();
        final String namex = this.cctx.namex();
        try {
            assert (qry.type() == GridCacheQueryType.SCAN);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Running local SCAN query: " + qry);
            }
            final String taskName = this.cctx.kernalContext().task().resolveTaskName(qry.taskHash());
            final IgniteBiPredicate filter = qry.scanFilter();
            ClusterNode locNode = this.cctx.localNode();
            final UUID subjId = qry.subjectId();
            if (this.cctx.gridEvents().isRecordable(96)) {
                this.cctx.gridEvents().record(new CacheQueryExecutedEvent(locNode, "Scan query executed.", 96, CacheQueryType.SCAN.name(), namex, null, null, filter, null, null, subjId, taskName));
            }
            final GridCloseableIterator<IgniteBiTuple<K, V>> iter = this.scanIterator(qry, true);
            if (updStatisticsIfNeeded) {
                needUpdStatistics = false;
            }
            final boolean readEvt = this.cctx.gridEvents().isRecordable(97);
            GridCloseableIteratorAdapter<Object> gridCloseableIteratorAdapter = new GridCloseableIteratorAdapter<Object>(){

                @Override
                protected Object onNext() throws IgniteCheckedException {
                    IgniteClosure transform;
                    long start = statsEnabled ? System.nanoTime() : 0L;
                    IgniteBiTuple next = (IgniteBiTuple)iter.nextX();
                    if (statsEnabled) {
                        CacheMetricsImpl metrics = GridCacheQueryManager.this.cctx.cache().metrics0();
                        metrics.onRead(true);
                        metrics.addGetTimeNanos(System.nanoTime() - start);
                    }
                    if (readEvt) {
                        GridCacheQueryManager.this.cctx.gridEvents().record(new CacheQueryReadEvent(GridCacheQueryManager.this.cctx.localNode(), "Scan query entry read.", 97, CacheQueryType.SCAN.name(), namex, null, null, filter, null, null, subjId, taskName, next.getKey(), next.getValue(), null, null));
                    }
                    if ((transform = qry.transform()) == null) {
                        return next;
                    }
                    CacheEntry entry = qry.keepBinary() ? ((GridCacheProxyImpl)GridCacheQueryManager.this.cctx.cache().keepBinary()).getEntry(next.getKey()) : GridCacheQueryManager.this.cctx.cache().getEntry(next.getKey());
                    return transform.apply(entry);
                }

                @Override
                protected boolean onHasNext() throws IgniteCheckedException {
                    return iter.hasNextX();
                }

                @Override
                protected void onClose() throws IgniteCheckedException {
                    iter.close();
                }
            };
            return gridCloseableIteratorAdapter;
        }
        catch (Exception e) {
            if (needUpdStatistics) {
                this.cctx.queries().collectMetrics(GridCacheQueryType.SCAN, namex, startTime, U.currentTimeMillis() - startTime, true);
            }
            throw e;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private QueryResult<K, V> queryResult(GridCacheQueryInfo qryInfo, String taskName) throws IgniteCheckedException {
        GridFutureAdapter<QueryResult<K, V>> fut;
        block12: {
            RequestFutureMap old;
            assert (qryInfo != null);
            final UUID sndId = qryInfo.senderId();
            assert (sndId != null);
            RequestFutureMap futs = (RequestFutureMap)this.qryIters.get(sndId);
            if (futs == null && (old = this.qryIters.putIfAbsent(sndId, futs = new RequestFutureMap(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, GridFutureAdapter<QueryResult<K, V>>> e) {
                    boolean rmv;
                    boolean bl = rmv = this.size() > GridCacheQueryManager.this.maxIterCnt;
                    if (rmv) {
                        try {
                            e.getValue().get().closeIfNotShared(GridCacheQueryManager.recipient(sndId, e.getKey()));
                        }
                        catch (IgniteCheckedException ex) {
                            U.error(GridCacheQueryManager.this.log, "Failed to close query iterator.", ex);
                        }
                    }
                    return rmv;
                }
            })) != null) {
                futs = old;
            }
            assert (futs != null);
            boolean exec = false;
            RequestFutureMap requestFutureMap = futs;
            synchronized (requestFutureMap) {
                if (futs.isCanceled(qryInfo.requestId())) {
                    return null;
                }
                fut = (GridFutureAdapter<QueryResult<K, V>>)futs.get(qryInfo.requestId());
                if (fut == null) {
                    fut = new GridFutureAdapter<QueryResult<K, V>>();
                    futs.put(qryInfo.requestId(), fut);
                    exec = true;
                }
            }
            if (exec) {
                try {
                    fut.onDone(this.executeQuery(qryInfo.query(), qryInfo.arguments(), false, qryInfo.query().subjectId(), taskName, GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId())));
                }
                catch (Throwable e) {
                    fut.onDone(e);
                    if (!(e instanceof Error)) break block12;
                    throw (Error)e;
                }
            }
        }
        return (QueryResult)fut.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeQueryResult(@Nullable UUID sndId, long reqId) {
        block8: {
            if (sndId == null) {
                return;
            }
            RequestFutureMap futs = (RequestFutureMap)this.qryIters.get(sndId);
            if (futs != null) {
                Object fut;
                RequestFutureMap requestFutureMap = futs;
                synchronized (requestFutureMap) {
                    fut = futs.remove(reqId);
                }
                if (fut != null) {
                    try {
                        ((QueryResult)fut.get()).closeIfNotShared(GridCacheQueryManager.recipient(sndId, reqId));
                    }
                    catch (IgniteCheckedException e) {
                        if (X.hasCause(e, GridDhtUnreservedPartitionException.class)) break block8;
                        U.error(this.log, "Failed to close iterator.", e);
                    }
                }
            }
        }
    }

    private static Object recipient(UUID sndId, long reqId) {
        assert (sndId != null);
        return new IgniteBiTuple<UUID, Long>(sndId, reqId);
    }

    private FieldsResult fieldsQueryResult(GridCacheQueryInfo qryInfo, String taskName) throws IgniteCheckedException {
        Map<Long, GridFutureAdapter<FieldsResult>> old;
        final UUID sndId = qryInfo.senderId();
        assert (sndId != null);
        Map<Long, GridFutureAdapter<FieldsResult>> iters = (Map<Long, GridFutureAdapter<FieldsResult>>)this.fieldsQryRes.get(sndId);
        if (iters == null && (old = this.fieldsQryRes.putIfAbsent(sndId, iters = new LinkedHashMap<Long, GridFutureAdapter<FieldsResult>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, GridFutureAdapter<FieldsResult>> e) {
                boolean rmv;
                boolean bl = rmv = this.size() > GridCacheQueryManager.this.maxIterCnt;
                if (rmv) {
                    try {
                        e.getValue().get().closeIfNotShared(GridCacheQueryManager.recipient(sndId, e.getKey()));
                    }
                    catch (IgniteCheckedException ex) {
                        U.error(GridCacheQueryManager.this.log, "Failed to close fields query iterator.", ex);
                    }
                }
                return rmv;
            }

            @Override
            public boolean equals(Object o) {
                return o == this;
            }
        })) != null) {
            iters = old;
        }
        return this.fieldsQueryResult(iters, qryInfo, taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldsResult fieldsQueryResult(Map<Long, GridFutureAdapter<FieldsResult>> resMap, GridCacheQueryInfo qryInfo, String taskName) throws IgniteCheckedException {
        GridFutureAdapter<FieldsResult<Object>> fut;
        assert (resMap != null);
        assert (qryInfo != null);
        boolean exec = false;
        Map<Long, GridFutureAdapter<FieldsResult>> map = resMap;
        synchronized (map) {
            fut = resMap.get(qryInfo.requestId());
            if (fut == null) {
                fut = new GridFutureAdapter();
                resMap.put(qryInfo.requestId(), fut);
                exec = true;
            }
        }
        if (exec) {
            try {
                fut.onDone(this.executeFieldsQuery(qryInfo.query(), qryInfo.arguments(), false, qryInfo.query().subjectId(), taskName, GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId())));
            }
            catch (IgniteCheckedException e) {
                fut.onDone(e);
            }
        }
        return fut.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFieldsQueryResult(@Nullable UUID sndId, long reqId) {
        if (sndId == null) {
            return;
        }
        Map futs = (Map)this.fieldsQryRes.get(sndId);
        if (futs != null) {
            IgniteInternalFuture fut;
            Map map = futs;
            synchronized (map) {
                fut = (IgniteInternalFuture)futs.remove(reqId);
            }
            if (fut != null) {
                assert (fut.isDone());
                try {
                    ((FieldsResult)fut.get()).closeIfNotShared(GridCacheQueryManager.recipient(sndId, reqId));
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to close iterator.", e);
                }
            }
        }
    }

    protected abstract boolean onPageReady(boolean var1, GridCacheQueryInfo var2, @Nullable Collection<?> var3, boolean var4, @Nullable Throwable var5);

    protected abstract boolean onFieldsPageReady(boolean var1, GridCacheQueryInfo var2, @Nullable List<GridQueryFieldMetadata> var3, @Nullable Collection<?> var4, @Nullable Collection<?> var5, boolean var6, @Nullable Throwable var7);

    public QueryMetrics metrics() {
        return this.metrics.copy();
    }

    public Collection<GridCacheQueryDetailMetricsAdapter> detailMetrics() {
        if (this.detailMetricsSz > 0) {
            if (this.detailMetrics.size() > this.detailMetricsSz) {
                GridBoundedPriorityQueue<GridCacheQueryDetailMetricsAdapter> latestMetrics = new GridBoundedPriorityQueue<GridCacheQueryDetailMetricsAdapter>(this.detailMetricsSz, QRY_DETAIL_METRICS_PRIORITY_NEW_CMP);
                latestMetrics.addAll(this.detailMetrics.values());
                return latestMetrics;
            }
            return new ArrayList<GridCacheQueryDetailMetricsAdapter>(this.detailMetrics.values());
        }
        return Collections.emptyList();
    }

    public void evictDetailMetrics() {
        int sz;
        if (this.detailMetricsSz > 0 && (sz = this.detailMetrics.size()) > this.detailMetricsSz) {
            int evictCnt = Math.min(10000, sz - this.detailMetricsSz);
            GridBoundedPriorityQueue<GridCacheQueryDetailMetricsAdapter> metricsToEvict = new GridBoundedPriorityQueue<GridCacheQueryDetailMetricsAdapter>(evictCnt, QRY_DETAIL_METRICS_PRIORITY_OLD_CMP);
            metricsToEvict.addAll(this.detailMetrics.values());
            for (GridCacheQueryDetailMetricsAdapter m : metricsToEvict) {
                this.detailMetrics.remove(m.key());
            }
        }
    }

    public void resetMetrics() {
        this.metrics = new GridCacheQueryMetricsAdapter();
    }

    public void resetDetailMetrics() {
        if (this.detailMetrics != null) {
            this.detailMetrics.clear();
        }
    }

    public void collectMetrics(GridCacheQueryType qryType, String qry, long startTime, long duration, boolean failed) {
        this.metrics.update(duration, failed);
        if (this.detailMetricsSz > 0) {
            if (qryType == GridCacheQueryType.SQL_FIELDS && !F.isEmpty(qry)) {
                int off;
                int len = qry.length();
                for (off = 0; off < len && Character.isWhitespace(qry.charAt(off)); ++off) {
                }
                if (qry.regionMatches(true, off, "EXPLAIN", 0, 7)) {
                    return;
                }
            }
            GridCacheQueryDetailMetricsAdapter m = new GridCacheQueryDetailMetricsAdapter(qryType, qry, this.cctx.name(), startTime, duration, failed);
            GridCacheQueryDetailMetricsKey key = m.key();
            this.detailMetrics.merge(key, m, QRY_DETAIL_METRICS_MERGE_FX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GridCacheSqlMetadata> sqlMetadata() throws IgniteCheckedException {
        if (!this.enterBusy()) {
            throw new IllegalStateException("Failed to get metadata (grid is stopping).");
        }
        try {
            MetadataJob job = new MetadataJob();
            Collection<ClusterNode> nodes = F.view(this.cctx.discovery().remoteNodes(), new P1<ClusterNode>(){

                @Override
                public boolean apply(ClusterNode n) {
                    return GridCacheQueryManager.this.cctx.kernalContext().discovery().cacheAffinityNode(n, GridCacheQueryManager.this.space);
                }
            });
            ArrayList<Object> res = new ArrayList<Object>(nodes.size() + 1);
            IgniteInternalFuture rmtFut = null;
            if (!nodes.isEmpty()) {
                rmtFut = this.cctx.closures().callAsyncNoFailover(GridClosureCallMode.BROADCAST, Collections.singleton(job), nodes, true, 0L);
            }
            IgniteInternalFuture<Collection<CacheSqlMetadata>> locFut = this.cctx.closures().callLocalSafe(job, true);
            if (rmtFut != null) {
                res.addAll(rmtFut.get());
            }
            res.add(locFut.get());
            HashMap<String, LinkedList<CacheSqlMetadata>> map = new HashMap<String, LinkedList<CacheSqlMetadata>>();
            for (Collection arrayList : res) {
                for (CacheSqlMetadata meta : arrayList) {
                    String name = meta.cacheName();
                    LinkedList<CacheSqlMetadata> cacheMetas = (LinkedList<CacheSqlMetadata>)map.get(name);
                    if (cacheMetas == null) {
                        cacheMetas = new LinkedList<CacheSqlMetadata>();
                        map.put(name, cacheMetas);
                    }
                    cacheMetas.add(meta);
                }
            }
            ArrayList<GridCacheSqlMetadata> col = new ArrayList<GridCacheSqlMetadata>(map.size());
            col.add(new CacheSqlMetadata((Iterable)map.remove(this.space)));
            for (Collection metas : map.values()) {
                col.add(new CacheSqlMetadata(metas));
            }
            ArrayList<GridCacheSqlMetadata> arrayList = col;
            return arrayList;
        }
        finally {
            this.leaveBusy();
        }
    }

    @Nullable
    public <K, V> IndexingQueryFilter backupsFilter(boolean includeBackups) {
        if (includeBackups) {
            return null;
        }
        return new IndexingQueryFilter(){

            @Override
            @Nullable
            public IgniteBiPredicate<K, V> forSpace(String spaceName) {
                final GridKernalContext ctx = GridCacheQueryManager.this.cctx.kernalContext();
                final GridCacheAdapter cache = ctx.cache().internalCache(spaceName);
                if (cache.context().isReplicated() || cache.configuration().getBackups() == 0) {
                    return null;
                }
                return new IgniteBiPredicate<K, V>(){

                    @Override
                    public boolean apply(K k, V v) {
                        return cache.context().affinity().primaryByKey(ctx.discovery().localNode(), k, AffinityTopologyVersion.NONE);
                    }
                };
            }

            @Override
            public boolean isValueRequired() {
                return false;
            }
        };
    }

    public AffinityTopologyVersion queryTopologyVersion() {
        return this.qryTopVer;
    }

    private IndexingQueryFilter filter(GridCacheQueryAdapter<?> qry) {
        return this.backupsFilter(qry.includeBackups());
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Query manager memory stats [grid=" + this.cctx.gridName() + ", cache=" + this.cctx.name() + ']', new Object[0]);
    }

    public String space() {
        return this.space;
    }

    public <R> CacheQuery<R> createSpiQuery(boolean keepBinary) {
        return new GridCacheQueryAdapter(this.cctx, GridCacheQueryType.SPI, null, null, null, null, false, keepBinary);
    }

    public <R> CacheQuery<R> createScanQuery(@Nullable IgniteBiPredicate<K, V> filter, @Nullable Integer part, boolean keepBinary) {
        return this.createScanQuery(filter, null, part, keepBinary);
    }

    public <T, R> CacheQuery<R> createScanQuery(@Nullable IgniteBiPredicate<K, V> filter, @Nullable IgniteClosure<T, R> trans, @Nullable Integer part, boolean keepBinary) {
        return new GridCacheQueryAdapter(this.cctx, GridCacheQueryType.SCAN, filter, trans, part, keepBinary);
    }

    public CacheQuery<Map.Entry<K, V>> createFullTextQuery(String clsName, String search, boolean keepBinary) {
        A.notNull("clsName", clsName);
        A.notNull("search", search);
        return new GridCacheQueryAdapter<Map.Entry<K, V>>(this.cctx, GridCacheQueryType.TEXT, clsName, search, null, null, false, keepBinary);
    }

    public CacheQuery<List<?>> createSqlFieldsQuery(String qry, boolean keepBinary) {
        A.notNull(qry, "qry");
        return new GridCacheQueryAdapter(this.cctx, GridCacheQueryType.SQL_FIELDS, null, qry, null, null, false, keepBinary);
    }

    private class RequestFutureMap
    extends LinkedHashMap<Long, GridFutureAdapter<QueryResult<K, V>>> {
        private static final long serialVersionUID = 0L;
        private static final int CANCELED_COUNT = 128;
        private Set<Long> canceled;

        private RequestFutureMap() {
        }

        @Override
        public GridFutureAdapter<QueryResult<K, V>> remove(Object key) {
            if (this.containsKey(key)) {
                return (GridFutureAdapter)super.remove(key);
            }
            if (this.canceled == null) {
                this.canceled = Collections.newSetFromMap(new LinkedHashMap<Long, Boolean>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Long, Boolean> eldest) {
                        return this.size() > 128;
                    }
                });
            }
            this.canceled.add((Long)key);
            return null;
        }

        boolean isCanceled(Long key) {
            return this.canceled != null && this.canceled.contains(key);
        }
    }

    private class PeekValueExpiryAwareIterator
    extends GridCloseableIteratorAdapter<IgniteBiTuple<K, V>> {
        private static final long serialVersionUID = 0L;
        private final ExpiryPolicy plc;
        private final GridCacheAdapter cache;
        private final AffinityTopologyVersion topVer;
        private final GridDhtCacheAdapter dht;
        private final IgniteBiPredicate<K, V> keyValFilter;
        private boolean locNode;
        private boolean heapOnly;
        private final boolean keepBinary;
        private IgniteBiTuple<K, V> next;
        private IgniteCacheExpiryPolicy expiryPlc;
        private Iterator<K> keyIt;

        private PeekValueExpiryAwareIterator(Iterator<K> keyIt, ExpiryPolicy plc, AffinityTopologyVersion topVer, IgniteBiPredicate<K, V> keyValFilter, boolean keepBinary, boolean locNode, boolean heapOnly) {
            this.keyIt = keyIt;
            this.plc = plc;
            this.topVer = topVer;
            this.keyValFilter = keyValFilter;
            this.locNode = locNode;
            this.heapOnly = heapOnly;
            this.dht = GridCacheQueryManager.this.cctx.isLocal() ? null : (GridCacheQueryManager.this.cctx.isNear() ? GridCacheQueryManager.this.cctx.near().dht() : GridCacheQueryManager.this.cctx.dht());
            this.cache = this.dht != null ? this.dht : GridCacheQueryManager.this.cctx.cache();
            this.keepBinary = keepBinary;
            this.expiryPlc = GridCacheQueryManager.this.cctx.cache().expiryPolicy(plc);
            this.advance();
        }

        @Override
        public boolean onHasNext() {
            return this.next != null;
        }

        @Override
        public IgniteBiTuple<K, V> onNext() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            IgniteBiTuple next0 = this.next;
            this.advance();
            return next0;
        }

        @Override
        protected void onClose() {
            this.sendTtlUpdate();
        }

        private void advance() {
            IgniteBiTuple<Object, Object> next0 = null;
            while (this.keyIt.hasNext()) {
                CacheObject val;
                next0 = null;
                Object key = this.keyIt.next();
                try {
                    val = this.value(key);
                }
                catch (IgniteCheckedException e) {
                    if (GridCacheQueryManager.this.log.isDebugEnabled()) {
                        GridCacheQueryManager.this.log.debug("Failed to peek value: " + e);
                    }
                    val = null;
                }
                if (this.dht != null && this.expiryPlc != null && this.expiryPlc.readyToFlush(100)) {
                    this.dht.sendTtlUpdateRequest(this.expiryPlc);
                    this.expiryPlc = GridCacheQueryManager.this.cctx.cache().expiryPolicy(this.plc);
                }
                if (val == null) continue;
                boolean keepBinary0 = !this.locNode || this.keepBinary;
                next0 = F.t(GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(key, keepBinary0), GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(val, keepBinary0));
                boolean passPred = true;
                if (this.keyValFilter != null) {
                    Object key0 = next0.getKey();
                    Object val0 = next0.getValue();
                    if (keepBinary0 && !this.keepBinary) {
                        key0 = GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(key0, this.keepBinary);
                        val0 = GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(val0, this.keepBinary);
                    }
                    passPred = this.keyValFilter.apply(key0, val0);
                }
                if (passPred) break;
                next0 = null;
            }
            IgniteBiTuple igniteBiTuple = this.next = next0 != null ? new IgniteBiTuple(next0.getKey(), next0.getValue()) : null;
            if (this.next == null) {
                this.sendTtlUpdate();
            }
        }

        private void sendTtlUpdate() {
            if (this.dht != null && this.expiryPlc != null) {
                this.dht.sendTtlUpdateRequest(this.expiryPlc);
                this.expiryPlc = null;
            }
        }

        private CacheObject value(K key) throws IgniteCheckedException {
            while (true) {
                try {
                    GridCacheEntryEx entry;
                    GridCacheEntryEx gridCacheEntryEx = entry = this.heapOnly ? this.cache.peekEx(key) : this.cache.entryEx(key);
                    if (this.expiryPlc != null && !this.heapOnly) {
                        entry.unswap();
                    }
                    return entry != null ? entry.peek(true, !this.heapOnly, !this.heapOnly, this.topVer, this.expiryPlc) : null;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (!this.heapOnly) continue;
                    return null;
                }
                break;
            }
        }
    }

    static class CircularQueue<R> {
        private int off;
        private int size;
        private R[] arr;

        CircularQueue(int cap) {
            assert (U.isPow2(cap));
            this.arr = new Object[cap];
        }

        public void add(R o) {
            if (this.size == this.arr.length) {
                Object[] newArr = new Object[this.arr.length << 1];
                int tailSize = this.arr.length - this.off;
                System.arraycopy(this.arr, this.off, newArr, 0, tailSize);
                if (this.off != 0) {
                    System.arraycopy(this.arr, 0, newArr, tailSize, this.off);
                    this.off = 0;
                }
                this.arr = newArr;
            }
            int idx = this.off + this.size & this.arr.length - 1;
            assert (this.arr[idx] == null);
            this.arr[idx] = o;
            ++this.size;
        }

        public void remove(int n) {
            assert (n > 0) : n;
            assert (n <= this.size) : n + " " + this.size;
            int mask = this.arr.length - 1;
            for (int i = 0; i < n; ++i) {
                int idx = this.off + i & mask;
                assert (this.arr[idx] != null);
                this.arr[idx] = null;
            }
            this.size -= n;
            this.off += n;
            if (this.off >= this.arr.length) {
                this.off -= this.arr.length;
            }
        }

        public R get(int idx) {
            assert (idx >= 0) : idx;
            assert (idx < this.size) : idx + " " + this.size;
            R res = this.arr[idx + this.off & this.arr.length - 1];
            assert (res != null);
            return res;
        }

        public int size() {
            return this.size;
        }
    }

    private static abstract class CachedResult<R>
    extends GridFutureAdapter<IgniteSpiCloseableIterator<R>> {
        private final Map<Object, QueueIterator> recipients = new GridLeanMap<Object, QueueIterator>(1);
        private CircularQueue<R> queue;
        private int pruned;

        protected CachedResult(Object rcpt) {
            boolean res = this.addRecipient(rcpt);
            assert (res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeIfNotShared(Object rcpt) throws IgniteCheckedException {
            assert (this.isDone());
            Map<Object, QueueIterator> map = this.recipients;
            synchronized (map) {
                if (this.recipients.isEmpty()) {
                    return;
                }
                this.recipients.remove(rcpt);
                if (this.recipients.isEmpty()) {
                    ((IgniteSpiCloseableIterator)this.get()).close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addRecipient(Object rcpt) {
            Map<Object, QueueIterator> map = this.recipients;
            synchronized (map) {
                if (this.isDone()) {
                    return false;
                }
                assert (!this.recipients.containsKey(rcpt)) : rcpt + " -> " + this.recipients;
                this.recipients.put(rcpt, new QueueIterator(rcpt));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onDone(@Nullable IgniteSpiCloseableIterator<R> res, @Nullable Throwable err) {
            assert (!this.isDone());
            Map<Object, QueueIterator> map = this.recipients;
            synchronized (map) {
                if (this.recipients.size() > 1) {
                    this.queue = new CircularQueue(128);
                    for (QueueIterator it : this.recipients.values()) {
                        it.init();
                    }
                }
                return super.onDone(res, err);
            }
        }

        private void pruneQueue() {
            assert (!this.recipients.isEmpty());
            assert (Thread.holdsLock(this.recipients));
            int minPos = Collections.min(this.recipients.values()).pos;
            if (minPos > this.pruned) {
                this.queue.remove(minPos - this.pruned);
                this.pruned = minPos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IgniteSpiCloseableIterator<R> iterator(Object rcpt) throws IgniteCheckedException {
            assert (rcpt != null);
            IgniteSpiCloseableIterator it = (IgniteSpiCloseableIterator)this.get();
            assert (it != null);
            Map<Object, QueueIterator> map = this.recipients;
            synchronized (map) {
                return this.queue == null ? it : (IgniteSpiCloseableIterator)this.recipients.get(rcpt);
            }
        }

        private class QueueIterator
        implements IgniteSpiCloseableIterator<R>,
        Comparable<QueueIterator> {
            private static final long serialVersionUID = 0L;
            private static final int NEXT_SIZE = 64;
            private final Object rcpt;
            private int pos;
            private Queue<R> next;

            private QueueIterator(Object rcpt) {
                this.rcpt = rcpt;
            }

            public void init() {
                assert (this.next == null);
                this.next = new ArrayDeque(64);
            }

            @Override
            public void close() throws IgniteCheckedException {
                CachedResult.this.closeIfNotShared(this.rcpt);
            }

            @Override
            public boolean hasNext() {
                return !this.next.isEmpty() || this.fillNext();
            }

            @Override
            public R next() {
                return this.next.remove();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fillNext() {
                IgniteSpiCloseableIterator it;
                assert (this.next.isEmpty());
                try {
                    it = (IgniteSpiCloseableIterator)CachedResult.this.get();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
                Map map = CachedResult.this.recipients;
                synchronized (map) {
                    for (int i = 0; i < 64; ++i) {
                        Object res;
                        int off = this.pos - CachedResult.this.pruned;
                        if (off == CachedResult.this.queue.size()) {
                            if (!it.hasNext()) break;
                            res = it.next();
                            CachedResult.this.queue.add(res);
                        } else {
                            res = CachedResult.this.queue.get(off);
                        }
                        assert (res != null);
                        ++this.pos;
                        this.next.add(res);
                    }
                    CachedResult.this.pruneQueue();
                }
                return !this.next.isEmpty();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int compareTo(QueueIterator o) {
                return Integer.compare(this.pos, o.pos);
            }
        }
    }

    private static class CompoundIterator<T>
    extends GridIteratorAdapter<T> {
        private static final long serialVersionUID = 4585888051556166304L;
        private final List<GridIterator<T>> iters;
        private int idx;
        private GridIterator<T> iter;

        private CompoundIterator(List<GridIterator<T>> iters) {
            if (iters.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.iters = iters;
            this.iter = F.first(iters);
        }

        @Override
        public boolean hasNextX() throws IgniteCheckedException {
            if (this.iter.hasNextX()) {
                return true;
            }
            ++this.idx;
            while (this.idx < this.iters.size()) {
                this.iter = this.iters.get(this.idx);
                if (this.iter.hasNextX()) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        @Override
        public T nextX() throws IgniteCheckedException {
            if (!this.hasNextX()) {
                throw new NoSuchElementException();
            }
            return this.iter.nextX();
        }

        @Override
        public void removeX() throws IgniteCheckedException {
            throw new UnsupportedOperationException();
        }
    }

    private class OffheapIteratorClosure
    extends CX2<T2<Long, Integer>, T2<Long, Integer>, IgniteBiTuple<K, V>> {
        private static final long serialVersionUID = 7410163202728985912L;
        private IgniteBiPredicate<K, V> filter;
        private boolean keepBinary;
        private boolean locNode;

        private OffheapIteratorClosure(IgniteBiPredicate<K, V> filter, boolean keepBinary, boolean locNode) {
            assert (filter != null);
            this.filter = filter;
            this.keepBinary = keepBinary;
            this.locNode = locNode;
        }

        @Override
        @Nullable
        public IgniteBiTuple<K, V> applyx(T2<Long, Integer> keyPtr, T2<Long, Integer> valPtr) throws IgniteCheckedException {
            Object val;
            LazyOffheapEntry e = new LazyOffheapEntry(keyPtr, valPtr);
            Object key = GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(e.key(), this.keepBinary);
            if (!this.filter.apply(key, val = GridCacheQueryManager.this.cctx.unwrapBinaryIfNeeded(e.value(), this.keepBinary))) {
                return null;
            }
            if (this.locNode) {
                return new IgniteBiTuple<Object, Object>(key, val);
            }
            if (key instanceof CacheObject) {
                ((CacheObject)key).prepareMarshal(GridCacheQueryManager.this.cctx.cacheObjectContext());
            }
            if ((val = GridCacheQueryManager.this.cctx.unwrapTemporary(e.value())) instanceof CacheObject) {
                ((CacheObject)val).prepareMarshal(GridCacheQueryManager.this.cctx.cacheObjectContext());
            }
            return new IgniteBiTuple<Object, Object>(key, val);
        }
    }

    private class LazyOffheapEntry
    extends AbstractLazySwapEntry {
        private final T2<Long, Integer> keyPtr;
        private final T2<Long, Integer> valPtr;

        private LazyOffheapEntry(T2<Long, Integer> keyPtr, T2<Long, Integer> valPtr) {
            assert (keyPtr != null);
            assert (valPtr != null);
            this.keyPtr = keyPtr;
            this.valPtr = valPtr;
        }

        @Override
        protected byte[] keyBytes() {
            return U.copyMemory((Long)this.keyPtr.get1(), (Integer)this.keyPtr.get2());
        }

        @Override
        protected V unmarshalValue() throws IgniteCheckedException {
            long ptr = GridCacheOffheapSwapEntry.valueAddress((Long)this.valPtr.get1(), (Integer)this.valPtr.get2());
            return GridCacheQueryManager.this.cctx.fromOffheap(ptr, false);
        }

        @Override
        long timeToLive() {
            return GridCacheOffheapSwapEntry.timeToLive((Long)this.valPtr.get1());
        }

        @Override
        long expireTime() {
            return GridCacheOffheapSwapEntry.expireTime((Long)this.valPtr.get1());
        }
    }

    private class LazySwapEntry
    extends AbstractLazySwapEntry {
        private final Map.Entry<byte[], byte[]> e;

        LazySwapEntry(Map.Entry<byte[], byte[]> e) {
            this.e = e;
        }

        @Override
        protected byte[] keyBytes() {
            return this.e.getKey();
        }

        @Override
        protected V unmarshalValue() throws IgniteCheckedException {
            IgniteBiTuple<byte[], Byte> t = GridCacheSwapEntryImpl.getValue(this.e.getValue());
            return GridCacheQueryManager.this.cctx.cacheObjects().toCacheObject(GridCacheQueryManager.this.cctx.cacheObjectContext(), t.get2(), t.get1());
        }

        @Override
        long timeToLive() {
            return GridCacheSwapEntryImpl.timeToLive(this.e.getValue());
        }

        @Override
        long expireTime() {
            return GridCacheSwapEntryImpl.expireTime(this.e.getValue());
        }
    }

    private abstract class AbstractLazySwapEntry {
        private K key;
        private V val;

        private AbstractLazySwapEntry() {
        }

        protected abstract byte[] keyBytes();

        protected abstract V unmarshalValue() throws IgniteCheckedException;

        K key() {
            try {
                if (this.key != null) {
                    return this.key;
                }
                this.key = GridCacheQueryManager.this.cctx.toCacheKeyObject(this.keyBytes());
                return this.key;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        V value() {
            try {
                if (this.val != null) {
                    return this.val;
                }
                this.val = this.unmarshalValue();
                return this.val;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        abstract long timeToLive();

        abstract long expireTime();
    }

    private static class FieldsResult<Q>
    extends CachedResult<Q> {
        private static final long serialVersionUID = 0L;
        private List<GridQueryFieldMetadata> meta;

        FieldsResult(Object rcpt) {
            super(rcpt);
        }

        public List<GridQueryFieldMetadata> metaData() throws IgniteCheckedException {
            this.get();
            return this.meta;
        }

        public void metaData(List<GridQueryFieldMetadata> meta) {
            this.meta = meta;
        }
    }

    private static class QueryResult<K, V>
    extends CachedResult<IgniteBiTuple<K, V>> {
        private static final long serialVersionUID = 0L;
        private final GridCacheQueryType type;

        private QueryResult(GridCacheQueryType type, Object rcpt) {
            super(rcpt);
            this.type = type;
        }

        public GridCacheQueryType type() {
            return this.type;
        }
    }

    private static class CacheSqlIndexMetadata
    implements GridCacheSqlIndexMetadata {
        private static final long serialVersionUID = 0L;
        private String name;
        private Collection<String> fields;
        private Collection<String> descendings;
        private boolean unique;

        public CacheSqlIndexMetadata() {
        }

        CacheSqlIndexMetadata(String name, Collection<String> fields, Collection<String> descendings, boolean unique) {
            assert (name != null);
            assert (fields != null);
            assert (descendings != null);
            this.name = name;
            this.fields = fields;
            this.descendings = descendings;
            this.unique = unique;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Collection<String> fields() {
            return this.fields;
        }

        @Override
        public boolean descending(String field) {
            return this.descendings.contains(field);
        }

        @Override
        public Collection<String> descendings() {
            return this.descendings;
        }

        @Override
        public boolean unique() {
            return this.unique;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.name);
            U.writeCollection(out, this.fields);
            U.writeCollection(out, this.descendings);
            out.writeBoolean(this.unique);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString(in);
            this.fields = U.readCollection(in);
            this.descendings = U.readCollection(in);
            this.unique = in.readBoolean();
        }

        public String toString() {
            return S.toString(CacheSqlIndexMetadata.class, this);
        }
    }

    private static class CacheSqlMetadata
    implements GridCacheSqlMetadata {
        private static final long serialVersionUID = 0L;
        private String cacheName;
        private Collection<String> types;
        private Map<String, String> keyClasses;
        private Map<String, String> valClasses;
        private Map<String, Map<String, String>> fields;
        private Map<String, Collection<GridCacheSqlIndexMetadata>> indexes;

        public CacheSqlMetadata() {
        }

        CacheSqlMetadata(@Nullable String cacheName, Collection<String> types, Map<String, String> keyClasses, Map<String, String> valClasses, Map<String, Map<String, String>> fields, Map<String, Collection<GridCacheSqlIndexMetadata>> indexes) {
            assert (types != null);
            assert (keyClasses != null);
            assert (valClasses != null);
            assert (fields != null);
            assert (indexes != null);
            this.cacheName = cacheName;
            this.types = types;
            this.keyClasses = keyClasses;
            this.valClasses = valClasses;
            this.fields = fields;
            this.indexes = indexes;
        }

        CacheSqlMetadata(Iterable<CacheSqlMetadata> metas) {
            this.types = new HashSet<String>();
            this.keyClasses = new HashMap<String, String>();
            this.valClasses = new HashMap<String, String>();
            this.fields = new HashMap<String, Map<String, String>>();
            this.indexes = new HashMap<String, Collection<GridCacheSqlIndexMetadata>>();
            for (CacheSqlMetadata meta : metas) {
                if (this.cacheName == null) {
                    this.cacheName = meta.cacheName;
                } else assert (F.eq(this.cacheName, meta.cacheName));
                this.types.addAll(meta.types);
                this.keyClasses.putAll(meta.keyClasses);
                this.valClasses.putAll(meta.valClasses);
                this.fields.putAll(meta.fields);
                this.indexes.putAll(meta.indexes);
            }
        }

        @Override
        public String cacheName() {
            return this.cacheName;
        }

        @Override
        public Collection<String> types() {
            return this.types;
        }

        @Override
        public String keyClass(String type) {
            return this.keyClasses.get(type);
        }

        @Override
        public String valueClass(String type) {
            return this.valClasses.get(type);
        }

        @Override
        public Map<String, String> fields(String type) {
            return this.fields.get(type);
        }

        @Override
        public Map<String, String> keyClasses() {
            return this.keyClasses;
        }

        @Override
        public Map<String, String> valClasses() {
            return this.valClasses;
        }

        @Override
        public Map<String, Map<String, String>> fields() {
            return this.fields;
        }

        @Override
        public Map<String, Collection<GridCacheSqlIndexMetadata>> indexes() {
            return this.indexes;
        }

        @Override
        public Collection<GridCacheSqlIndexMetadata> indexes(String type) {
            return this.indexes.get(type);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.cacheName);
            U.writeCollection(out, this.types);
            U.writeMap(out, this.keyClasses);
            U.writeMap(out, this.valClasses);
            U.writeMap(out, this.fields);
            U.writeMap(out, this.indexes);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cacheName = U.readString(in);
            this.types = U.readCollection(in);
            this.keyClasses = U.readMap(in);
            this.valClasses = U.readMap(in);
            this.fields = U.readMap(in);
            this.indexes = U.readMap(in);
        }

        public String toString() {
            return S.toString(CacheSqlMetadata.class, this);
        }
    }

    @GridInternal
    private static class MetadataJob
    implements IgniteCallable<Collection<CacheSqlMetadata>> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;

        private MetadataJob() {
        }

        @Override
        public Collection<CacheSqlMetadata> call() {
            final GridKernalContext ctx = ((IgniteKernal)this.ignite).context();
            Collection cacheNames = F.viewReadOnly(ctx.cache().caches(), new C1<IgniteInternalCache<?, ?>, String>(){

                @Override
                public String apply(IgniteInternalCache<?, ?> c) {
                    return c.name();
                }
            }, new P1<IgniteInternalCache<?, ?>>(){

                @Override
                public boolean apply(IgniteInternalCache<?, ?> c) {
                    return !"ignite-marshaller-sys-cache".equals(c.name()) && !"ignite-sys-cache".equals(c.name()) && !"ignite-atomics-sys-cache".equals(c.name());
                }
            });
            return F.transform(cacheNames, new C1<String, CacheSqlMetadata>(){

                @Override
                public CacheSqlMetadata apply(String cacheName) {
                    Collection<GridQueryTypeDescriptor> types = ctx.query().types(cacheName);
                    HashSet<String> names = U.newHashSet(types.size());
                    HashMap<String, String> keyClasses = U.newHashMap(types.size());
                    HashMap<String, String> valClasses = U.newHashMap(types.size());
                    HashMap<String, Map<String, String>> fields = U.newHashMap(types.size());
                    HashMap<String, Collection<GridCacheSqlIndexMetadata>> indexes = U.newHashMap(types.size());
                    for (GridQueryTypeDescriptor type : types) {
                        if (type.name().startsWith("GridCache")) continue;
                        names.add(type.name());
                        keyClasses.put(type.name(), type.keyClass().getName());
                        valClasses.put(type.name(), type.valueClass().getName());
                        int size = 2 + type.fields().size();
                        LinkedHashMap<String, String> fieldsMap = U.newLinkedHashMap(size);
                        fieldsMap.put("_KEY", type.keyClass().getName());
                        fieldsMap.put("_VAL", type.valueClass().getName());
                        for (Map.Entry<String, Class<?>> e : type.fields().entrySet()) {
                            fieldsMap.put(e.getKey().toUpperCase(), e.getValue().getName());
                        }
                        fields.put(type.name(), fieldsMap);
                        ArrayList<CacheSqlIndexMetadata> indexesCol = new ArrayList<CacheSqlIndexMetadata>(type.indexes().size());
                        for (Map.Entry<String, GridQueryIndexDescriptor> e : type.indexes().entrySet()) {
                            GridQueryIndexDescriptor desc = e.getValue();
                            if (desc.type() != GridQueryIndexType.SORTED) continue;
                            Collection<String> idxFields = e.getValue().fields();
                            LinkedList<String> descendings = new LinkedList<String>();
                            for (String idxField : idxFields) {
                                if (!desc.descending(idxField)) continue;
                                descendings.add(idxField);
                            }
                            indexesCol.add(new CacheSqlIndexMetadata(e.getKey().toUpperCase(), idxFields, descendings, false));
                        }
                        indexes.put(type.name(), indexesCol);
                    }
                    return new CacheSqlMetadata(cacheName, names, keyClasses, valClasses, fields, indexes);
                }
            });
        }
    }
}

