/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jsr166.LongAdder8;

public class GridCacheQueryMetricsAdapter
implements QueryMetrics,
Externalizable {
    private static final long serialVersionUID = 0L;
    private final GridAtomicLong minTime = new GridAtomicLong(Long.MAX_VALUE);
    private final GridAtomicLong maxTime = new GridAtomicLong();
    private final LongAdder8 sumTime = new LongAdder8();
    private double avgTime;
    private final LongAdder8 execs = new LongAdder8();
    private final LongAdder8 completed = new LongAdder8();
    private final LongAdder8 fails = new LongAdder8();

    @Override
    public long minimumTime() {
        long min = this.minTime.get();
        return min == Long.MAX_VALUE ? 0L : min;
    }

    @Override
    public long maximumTime() {
        return this.maxTime.get();
    }

    @Override
    public double averageTime() {
        if (this.avgTime > 0.0) {
            return this.avgTime;
        }
        double val = this.completed.sum();
        return val > 0.0 ? (double)this.sumTime.sum() / val : 0.0;
    }

    @Override
    public int executions() {
        return this.execs.intValue();
    }

    public int completedExecutions() {
        return this.completed.intValue();
    }

    @Override
    public int fails() {
        return this.fails.intValue();
    }

    public void update(long duration, boolean fail) {
        if (fail) {
            this.execs.increment();
            this.fails.increment();
        } else {
            this.execs.increment();
            this.completed.increment();
            this.minTime.setIfLess(duration);
            this.maxTime.setIfGreater(duration);
            this.sumTime.add(duration);
        }
    }

    public GridCacheQueryMetricsAdapter copy() {
        GridCacheQueryMetricsAdapter m = new GridCacheQueryMetricsAdapter();
        m.fails.add(this.fails.sum());
        m.minTime.set(this.minTime.get());
        m.maxTime.set(this.maxTime.get());
        m.execs.add(this.execs.sum());
        m.completed.add(this.completed.sum());
        m.sumTime.add(this.sumTime.sum());
        m.avgTime = this.avgTime;
        return m;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.minTime.get());
        out.writeLong(this.maxTime.get());
        out.writeDouble(this.averageTime());
        out.writeInt(this.execs.intValue());
        out.writeInt(this.fails.intValue());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.minTime.set(in.readLong());
        this.maxTime.set(in.readLong());
        this.avgTime = in.readDouble();
        this.execs.add(in.readInt());
        this.fails.add(in.readInt());
    }

    public String toString() {
        return S.toString(GridCacheQueryMetricsAdapter.class, this);
    }
}

