/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheSqlQuery
implements Message,
GridCacheQueryMarshallable {
    private static final long serialVersionUID = 0L;
    public static final Object[] EMPTY_PARAMS = new Object[0];
    @GridToStringInclude(sensitive=true)
    private String qry;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    private Object[] params;
    private byte[] paramsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private int[] paramIdxs;
    @GridToStringInclude
    @GridDirectTransient
    private int paramsSize;
    @GridToStringInclude
    @GridDirectTransient
    private LinkedHashMap<String, ?> cols;
    private String alias;

    public GridCacheSqlQuery() {
    }

    public GridCacheSqlQuery(String qry) {
        A.ensure(!F.isEmpty(qry), "qry must not be empty");
        this.qry = qry;
    }

    public LinkedHashMap<String, ?> columns() {
        return this.cols;
    }

    public GridCacheSqlQuery columns(LinkedHashMap<String, ?> columns) {
        this.cols = columns;
        return this;
    }

    public String query() {
        return this.qry;
    }

    public GridCacheSqlQuery query(String qry) {
        this.qry = qry;
        return this;
    }

    public Object[] parameters() {
        return this.params;
    }

    public int[] parameterIndexes() {
        return this.paramIdxs;
    }

    public GridCacheSqlQuery parameters(Object[] params, int[] paramIdxs) {
        this.params = F.isEmpty(params) ? EMPTY_PARAMS : params;
        this.paramsSize = this.params.length;
        this.paramIdxs = paramIdxs;
        return this;
    }

    @Override
    public void marshall(Marshaller m) {
        if (this.paramsBytes != null) {
            return;
        }
        assert (this.params != null);
        try {
            this.paramsBytes = U.marshal(m, (Object)this.params);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void unmarshall(Marshaller m, GridKernalContext ctx) {
        if (this.params != null) {
            return;
        }
        assert (this.paramsBytes != null);
        try {
            ClassLoader ldr = U.resolveClassLoader(ctx.config());
            this.params = m instanceof BinaryMarshaller ? (Object[])((BinaryMarshaller)m).binaryMarshaller().unmarshal(this.paramsBytes, ldr) : (Object[])U.unmarshal(m, this.paramsBytes, ldr);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(GridCacheSqlQuery.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("alias", this.alias)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByteArray("paramsBytes", this.paramsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeString("qry", this.qry)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.alias = reader.readString("alias");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.paramsBytes = reader.readByteArray("paramsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.qry = reader.readString("qry");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheSqlQuery.class);
    }

    @Override
    public byte directType() {
        return 112;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    public GridCacheSqlQuery copy(Object[] args) {
        GridCacheSqlQuery cp = new GridCacheSqlQuery();
        cp.qry = this.qry;
        cp.cols = this.cols;
        cp.paramIdxs = this.paramIdxs;
        cp.paramsSize = this.paramsSize;
        if (F.isEmpty(args)) {
            cp.params = EMPTY_PARAMS;
        } else {
            cp.params = new Object[this.paramsSize];
            for (int paramIdx : this.paramIdxs) {
                cp.params[paramIdx] = args[paramIdx];
            }
        }
        return cp;
    }
}

