/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.nio.ByteBuffer;
import javax.cache.event.EventType;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridCodegenConverter;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class CacheContinuousQueryEntry
implements GridCacheDeployable,
Message {
    private static final long serialVersionUID = 0L;
    private static final byte BACKUP_ENTRY = 1;
    private static final byte FILTERED_ENTRY = 2;
    private static final EventType[] EVT_TYPE_VALS = EventType.values();
    @GridCodegenConverter(type=byte.class, get="evtType != null ? (byte)evtType.ordinal() : -1", set="eventTypeFromOrdinal($val$)")
    private EventType evtType;
    @GridToStringInclude
    @GridCodegenConverter(get="isFiltered() ? null : key")
    private KeyCacheObject key;
    @GridToStringInclude
    @GridCodegenConverter(get="isFiltered() ? null : newVal")
    private CacheObject newVal;
    @GridToStringInclude
    @GridCodegenConverter(get="isFiltered() ? null : oldVal")
    private CacheObject oldVal;
    private int cacheId;
    @GridToStringExclude
    @GridDirectTransient
    private GridDeploymentInfo depInfo;
    private int part;
    private long updateCntr;
    private byte flags;
    @GridToStringInclude
    private AffinityTopologyVersion topVer;
    private GridLongList filteredEvts;
    private boolean keepBinary;

    @Nullable
    public static EventType eventTypeFromOrdinal(int ord) {
        return ord >= 0 && ord < EVT_TYPE_VALS.length ? EVT_TYPE_VALS[ord] : null;
    }

    public CacheContinuousQueryEntry() {
    }

    CacheContinuousQueryEntry(int cacheId, EventType evtType, KeyCacheObject key, @Nullable CacheObject newVal, @Nullable CacheObject oldVal, boolean keepBinary, int part, long updateCntr, @Nullable AffinityTopologyVersion topVer) {
        this.cacheId = cacheId;
        this.evtType = evtType;
        this.key = key;
        this.newVal = newVal;
        this.oldVal = oldVal;
        this.part = part;
        this.updateCntr = updateCntr;
        this.topVer = topVer;
        this.keepBinary = keepBinary;
    }

    @Nullable
    AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    int cacheId() {
        return this.cacheId;
    }

    EventType eventType() {
        return this.evtType;
    }

    int partition() {
        return this.part;
    }

    long updateCounter() {
        return this.updateCntr;
    }

    void markBackup() {
        this.flags = (byte)(this.flags | 1);
    }

    void markFiltered() {
        this.flags = (byte)(this.flags | 2);
        this.depInfo = null;
    }

    void topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public int size() {
        return this.filteredEvts != null ? this.filteredEvts.size() + 1 : 1;
    }

    CacheContinuousQueryEntry forBackupQueue() {
        if (!this.isFiltered()) {
            return this;
        }
        CacheContinuousQueryEntry e = new CacheContinuousQueryEntry(this.cacheId, null, null, null, null, this.keepBinary, this.part, this.updateCntr, null);
        e.flags = this.flags;
        return e;
    }

    boolean isBackup() {
        return (this.flags & 1) != 0;
    }

    boolean isFiltered() {
        return (this.flags & 2) != 0;
    }

    boolean isKeepBinary() {
        return this.keepBinary;
    }

    void filteredEvents(GridLongList cntrs) {
        this.filteredEvts = cntrs;
    }

    long[] filteredEvents() {
        return this.filteredEvts == null ? null : this.filteredEvts.array();
    }

    void prepareMarshal(GridCacheContext cctx) throws IgniteCheckedException {
        assert (this.key != null);
        this.key.prepareMarshal(cctx.cacheObjectContext());
        if (this.newVal != null) {
            this.newVal.prepareMarshal(cctx.cacheObjectContext());
        }
        if (this.oldVal != null) {
            this.oldVal.prepareMarshal(cctx.cacheObjectContext());
        }
    }

    void unmarshal(GridCacheContext cctx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        if (!this.isFiltered()) {
            this.key.finishUnmarshal(cctx.cacheObjectContext(), ldr);
            if (this.newVal != null) {
                this.newVal.finishUnmarshal(cctx.cacheObjectContext(), ldr);
            }
            if (this.oldVal != null) {
                this.oldVal.finishUnmarshal(cctx.cacheObjectContext(), ldr);
            }
        }
    }

    KeyCacheObject key() {
        return this.key;
    }

    CacheObject value() {
        return this.newVal;
    }

    CacheObject oldValue() {
        return this.oldVal;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void prepare(GridDeploymentInfo depInfo) {
        this.depInfo = depInfo;
    }

    @Override
    public GridDeploymentInfo deployInfo() {
        return this.depInfo;
    }

    @Override
    public byte directType() {
        return 96;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("evtType", this.evtType != null ? (byte)this.evtType.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("filteredEvts", this.filteredEvts)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeBoolean("keepBinary", this.keepBinary)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("key", this.isFiltered() ? null : this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMessage("newVal", this.isFiltered() ? null : this.newVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMessage("oldVal", this.isFiltered() ? null : this.oldVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("part", this.part)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeLong("updateCntr", this.updateCntr)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.evtType = CacheContinuousQueryEntry.eventTypeFromOrdinal(reader.readByte("evtType"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.filteredEvts = (GridLongList)reader.readMessage("filteredEvts");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.keepBinary = reader.readBoolean("keepBinary");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.newVal = (CacheObject)reader.readMessage("newVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.oldVal = (CacheObject)reader.readMessage("oldVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.part = reader.readInt("part");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.updateCntr = reader.readLong("updateCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheContinuousQueryEntry.class);
    }

    @Override
    public byte fieldsCount() {
        return 11;
    }

    public String toString() {
        return S.toString(CacheContinuousQueryEntry.class, this);
    }
}

