/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandler;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryManager;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheContinuousQueryHandlerV2<K, V>
extends CacheContinuousQueryHandler<K, V> {
    private static final long serialVersionUID = 0L;
    private Factory<? extends CacheEntryEventFilter> rmtFilterFactory;
    private CacheContinuousQueryHandler.DeployableObject rmtFilterFactoryDep;
    private byte types;
    protected transient CacheEntryEventFilter filter;

    public CacheContinuousQueryHandlerV2() {
    }

    public CacheContinuousQueryHandlerV2(String cacheName, Object topic, CacheEntryUpdatedListener<K, V> locLsnr, Factory<? extends CacheEntryEventFilter<K, V>> rmtFilterFactory, boolean oldValRequired, boolean sync, boolean ignoreExpired, boolean ignoreClsNotFound, @Nullable Byte types) {
        super(cacheName, topic, locLsnr, null, oldValRequired, sync, ignoreExpired, ignoreClsNotFound);
        assert (rmtFilterFactory != null);
        this.rmtFilterFactory = rmtFilterFactory;
        if (types != null) {
            assert (types != 0);
            this.types = types;
        }
    }

    @Override
    public CacheEntryEventFilter getEventFilter() {
        if (this.filter == null) {
            assert (this.rmtFilterFactory != null);
            Factory<? extends CacheEntryEventFilter> factory = this.rmtFilterFactory;
            this.filter = factory.create();
            if (this.types != 0) {
                this.filter = new CacheContinuousQueryManager.JCacheQueryRemoteFilter(this.filter, this.types);
            }
        }
        return this.filter;
    }

    @Override
    public void p2pMarshal(GridKernalContext ctx) throws IgniteCheckedException {
        super.p2pMarshal(ctx);
        if (this.rmtFilterFactory != null && !U.isGrid(this.rmtFilterFactory.getClass())) {
            this.rmtFilterFactoryDep = new CacheContinuousQueryHandler.DeployableObject(this.rmtFilterFactory, ctx);
        }
    }

    @Override
    public void p2pUnmarshal(UUID nodeId, GridKernalContext ctx) throws IgniteCheckedException {
        super.p2pUnmarshal(nodeId, ctx);
        if (this.rmtFilterFactoryDep != null) {
            this.rmtFilterFactory = (Factory)this.rmtFilterFactoryDep.unmarshal(nodeId, ctx);
        }
    }

    @Override
    public GridContinuousHandler clone() {
        return super.clone();
    }

    @Override
    public String toString() {
        return S.toString(CacheContinuousQueryHandlerV2.class, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        boolean b = this.rmtFilterFactoryDep != null;
        out.writeBoolean(b);
        if (b) {
            out.writeObject(this.rmtFilterFactoryDep);
        } else {
            out.writeObject(this.rmtFilterFactory);
        }
        out.writeByte(this.types);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        boolean b = in.readBoolean();
        if (b) {
            this.rmtFilterFactoryDep = (CacheContinuousQueryHandler.DeployableObject)in.readObject();
        } else {
            this.rmtFilterFactory = (Factory)in.readObject();
        }
        this.types = in.readByte();
    }
}

